<?php
$years = array();
$s_yr = date("Y") + 2;
$e_yr = date("Y");
for ($i = $e_yr; $i <= $s_yr; $i++) {
    $years[$i] = $i;
}
$countries = get_study_countries();
?> 
<!-- {{ html()->form('POST', route('admin.auth.user.addapplication', $user->id))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
<div class="row">
    <div class="col">
        <h6><strong>Add New Course Application</strong></h6>
    </div>
</div>
<div class="row">
    <div class="col-sm-12 col-md-5 mt-1">
        <div class="form-group mb-3">
            <label>Country</label>
            {{ html()->select('country', $countries)
                    ->class('form-control form-select') }}
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12 col-md-5">
        <div class="form-group mb-3">
            <label>University</label>
            <input type="text" class="form-control" name="university" required />
        </div>        
    </div>
    <div class="col-sm-12 col-md-5">
        <div class="form-group mb-3">
            <label>Course</label>
            <input type="text" class="form-control" name="course" required />
        </div>        
    </div>
    <div class="col-sm-12 col-md-5">    
        <div class="form-group mb-3">
            <label>Year</label>
            {{ html()->select('year', $years)
                    ->class('form-control form-select') }}
        </div>
    </div>
    <div class="col-sm-12 col-md-5">        
        <div class="form-group mb-3">
            <label>Intake</label><br />
            <select name="intake" class="form-control form-select" required>
            <option value="1"> January</option>
            <option value="2"> February</option>
            <option value="3"> March</option>
            <option value="4"> April</option>
            <option value="5"> May</option>
            <option value="6"> June</option>
            <option value="7"> July</option>
            <option value="8"> August</option>
            <option value="9"> September</option>
            <option value="10"> October</option>
            <option value="11"> November</option>
            <option value="12"> December</option>
            </select>
        </div>        
    </div>    
    <div class="col-sm-12 col-md-5">
        <input type="submit" class="btn btn-success" name="submit" value="Create" />
    </div>
</div>    
{{ html()->form()->close() }} -->

<div class="row">
    <div class="col">
        <!-- <hr> -->
        <h4 class="heading-bg-color">University Applications</h4>
        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
            <table class="table table-striped bg-none mb-0">
                <tr>
                    <th>Appl. ID</th>
                    <th>Country</th>
                    <th>University</th>
                    <th>Course</th>
                    <th>Year</th>
                    <th>Intake</th>
                    <!-- <th>Appli Open Dt</th>
                    <th>Appli Close Dt</th> -->
                    <th>Status</th>
                    <th colspan="2">Action</th>
                    {{-- <th></th> --}}
                </tr>
                @if($user->applications) 
                    @foreach($user->applications as $application)
                    <tr>
                        <td><strong><a href="{{ route('admin.applicationdetail', $application['id']) }}">{{ $application['appl_id'] }}</a></strong></td>
                        <td>{!! $application['country'] !!}</td>
                        <td>{{ $application['university'] }}</td>
                        <td>{{ $application['course'] }}</td>
                        <td>{{ $application['year'] }}</td>
                        <td>{{ $application['intake'] }}</td>
                        <!-- <td>{{ $application['open_date'] }}</td>
                        <td>{{ $application['close_date'] }}</td> -->
                        <td>{{ $application['status'] }}</td>
                        <td>
                            <a class="btn btn-primary btn-sm" href="{{ route('admin.applicationdetail', $application['id']) }}">Details</a>
                            @if(!auth()->user()->isAgent())
                            <form class="d-inline-block" style="display: inline;" method="post" id="applicationDelete_{{$application['id']}}" action="{{route('admin.applicationdelete')}}">
                                @csrf
                                <input type="hidden" name="application_id" value="{{$application['id']}}">
                                <button type="button" data-appl_id={{$application['id']}}  class="btn btn-sm btn-outline-danger deleteBtn" style="border: 1px solid red" ><i class='fas fa-trash-alt'></i></button></td>
                            </form>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                @else
                    <tr>
                        <td colspan="8" class="text-center">No University Applications Found</td>
                    </tr>
                @endif
            </table>        
        </div>
        @if(!$user->applications) 
            <p>Note: To create an University Applications, go to 'Course Preference' tab & click on 'Create University Applications' button for an existing course preference or add a new course preference & then click on 'Create Application'.</p>
        @endif
    </div>

    {{-- <hr>
    <hr>
    <hr>

    <div class="col">
        <h2>Online Signature With HTML + Javascript Example</h2>
        <form id="form-submit" method="POST">
            <input type="hidden" id="user_id" value="{{$user->id}}" name="user_id">
            <div class="wrapper">
                <canvas id="signature-pad" class="signature-pad" width=400 height=200></canvas>
            </div>
            <button id="clear" class="btn btn-sm btn-secondary">Clear</button>
            <button id="save" class="btn btn-success">Save</button>
        </form>

        <br/>
        <hr>
        <h3>Results</h3>
        <textarea type="hidden" id='signature-result' name="signature-result">
            {{get_student_signature($user->id)}}
        </textarea>
        <img src="data:{{get_student_signature($user->id)}}" id="signature-img-result" />
    </div> --}}
</div>

@push('after-scripts')
<script>
    $('.deleteBtn').on("click", function() {
        let btn = $(this);
        let appl_id = btn.data("appl_id");
        Swal.fire({
            title: "Are you sure you want to delete this University Applications?",
            html: "<h6 class='text-danger'>This action cannot be undone!</h6>",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes",
        }).then((result) => {
            if (result.value) {
                $('#applicationDelete_'+appl_id).submit();
            } 
        });
    });

</script>
@endpush

{{-- ----------------------------------------------------- Document Signing --------------------------------------------------------------- --}}
{{-- 
@push('after-styles')
    <style>
        .wrapper {
            position: relative;
            width: 400px;
            height: 200px;
            -moz-user-select: none;
            -webkit-user-select: none;
            -ms-user-select: none;
            user-select: none;
            border: solid 1px #ddd;
            margin: 10px 0px;
        }
        .signature-pad {
            position: absolute;
            left: 0;
            top: 0;
            width:400px;
            height:200px;
        }
        textarea {
            width: 100%;
            min-height: 100px;
        }
    </style>
@endpush

@push('after-scripts')
    <script src="https://code.jquery.com/jquery-3.5.1.min.js" integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0="crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/signature_pad@2.3.2/dist/signature_pad.min.js"></script>
    <script>
        $(function() {
            // init signaturepad
            var signaturePad = new SignaturePad(document.getElementById('signature-pad'), {
                    backgroundColor: 'rgba(255, 255, 255, 0)',
            penColor: 'rgb(0, 0, 0)'
            });

            // get image data and put to hidden input field
            function getSignaturePad() {
                event.preventDefault();
                var imageData = signaturePad.toDataURL('image/png');
                var user_id = $('#user_id').val();
                $.ajax({
                    url: "{{route('admin.document.signature')}}",
                    type: "POST",
                    data: {
                        image_data: imageData,
                        user_id: user_id,
                        _token: '{{csrf_token()}}'
                    },
                    context: this,
                    success: function (result) {
                        if(result.success){
                            console.log("Doooo")
                            swal.fire({
                                title: result.message,
                                icon: "success",
                                button: "ok",
                            });
                        } else{
                            swal.fire({
                                title: result.message,
                                icon: "error",
                                button: "ok",
                            });
                        }
                    }
                }); 

                // $('#signature-result').val(imageData)
                // $('#signature-img-result').attr('src',"data:"+imageData);
            }

            // form action
            $('#form-submit').submit(function() {
                getSignaturePad();
                return false; // set true to submits the form.
            });

            // action on click button clea
            $('#clear').click(function(e) {
                e.preventDefault();
                signaturePad.clear();
            })
        });
    </script>
@endpush --}}