<div class="row">
    <div class="col-12">
        @if(!auth()->user()->isAgent())
        <h4 class="heading-bg-color">Share course suggestions to student</h4>
        <h6>Upload Document</h6>
        {{ html()->form('POST', route('admin.auth.user.coursesuggestion', $user->id))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
        <div class="row">
            <div class="form-group col-sm-12 col-md-5">
                <label class="required-field">Title</label>
                <input type="text" class="form-control" name="title" required />
            </div>
            <div class="form-group col-md-5">
                <label class="required-field">Select File</label>
                <input type="file" name="file" accept=".xls,.xlsx,.csv,.pdf,.doc,.docx,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document">
                <br />
                <small>Allowed: xls/xlsx/csv/doc/docx/pdf</small>
            </div>
            <div class="form-group col-md-2">
                <input type="submit" class="btn btn-primary" name="submit" value="Upload" style="margin-top:20px;">
    
            </div>
        </div>

        {{ html()->form()->close() }}
        <hr>
        <br />
        @endif

        <h4 class="heading-bg-color">Previous Course Suggestions</h4>
        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
            <table class="table table-striped bg-none mb-0">
                <tr>
                    <th>Date</th>
                    <th>File</th>
                    <th>Accepted?</th>
                </tr>
                @if($user->coursesuggestionhistory) 
                    @foreach($user->coursesuggestionhistory as $item)
                    <tr>
                        <td>{{ get_date_time_formated($item['date']) }}</td>
                        <td >{!! $item['file'] !!}</td>
                        <td>{{ $item['satisfied'] }}</td>
                    </tr>
                    @endforeach
                @else
                    <tr><td colspan="3" class="text-center">Record Not Found!</td></tr>
                @endif
            </table>        
        </div>
    </div>
    <br>
    <div class="col-12 mt-5">
        <h4 class="heading-bg-color">Course Finder Suggestions/ Student Bookmarked</h4>
        {{-- <br /> --}}
        <p>You can search for a course in course finder and suggest to student <a href="{{route('admin.coursemanagement.course-finder')}}" class="text-primary">Open Course Finder</a></p>
        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
            <table class="table table-striped bg-none mb-0">
                <tr>
                    <th style="min-width: 90px !important;">Date</th>
                    <th>Course</th>
                    <th>Accepted?</th>
                    <th>Action</th>
                </tr>
                @if(count($user->coursefindersuggestionhistory)) 
                    @foreach($user->coursefindersuggestionhistory as $item)
                        <tr>
                            <td>{{ get_date_formated($item['date']) }}</td>
                            <td>{!! $item['course'] !!}</td>
                            <td>{!! $item['approved'] ? "<span class='badge badge-success'>Yes</span>" : "--" !!}</td>
                            <td>
                                <form method="post" id="suggestionDelete_{{$item['id']}}" action="{{route('admin.findersuggestiondelete')}}">
                                    @csrf
                                    <input type="hidden" name="suggestion_id" value="{{$item['id']}}">
                                    <button type="button" @if($item['approved']) title="Cannot delete once accepted." disabled  @endif  class="btn btn-sm btn-outline-danger suggdeleteBtn" title="Delete" data-sugg_id="{{$item['id']}}"><i class='fas fa-trash-alt'></i></button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                @else
                    <tr><td colspan="4" class="text-center">No suggestions yet!</td></tr>
                @endif
            </table>        
        </div>
    </div>
</div>

@push('after-scripts')

<script>
    $('.suggdeleteBtn').on("click", function() {
        let btn = $(this);
        let sugg_id = btn.data("sugg_id");

        var warning = "<b class='text-danger'>This action cannot be undone!</b>";
        swal({
            title: "Are you sure you want to delete this Suggestion?",
            html: true,
            text: "" + warning + "",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes",
            closeOnConfirm: true
        }, function() {
            $('#suggestionDelete_'+sugg_id).submit();
        });

    });

    @if(isset($item['id']))
    $('.course_preference').on("click", function(event) {
        event.preventDefault();
        let btn = $(this);
        var sugg_id = btn.data("sugg_id");
        Swal.fire({
            title: "Are you sure you want add this to student course preference?",
            // html: "<h6 class='text-danger'>This action cannot be undone!</h6>",
            // icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#007bff",
            confirmButtonText: "Yes",
        }).then((result) => {
            if (result.value) {
                window.location = '{{url("admin/coursemanagement/create/course-preference/")}}/'+sugg_id;   
            } 
        });
    });
    @endif

</script>

@endpush


