<?php
$docs_conf = get_student_doc_configs();
$user_study_level = get_my_study_level($user);

$maxfilesize = config('app.doc_single_max_size') * 1024 * 1024;
$max_sop_files = config('app.max_sop_files');
$max_pass_files = config('app.max_pass_files');
$max_lor_files = config('app.max_lor_files');
$max_experience_files = config('app.max_experience_files');
$max_other_files = config('app.max_other_files');

$pass_files_left = $max_pass_files - get_pass_count($user->id);
$lor_files_left = $max_lor_files - get_lor_count($user->id);
$exp_files_left = $max_experience_files - get_exp_count($user->id);
$other_files_left = $max_other_files - get_other_count($user->id);
?>

<div class="row">
    <div class="col">
        @if(!$user->overseas_study_level_selection)
        <div class="alert alert-danger" role="alert">
            Student Study Level is Required!
        </div>
        @else

        @if(!$user->coursepreferences)
        <div class="alert alert-danger" role="alert">
            Student Course Preferences is pending
        </div>
        @endif
        <div class="row">
            <div class="col-sm-9">
                <h4>Documents /Certificates</h4>
            </div>
            <div class="col-sm-3">
                {{ html()->modelForm($logged_in_user, 'POST', route('admin.downloads.userdocs'))->class('form-horizontal')->open() }}
                <input type="hidden" name="uid" value="{{ $user->id }}">
                {{-- <input type="submit" class="btn btn-primary" name="download" value="Download all docs as Zip"> --}}
                <button class="btn btn-primary" type="submit" title="Download all docs as Zip">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-zip-fill" viewBox="0 0 16 16">
                        <path d="M8.5 9.438V8.5h-1v.938a1 1 0 0 1-.03.243l-.4 1.598.93.62.93-.62-.4-1.598a1 1 0 0 1-.03-.243z"/>
                        <path d="M4 0h8a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2zm2.5 8.5v.938l-.4 1.599a1 1 0 0 0 .416 1.074l.93.62a1 1 0 0 0 1.109 0l.93-.62a1 1 0 0 0 .415-1.074l-.4-1.599V8.5a1 1 0 0 0-1-1h-1a1 1 0 0 0-1 1zm1-5.5h-1v1h1v1h-1v1h1v1H9V6H8V5h1V4H8V3h1V2H8V1H6.5v1h1v1z"/>
                        </svg>
                        Download all docs as Zip
                </button>
                {{ html()->closeModelForm() }}
            </div>
        </div>

        <h4>Academic Certificates</h4>
        <form method="post" action="{{route('admin.studyabroad.documents.save')}}" enctype="multipart/form-data">
            @csrf
            {{-- <input type="hidden" value="{{$user->id}}" name="user_id"> --}}
            <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
                <table class="table table-striped bg-none mb-0">
                <thead class="tableHeading">
                    <tr>
                        <td style="width:25%;"><b>Document</b></td>
                        <td><b></b></td>
                    </tr>
                </thead>
                <tbody>

                    @if($docs_conf[$user_study_level]['class10']['certificate']['enable'])
                    <tr>
                        <td>
                            {{-- 10th Certificate --}}
                            {{_label('class_10_certificate')}} {!!($docs_conf[$user_study_level]['class10']['certificate']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-5">
                            @if($class10)
                            Uploaded File: <?php echo substr($class10, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="10th Certificate" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $class10) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="class10" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                            <form action="" method="post" enctype="multipart/form-data">
                                <input type="file" name="class10" id="file_tenth" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                <span class="text-danger input-err"></span>
                            </form>
                            <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['class10']['marks_sheet']['enable'])
                    <tr>
                        <td>
                            {{-- 10th Marks Sheet --}}
                            {{_label('class_10_marks_sheet')}} {!!($docs_conf[$user_study_level]['class10']['marks_sheet']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-5">
                            @if($class10_marks_sheet)
                            Uploaded File: <?php echo substr($class10_marks_sheet, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="10th Marks Sheet" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $class10_marks_sheet) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="class10_marks_sheet" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                            <form action="" method="post" enctype="multipart/form-data">
                                <input type="file" name="class10_marks_sheet" id="file_tenthMarkSheet" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                <span class="text-danger input-err"></span>
                            </form>
                            <span style="display:none;font-weight: 700;padding-left:0px!important;" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['class12']['certificate']['enable'])
                    <tr>
                        <td>
                            {{-- 12th Certificate --}}
                            {{_label('class_12_certificate')}} {!!($docs_conf[$user_study_level]['class12']['certificate']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($class12)
                            Uploaded File: <?php echo substr($class12, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="12th Certificate" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $class12) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="class12" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                            <form action="" method="post" enctype="multipart/form-data">
                                <input type="file" name="class12" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                <span class="text-danger input-err"></span>
                            </form>
                            <span style="display:none;font-weight: 700;padding-left:0px!important;" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['class12']['marks_sheet']['enable'])
                    <tr>
                        <td>
                            {{-- 12th Marks Sheet --}}
                            {{_label('class_12_marks_sheet')}} {!!($docs_conf[$user_study_level]['class12']['marks_sheet']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($class12_marks_sheet)
                            Uploaded File: <?php echo substr($class12_marks_sheet, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="12th Marks Sheet" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $class12_marks_sheet) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="class12_marks_sheet" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="class12_marks_sheet" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['diploma']['certificate']['enable'])
                    <tr>
                        <td>
                            {{-- Diploma Certificate --}}
                            {{_label('diploma_certificate')}} {!!($docs_conf[$user_study_level]['diploma']['certificate']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($diploma)
                            Uploaded File: <?php echo substr($diploma, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="Diploma Certificate" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $diploma) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="diploma" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="diploma" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['diploma']['marks_sheet']['enable'])
                    <tr>
                        <td>
                            {{-- Diploma Marks Sheet --}}
                            {{_label('diploma_marks_sheet')}} {!!($docs_conf[$user_study_level]['diploma']['marks_sheet']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($diploma_marks_sheet)
                            Uploaded File: <?php echo substr($diploma_marks_sheet, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="Diploma Marks Sheet" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $diploma_marks_sheet) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="diploma_marks_sheet" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="diploma_marks_sheet" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['degree']['certificate']['enable'])
                    <tr>
                        <td>
                            {{-- Bachelors Degree Certificate --}}
                            {{_label('bachelors_certificate')}} {!!($docs_conf[$user_study_level]['degree']['certificate']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($grad_degree)
                            Uploaded File: <?php echo substr($grad_degree, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="Bachelors Certificate" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $grad_degree) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="grad_degree" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="grad_degree" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['degree']['marks_sheet']['enable'])
                    <tr>
                        <td>
                            {{-- Bachelors Marks Sheet/Transcripts --}}
                            {{_label('bachelors_marks_sheet')}} {!!($docs_conf[$user_study_level]['degree']['marks_sheet']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($grad_transcripts)
                            Uploaded File: <?php echo substr($grad_transcripts, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="Bachelors Transcripts" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $grad_transcripts) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="grad_transcripts" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="grad_transcripts" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['degree']['provisional']['enable'])
                    <tr>
                        <td>
                            {{-- Bachelors Provisional Certificate --}}
                            {{_label('bachelors_provisional_certificate')}} {!!($docs_conf[$user_study_level]['degree']['provisional']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($grad_provisional)
                            Uploaded File: <?php echo substr($grad_provisional, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="Bachelors Provisional" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $grad_provisional) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="grad_provisional" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="grad_provisional" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['degree']['all_sem']['enable'])
                    <tr>
                        <td>
                            {{-- Bachelors All Semesters Marks Sheet/Transcripts (Single PDF) --}}
                            {{_label('bachelors_marks_sheets_all_semesters')}} {!!($docs_conf[$user_study_level]['degree']['all_sem']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($grad_all_sem)
                            Uploaded File: <?php echo substr($grad_all_sem, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="Bachelors All Sem Marks Sheet" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $grad_all_sem) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="grad_all_sem" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="grad_all_sem" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['pg_degree']['certificate']['enable'])
                    <tr>
                        <td>
                            {{-- Masters Degree Certificate --}} 
                            {{_label('masters_certificate')}} {!!($docs_conf[$user_study_level]['pg_degree']['certificate']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($pg_degree)
                            Uploaded File: <?php echo substr($pg_degree, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="Masters Certificate" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $pg_degree) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="pg_degree" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="pg_degree" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['pg_degree']['marks_sheet']['enable'])
                    <tr>
                        <td>
                            {{-- Masters Marks Sheet/Transcripts --}}
                            {{_label('masters_marks_sheet')}} {!!($docs_conf[$user_study_level]['pg_degree']['marks_sheet']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($pg_transcripts)
                            Uploaded File: <?php echo substr($pg_transcripts, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="Masters Transcripts" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $pg_transcripts) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="pg_transcripts" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="pg_transcripts" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['pg_degree']['provisional']['enable'])
                    <tr>
                        <td>
                            {{-- Masters Provisional Certificate --}}
                            {{_label('masters_provisional_certificate')}} {!!($docs_conf[$user_study_level]['pg_degree']['provisional']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($pg_provisional)
                            Uploaded File: <?php echo substr($pg_provisional, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="Masters Provisional" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $pg_provisional) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="pg_provisional" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="pg_provisional" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    @if($docs_conf[$user_study_level]['pg_degree']['all_sem']['enable'])
                    <tr>
                        <td>
                            {{-- Masters All Semesters Marks Sheet/Transcripts (Single PDF) --}}
                            {{_label('masters_marks_sheets_all_semesters')}} {!!($docs_conf[$user_study_level]['pg_degree']['all_sem']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($pg_all_sem)
                            Uploaded File: <?php echo substr($pg_all_sem, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="Masters All Sem Marks Sheet" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $pg_all_sem) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="pg_all_sem" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="pg_all_sem" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    @endif
                    {{-- //Additional docs One --}}
                    @if($additional_docs_one)
                            @foreach($additional_docs_one as $adc)
                            <tr>
                                <td style="padding: 10px!important;">
                                    <h6 style="padding-top:5px;">{{$adc->title}}</h6>
                                </td>
                                <td>
                                    @if(count(get_additional_docs($user->id,$adc->doc_type)))
                                    <b>Uploaded Files:</b><br>
                                    @foreach(get_additional_docs($user->id,$adc->doc_type) as $docs)
                                    <span id="{{$adc->doc_type}}_fls"><?php echo substr($docs->file, 5); ?></span>
                                    <a title="delete document" data-additional_doc="{{$docs->doc_type}}" data-additional_id="{{$docs->id}}" href="javascript:void(0)" class="cross del-additional-btn ml-1"></a>
                                    <br />
                                    <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $docs->file) ?>">View</a>
                                    <br />
                                    @endforeach
                                    @endif
                                    <form action="" method="post" enctype="multipart/form-data">
                                        @csrf
                                        <input type="file" style="" class="form-control" id="{{$adc->doc_type}}" name="{{$adc->doc_type}}{{($adc->file_count > 1)? '[]' : ''}}" {{($adc->file_count > 1)? "multiple" : ""}} accept="{{$adc->file_types}}">
                                    </form>
                                    <span style="display:none;" id="{{$adc->doc_type}}_loading" class="text-success p-3"><b>Uploading...</b></span>
                                    <span id="{{$adc->doc_type}}-file-input-error" class="text-danger"></span>
                                    <p class="card-subtitle mt-2 mb-0 text-dark">Allowed file types: {{$adc->file_types}}</p>
                                        @if($adc->file_count >1)
                                            <small>Maximum <?= $adc->file_count ?> files.</small>
                                        @endif
                                </td>
                            </tr>
                        @endforeach
                    @endif
                    {{-- //Additional docs One --}}
                    <tr>
                        <td style="padding: 10px!important;" colspan="2">
                            <h4 style="padding-top:25px;">Tests/English Certificates</h4>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            IELTS
                        </td>
                        <td class="col-4">
                            @if($lang_ielts)
                            Uploaded File: <?php echo substr($lang_ielts, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="IELTS" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $lang_ielts) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="lang_ielts" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="lang_ielts" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            PTE
                        </td>
                        <td class="col-4">
                            @if($lang_pte)
                            Uploaded File: <?php echo substr($lang_pte, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="PTE" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $lang_pte) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="lang_pte" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="lang_pte" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            GRE
                        </td>
                        <td class="col-4">
                            @if($gre)
                            Uploaded File: <?php echo substr($gre, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="GRE" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $gre) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="gre" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="gre" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            GMAT
                        </td>
                        <td class="col-4">
                            @if($gmat)
                            Uploaded File: <?php echo substr($gmat, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="GMAT" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $gmat) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="gmat" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                            <form action="" method="post" enctype="multipart/form-data">
                                <input type="file" name="gmat" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                <span class="text-danger input-err"></span>
                            </form>
                            <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            TOEFL
                        </td>
                        <td class="col-4">
                            @if($toefl)
                            Uploaded File: <?php echo substr($toefl, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="TOEFL" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $toefl) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="toefl" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="toefl" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Duolingo
                        </td>
                        <td class="col-4">
                            @if($duolingo)
                            Uploaded File: <?php echo substr($duolingo, 5); ?> <a title="delete document" data-id="{{$user->id}}" data-type="DUOLINGO" href="javascript:void(0)" class="cross del-edu-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $duolingo) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="duolingo" class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" name="duolingo" id="input-file-now" class="form-control file_edu" accept=".pdf, .jpeg, .jpg">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="tenth_marksheet_loading" class="text-success p-3 loding"><b>Uploading...</b></span>
                            </div>
                        </td>
                    </tr>
                    {{-- //Additional docs Two --}}
                    @if($additional_docs_two)
                            @foreach($additional_docs_two as $adc)
                            <tr>
                                <td style="padding: 10px!important;">
                                    <h6 style="padding-top:5px;">{{$adc->title}}</h6>
                                </td>
                                <td>
                                    @if(count(get_additional_docs($user->id,$adc->doc_type)))
                                    <b>Uploaded Files:</b><br>
                                    @foreach(get_additional_docs($user->id,$adc->doc_type) as $docs)
                                    <span id="{{$adc->doc_type}}_fls"><?php echo substr($docs->file, 5); ?></span>
                                    <a title="delete document" data-additional_doc="{{$docs->doc_type}}" data-additional_id="{{$docs->id}}" href="javascript:void(0)" class="cross del-additional-btn ml-1"></a>
                                    <br />
                                    <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $docs->file) ?>">View</a>
                                    <br />
                                    @endforeach
                                    @endif
                                    <form action="" method="post" enctype="multipart/form-data">
                                        @csrf
                                        <input type="file" style="" class="form-control" id="{{$adc->doc_type}}" name="{{$adc->doc_type}}{{($adc->file_count > 1)? '[]' : ''}}" {{($adc->file_count > 1)? "multiple" : ""}} accept="{{$adc->file_types}}">
                                    </form>
                                    <span style="display:none;" id="{{$adc->doc_type}}_loading" class="text-success p-3"><b>Uploading...</b></span>
                                    <span id="{{$adc->doc_type}}-file-input-error" class="text-danger"></span>
                                    <p class="card-subtitle mt-2 mb-0 text-dark">Allowed file types: {{$adc->file_types}}</p>
                                        @if($adc->file_count >1)
                                            <small>Maximum <?= $adc->file_count ?> files.</small>
                                        @endif
                                </td>
                            </tr>
                        @endforeach
                    @endif
                    {{-- //Additional docs Two --}}
                    <tr>
                        <td style="padding: 10px!important;" colspan="2">
                            <h4 style="padding-top:25px;">Passport, CV, LOR, Experience Letters, Other Documents</h4>
                        </td>
                    </tr>

                    <tr>
                        <td>Passport {!!($docs_conf[$user_study_level]['passport']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}</td>
                        <td class="col-4">

                            @if(count($passports)>0)
                            Uploaded Files:<br>
                            @foreach($passports as $passport)
                            <?php echo substr($passport->file, 5); ?></a>
                            <a title="delete document" data-type="Passport" data-id="{{$passport->id}}" href="javascript:void(0)" class="cross del-pro-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $passport->file) ?>">View</a>
                            <br />
                            @endforeach
                            @endif
                            {{-- <input type="file" name="passport[]" multiple class="form-control" accept=".pdf, .jpeg, .jpg"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input class="form-control" id="file_passport" accept=".pdf, .jpeg, .jpg" type="file" name="file[]" multiple>
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="passport_loading" class="text-success p-3"><b>Uploading...</b></span>
                                <span id="pass-file-input-error" class="text-danger"></span>
                                <small>Multiple files allowed. (Maximum <?= $max_pass_files ?> files)</small>
                            </div>
                        </td>
                    </tr>                    
                    <tr>
                        <td>
                            CV {!!($docs_conf[$user_study_level]['cv']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if($cv)
                            Uploaded File: <?php echo substr($cv, 5); ?>
                            <a title="delete document" data-type="CV" data-id="{{$user->id}}" href="javascript:void(0)" class="cross del-pro-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" href="<?php echo url('storage/' . $cv) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            {{-- <input type="file" name="cv" class="form-control" accept=".doc,.docx"> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input class="form-control" id="file_cv" accept=".doc,.docx,.pdf" type="file" name="file">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="cv_loading" class="text-success p-3"><b>Uploading...</b></span>
                                <span id="cv-file-input-error" class="text-danger"></span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Student Photograph
                        </td>
                        <td class="col-4">
                            @if($stu_photo)
                            Uploaded File: <?php echo substr($stu_photo, 5); ?>
                            <a title="delete photograph" data-type="STU_PHOTO" data-id="{{$user->id}}" href="javascript:void(0)" class="cross del-pro-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $stu_photo) ?>">View</a>
                            @endif
                            <br />
                            Upload New File:
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input class="form-control" id="file_stu_photo" accept=".jpg,.jpeg,.pdf" type="file" name="file">
                                    <span class="text-danger input-err"></span>
                                </form>
                                <span style="display:none;font-weight: 700;padding-left:0px!important;" id="stu_photo_loading" class="text-success p-3"><b>Uploading...</b></span>
                                <span id="stu-photo-file-input-error" class="text-danger"></span>
                                <h6 class="card-subtitle mt-2" style="margin-bottom:2px;">Allowed formats (.pdf, .jpg, .jpeg)</h6>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Letter of Recommendation (LOR) {!!($docs_conf[$user_study_level]['lor']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}
                        </td>
                        <td class="col-4">
                            @if(count($lors)>0)
                            Uploaded Files:<br>
                            @foreach($lors as $lor)
                            <?php echo substr($lor->file, 5); ?>
                            <a title="delete document" data-type="LOR" data-id="{{$lor->id}}" href="javascript:void(0)" class="cross del-pro-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" href="<?php echo url('storage/' . $lor->file) ?>">View</a>
                            <br />
                            @endforeach
                            @endif
                            {{-- <input type="file" name="lor[]" class="form-control" accept=".pdf, .jpeg, .jpg" multiple> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input type="file" id="file_lor" class="form-control" name="file_lor[]" multiple accept="application/pdf">
                                </form>
                                <span style="display:none;" id="lor_loading" class="text-success p-3"><b>Uploading...</b></span>
                                <span id="lor-file-input-error" class="text-danger"></span>
                                <small>Multiple files allowed. (Maximum <?= $max_lor_files ?> files)</small>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Experience Letters
                        </td>
                        <td class="col-4">
                            @if(count($experience)>0)
                            Uploaded Files:<br>
                            @foreach($experience as $exp)
                            <?php echo substr($exp->file, 5); ?>
                            <a title="delete document" data-type="EXP" data-id="{{$exp->id}}" href="javascript:void(0)" class="cross del-pro-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" href="<?php echo url('storage/' . $exp->file) ?>">View</a>
                            <br />
                            @endforeach
                            @endif
                            {{-- <input type="file" name="exp[]" class="form-control" accept=".pdf, .jpeg, .jpg" multiple> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input class="form-control" type="file" id="file_exp" name="file_exp[]" multiple accept="application/pdf">
                                </form>
                                <span style="display:none;" id="file_exp_loading" class="text-success p-3"><b>Uploading...</b></span>
                                <span id="file-exp-file-input-error" class="text-danger"></span>
                            <small>Multiple files allowed (<?= $max_experience_files ?> files)</small>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Other Certificates/Documents
                        </td>
                        <td class="col-4">
                            @if(count($otherdocs)>0)
                            Uploaded Files:<br>
                            @foreach($otherdocs as $otherdoc)
                            <?php echo substr($otherdoc->file, 5); ?>
                            <a title="delete document" data-type="Others" data-id="{{$otherdoc->id}}" href="javascript:void(0)" class="cross del-pro-btn ml-1"></a>
                            <br />
                            <a class="btn btn-sm btn-outline-primary" href="<?php echo url('storage/' . $otherdoc->file) ?>">View</a>
                            <br />
                            @endforeach
                            @endif
                            {{-- <input type="file" name="other[]" class="form-control" accept=".pdf, .jpeg, .jpg" multiple> --}}
                            <div>
                                <form action="" method="post" enctype="multipart/form-data">
                                    <input class="form-control" type="file" id="file_other" name="file_other[]" multiple accept="application/pdf">
                                </form>
                                <span style="display:none;" id="file_other_loading" class="text-success p-3"><b>Uploading...</b></span>
                                <span id="file-other-file-input-error" class="text-danger"></span>
                            <small>Multiple files allowed (<?= $max_other_files ?> files)</small>
                            </div>
                        </td>
                    </tr>
                    {{-- //Additional docs Three --}}
                            @if($additional_docs_three)
                            @foreach($additional_docs_three as $adc)
                            <tr>
                                <td style="padding: 10px!important;">
                                    <h6 style="padding-top:5px;">{{$adc->title}}</h6>
                                </td>
                                <td>
                                    @if(count(get_additional_docs($user->id,$adc->doc_type)))
                                    <b>Uploaded Files:</b><br>
                                    @foreach(get_additional_docs($user->id,$adc->doc_type) as $docs)
                                    <span id="{{$adc->doc_type}}_fls"><?php echo substr($docs->file, 5); ?></span>
                                    <a title="delete document" data-additional_doc="{{$docs->doc_type}}" data-additional_id="{{$docs->id}}" href="javascript:void(0)" class="cross del-additional-btn ml-1"></a>
                                    <br />
                                    <a class="btn btn-sm btn-outline-primary" target="_blank" href="<?php echo url('storage/' . $docs->file) ?>">View</a>
                                    <br />
                                    @endforeach
                                    @endif
                                    <form action="" method="post" enctype="multipart/form-data">
                                        @csrf
                                        <input type="file" style="" class="form-control" id="{{$adc->doc_type}}" name="{{$adc->doc_type}}{{($adc->file_count > 1)? '[]' : ''}}" {{($adc->file_count > 1)? "multiple" : ""}} accept="{{$adc->file_types}}">
                                    </form>
                                    <span style="display:none;" id="{{$adc->doc_type}}_loading" class="text-success p-3"><b>Uploading...</b></span>
                                    <span id="{{$adc->doc_type}}-file-input-error" class="text-danger"></span>
                                    <p class="card-subtitle mt-2 mb-0 text-dark">Allowed file types: {{$adc->file_types}}</p>
                                        @if($adc->file_count >1)
                                            <small>Maximum <?= $adc->file_count ?> files.</small>
                                        @endif
                                </td>
                            </tr>
                        @endforeach
                    @endif
                    {{-- //Additional docs Three --}}
                    <tr>
                        <td style="padding: 10px!important;" colspan="2">
                            <h4 style="padding-top:25px;">SOP {!!($docs_conf[$user_study_level]['sop']['mandatory']) ? '<span class="col-form-label required-field"></span>' : ''!!}</h4>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <div class="row">
                                <div class="col-12">
                                    <br />
                                    <table class="table table-bordered">
                                        <thead>
                                            <td><b>Course</b></td>
                                            <td><b>University</b></td>
                                            <td><b>Upload SOP</b></td>
                                        </thead>
                                        <tbody>

                                            @if($user->coursepreferences)
                                            @foreach($user->coursepreferences as $coursepreference)
                                            <tr>
                                                 <td>
                                                    {{-- {{ ($coursepreference['course_id']) ? get_university_course_data($coursepreference['course_id'])->course_name : $coursepreference['course_other']}} --}}
                                                    @if($coursepreference['course_id'])
                                                        @if(get_university_course_data($coursepreference['course_id']))
                                                            {{ get_university_course_data($coursepreference['course_id'])->course_name }}
                                                        @else
                                                            --
                                                        @endif
                                                    @else
                                                        {{$coursepreference['course_other']}}
                                                    @endif
                                                </td>
                                                {{-- <td>{{($coursepreference['university_id']) ? get_university_data($coursepreference['university_id'])->university_name : '-'}}</td> --}}
                                                <td>  {{ $coursepreference['university_id'] 
                                                    ? optional(get_university_data($coursepreference['university_id']))->university_name 
                                                    : $coursepreference['university_other'] }}</td>
                                               
                                                <td style="width:40%;">
                                                    <span class="ref_sop">
                                                        @if(get_lead_sop_list($coursepreference['id']))
                                                        Uploaded File: <?php echo substr(get_lead_sop_list($coursepreference['id'])->file, 5); ?>
                                                        <br />
                                                        <a class="btn btn-sm btn-outline-primary" href="<?php echo url('storage/' . get_lead_sop_list($coursepreference['id'])->file) ?>">View</a>
                                                        <br />
                                                        <label>Replace File</label>
                                                        @endif
                                                    </span>
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        <input type="hidden" class="input-group" value="{{$coursepreference['id']}}" name="course_pref_id">
                                                        <input type="file" style="" class="form-control" id="file_sop{{$coursepreference['id']}}" accept=".doc,.docx,.pdf" name="file_sop">
                                                    </form>
                                                    <span style="display:none;" id="sop_loading" class="text-success p-3"><b>Uploading...</b></span>
                                                    <span id="sop-file-input-error" class="text-danger"></span>
                                                </td>
                                            </tr>
                                            @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </td>
                    </tr>
                    {{-- //essay --}}
                    <tr>
                        <td style="padding: 10px!important;" colspan="2">
                            <h4 style="padding-top:25px;">Essay</h4>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <div class="row">
                                <div class="col-12">
                                    <br />
                                    <table class="table table-bordered">
                                        <thead>
                                            <td><b>Course</b></td>
                                            <td><b>University</b></td>
                                            <td><b>Upload Essay</b></td>
                                        </thead>
                                        <tbody>

                                            @if($user->coursepreferences)
                                            @foreach($user->coursepreferences as $coursepreference)
                                            <tr>
                                                 <td>
                                                    {{-- {{ ($coursepreference['course_id']) ? get_university_course_data($coursepreference['course_id'])->course_name : $coursepreference['course_other']}} --}}
                                                    @if($coursepreference['course_id'])
                                                        @if(get_university_course_data($coursepreference['course_id']))
                                                            {{ get_university_course_data($coursepreference['course_id'])->course_name }}
                                                        @else
                                                            --
                                                        @endif
                                                    @else
                                                        {{$coursepreference['course_other']}}
                                                    @endif
                                                </td>
                                               <td>
    {{ $coursepreference['university_id'] 
        ? optional(get_university_data($coursepreference['university_id']))->university_name 
        : $coursepreference['university_other'] }}
</td>

                                                <td style="width:40%;">
                                                    <span class="ref_essay">
                                                        @if(count(get_essay_list($coursepreference['id'])))
                                                        @foreach(get_essay_list($coursepreference['id']) as $essay)
                                                        Uploaded File: <?php echo substr($essay->file, 5); ?>
                                                        <a title="delete document" data-type="Essay" data-id="{{$essay->id}}" href="javascript:void(0)" class="cross del-pro-btn ml-1"></a>
                                                        <br />
                                                        <a class="btn btn-sm btn-outline-primary" href="<?php echo url('storage/' . $essay->file) ?>">View</a>
                                                        <br>
                                                        @endforeach
                                                        @endif
                                                    </span>
                                                    <form action="" method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        <input type="hidden" class="input-group" value="{{$coursepreference['id']}}" name="course_pref_id">
                                                        <input type="file" style="" class="form-control" multiple id="file_essay{{$coursepreference['id']}}" accept=".doc,.docx,.pdf" name="file_essay[]">
                                                    </form>
                                                    <span style="display:none;" id="essay_loading" class="text-success p-3"><b>Uploading...</b></span>
                                                    <span id="essay-file-input-error" class="text-danger"></span>
                                                </td>
                                            </tr>
                                            @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </td>
                    </tr>
                    {{-- //essay --}}
                </tbody>
            </table>
            </div>
        </form>


        @if(!\Auth::user()->isAgent())
        <form method="post" id="docs_done" action="{{route('admin.studyabroad.documents.mark-done')}}">
            @csrf
            <input type="hidden" name="user_id" value="{{$user->id}}">
            <input type="checkbox" id="docs_upload_completed" name="docs_upload_completed" value="1" @if($user->profile_complete != 'course') disabled @endif
            @if($user->profile_complete == 'documents') checked @endif
            >&nbsp;<label for="docs_upload_completed">Mark all documents upload completed</label>
        </form>
        @endif

        @endif
    </div>
</div>
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<link href="{{ asset('assets/plugins/sweetalert/sweetalert.css') }}" rel="stylesheet" type="text/css">
<style>
    .cross {
        display: inline-block;
        box-sizing: border-box;
        width: 12px;
        height: 12px;
        border-width: 3px;
        border-style: solid;
        border-color: red;
        border-radius: 100%;
        background: -webkit-linear-gradient(-45deg, transparent 0%, transparent 46%, white 46%, white 56%, transparent 56%, transparent 100%), -webkit-linear-gradient(45deg, transparent 0%, transparent 46%, white 46%, white 56%, transparent 56%, transparent 100%);
        background-color: red;
        transition: all 0.3s ease;
    }
</style>
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script src="{{ asset('assets/plugins/sweetalert/sweetalert.min.js') }}"></script>
<script type="text/javascript">
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
        $('.file_edu').change(function(e) {
        e.preventDefault();
        $(this).closest('div').find('.loding').show();
        var formData = new FormData();
        var file = $(this).prop('files')[0];
        var type = $(this).attr('name');
        formData.append('type', type);
        formData.append('file', file);
        formData.append('user_id', "{{$user->id}}");
        $(this).closest('div').find('.input-err').text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('admin.studyabroad.documents.save') }}",
            data: formData,
            contentType: false,
            processData: false,
            context: this,
            success: function(data) {
                $(this).closest('div').find('.loding').hide();
                if (data.res == 'success') {
                    $(this).val('');
                    console.log(data);
                    $.toast({
                        heading: 'Success',
                        text: data.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                } else {
                    $(this).closest('div').find('.loding').hide();
                    $(this).closest('div').find('.input-err').text(data.message);
                }
            },
            error: function(response) {
                var row = $(this);
                $.each(response.responseJSON.errors, function(key, value) {
                    row.closest('div').find('.loding').hide();
                    row.closest('div').find('.input-err').text(value[0]);
                });
            }
        });
    });

$('#file_cv').change(function(e) {
        e.preventDefault();
        $('#cv_loading').show();
        var formData = new FormData();
        var file = $('#file_cv').prop('files')[0];
        formData.append('file', file);
        formData.append('user_id', "{{$user->id}}");
        $('#cv-file-input-error').text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('admin.studyabroad.documents.cv.upload') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $('#cv_loading').hide();
                if (data == 'success') {
                    $('#file_cv').val('');
                    console.log(data);
                    $.toast({
                        heading: 'Success',
                        text: 'CV has been uploaded successfully',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                }
            },
            error: function(response) {
                $('#cv_loading').hide();
                $.each(response.responseJSON.errors, function(key, value) {
                    $('#cv-file-input-error').html(value[0]);
                });
            }
        });
    });


    $('#file_stu_photo').change(function(e) {
        e.preventDefault();
        $('#stu_photo_loading').show();
        var formData = new FormData();
        var file = $('#file_stu_photo').prop('files')[0];
        formData.append('file', file);
        formData.append('user_id', "{{$user->id}}");
        $('#stu-photo-file-input-error').text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('admin.studyabroad.documents.stu-photo.upload') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $('#stu_photo_loading').hide();
                if (data == 'success') {
                    $('#file_stu_photo').val('');
                    console.log(data);
                    $.toast({
                        heading: 'Success',
                        text: 'Student Photograph has been uploaded successfully',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                }
            },
            error: function(response) {
                $('#stu_photo_loading').hide();
                $.each(response.responseJSON.errors, function(key, value) {
                    $('#stu-photo-file-input-error').html(value[0]);
                });
            }
        });
    });

$('#file_passport').change(function(e) {
        e.preventDefault();
        $('#passport_loading').show();
        var formData = new FormData();
        var files = $('#file_passport')[0].files;
        console.log(files.length);
        var files_left = <?= $pass_files_left ?>;
        formData.append('user_id', "{{$user->id}}");
        if (files.length > files_left) {
            $('#passport_loading').hide();
            if (files_left == 0) {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            } else {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more than ' + files_left + ' documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            }
        } else {
            for (var i = 0; i < files.length; i++) {
                formData.append("files[]", files[i], files[i]['name']);
            }
            $('#pass-file-input-error').text('');
            $.ajax({
                type: 'POST',
                url: "{{ route('admin.studyabroad.documents.pass.upload') }}",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#passport_loading').hide();
                    if (data == 'success') {
                        $('#file_passport').val('');
                        console.log(data);
                        $.toast({
                            heading: 'Success',
                            text: 'Passport has been uploaded successfully',
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                    }
                    if (data == 'error') {
                        $('#file_passport').val('');
                        console.log(data);
                        $('#pass-file-input-error').text('Something went wrong');
                    }
                },
                error: function(response) {
                    $('#passport_loading').hide();
                    $.each(response.responseJSON.errors, function(key, value) {
                        $('#pass-file-input-error').html(value[0]);
                    });
                }
            });
        }
    });

    $('#file_lor').change(function(e) {
        e.preventDefault();
        $('#lor_loading').show();
        var formData = new FormData();
        var files = $('#file_lor')[0].files;
        console.log(files.length);
        var files_left = <?= $lor_files_left ?>;
        formData.append('user_id', "{{$user->id}}");
        if (files.length > files_left) {
            $('#lor_loading').hide();
            if (files_left == 0) {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            } else {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more than ' + files_left + ' documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            }
        } else {
            for (var i = 0; i < files.length; i++) {
                formData.append("files[]", files[i], files[i]['name']);
            }
            $('#lor-file-input-error').text('');
            $.ajax({
                type: 'POST',
                url: "{{ route('admin.studyabroad.documents.lor.upload') }}",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#lor_loading').hide();
                    if (data == 'success') {
                        $('#file_lor').val('');
                        console.log(data);
                        $.toast({
                            heading: 'Success',
                            text: 'LOR has been uploaded successfully',
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                    }
                    if (data == 'error') {
                        $('#file_lor').val('');
                        console.log(data);
                        $('#lor-file-input-error').text('Something went wrong');
                    }
                },
                error: function(response) {
                    $('#lor_loading').hide();
                    $.each(response.responseJSON.errors, function(key, value) {
                        $('#lor-file-input-error').html(value[0]);
                    });
                }
            });
        }
    });

    $('#file_exp').change(function(e) {
        e.preventDefault();
        $('#file_exp_loading').show();
        var formData = new FormData();
        formData.append('user_id', "{{$user->id}}");
        var files = $('#file_exp')[0].files;
        console.log(files.length);
        var exp_files_left = <?= $exp_files_left ?>;
        if (files.length > exp_files_left) {
            $('#file_exp_loading').hide();
            if (exp_files_left == 0) {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            } else {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more than ' + exp_files_left + ' documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            }
        } else {
            for (var i = 0; i < files.length; i++) {
                formData.append("files[]", files[i], files[i]['name']);
            }
            $('#file-exp-file-input-error').text('');
            $.ajax({
                type: 'POST',
                url: "{{ route('admin.studyabroad.documents.exp.upload') }}",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#file_exp_loading').hide();
                    if (data == 'success') {
                        $('#file_exp').val('');
                        console.log(data);
                        $.toast({
                            heading: 'Success',
                            text: 'Work Experience Letter has been uploaded successfully',
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                    }
                    if (data == 'error') {
                        $('#file_exp').val('');
                        console.log(data);
                        $('#file-exp-file-input-error').text('Something went wrong');
                    }
                },
                error: function(response) {
                    $('#file_exp_loading').hide();
                    $.each(response.responseJSON.errors, function(key, value) {
                        $('#file-exp-file-input-error').html(value[0]);
                    });
                }
            });
        }
    });

    $('#file_other').change(function(e) {
        e.preventDefault();
        $('#file_other_loading').show();
        var formData = new FormData();
        formData.append('user_id', "{{$user->id}}");
        var files = $('#file_other')[0].files;
        console.log(files.length);
        var other_files_left = <?= $other_files_left ?>;
        if (files.length > other_files_left) {
            $('#file_other_loading').hide();
            if (other_files_left == 0) {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            } else {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more than ' + other_files_left + ' documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            }
        } else {
            for (var i = 0; i < files.length; i++) {
                formData.append("files[]", files[i], files[i]['name']);
            }
            $('#file-other-file-input-error').text('');
            $.ajax({
                type: 'POST',
                url: "{{ route('admin.studyabroad.documents.other.upload') }}",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#file_other_loading').hide();
                    if (data == 'success') {
                        $('#file_other').val('');
                        console.log(data);
                        $.toast({
                            heading: 'Success',
                            text: 'Other Certificate has been uploaded successfully',
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 1000,
                            stack: 6
                        });
                        location.reload();
                    }
                    if (data == 'error') {
                        $('#file_other').val('');
                        console.log(data);
                        $('#file-other-file-input-error').text('Something went wrong');
                    }
                },
                error: function(response) {
                    $('#file_other_loading').hide();
                    $.each(response.responseJSON.errors, function(key, value) {
                        $('#file-other-file-input-error').html(value[0]);
                    });
                }
            });
        }
    });

    $(".del-edu-btn").on("click", function() {
        var id = $(this).data('id');
        var type = $(this).data('type');
        swal({
            title: "Are you sure?",
            text: "Do you want to delete?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }, function() {
            $.ajax({
                url: "{{route('admin.studyabroad.documents.edu.delete')}}",
                type: "POST",
                data: {
                    id: id,
                    type: type,
                    _token: '{{csrf_token()}}'
                },
                context: this,
                success: function(result) {
                    $.toast({
                        heading: 'Deleted',
                        text: result.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                }
            });
        });

    });

    $(".del-pro-btn").on("click", function() {
        var id = $(this).data('id');
        var type = $(this).data('type');

        swal({
            title: "Are you sure?",
            text: "Do you want to delete?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }, function() {
            $.ajax({
                url: "{{route('admin.studyabroad.documents.pro.delete')}}",
                type: "POST",
                data: {
                    id: id,
                    type: type,
                    _token: '{{csrf_token()}}'
                },
                context: this,
                success: function(result) {
                    $.toast({
                        heading: 'Deleted',
                        text: result.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                }
            });
        });

    });

    @if($user->coursepreferences)
    @foreach($user->coursepreferences as $coursepreference)
    var cnt = "{{$coursepreference['id']}}";
    $('#file_sop' + cnt).change(function(e) {
        e.preventDefault();
        var $loading = $(this).closest('tr').find('#sop_loading');
        var $err = $(this).closest('tr').find('#sop-file-input-error');
        $loading.show();
        var formData = new FormData();
        var file = $(this).prop('files')[0];
        var course_pref_id = $(this).closest('tr').find("input[name='course_pref_id']").val();
        var user_id = "{{$user->id}}";
        formData.append('file', file);
        formData.append('user_id', user_id);
        formData.append('course_pref_id', course_pref_id);
        formData.append('_token', '{{csrf_token()}}');

        $err.text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('admin.studyabroad.documents.sop.upload') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $loading.hide();
                if (data == 'success') {
                    $(this).val('');
                    $.toast({
                        heading: 'Success',
                        text: 'SOP has been uploaded successfully',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3000,
                        stack: 6
                    });
                    location.reload();
                }
            },
            error: function(response) {
                $loading.hide();
                // $err.text(response.responseJSON.message);
                $.each(response.responseJSON.errors, function(key, value) {
                    $err.html(value[0]);
                });
            }
        });
    });

// Essay
$('#file_essay' + cnt).change(function(e) {
        e.preventDefault();
        var $loading = $(this).closest('tr').find('#essay_loading');
        var $err = $(this).closest('tr').find('#essay-file-input-error');
        $loading.show();
        var formData = new FormData();
        //var file = $(this).prop('files')[0];
        var course_pref_id = $(this).closest('tr').find("input[name='course_pref_id']").val();
        var user_id = "{{$user->id}}";
        let totalFiles = $(this).prop('files').length;
        let files = $(this).prop('files');
         //alert(files.name);
        for (var i = 0; i < totalFiles; i++) {
            formData.append("files[]", files[i], files[i].name);
        }
        formData.append('totalFiles', totalFiles);
        //formData.append('file', file);
        formData.append('user_id', user_id);
        formData.append('course_pref_id', course_pref_id);
        formData.append('_token', '{{csrf_token()}}');

        $err.text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('admin.studyabroad.documents.essay.upload') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                // console.log("Return: "+data);
                $loading.hide();
                if (data == 'success') {
                    $(this).val('');
                    $.toast({
                        heading: 'Success',
                        text: 'Essay has been uploaded successfully',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3000,
                        stack: 6
                    });
                    location.reload();
                }
                if (data == 'error_max_files') {
                    $(this).val('');
                    $.toast({
                        heading: 'Error',
                        text: 'You can upload upto '+{{env("MAX_ESSAY_FILES")}}+' essays for each course preference',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 8
                    });
                    //  location.reload();
                }
            },
            error: function(response) {
                $loading.hide();
                //$err.text(response.responseJSON.message);
                $.each(response.responseJSON.errors, function(key, value) {
                    $err.html(value[0]);
                });
            }
        });
    });
//essay
    @endforeach
    @endif


 @if($additional_docs_one)
    @foreach($additional_docs_one as $adc)
    <?php $add_files_left = $adc->file_count - get_docs_count($user->id,$adc->doc_type); ?>
    $("#{{$adc->doc_type}}").change(function(e) {
        e.preventDefault();
        var $loading = $(this).closest('div').find("#{{$adc->doc_type}}_loading");
        var $err = $(this).closest('div').find("#{{$adc->doc_type}}-file-input-error");
        $loading.show();

        var formData = new FormData();
        var files = $('#{{$adc->doc_type}}')[0].files;

        var add_files_left = <?= $add_files_left ?>;

        if (files.length > add_files_left) {
            $loading.hide();
            if (add_files_left == 0) {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            } else {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more than ' + add_files_left + ' documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            }
        } else {
        for (var i = 0; i < files.length; i++) {
                formData.append("files[]", files[i], files[i]['name']);
        }
        formData.append('doc_type', "{{$adc->doc_type}}");
        var user_id = "{{$user->id}}";
        formData.append('user_id', user_id);
        formData.append('_token', '{{csrf_token()}}');
        formData.append('file_types', "{{$adc->file_types}}");

        $err.text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('admin.studyabroad.documents.additional.upload') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $loading.hide();
                console.log(data);
                if (data == 'success') {
                    $(this).val('');
                    $.toast({
                        heading: 'Success',
                        text: '{{$adc->title}} document has been uploaded successfully',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                }
            },
            error: function(response) {
                $loading.hide();
                $.each(response.responseJSON.errors, function(key, value) {
                    $err.html(value[0]);
                });
            }
        });
        }
    });
@endforeach
@endif
@if($additional_docs_two)
    @foreach($additional_docs_two as $adc)
    <?php $add_files_left = $adc->file_count - get_docs_count($user->id,$adc->doc_type); ?>
    $("#{{$adc->doc_type}}").change(function(e) {
        e.preventDefault();
        var $loading = $(this).closest('div').find("#{{$adc->doc_type}}_loading");
        var $err = $(this).closest('div').find("#{{$adc->doc_type}}-file-input-error");
        $loading.show();

        var formData = new FormData();
        var files = $('#{{$adc->doc_type}}')[0].files;

        var add_files_left = <?= $add_files_left ?>;

        if (files.length > add_files_left) {
            $loading.hide();
            if (add_files_left == 0) {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            } else {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more than ' + add_files_left + ' documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            }
        } else {
        for (var i = 0; i < files.length; i++) {
                formData.append("files[]", files[i], files[i]['name']);
        }
        formData.append('doc_type', "{{$adc->doc_type}}");
        var user_id = "{{$user->id}}";
        formData.append('user_id', user_id);
        formData.append('_token', '{{csrf_token()}}');
        formData.append('file_types', "{{$adc->file_types}}");

        $err.text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('admin.studyabroad.documents.additional.upload') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $loading.hide();
                console.log(data);
                if (data == 'success') {
                    $(this).val('');
                    $.toast({
                        heading: 'Success',
                        text: '{{$adc->title}} document has been uploaded successfully',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                }
            },
            error: function(response) {
                $loading.hide();
                $.each(response.responseJSON.errors, function(key, value) {
                    $err.html(value[0]);
                });
            }
        });
        }
    });
@endforeach
@endif
@if($additional_docs_three)
    @foreach($additional_docs_three as $adc)
    <?php $add_files_left = $adc->file_count - get_docs_count($user->id,$adc->doc_type); ?>
    $("#{{$adc->doc_type}}").change(function(e) {
        e.preventDefault();
        var $loading = $(this).closest('div').find("#{{$adc->doc_type}}_loading");
        var $err = $(this).closest('div').find("#{{$adc->doc_type}}-file-input-error");
        $loading.show();

        var formData = new FormData();
        var files = $('#{{$adc->doc_type}}')[0].files;

        var add_files_left = <?= $add_files_left ?>;

        if (files.length > add_files_left) {
            $loading.hide();
            if (add_files_left == 0) {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            } else {
                $.toast({
                    heading: 'Warning',
                    text: 'You cannot upload more than ' + add_files_left + ' documents.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'warning',
                    hideAfter: 4000,
                    stack: 6
                });
            }
        } else {
        for (var i = 0; i < files.length; i++) {
                formData.append("files[]", files[i], files[i]['name']);
        }
        formData.append('doc_type', "{{$adc->doc_type}}");
        var user_id = "{{$user->id}}";
        formData.append('user_id', user_id);
        formData.append('_token', '{{csrf_token()}}');
        formData.append('file_types', "{{$adc->file_types}}");

        $err.text('');
        $.ajax({
            type: 'POST',
            url: "{{ route('admin.studyabroad.documents.additional.upload') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $loading.hide();
                console.log(data);
                if (data == 'success') {
                    $(this).val('');
                    $.toast({
                        heading: 'Success',
                        text: '{{$adc->title}} document has been uploaded successfully',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    location.reload();
                }
            },
            error: function(response) {
                $loading.hide();
                $.each(response.responseJSON.errors, function(key, value) {
                    $err.html(value[0]);
                });
            }
        });
        }
    });
@endforeach
@endif
$(".del-additional-btn").on("click", function() {
        var additional_id = $(this).data('additional_id');
        var additional_doc = $(this).data('additional_doc'); 
        swal({
            title: "Are you sure?",
            text: "Do you want to delete?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }, function() {
            $.ajax({
                url: "{{route('admin.studyabroad.documents.additional.delete')}}",
                type: "POST",
                data: {
                    additional_id: additional_id,
                    _token: '{{csrf_token()}}'
                },
                context: this,
                success: function(result) {
                    $.toast({
                        heading: 'Deleted',
                        text: result.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 1000,
                        stack: 6
                    });
                    
                  
                    location.reload();
                    //alert('#'+additional_doc+"_fls");
                    //$('#'+additional_doc+"_fls").load('#'+additional_doc+"_fls")
                    // $("#ref_lor").load(location.href + " #ref_lor");
                }
            });
        });
    });

    $('#docs_upload_completed').on("click", function() {
        swal({
            title: "Are you sure?",
            text: "Do you want to contiue?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes",
            closeOnConfirm: true
        }, function() {
            $('#docs_done').submit();
        });

    });
</script>
@endpush