@php $agent = get_user_by_id($user->agent_id); @endphp
<div class="row">
    <div class="col-md-8">
        @if(!$user->is_lead && (!is_staff_user($user->id)))
        <div class="row">
            <div class="col-md-6 text-left">
                <b>Status:</b>
                <span id="stat_text"><span class="badge" style="font-size: 13px!important;font-weight: 400; background-color: {{get_overseas_status_color($user->overseas_status)}};">{{$user->overseas_status}}</span></span>
                <div class="form-group" style="display:inline-flex;">    
                   <span id="select_stat_input" style="display:none;">
                    <form action="{{route('admin.auth.user.change-overseas-status')}}" method="POST" id="stu_stat_form">
                    <input type="hidden" id="stu_id" name="stu_id" value="{{$user->id}}">
                    @csrf
                    <select name="student_status" onchange="changeStatus({{$user->id}}, this.value)" class="form-select mb-0">
                        @foreach(get_overseas_status_list() as $stu_status_data)
                        <option value="{{$stu_status_data->status}}" {{($stu_status_data->status == $user->overseas_status)? 'selected' : ''}}>{{$stu_status_data->status}}</option>
                        @endforeach
                    </select>
                    </form>
                    </span> 
                    @if (!auth()->user()->isAgent())
                    <button class="btn" style="margin-bottom:0px!important;" id="edit_status_button"><i class="fa fa-edit text-primary"></i></button>
                    @endif
                </div>
            </div>
            @if(!\Auth::user()->isAgent())
            <div class="{{(!$user->is_lead)? 'col-md-6' : 'col-md-8'}} p-2 " style="text-align: right;">
                <b>Next Follow-up:</b> {!! ($user->next_followup) ? '<span class="bg-warning p-1 rounded fw-bold">'. date('d/m/Y h:s A', strtotime($user->next_followup)) .'</span>' : '--' !!}
            </div>
            @endif
        </div>
        @endif
        {{-- @if($user->student_type=='study_abroad_course' || $user->student_type=='study_abroad')
        @if(!$user->is_lead)
        <h5 class="mt-3">University Applications</h5>
        @if(count($user->applications))
        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
            <table class="table table-hover bg-none mb-0">
                <tr>
                    <th>ID</th>
                    <th>Country</th>
                    <th>University/Course</th>
                    <th style="min-width: 95px !important;">Intake</th>
                </tr>
                @foreach($user->applications as $application)
                <tr>
                    <td><strong><a href="{{ route('admin.applicationdetail', $application['id']) }}">{{$application['appl_id']}}</a></strong></td>
                    <td>{{ $application['country'] }}</td>
                    <td>{{$application['university']}} - {{$application['course']}}</td>
                    <td>{{$application['year']}} - {{$application['intake']}}</td>
                </tr>
                @endforeach
            </table>
        </div>
        @else
        No University Applications found!
        @endif
        @endif --}}
        {{-- @elseif($user->student_type=='abroad_job')

        <h6>University Applications</h6>
        @if(count($user->applications))
        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
            <table class="table table-hover bg-none mb-0">
                <tr>
                    <th>ID</th>
                    <th>Country</th>
                </tr>
                @foreach($user->applications as $application)
                <tr>
                    <td><a href="{{ route('admin.applicationdetail', $application['id']) }}">{{$application['appl_id']}}</a></td>
                    <td>{{ $application['country'] }}</td>
                </tr>
                @endforeach
            </table>
        </div>
        @else
        No University Applications found!
        @endif --}}

        {{-- @elseif($user->student_type=='visa')
        <h6>Visa Applications</h6>
        @if(count($user->applications))
        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
            <table class="table table-hover bg-none mb-0">
                <tr>
                    <th>ID</th>
                    <th>Details</th>
                </tr>
                @foreach($user->applications as $application)
                <tr>
                    <td><a href="{{ route('admin.applicationdetail', $application['id']) }}">{{$application['appl_id']}}</a></td>
                    <td>{!! $application['country'] !!}</td>
                </tr>
                @endforeach
            </table>
        </div>
        @else
        No applications found!
        @endif
        @endif --}}

        {{-- @if($user->student_type=='study_abroad_course' || $user->student_type=='course')
        @if(!$user->is_lead)
        <h6 class="mt-2">Batches</h6>
        @if(count($student_batches))
        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
            <table class="table table-hover bg-none mb-0">
                <tr>
                    <th>Course</th>
                    <th>Batch</th>
                    <th>Branch</th>
                    <th>Batch Start</th>
                </tr>
                @foreach($student_batches as $batch)
                <tr>
                    <td>{{$batch->course}}</td>
                    <td><a href="{{route('admin.batch.managestudent', $batch->batch_id)}}">{{$batch->batch_code}}</a></td>
                    <td>{{$batch->branch}}</td>
                    <td>{{$batch->start_date}}</td>
                </tr>
                @endforeach
            </table>
        </div>
        @else
        No batches found!
        @endif
        @endif
        @endif --}}


        {{--<h6>Tags</h6>
        <div>
            {!! $user->tags_label !!}
        </div>
        <br />
        <h6>Recent Tickets</h6>
        <div>

        </div>        
        <br />
        <br />--}}


        <h5 class="mt-4">Basic Details</h5>
        <div class="p-3" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
            {{-- <table class="table table-hover bg-none mb-0">
                <tr>
                    <th>ID</th>
                    <td>{{$user->id}}</td>
                </tr> --}}
                {{-- @if(!isset($is_staff))
                    @if(config('app.product_code') == 'EDUCTRL_CRM')
                    <tr>
                        <th>Type/Interested In</th>
                        <td>{!! $user->student_type_label !!}</td>
                    </tr>
                    @endif
                    @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM' || config('app.product_code') == 'VISA')
                        @if($user->student_type=='study_abroad' || $user->student_type=='study_abroad_course' || $user->student_type=='visa')
                            @if(!\Auth::user()->isAgent())
                            <tr>
                                <th>Agent</th>
                                @php
                                $agent = get_user_by_id($user->agent_id);
                                @endphp
                                <td>
                                    {{ $agent ? $agent->first_name." ".$agent->last_name." (".$agent->email.")" : "-"}}
                                    @if($agent)
                                        <a target="_blank" href="{{route('admin.communicate.mail', $user->agent_id)}}" class="me-1 text-primary" title="Email"><i class="bi bi-envelope" style="font-size: 16px"></i></a> 
                                        <a target="_blank" href="{{route('admin.communicate.sms', $user->agent_id)}}" class="text-primary" title="SMS"><i class="bi bi-chat-dots" style="font-size: 16px"></i></a>
                                    @endif
                                </td>
                            </tr>
                            @endif
                        @endif
                    @endif
                @endif --}}
                @if (!is_staff_user($user->id))
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Gender</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ucfirst($user->gender)}}</p>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Date of Birth</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ $user->birthday ? date('d-m-Y', strtotime($user->birthday)) : '-' }}</p>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Interested Study Level</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ $user->overseas_study_level_selection ? $user->overseas_study_level_selection : '-'}}</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Country Interested in</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                                @php
                                    $show_country = "";
                                    $country_interested = explode(",",$user->country_interested);
                                @endphp
                                    @if(filter_var($country_interested[0], FILTER_VALIDATE_INT))
                                        @foreach ($country_interested as $country) 
                                            @php
                                                $show_country .= get_country_name($country);
                                            @endphp
                                            @if(!$loop->last)
                                                $show_country .= ", ";
                                            @endif
                                        @endforeach
                                    @else
                                        @php
                                            $show_country = $user->country_interested;
                                        @endphp
                                    @endif
                                {{-- {{ $user->country_interested ? $user->country_interested : '-' }} --}}
                                {{ $show_country }}
                            </p>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Course Interested to Study</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ $user->overseas_course_intersted ? $user->overseas_course_intersted : '-'}}</p>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Intake</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails){{ $userDetails->intake_month ? date('F', mktime(0,0,0,$userDetails->intake_month)) : '-'}} {{ $userDetails->intake_year ? $userDetails->intake_year : '-'}} @endif</p>
                        </div>
                    </div>
                    @if(env('ADDITIONAL_SERVICES_ENABLE'))
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Other Services Interested In</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                                @if($user->services)
                                    @php 
                                        $service_interested = explode(",", $user->services);
                                    @endphp
                                    {{get_all_services($service_interested, false)}}
                                @else
                                    -
                                @endif</p>
                        </div>
                        {{-- <div class="col-sm-12 col-md-4">
                            <label>Course Interested to Study</label>
                            <p>{{ $user->overseas_course_intersted ? $user->overseas_course_intersted : '-'}}</p>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label>Intake</label>
                            <p>@if($userDetails) {{ $userDetails->intake_year ? $userDetails->intake_year : '-'}} @endif</p>
                        </div> --}}
                    </div>
                    @endif
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Qualification</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails) {{ $userDetails->highest_level_education ? ucfirst($userDetails->highest_level_education) : '-' }} @endif</p>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Passout Year</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails) {{ $userDetails->passout_year ? $userDetails->passout_year : '-' }} @endif</p>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Score/Grade</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails) {{ $userDetails->qualification_score ? $userDetails->qualification_score : '-' }} @endif</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Currently Studying Course</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails) {{ $userDetails->current_course ? $userDetails->current_course : '-'}} @endif</p>
                        </div>
                        {{-- <div class="col-sm-12 col-md-4">
                            <label>Passout Year</label>
                            <p>@if($userDetails) {{ $userDetails->passout_year ? $userDetails->passout_year : '-' }} @endif</p>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label>Score/Grade</label>
                            <p>@if($userDetails) {{ $userDetails->qualification_score ? $userDetails->qualification_score : '-' }} @endif</p>
                        </div> --}}
                    </div>
                    <div class="row">
                        <div class="col-12">
                            @if($userDetails && $userDetails->lead_notes)
                                <div style="border: 1px solid rgb(214, 214, 42); border-radius: 10px; padding: 10px;">
                                    {!!nl2br($userDetails->lead_notes)!!}
                                </div>
                            @endif
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">ID</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{$user->id}}</p>
                        </div>
                        @if(!\Auth::user()->isAgent())
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Branch</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{branch_name($user->branch)}}</p>
                        </div>
                        @endif
                        @if(!\Auth::user()->isAgent())
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Assigned to Staff</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{$user->assigned_to ? get_user_full_name_by_id($user->assigned_to) : '-'}}</p>
                        </div>
                        @endif
                    </div>
                    @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM' || config('app.product_code') == 'VISA')
                        @if($user->student_type=='study_abroad' || $user->student_type=='study_abroad_course' || $user->student_type=='visa')
                            @if(!\Auth::user()->isAgent())
                            <div class="row">
                                <div class="col-sm-12">
                                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Agent</label>
                                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@php
                                        @endphp
                                        {{ $agent ? $agent->first_name." ".$agent->last_name." (".$agent->email.")" : "-"}}
                                        @if($agent)
                                            <br>
                                            <a target="_blank" href="{{route('admin.communicate.mail', $user->agent_id)}}" class="me-3 text-primary" title="Email"><i class="bi bi-envelope" style="font-size: 18px !important;"></i></a> 
                                            <a target="_blank" href="{{route('admin.communicate.sms', $user->agent_id)}}" class="text-primary" title="SMS"><i class="bi bi-chat-dots" style="font-size: 18px !important;"></i></a>
                                        @endif
                                        </p>
                                </div>
                            </div>
                            @endif
                        @endif
                    @endif
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Lead Source</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{$user->lead_source}}</p>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Lead Source Details</label>
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;"> @if($userDetails->lead_source_detail) ({{$userDetails->lead_source_detail}}) @else - @endif</p>
                        </div>
                        {{-- <div class="col-sm-12 col-md-4">
                            <label>Assigned to Staff</label>
                            <p>{{$user->assigned_to ? get_user_full_name_by_id($user->assigned_to) : '-'}}</p>
                        </div> --}}
                    </div>
                    <hr>
                @endif  
                <div class="row">
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Status</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{!! $user->status_label !!}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Last Login At</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($user->last_login_at)
                            {{ timezone()->convertToLocal($user->last_login_at) }}
                            @else
                            N/A
                            @endif
                        </p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Last Login IP</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ $user->last_login_ip ?? 'N/A' }}</p>
                    </div>
                </div>

                {{-- <tr>
                    <th>Gender</th>
                    <td>{{ucfirst($user->gender)}}</td>
                </tr>
                <tr>
                    <th>Date of Birth</th>
                    <td>{{ $user->birthday ? date('d-m-Y', strtotime($user->birthday)) : '-' }}</td>
                </tr>
                
                <tr>
                    <th>Branch</th>
                    <td>{{branch_name($user->branch)}}</td>
                </tr>
               
                <tr>
                    <th>Assigned to Staff</th>
                    <td>{{$user->assigned_to ? get_user_full_name_by_id($user->assigned_to) : '-'}}</td>
                </tr>  
                <tr>
                    <th>Interested Study Level</th>
                    <td>{{ $user->overseas_study_level_selection ? $user->overseas_study_level_selection : '-'}}</td>
                </tr>
                <tr>
                    <th>Country Interested in</th>
                    <td>{{ $user->country_interested ? $user->country_interested : '-' }}</td>
                </tr>
                <tr>
                    <th>Course Interested to Study</th>
                    <td>{{ $user->overseas_course_intersted ? $user->overseas_course_intersted : '-'}}</td>
                </tr>
                <tr>
                    <th>Intake</th>
                    <td>@if($userDetails) {{ $userDetails->intake_year ? $userDetails->intake_year : '-'}} @endif</td>
                </tr>
                <tr>
                    <th>Other Services Interested In</th>
                    <td>@if($user->services)
                        @php 
                            $service_interested = explode(",", $user->services);
                        @endphp
                        @foreach($service_interested as $interest)
                            @if(!$loop->last)
                                {{get_services($interest)}},
                            @else
                                {{get_services($interest)}}
                            @endif
                        @endforeach
                        @else
                        -
                        @endif
                    </td>
                </tr>
                <tr>
                    <th>Qualification</th>
                    <td>@if($userDetails) {{ $userDetails->highest_level_education ? ucfirst($userDetails->highest_level_education) : '-' }} @endif</td>
                </tr>
                <tr>
                    <th>Passout Year</th>
                    <td>@if($userDetails) {{ $userDetails->passout_year ? $userDetails->passout_year : '-' }} @endif</td>
                </tr>
                <tr>
                    <th>Score/Grade</th>
                    <td>@if($userDetails) {{ $userDetails->qualification_score ? $userDetails->qualification_score : '-' }} @endif</td>
                </tr>
               
                <tr>
                    <th>Currently Studying Course</th>
                    <td>@if($userDetails) {{ $userDetails->current_course ? $userDetails->current_course : '-'}} @endif</td>
                </tr>              
                <tr>
                    <th>Lead Source</th>
                    <td>{{$user->lead_source}} @if($userDetails->lead_source_detail) ({{$userDetails->lead_source_detail}}) @else - @endif</td>
                </tr> 
                @endif               
                <tr>
                    <th>@lang('labels.backend.access.users.tabs.content.overview.status')</th>
                    <td>{!! $user->status_label !!}</td>
                </tr> --}}

                {{-- 
                    This is not used
                    <tr>
                    <th>Email Confirmed</th>
                    <td>{!! $user->confirmed_label !!}</td>
                </tr> --}}

                {{-- <tr>
                    <th>@lang('labels.backend.access.users.tabs.content.overview.timezone')</th>
                    <td>{{ $user->timezone }}</td>
                </tr>

                <tr>
                    <th>@lang('labels.backend.access.users.tabs.content.overview.last_login_at')</th>
                    <td>
                        @if($user->last_login_at)
                        {{ timezone()->convertToLocal($user->last_login_at) }}
                        @else
                        N/A
                        @endif
                    </td>
                </tr>

                <tr>
                    <th>@lang('labels.backend.access.users.tabs.content.overview.last_login_ip')</th>
                    <td>{{ $user->last_login_ip ?? 'N/A' }}</td>
                </tr>
            </table> --}}
        </div>

        
@if(!\Auth::user()->isAgent() && !is_staff_user($user->id))
<div class="row mt-5">
    <div class="col-sm-9">
        <h4>Invoices</h4>
    </div>
    <div class="col-sm-3">
        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Application Stage" style="float: right;">
            <a href="{{route('admin.invoice.student-invoice-generate', $user->id)}}" target="_blank" class="btn btn-primary btn-sm ml-1" title="Add New Invoice"><i class="bi bi-plus-circle"></i> Create</a>
        </div>
    </div>
</div>
<div class="row">
    <div class="col">
        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
            <table class="table table-hover table-striped mb-0" id="invoice_tbl">
                <thead>
                    <tr>
                        <th style="font-size: 16px !important;">Date</th>
                        <th style="font-size: 16px !important;">Invoice #</th>
                        <th style="font-size: 16px !important;">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @if(count($invoice))
                        @foreach($invoice as $page)
                        <tr>
                            <td>{{get_date_formated($page->created_at)}}</td>
                            <td>
                                <a href="{{route('admin.invoice.view-student-invoice', $page->id)}}" target='_blank' style="text-decoration: underline;">
                                    {{$page->invoice_num}}
                                </a>
                            </td>
                            <td>
                                Total: {{config('app.currency_symbol')}} {{$page->grand_total}}  <br>
                                @php $total_invoice_payment = get_total_invoice_payment($page->id); @endphp
                                Due: {{config('app.currency_symbol')}} {{$total_invoice_payment ? $page->grand_total - $total_invoice_payment : $page->grand_total}}
                            </td>
                        </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="3">No Records Found</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="row mt-5">
    <div class="col-sm-9">
        <h4>{{_label('backend_support_tickets_menu')}}</h4>
    </div>
    <div class="col-sm-3">
        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Application Stage" style="float: right;">
            <a href="{{route('admin.newticket', $user->id)}}" target="_blank" class="btn btn-primary btn-sm ml-1" title="Add New Ticket"><i class="bi bi-plus-circle"></i> Create</a>
        </div>
    </div>
</div>
<div class="row">
    <div class="col">
        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
            <table class="table table-hover table-striped mb-0" id="invoice_tbl">
                <thead>
                    <tr>
                        <th style="font-size: 16px !important; width:40%;">Ticket</th>
                        <th style="font-size: 16px !important;">Assigned To</th>                            
                        <th style="font-size: 16px !important;">Status</th>    
                        <th style="font-size: 16px !important;">Last Reply</th>
                    </tr>
                </thead>
                <tbody>
                    @if(count($tickets))
                        @foreach($tickets as $ticket)
                        <tr>
                            <td>
                                <a href="{{route('admin.viewticket', $ticket->ticket_id)}}" target="_blank" style="text-decoration: underline;">
                                    #{{$ticket->ticket_id}} {{$ticket->subject}}
                                </a>
                            </td>
                            <td>
                                @if($ticket->assigned_to) 
                                    {{get_user_full_name_by_id($ticket->assigned_to)}}
                                @else
                                    --
                                @endif
                            </td>
                            <td>
                                @if ($ticket->status == 'new')
                                    <span class="badge badge-danger">New</span>
                                @elseif ($ticket->status == 'customer_reply')
                                    <span class="badge badge-warning">User Replied</span>
                                @elseif ($ticket->status == 'staff_reply')
                                    <span class="badge badge-success">Answered</span>
                                @elseif ($ticket->status == 'inprogress')
                                    <span class="badge badge-default">In Progress</span>
                                @else
                                    <span class="badge badge-disabled">Closed</span>
                                @endif
                            </td>
                            <td>
                                {{get_date_time_formated($ticket->updated_at)}}
                            </td>
                        </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="4">No Records Found</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>
@endif
    </div>
    
    @if(!\Auth::user()->isAgent())
    <!--table-responsive-->
    <div class="col-md-4" style="padding-left: 15px;">
        @if(!isset($is_staff) && !$user->is_lead)
            <a class="followup-btn btn btn-outline-primary" href="#"><i class="fa fa-user-clock"></i> &nbsp;&nbsp;&nbsp;New Follow-up Record</a>
        @endif
        @if(!isset($is_staff))
        <div class="card mt-3">
            <div class="card-header py-2 bg-primary text-white border-primary" style="font-size: 16px !important; background-color: rgb(232, 232, 232);">Actions</div>
            <ul class="list-group" style="border-radius: 0px !important;">
                @if(!auth()->user()->isAgent() && !$user->is_lead)
                {{-- <a class="list-group-item followup-btn" href="#"><i class="fa fa-user-clock"></i> &nbsp;&nbsp;&nbsp;New Follow-up Record</a> --}}
                <a class="list-group-item" href="{{ route('admin.ticketlist').'/?q='.$user->id }}"><i class="ri-ticket-2-fill menu-icon text-primary"></i> &nbsp;&nbsp;&nbsp;View Support Tickets</a>
                @endif 
                @if(!($user->confirmed))
                <a class="list-group-item" href="{{ url("admin/auth/user/".$user->id."/account/confirm/resend") }}"><i class="bi bi-arrow-clockwise text-primary"></i> &nbsp;&nbsp;&nbsp;Resend Confirmation Code</a>
                <span class="list-group-item"><i class="fas fa-check text-muted"></i> &nbsp;&nbsp;&nbsp;{!! $user->confirmed_label !!}</span>
                @endif
                
                <a class="list-group-item" href="{{ url("admin/auth/user/".$user->id."/password/change") }}"><i class="fas fa-key text-primary"></i> &nbsp;&nbsp;&nbsp;Reset Password</a>
                @if(!$user->is_lead)
                <a class="list-group-item" href="{{ url("admin/auth/user/".$user->id."/login-as") }}"><i class="fa fa-user text-primary"></i> &nbsp;&nbsp;&nbsp;Login as User</a>
                @endif

                <a class="list-group-item" target="_blank" href="{{ route('admin.communicate.mail', $user->id) }}"><i class="fa fa-envelope text-primary"></i> &nbsp;&nbsp;&nbsp;Send email</a>

                <a class="list-group-item" target="_blank" href="{{ route('admin.communicate.sms', $user->id) }}"><i class="fa fa-comment text-primary"></i> &nbsp;&nbsp;&nbsp;Send sms</a>
                {{-- @if(env('WATI_WHATSAPP_TOKEN')) --}}
                @if(get_site_config('whatsapp_enabled'))
                   <a class="list-group-item" target="_blank" href="{{route('admin.communicate.whatsapp', $user->id)}}"><i class="fab fa-whatsapp text-primary"></i> &nbsp;&nbsp;&nbsp;Send Whatsapp</a>
                @else
                    <a class="list-group-item" target="_blank" href="https://wa.me/{{$user->mobile}}"><i class="fab fa-whatsapp text-primary"></i> &nbsp;&nbsp;&nbsp;Send Whatsapp</a>
                @endif
                
                @if(!$user->is_lead)
                <a class="list-group-item" href="{{ route('admin.auth.user.edit', $user) }}"><i class="fa fa-edit text-primary"></i> &nbsp;&nbsp;&nbsp;Edit Basic Info</a>
                <a class="list-group-item" href="{{route('admin.student.edit',$user->id)}}"><i class="fa fa-edit text-primary"></i> &nbsp;&nbsp;&nbsp;Edit Profile</a>
                @else
                <a class="list-group-item" href="{{ route('admin.leadmanagement.edit', $user->id) }}"><i class="fa fa-edit text-primary"></i> &nbsp;&nbsp;&nbsp;Edit Lead Details</a>
                @endif
                
                <p class="list-group-item m-0 text-primary">
                <a href="{{ route('admin.get-esignature-form', $user->id) }}" style="color:#212529!important"> <i class="fas fa-file-signature text-primary"></i> &nbsp;&nbsp;&nbsp; Student Agreement</a>
                </p>
                @if(env('AGENTS_ENABLE'))
                <p class="list-group-item m-0 text-primary">
                    @if($user->agent_id == 0)
                    <a href="{{ route('admin.auth.add.student-to.agent', $user->id) }}" style="color:#212529!important"><i class="fas fa-link text-primary"></i> &nbsp;&nbsp;&nbsp;Link to Agent</a>
                    @else
                        @if(\Auth::user()->isAdmin())
                            <a href="javascript:void(0)" data-user_id="{{$user->id}}" data-agent_id="{{$user->agent_id}}" id="unlink_agent" style="color:#212529!important"><i class="fas fa-unlink text-primary"></i>&nbsp;&nbsp;&nbsp;&nbsp;Unlink Agent ({{$agent->first_name}} {{$agent->last_name}})</a>
                        @endif
                    @endif
                </p>
                @endif
                
                @if(!auth()->user()->isAgent())
                    @if(config('app.product_code') == 'TRAINING' || config('app.product_code') == 'EDUCTRL_CRM')
                    <a class="list-group-item" href="{{route('admin.auth.user.democlasspermission', $user->id)}}"><i class="fa fa-edit text-primary"></i> &nbsp;&nbsp;&nbsp;Demo Class Permissions</a>
                    @endif
                    @if(get_site_config('module_country_info'))
                        @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
                        <a class="list-group-item" href="{{route('admin.auth.user.countrypermission', $user->id)}}"><i class="fa fa-globe text-primary"></i> &nbsp;&nbsp;&nbsp;Country Info Permissions</a>
                        @endif
                    @endif
                @endif
                @if(!$user->is_lead)
                <a data-id="{{ $user->id }}" class="list-group-item stuentLeadConvert-btn " style="cursor: pointer"><i class="fa fa-reply text-primary" aria-hidden="true"></i> &nbsp;&nbsp;&nbsp;Convert Back To Lead</a>
                @else
                @php $converted_lead_status = get_converted_lead_status(); @endphp
                    @if(!($user->status == $converted_lead_status))
                        <a class="list-group-item" title="Convert To Student" data-lead_id="{{$user->id}}" data-lead_status="{{$converted_lead_status}}" id="follow-up-lead-convert" style="cursor: pointer"><i class="fa fa-forward text-primary" aria-hidden="true"></i>  &nbsp;&nbsp;&nbsp;Convert To Student</a>
                    @endif
                @endif
                <a class="list-group-item" href="{{route('admin.auth.user.destroy', $user)}}" data-method="delete" data-trans-button-cancel="@lang('buttons.general.cancel')" data-trans-button-confirm="@lang('buttons.general.crud.delete')" data-trans-title="@lang('strings.backend.general.are_you_sure')"><i class='fas fa-trash-alt text-primary'></i> &nbsp;&nbsp;&nbsp;Delete</a>
            </ul>
        </div>
        <div class="card">
            <div class="card-header bg-primary text-white py-2" style="font-size: 16px !important;">Confidential Notes</div>
            <div class="card-body">
                <form method="post" action="{{route('admin.user.add_notes', $user)}}" id="followup-form" class="form-horizontal" style="margin-left: -10px;margin-right: -10px;">
                    @csrf
                    <input type="hidden" id="stu_id" name="stu_id" value="{{$user->id}}">
                    <span class="d-inline-block mt-2 mb-1">This notes is visible to staff only</span>
                    <textarea style="" class="form-control mb-1 mt-2" id="confidential_notes" name="confidential_notes" rows="4" placeholder="Write your notes here..."  required></textarea>
                    <div class="form-group clearfix text-end mt-2">
                        {{ form_submit("Save") }}
                    </div>
                </form>
                <div class="row">                    
                    <div class="col-md-12" style="border: 1px solid rgb(227, 227, 227);">
                        @if(count($notes))
                        <div style="max-height: 200px; overflow-y: scroll;" class="p-1">
                            @foreach($notes as $note)
                            <p style="color: #353535 !important;" class="mb-1"><strong>{{$note->notes}}</strong></p>
                            <div style="font-style: italic;">{{ date('d M Y g:i A', strtotime($note->created_at)) . ' ' . get_user_name_by_id($note->staff_id)}}</div>
                            <hr style="height: 1px; color: rgb(164 176 247);">
                            @endforeach
                        </div>
                        @else
                            <p class="text-center p-2">No Notes Found!</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        @endif
        
    </div>
    @endif
</div>

@if(!\Auth::user()->isAgent() && !is_staff_user($user->id))
<div class="row mt-5">
    <div class="col-sm-12">
        <h4 class="mb-4">User Activity Log</h4>
        {!! $user->useractivity !!}
    </div>
</div>
@endif

<div class="modal fade" id="followupsModal">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Follow-up Record</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 50px;"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="{{route('admin.user.update_followup', $user)}}" id="followup-form" class="form-horizontal">
                    @csrf
                    <div class="col-12">
                            <input type="hidden" id="stu_id" name="stu_id" value="{{$user}}">
                            <div class="col-sm-12 col-md-12">
                                <label style="padding-bottom: 2px;" class="col-form-label required-field">Follow-up details</label>
                                <textarea style="padding-bottom: 2px;" class="form-control" id="followup_details" name="followup_details" rows="4" placeholder="Follow-up details*"  required></textarea>
                            </div>
                            <div class="col-sm-12 col-md-12">
                                <label class="col-form-label required-field" style="padding-bottom: 2px;">Mode of communication</label>
                                <div class="">
                                    <select class="form-control form-select"  id="communication_mode" name="communication_mode" required>
                                        <option value="">Select</option>
                                        @foreach(get_communication_modes() as $mode)
                                            <option value="{{$mode}}">{{$mode}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-12 col-md-12">
                                <label class="col-form-label required-field" style="padding-bottom: 2px;">Application status</label>
                                <div class="">
                                    <select class="form-control form-select"  id="application_status" name="application_status" required>
                                        <option value="">Select</option>
                                        @foreach(get_application_statuses() as $statuses)
                                        <option value="{{$statuses->status_name}}">{{$statuses->status_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-12 col-md-12 ">
                                <label class="col-form-label">Next Follow-up</label>
                                <div class="">
                                    <div class="">
                                        <input type="text" autocomplete="off" class="form-control followdatetimepicker" placeholder="Choose Date & Time" id="next_followup" name="next_followup">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group mt-2 clearfix text-center">
                                {{ form_submit("Submit") }}
                            </div>
                        </div>
                    </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="convertStudentLeadModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Convert Back To Lead</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 50px;"></button>
            </div>
            <div class="modal-body load_modal">

            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="disqualifyStudentModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Disqualify Student</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 50px;"></button>
            </div>
            <div class="modal-body load_modal">

            </div>
        </div>
    </div>
</div>
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
@endpush
@push ('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $(document).on('click', '.followup-btn', function() {
            $('#followupsModal').modal('show');
            $('#followupsModal').on('hidden.bs.modal', function() {
                $('#followupsModal').html("");
            });
        });

        $('.followdatetimepicker').datetimepicker({
            timepicker: true,
            step: 30,
            format: 'd-M-Y H:i',
            container: "followupsModal",
        });
    });

    $(document).on('click', '.stuentLeadConvert-btn', function() {
        var this_id = $(this).attr('data-id');
        var base_url = "{{ route('admin.auth.user.index')}}/" + this_id + "/convert-student-lead";
        // var base_url = "{{ url('admin/convert-student-lead')}}/" + this_id;
        $.get(base_url, function(data) {
            $('#convertStudentLeadModal').on('shown.bs.modal', function() {
                $('#convertStudentLeadModal .load_modal').html(data);
            });
            $('#convertStudentLeadModal').modal('show');
            $('#convertStudentLeadModal').on('hidden.bs.modal', function() {
                $('#convertStudentLeadModal .load_modal').html("");
            });
        });
    });

    $('#edit_status_button').on('click',function(){
        if($("#select_stat_input").is(":visible")) {  
            $("#select_stat_input").hide();
            $('#edit_status_button').html('<i class="fa fa-edit"></i>');
            $("#stat_text").show();
        } else {
            $("#stat_text").hide();
            $("#select_stat_input").show();
        }
    });

    function changeStatus(stu_id, status) {

    if(status == "{{get_disqualified_student_status()}}"){

        var base_url = "{{ url('admin/auth/student')}}/" + stu_id + "/disqualified";
        $.get(base_url, function(data) {
            $('#disqualifyStudentModal').on('shown.bs.modal', function() {
                $('#disqualifyStudentModal .load_modal').html(data);
            });
            $('#disqualifyStudentModal').modal('show');
            $('#disqualifyStudentModal').on('hidden.bs.modal', function() {
                $('#disqualifyStudentModal .load_modal').html("");
            });
        });
    }else{
        $('#stu_stat_form').submit();
            // $.ajax({
            //     url: "{{route('admin.auth.user.change-overseas-status')}}",
            //     method: "POST",
            //     data: {'stu_id':stu_id,'status':status,'_token':  $('meta[name="csrf-token"]').attr('content'),
            //         },
            //     success: function(data) {
            //         if(data.status=="200"){
            //             $.toast({
            //                 heading: 'Success',
            //                 text: data.res,
            //                 position: 'top-right',
            //                 loaderBg: '#ff6849',
            //                 icon: 'success',
            //                 hideAfter: 3000,
            //                 stack: 8
            //             });
            //             $("#stat_text").html(data.updated_status);
            //             $("#stat_text").show();
            //             $("#select_stat_input").hide();
            //             $('#edit_status_button').html('<i class="fa fa-edit"></i>');
            //         }
            //     }
            // });
        }
    }    

    $('#unlink_agent').click(function(event) {
        event.preventDefault();
        var user_id = $(this).attr('data-user_id');
        var agent_id = $(this).attr('data-agent_id');
        console.log(user_id+"--"+agent_id);
        var url_link = "{{ url('admin/auth/user/')}}/"+user_id+"/unlink-agent/"+agent_id;
        swal({
            title: "Are you sure you want to unlink Agent?",
            // text: "Do you want to unlink Agent?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3B71CA",
            confirmButtonText: "Yes, unlink it!",
            closeOnConfirm: true
        }, function() {
                $.ajax({
                    url: url_link,
                    type: "GET",
                    context: this,
                    success: function (result) {
                        if(result.success){
                            $.toast({
                                heading: 'Success',
                                text: 'Agent unlinked from Student!',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'success',
                                hideAfter: 1000,
                                stack: 6
                            });
                            setTimeout(() => {
                                location.reload();
                            }, 1000);
                        }
                    }
                }); 
        });        
    });


    $('#follow-up-lead-convert').click(function(event) {
        event.preventDefault();
        // var lead = $(this).attr('id');
        var lead_id = $(this).attr('data-lead_id');
        var lead_status = $(this).attr('data-lead_status');
        swal({
            title: "Are you sure?",
            text: "Do you want to Convert to Student?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3B71CA",
            confirmButtonText: "Yes, convert it!",
            closeOnConfirm: true
        }, function() {
                $.ajax({
                    url: "{{route('admin.leads.changestatus')}}",
                    type: "POST",
                    data: {
                        lead_id: lead_id,
                        lead_status: lead_status,
                        _token: '{{csrf_token()}}'
                    },
                    context: this,
                    success: function (result) {
                        if(result.success){
                            $.toast({
                                heading: 'Success',
                                text: 'Lead Converted to Student Successfully!',
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'success',
                                hideAfter: 1000,
                                stack: 6
                            });
                            setTimeout(() => {
                                location.reload();
                            }, 1000);
                        }
                    }
                }); 
        });        
    });
</script>
@endpush
