<div class="row">
    <div class="col">
        <div class="table-responsive">
            @if(!$user->profile_complete)
            <div class="alert alert-danger" role="alert">
                Student Profile Incomplete
            </div>
            @endif
            <div class="row">
                <div class="col-12">
                    <h3 class="heading-bg-color">Student Profile</h3>
                </div>
                <div class="col-12 mt-3">
                    <div class="row align-items-center mb-3">
                        <div class="col-12 col-md-7 col-lg-6 mb-2">
                            <h4>Basic Information</h4>
                        </div>
                        <div class="col-12 col-md-3 col-lg-3 mb-2">
                            <div class="ms-md-4">
                                {{ html()->modelForm($logged_in_user, 'POST', route('admin.downloads.userprofile'))->style('display:inline')->open() }}
                                <input type="hidden" name="uid" value="{{ $user->id }}">
                                <button type="submit" class="btn btn-outline-success w-100">
                                    <i class="bi bi-file-earmark-pdf"></i> Download Profile
                                </button>
                                {{ html()->closeModelForm() }}
                            </div>
                        </div>
                        <div class="col-12 col-md-2 col-lg-3 mb-2">
                            <a href="{{route('admin.student.edit',$user->id)}}" class="btn btn-primary w-100">
                                <i class="fa fa-edit"></i> Edit Profile
                            </a>
                        </div>
                    </div>
                    
                </div>
            </div>
            <div class="row mt-5">
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">First Name</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ $user->first_name }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Middle Name</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($user->middle_name!='')?$user->middle_name:'' }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Last Name</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($user->last_name!='')?$user->last_name:'' }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Gender</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ucwords($user->gender) }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">E-mail</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ $user->email }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Date of Birth</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;"> @if($user->birthday) {{date("d-m-Y", strtotime($user->birthday))}}@else -- @endif</p>
                </div>
                <div class="col-sm-12 col-md-4">
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Mobile</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($user->dialcode) +{{ $user->dialcode }}-@endif{{ $user->mobile }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Whatsapp</label>
                    @if($user->whatsapp)
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($user->dialcode) +{{ $user->dialcode }}-@endif{{ $user->whatsapp }}</p>
                    @else
                    <br>--
                    @endif
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Alternate Contact</label>
                    @if($user->whatsapp)
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($user->dialcode) +{{ $user->dialcode }}-@endif{{ $user->alternate_contact }}</p>
                    @else
                    <br>--
                    @endif
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Interested Study Level</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($user && $user->overseas_study_level_selection)? $user->overseas_study_level_selection : '--' }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Country Interested in</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        @php
                            $show_country = "";
                            $country_interested = explode(",",$user->country_interested);
                        @endphp
                            @if(filter_var($country_interested[0], FILTER_VALIDATE_INT))
                                @foreach ($country_interested as $country) 
                                    @php
                                        $show_country .= get_country_name($country);
                                    @endphp
                                    @if(!$loop->last)
                                        $show_country .= ", ";
                                    @endif
                                @endforeach
                            @else
                                @php
                                    $show_country = $user->country_interested;
                                @endphp
                            @endif
                        {{-- {{ $user->country_interested ? $user->country_interested : '-' }} --}}
                        {{ $show_country }}
                    </p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Course Interested to Study</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ $user->overseas_course_intersted ? $user->overseas_course_intersted : '-'}}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Intake</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails){{ $userDetails->intake_month ? date('F', mktime(0,0,0,$userDetails->intake_month)) : '-'}} {{ $userDetails->intake_year ? $userDetails->intake_year : '-'}} @endif</p>
                </div>
                @if(env('ADDITIONAL_SERVICES_ENABLE'))
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Other Services Interested In</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($user->services)
                        @php 
                            $service_interested = explode(",", $user->services);
                        @endphp
                        {{get_all_services($service_interested, false)}}
                        @else
                        -
                        @endif</p>
                </div>
                @endif
            </div>

            <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Highest Level of Education</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->highest_level_education)? ucfirst($userDetails->highest_level_education):'--' }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Passout Year</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        {{ $userDetails->passout_year ? $userDetails->passout_year : '-' }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Score/Grade</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        {{ $userDetails->qualification_score ? $userDetails->qualification_score : '-' }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Currently Studying Course</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        {{ $userDetails->current_course ? $userDetails->current_course : '-'}}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Work Experience</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        {{ $userDetails->work_experience ? $userDetails->work_experience : '-'}}</p>
                </div>
            </div>
            <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Marital status</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails)? ucwords($userDetails->marital_status) : '' }}</p>
                </div>
                <div class="col-sm-12 col-md-4" 
                    @if ($userDetails) 
                        @if ($userDetails->marital_status != 'married') 
                            style="display:none;" 
                        @else 
                            style="" 
                        @endif
                    @else 
                        style="display:none;" 
                    @endif >
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Date of Marriage</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails)? date('d-m-Y', strtotime($userDetails->date_of_marriage)) : '' }}</p>
                </div>
            </div>
            <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Nationality</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->nationality)? get_country_name($userDetails->nationality):'--' }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Citizenship</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->citizenship)? get_country_name($userDetails->citizenship):'--' }}</p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Country of Education</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails)? get_country_name($userDetails->country_of_education):'--' }}</p>
                </div>
            </div>
            
            {{-- //Dynamic inputs data --}}
            @if($userDetails->user_data_js!='null' && $userDetails->user_data_js!='')
            <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
            <h4 class="mt-4">Additional Information</h4>
            <div class="row">
                <?php $attrData =  json_decode($userDetails->user_data_js, true); 
                    if($user->is_lead){
                        $user_type = 'lead';
                    }
                    if(!$user->is_lead){
                        $user_type = 'student';
                    }
                ?>
                @foreach($attrData as $key=>$att)
                @if(get_attr_label($key,$user_type)!='')
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">{{get_attr_label($key,$user_type)}}</label>
                        @if(is_array($att))
                            <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                                @foreach($att as $att_arr)
                                        {{$att_arr}}
                                        @if( !$loop->last),
                                        @endif
                                @endforeach
                            </p>
                        @else
                            <p>{{($att)? $att : '--'}}</p>
                        @endif
                    </div>
                @endif
                @endforeach
            </div>
            @endif
            {{-- //Dynamic inputs data --}}

            @if($user->student_type != 'course')
                <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
                <h4 class="mb-3">Current Address</h4>
                <div class="row">
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Address</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($user->address_1!='')?$user->address_1:'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Country</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($user->country!='')?get_country_name($user->country):'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">State</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($user->state!='')?get_state_name($user->state):'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">City</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($user->city!='')?$user->city:'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Postal Code</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($user->post_code!='')?$user->post_code:'--' }}</p>
                    </div>
                </div>
                <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
                <h4 class="mb-3">Permanent Address</h4>
                @if($userDetails && $userDetails->permanent_address == $user->address_1)
                <div class="row">
                    <p class="mb-4" style="color: rgb(40, 40, 40) !important;">Same as Current Address</p>
                @else
                <div class="row">
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Address</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails)? $userDetails->permanent_address : '--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Country</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails)? get_country_name($userDetails->permanent_country) : '--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">State</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails)? get_state_name($userDetails->permanent_state) : '--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">City</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails)? $userDetails->permanent_city : '--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Postal Code</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails)? $userDetails->permanent_post_code : '--'}}</p>
                    </div>
                @endif
                </div>
                <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
                <h4 class="mb-3">Passport Information</h4>
                <div class="row">
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Name (As in Passport)</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->name_passport)? $userDetails->name_passport : '--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Passport No.</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->passport_num)? $userDetails->passport_num : '--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-2">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Issue Date</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails)
                            @if($userDetails->passport_issue_date) {{date("d-m-Y", strtotime($userDetails->passport_issue_date))}}@else
                            -- @endif
                            @else
                            --
                            @endif
                        </p>
                    </div>
                    <div class="col-sm-12 col-md-2">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Expiry Date</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails)
                            @if($userDetails && $userDetails->passport_expiry_date) {{date("d-m-Y", strtotime($userDetails->passport_expiry_date))}}@else
                            -- @endif
                            @else
                            --
                            @endif
                        </p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Issue Country</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails)? get_country_name($userDetails->passport_country): '--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">City of Birth</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->city_of_birth)? $userDetails->city_of_birth:'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Country of Birth</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails)? get_country_name($userDetails->country_of_birth) : '--' }}</p>
                    </div>
                </div>
                <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
            
                <h4 class="mb-3">Nationality</h4>
                <div class="row">
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Is the applicant a citizen of more than one country?</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails)
                            {{ ($userDetails->dual_citizenship==1)?'Yes':'No' }}@if($userDetails->dual_citizenship=='1') [
                            @foreach(explode(',',$userDetails->dual_citizenship_country) as $dual_countries)
                            {{get_country_name($dual_countries)}}@if(!$loop->last),@endif
                            @endforeach
                        ] @endif
                            @else
                            --
                            @endif
                        </p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Is the applicant living and studying in any other country?</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails)
                            {{ ($userDetails->studying_abroad==1)?'Yes':'No' }}@if($userDetails->studying_abroad=='1') [{{get_country_name($userDetails->studying_abroad_country)}}] @endif
                            @else
                            --
                            @endif</p>
                    </div>
                </div>
                <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
                <h4 class="mb-3">Background Info</h4>
                <div class="row">
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Has applicant applied for any type of immigration into any country?</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails)
                            {{ ($userDetails && $userDetails->immigration==1)?'Yes':'No' }}@if($userDetails->immigration=='1') [
                                @foreach(explode(',',$userDetails->immigration_country) as $immigration_countries)
                                    {{get_country_name($immigration_countries)}}@if(!$loop->last),@endif
                                @endforeach
                                ] @endif
                            @else
                            --
                            @endif
                        </p>
                    </div>

                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Does applicant suffer from a serious medical condition?</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->medical_condition==1)?'Yes':'No' }}</p>
                    </div>

                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Has applicant Visa refusal for any country?</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">@if($userDetails)
                            {{ ($userDetails->visa_refusal==1)?'Yes':'No' }}@if($userDetails->visa_refusal=='1') [
                                @foreach(explode(',',$userDetails->visa_refusal_country) as $visa_refusal_countries)
                                    {{get_country_name($visa_refusal_countries)}}@if(!$loop->last),@endif
                                @endforeach
                                ] @endif
                        @else
                        --
                        @endif
                        </p>
                    </div>

                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Has applicant ever been convicted of a criminal offence?</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->criminal_offence==1)?'Yes':'No' }}</p>
                    </div>
                </div>
                <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
                <h4 class="mb-3">Emergency Contacts</h4>
                <div class="row">
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Name</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->emergency_name)? ucfirst($userDetails->emergency_name):'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Email</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->emergency_email)? ucfirst($userDetails->emergency_email):'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Phone</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->emergency_phone)? ucfirst($userDetails->emergency_phone):'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Relationship with Applicant</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->emergency_relation)? ucfirst($userDetails->emergency_relation):'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Address</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->emergency_address)? ucfirst($userDetails->emergency_address):'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Country</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->emergency_country)? get_country_name($userDetails->emergency_country):'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">State</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->emergency_state)? get_state_name($userDetails->emergency_state):'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">City</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->emergency_city)? ucfirst($userDetails->emergency_city):'--' }}</p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Postal Code</label>
                        <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">{{ ($userDetails && $userDetails->emergency_postalcode)? ucfirst($userDetails->emergency_postalcode):'--' }}</p>
                    </div>
                </div>

                <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
                <div class="overflow-auto">
                    <h4 class="mt-4">Academic Information</h4>
                    @if($user->academics && count($user->academics) > 0)
                    <table class="table table-hover">
                        <tr>
                            <th>Level of Education</th>
                            <th style="min-width: 120px;">Course Name</th>
                            <th>Course Status</th>
                            <th>Percentage or CGPA</th>
                            <th>Start Year</th>
                            <th>Year of Passing</th>
                            <th>Country of Institute</th>
                            <th>Campus City</th>
                            <th>Postal Code</th>
                            <th style="min-width: 120px;">Institute</th>
                            <th style="min-width: 120px;">University / Board</th>
                            

                            {{-- <th>Backlogs</th> --}}
                        </tr>
                 
                        @foreach($user->academics as $education)
                        <tr>
                            <td>{{ $education->education_level }}</td>
                            <td>{{ $education->course_name }}</td>
                            <td>{{ $education->course_status }}</td>
                            <td>{{ $education->percent_cgpa }}</td>
                            <td>{{ $education->start_year }}</td>
                            <td>{{ $education->pass_year }}</td>
                            <td>{{ get_country_name($education->institute_country) }}</td>
                            <td>{{ $education->campus_city }}</td>
                            <td>{{ $education->postal_code }}</td>
                            <td>{{ $education->institute }}</td>
                            <td>{{ $education->university }}</td>
                            {{-- <td>{{ $education->backlogs }}</td> --}}
                        </tr>
                        @endforeach
                    </table>
                    @else
                    <p >No Data Available</p>
                    @endif
                </div>
                <br />
                <h4>Tests, Language Certifications</h4>
                <h4 style="text-decoration: underline;">English</h4>
                @if($user->englishcert && count($user->englishcert) > 0)
                    @php
                        $hasScore = false;
                        foreach ($user->englishcert as $cert) {
                            if ($cert->overall_score) {
                                $hasScore = true;
                                break;
                            }
                        }
                    @endphp
                    @if($hasScore)
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Exam</th>
                                <th>Overall Score</th>
                                <th>Speaking</th>
                                <th>Reading</th>
                                <th>Listening</th>   
                                <th>Writing</th>
                                <th>Score Expiry Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($user->englishcert as $exam)
                                @if($exam->overall_score && ($exam->exam == "IELTS" || $exam->exam == "TOEFL" || $exam->exam == "PTE"))
                                    <tr>
                                        <td>{{ $exam->exam }}</td>
                                        <td>{{ $exam->overall_score }}</td>
                                        <td>{{ $exam->speaking }}</td>
                                        <td>{{ $exam->reading }}</td>
                                        <td>{{ $exam->listening }}</td>
                                        <td>{{ $exam->writing }}</td>
                                        <td>{{ $exam->expiry_date }}</td>
                                    </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                    @else
                        <p>No Data available.</p>
                    @endif

                    @if($hasScore)
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Exam</th>
                                <th>Overall Score</th>
                                <th>Score Expiry Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($user->englishcert as $exam)
                                @if($exam->overall_score && $exam->exam == "DET")
                                    <tr>
                                        <td>{{ $exam->exam }}</td>
                                        <td>{{ $exam->overall_score }}</td>
                                        <td>{{ $exam->expiry_date }}</td>
                                    </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                    @else
                        <p>No Data available.</p>
                    @endif

                    @if($hasScore)
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Exam</th>
                                <th>Overall Score</th>
                                <th>Math</th>
                                <th>Reading</th>
                                <th>Writing</th>  
                                <th>Science</th>
                                <th>English</th>
                                <th>Score Expiry Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($user->englishcert as $exam)
                                @if($exam->overall_score && $exam->exam == "ACT")
                                    <tr>
                                        <td>{{ $exam->exam }}</td>
                                        <td>{{ $exam->overall_score }}</td>
                                        <td>{{ $exam->math }}</td>
                                        <td>{{ $exam->reading }}</td>
                                        <td>{{ $exam->writing }}</td>
                                        <td>{{ $exam->science }}</td>
                                        <td>{{ $exam->english }}</td>
                                        <td>{{ $exam->expiry_date }}</td>
                                    </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                    @else
                        <p>No Data available.</p>
                    @endif

                    @if($hasScore)
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Exam</th>
                                <th>Overall Score</th>
                                <th>Math</th>
                                <th>Reading</th>
                                <th>Writing</th>  
                                <th>Essay</th>
                                <th>Score Expiry Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($user->englishcert as $exam)
                                @if($exam->overall_score && $exam->exam == "SAT")
                                    <tr>
                                        <td>{{ $exam->exam }}</td>
                                        <td>{{ $exam->overall_score }}</td>
                                        <td>{{ $exam->math }}</td>
                                        <td>{{ $exam->reading }}</td>
                                        <td>{{ $exam->writing }}</td>
                                        <td>{{ $exam->essay }}</td>
                                        <td>{{ $exam->expiry_date }}</td>
                                    </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                    @else
                        <p>No Data available.</p>
                    @endif

                @else
                    <p>No Data Available</p>
                @endif
        
                <br />
                <h4 >Other Languages</h4>
                @if($user->languagecert && count($user->languagecert) > 0) 
                <table class="table table-hover">
                    <tr>
                        <th>Language</th>
                        <th>Level</th>
                        <th>Overall Score(%)</th>
                        <th>Speaking (Marks or %)</th>
                        <th>Reading (Marks or %)</th>
                        <th>Writing (Marks or %)</th>
                        <th>Listening (Marks or %)</th>                    
                        <th>Institute</th>
                    </tr>
                    @foreach($user->languagecert as $cert)
                    <tr>
                        <td>{{ $cert->language }}</td>
                        <td>{{ $cert->level }}</td>
                        <td>{{ $cert->overall_score }}</td>
                        <td>{{ $cert->speaking }}</td>
                        <td>{{ $cert->reading }}</td>
                        <td>{{ $cert->writing }}</td>
                        <td>{{ $cert->listening }}</td>
                        <td>{{ $cert->institute }}</td>
                    </tr>
                    @endforeach
                </table>   
                @else
                <p >No Data Available</p>         
                @endif
            
                <br />
                <h4>GRE / GMAT</h4>
                @if($user->gregmat && count($user->gregmat) > 0) 
                @php
                    $hasTotal = false;
                    foreach ($user->gregmat as $cert) {
                        if ($cert->total_score) {
                            $hasTotal = true;
                            break;
                        }
                    }
                @endphp
                    @if($hasTotal)
                    <table class="table table-hover">
                        <tr>
                            <th>Exam</th>
                            <th>Total Score</th>
                            <th>Verbal</th>
                            <th>Quantitative</th>
                            <th>Analytical</th>
                            <th>Integrated</th>                    
                            <th>Score Expiry Date</th>
                        </tr>
                        @foreach($user->gregmat as $exam)
                        @if($exam->total_score || $exam->verbal || $exam->quantitative || $exam->analytical || $exam->integrated || $exam->expiry_date)
                        <tr>
                            <td>{{ $exam->exam }}</td>
                            <td>{{ $exam->total_score }}</td>
                            <td>{{ $exam->verbal }}</td>
                            <td>{{ $exam->quantitative }}</td>
                            <td>{{ $exam->analytical }}</td>
                            <td>{{ $exam->integrated }}</td>
                            <td>{{ $exam->expiry_date }}</td>
                        </tr>
                        @endif
                        @endforeach
                    </table>
                    @else
                    <p>No scores available.</p>
                    @endif    
                @else
                <p >No Data Available</p>        
                @endif

                <br />
                <h4>Internships</h4>
                @if($user->user_internships && count($user->user_internships) > 0) 
                <table class="table table-hover">
                    <tr>
                        <th>Company Name</th>
                        <th>Number of days/months or years</th>
                        <th>Place</th>
                    </tr>
                    @foreach($user->user_internships as $internship)
                    <tr>
                        <td>{{ $internship->company }}</td>
                        <td>{{ $internship->duration }}</td>
                        <td>{{ $internship->place }}</td>
                    </tr>
                    @endforeach
                </table>   
                @else
                <p >No Data Available</p>
                @endif

                <br />
                <h4 >Additional Courses</h4>
                @if($user->additionalcourses && count($user->additionalcourses) > 0) 
                <table class="table table-hover">
                    <tr>
                        <th>Course</th>
                        <th>Duration</th>
                        {{-- <th>Number of Hours</th> --}}
                        <th>Certification issue Authority</th>
                    </tr>
                    @foreach($user->additionalcourses as $additionalcourse)
                    <tr>
                        <td>{{ $additionalcourse->course }}</td>
                        <td>{{ $additionalcourse->duration }}</td>
                        {{-- <td>{{ $additionalcourse->hours }}</td> --}}
                        <td>{{ $additionalcourse->institute }}</td>
                    </tr>
                    @endforeach
                </table>    
                @else
                <p >No Data Available</p>           
                @endif

                <br />
                <h4 >Employment History</h4>

                <div id="employment" class="table-responsive">
                 @if ($user->employment->isNotEmpty())
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th style="min-width: 120px !important;">Employment Type</th>
                                <th style="min-width: 120px !important;">Currently Working</th>
                                <th style="min-width: 130px !important;">Organisation Name</th>
                                <th style="min-width: 120px !important;">Industry Type</th>
                                <th style="min-width: 120px !important;">Employer Phone</th>
                                <th style="min-width: 120px !important;">Street Address</th>
                                <th style="min-width: 120px !important;">Country</th>
                                <th style="min-width: 120px !important;">State</th>
                                <th style="min-width: 120px !important;">City</th>
                                <th style="min-width: 120px !important;">Post Code</th>
                                <th style="min-width: 120px !important;">Contact Person Name</th>
                                <th style="min-width: 120px !important;">Contact Person Business Phone</th>
                                <th style="min-width: 120px !important;">Contact Person Mobile No</th>
                                <th style="min-width: 130px !important;">Your Working Position Designation</th>
                                <th style="min-width: 120px !important;">Date Start From</th>
                                <th style="min-width: 120px !important;">Date Working Ended</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($user->employment as $profile_employment_detail)
                                <tr>
                                    <td>{{ $profile_employment_detail->employment_histroy_type }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_currently_working }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_organisation_name }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_industry_type }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_employer_phone }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_address }}</td>
                                    <td>{{ get_country_name($profile_employment_detail->employment_history_country) }}
                                    </td>
                                    <td>{{ get_state_name($profile_employment_detail->employment_history_state) }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_city }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_postcode }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_contact_person_name }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_contact_person_business_phone }}
                                    </td>
                                    <td>{{ $profile_employment_detail->employment_history_contact_person_mobile_number }}
                                    </td>
                                    <td>{{ $profile_employment_detail->employment_history_working_position_occupation }}
                                    </td>
                                    <td>
                                        @if ($profile_employment_detail->employment_history_start_date)
                                            {{ date('d M Y', strtotime($profile_employment_detail->employment_history_start_date)) }}
                                        @endif
                                    </td>
                                    <td>
                                        @if ($profile_employment_detail->employment_history_working_ended)
                                            {{ date('d M Y', strtotime($profile_employment_detail->employment_history_working_ended)) }}
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                                   
                        </tbody>
                           
                    </table>
                    @else
                        <p>No Data Available</p> 
                    @endif
                </div>
                </br>
                <h4 >Visa Application History</h4>
                <div id="employment" class="table-responsive">
                    @if (count($user->visa) != 0)
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Country Applied For</th>
                                <th>Name Used</th>
                                <th>Visa Name/Type</th>
                                <th>Application Date</th>
                                <th>Application Number</th>
                                <th>Outcome</th>
                            </tr>
                        </thead>
                        
                        <tbody>
                            @foreach ($user->visa as $application_history)
                                <tr>
                                    <td>{{ get_country_name($application_history->country_applied_for_visa) }}</td>
                                    <td>{{ $application_history->name_used_for_visa_apply }}</td>
                                    <td>{{ $application_history->visa_apply_visa_type }}</td>
                                    <td>
                                        @if ($application_history->visa_apply_application_date)
                                            {{ date('d M Y', strtotime($application_history->visa_apply_application_date)) }}
                                        @endif
                                    </td>
                                    <td>{{ $application_history->visa_apply_application_number }}</td>
                                    <td>{{ $application_history->visa_apply_outcome }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @else
                    <p >No Data Available</p>           
                    @endif
                </div>
            </br> 
            <h4 >International Travel History</h4>
                <div id="employment" class="table-responsive">
                    @if (count($user->travel) != 0)
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Country Visited</th>
                                <th>Name Used On Entry</th>
                                <th>Visa Type</th>
                                <th>Visa Issue At</th>
                                <th>Date From </th>
                                <th>Date Up To</th>
                                <th>Reason of Visit</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($user->travel as $profile_travel_history)
                            <tr>
                                <td>{{ get_country_name($profile_travel_history->country_visited) }}</td>
                                <td>{{ $profile_travel_history->name_used_on_country }}</td>
                                <td>{{ $profile_travel_history->visa_type }}</td>
                                <td>{{ $profile_travel_history->visa_issue_at }}</td>
                                <td>
                                    @if ($profile_travel_history->date_from)
                                        {{ date('d M Y', strtotime($profile_travel_history->date_from)) }}
                                    @endif
                                </td>
                                <td>
                                    @if ($profile_travel_history->date_up_to)
                                        {{ date('d M Y', strtotime($profile_travel_history->date_up_to)) }}
                                    @endif
                                </td>
                                <td>{{ $profile_travel_history->reason_of_visit }}</td>
                                
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @else
                    <p >No Data Available</p>           
                    @endif
                </div>
            </br>
            <h4 >Family Details</h4>
            <div id="employment" class="table-responsive">
                @if (count($user->family) != 0)
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Relationship</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Contact</th>
                            <th>Date of Birth</th>
                            <th>Country of Birth</th>
                            <th>Country of Residence</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($user->family as $family)
                        <tr>
                            <td>
                                {{ $family->relationship }}
                            </td>
                            <td style="min-width: 120px;">
                                {{ $family->first_name }} {{ $family->last_name }}</td>
                            <td style="min-width: 120px;">
                                {{ $family->email }}</td>
                            <td style="min-width: 120px;">
                                +{{ $family->dial_code }}-{{ $family->mobile }}</td>
                            <td>{{ $family->birth_date }}
                            </td>
                            <td>{{ get_country_name($family->birth_country) }}
                            </td>
                            <td>{{ get_country_name($family->residence_country) }}
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                @else
                <p >No Data Available</p>           
                @endif
            </div>
            </br>            
        </div>
        @endif
    </div>
</div>
