@if(!\Auth::user()->isAgent())
<div class="row">
    <div class="col">
        <h4 class="heading-bg-color">Add New Service Request</h4>
        <form method="post" action="{{route('admin.service-request.store')}}">
            <div class="row">
                @csrf
                <input type="hidden" name="user_id" value="{{$user->id}}">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="" class="required-field">Select Service</label>
                        <select class="form-control form-select" id="service_id" name="service_id" required>
                            <option value="">Select</option>
                            @foreach(get_services_data() as $service)
                                <option @if(old('service_id') == $service->id) selected @endif value="{{$service->id}}">{{$service->service_name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-4" id="country_block">
                    <div class="form-group">
                        <label for="" class="required-field" id="country_label">Country</label>
                        <select class="form-control form-select" id="country" name="country">
                            <option value="">Country</option>
                            @foreach($countries as $country)
                                <option @if(old('country') == $country->id) selected @endif value="{{$country->id}}">{{$country->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-4" >
                    <div class="form-group">
                        <label for="college_appl_id" id="college_appl_id">University Application ID</label>
                        <select class="form-control form-select" id="college_appl_id" name="college_appl_id" required>
                            <option value="0">N/A</option>
                            @foreach($universityApplId as $universityAppl)
                                <option @if(old('college_appl_id') == $universityAppl->appl_id) selected @endif value="{{$universityAppl->appl_id}}">{{$universityAppl->appl_id}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                    <span class="label"><b>Amount</b></span><br>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" style="padding: 5px 10px;font-size: 15px;">{{env('APP_CURRENCY_SYMBOL')}}</span>
                        </div>
                        <input type="number" id="amount" name="amount" class="form-control" placeholder="Amount" value="">
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="form-group">
                        <label for="">Description</label>
                        <input type="text" name="description" class="form-control" value="{{ Request::old('description') }}" placeholder="Notes">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-2 mx-auto">
                    <button type="submit" class="form-control btn btn-primary">Create</button>
                </div>
            </div>
        </form>
    </div>
</div>

<hr>
@endif

<div class="row">
    <div class="col">
        <h4 class="heading-bg-color">Service Requests</h4>
        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">                
            <table class="table table-striped bg-none mb-0" >
                <tr>
                    <th>ID</th>
                    <th>Date</th>
                    <th>Service</th>
                    <th>Country</th>
                    <th>Amount</th>
                    <th>Description</th>
                    <th style="min-width: 145px !important;">Actions</th>
                </tr>
                @if(count($services))
                    @foreach($services as $service)
                    <tr>
                        <td>@if($service->appl_id){{$service->appl_id}}@else -- @endif</td>
                        <td>{{ date("d M Y", strtotime($service->created_at))}}</td>
                        <td>{{ get_services($service->service_id) }}</td>
                        <td>@if($service->country){{ get_country_name($service->country) }}@else -- @endif</td>
                        <td>@if($service->amount){{ $service->amount }}@else -- @endif</td>
                        <td>@if($service->description){{ $service->description }}@else -- @endif</td>
                        <td>
                        <a href="{{route('admin.service-visa.view', $service->id)}}" title="View" class="btn btn-sm btn-outline-primary"><i class="fa fa-eye " style="font-size:16px;"></i></a>&nbsp;&nbsp;
                        @if(!auth()->user()->isAgent())
                            <a href="{{route('admin.service-request.edit', $service->id)}}" title="Edit" class="btn btn-sm btn-outline-primary"><i class="fa fa-edit" style="font-size:16px;"></i></a>&nbsp;&nbsp;
                            <a href="{{route('admin.service-request.delete', $service->id)}}" title="Delete" class="btn btn-sm btn-outline-danger" 
                                data-method="delete"
                                data-trans-button-cancel="Cancel"
                                data-trans-button-confirm="Delete"
                                data-trans-title="Are you sure?">
                                <i class='fas fa-trash-alt' style='font-size:17px'></i>
                            </a>
                        @endif
                        </td> 
                    </tr>
                    @endforeach
                @else    
                    <tr>
                        <td colspan="6" class="text-center">No Record Found</td>
                    </tr>
                @endif
            </table>
        </div>
    </div>
</div>

@push ('after-scripts')
<script>
    $(document).ready(function() {
        $('#service_id').on('change', function () {
            var services_id = this.value;
            $.ajax({
                url: "{{route("admin.search.service.country")}}",
                type: "POST",
                data: {
                    services_id: services_id,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (results) {
                    console.log(results)
                    $('#amount').val(results.amount);
                    if(results.results){
                        $('#country').attr('required','required');
                        $('#country_label').addClass('required-field');
                        // $('#country_block').show();
                    }else{
                        //$('#country_block').show();
                        // $('#country').removeAttr('required');​​​​​
                        $('#country_label').removeClass('required-field');
                        // $('#country_block').hide();
                    }
                }
            });
        });

        $('#service_id').trigger('change');
    });
</script>
@endpush
