@php
$countries = get_study_countries();
$service_types = DB::table('visa_service_types')->where('status', 1)->orderBy('display_order')->get();
@endphp
<div class="row">
    <div class="col-md-12">
        @if(!$user->profile_complete)
        <div class="alert alert-danger" role="alert">
            User Profile Incomplete, profile must be completed first.
        </div>
        @endif
    </div>

</div>
<div class="row">
    <div class="col">
        <h4>Visa Preferences</h4>
        <div class="table-responsive">
            <table class="table table-hover">
                <tr>
                    <th>Country</th>
                    <th>Service Type</th>
                    <th>Letter Type</th>
                    <th>Actions</th>
                </tr>
                @if($user->visapreferences)
                @foreach($user->visapreferences as $visapreference)
                <tr>
                    <td>{{ $visapreference['country'] }}</td>
                    <td>{{ $visapreference['service_type'] }}</td>
                    <td>{{ $visapreference['letter_type'] }}</td>
                    <td>
                        @if(!check_application($visapreference['id'], 'visa'))
                            @if(auth()->user()->isAgent())
                                <a class="btn btn-secondary btn-sm" href="javascript:void(0)" title="Add Application" style="cursor: not-allowed;">Create Application</a>&nbsp;&nbsp;
                            @else
                                <a class="btn btn-primary btn-sm" href="{{route('admin.overseas.visaapplication.add',$visapreference['id'])}}" title="Add Application">Create Application</a>&nbsp;&nbsp;
                            @endif
                        @else
                            <a class="btn btn-primary btn-sm" href="{{route('admin.overseas.visaapplication.view',$visapreference['id'])}}" title="View Application">View Application</a>&nbsp;&nbsp;
                        @endif
                        <a href="{{route('admin.overseas.visapref.delete', $visapreference['id'])}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure?"><i class='fas fa-trash-alt text-danger' style='font-size:17px'></i></a>
                    </td>
                </tr>
                @endforeach
                @endif
                <tr>
                    <td colspan="5"><b>Add New Visa Preference</b></td>
                </tr>
                <form method="post" action="{{route('admin.overseas.visapref.save')}}">
                    @csrf
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                    <tr>
                        <td>
                            <div class="form-group">
                                <select class="form-control form-select" name="country" required>
                                    <option value="">Country</option>
                                    @foreach($countries as $country)
                                    <option @if(old('country')==$country) selected @endif value="{{$country}}">{{$country}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                                <select class="form-control form-select" id="service_type" name="service_type" required>
                                    <option value=""></option>
                                    @foreach($service_types as $service_type)
                                    <option value="{{$service_type->id}}">{{$service_type->title}}</option>
                                    @endforeach
                                </select>

                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                                <select class="form-control form-select" id="letter_type" name="letter_type" required>
                                    <option value=""></option>
                                </select>
                            </div>
                        </td>

                        <td>
                            <button type="submit" class="form-control btn btn-primary">Add</button>
                        </td>
                    </tr>
                </form>
            </table>
        </div>
    </div>
</div>


@push('after-scripts')
<script>
    $(document).ready(function() {
        addDeleteForms();

        $('#service_type').on('change', function() {
            $('#letter_type').html('<option value="">Loading...</option>');
            $('#letter_type').attr('disabled', 'disabled');
            $.ajax({
                url: "{{url('api/fetch-visa-letter-types')}}",
                type: "POST",
                data: {
                    service_id: $('#service_type').val(),
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                currency: '{{config('app.currency_symbol')}}',         
                beforeSend: function(){
                    console.log(new Date().toLocaleString()+":Service type changed..Fetching the letter types...");
                },
                success: function(result) {
                    console.log(new Date().toLocaleString()+":Fetch letter types completed.");
                    $('#letter_type').removeAttr('disabled');
                    $('#letter_type').html('<option value="">Select</option>');
                    //console.log(result.lettertypes);
                    for(var i = 0; i < result.lettertypes.length; i++) {
                        var fees = ' (Price: ' + this.currency + Math.round(result.lettertypes[i].fees) +')';
                        $('#letter_type').append('<option value="' + result.lettertypes[i].id + '">' + result.lettertypes[i].title + fees + '</option>');
                    }
                }
            });
        });       
        
    });
</script>
@endpush