<form method="post" action="{{ route('admin.studyabroad.profile.academic.save') }}">
    @csrf
    <input type="hidden" id="add_academics_information_user_id" name="user_id">
    <div class="row">
        <div class="col-md-3">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Education Level</label>
                <select class="form-control form-select" name="education_level" required>
                    <option value="">Select</option>
                    <option value="10" @if (Request::old('education_level') == 10) selected @endif>10th</option>
                    <option value="12" @if (Request::old('education_level') == 12) selected @endif>12th</option>
                    <option value="Diploma" @if (Request::old('education_level') == 'Diploma') selected @endif>Diploma</option>
                    <option value="Bachelors" @if (Request::old('education_level') == 'Bachelors') selected @endif>Bachelors</option>
                    <option value="Masters" @if (Request::old('education_level') == 'Masters') selected @endif>Masters</option>
                    <option value="Other" @if (Request::old('education_level') == 'Other') selected @endif>Other</option>
                </select>
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Course Name</label>
                <input type="text" class="form-control" placeholder="Course Name" name="course_name" maxlength="100"
                  required  value="@if (Request::old('course_name')) {{ Request::old('course_name') }} @endif">

            </div>
        </div>
        <div class="col-md-3">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Institute</label>
                <input type="text" required class="form-control" placeholder="Institute" name="institute"
                    maxlength="50" value="@if (Request::old('institute')) {{ Request::old('institute') }} @endif">
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">University/Board</label>
                <input type="text" required class="form-control" placeholder="University/Board" name="university"
                    maxlength="50" value="@if (Request::old('institute')) {{ Request::old('institute') }} @endif">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-3">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Country of Institute</label>
                <select class="form-control form-select" name="institute_country" required>
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}" @if (Request::old('country_of_institute') == $country->id) selected @endif>
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">Campus City</label>
                <input type="text" class="form-control" placeholder="Campus City" name="campus_city" maxlength="50"
                    value="@if (Request::old('campus_city')) {{ Request::old('campus_city') }} @endif">
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">Postal Code</label>
                <input type="text" class="form-control" placeholder="Postal Code" name="postal_code" maxlength="20"
                    value="@if (Request::old('postal_code')) {{ Request::old('postal_code') }} @endif">
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Marks %</label>
                <input type="number" step='0.10' min="0" max="100" class="form-control"
                    placeholder="Marks %" name="percent_cgpa" required
                    value="@if (Request::old('percent_cgpa')) {{ Request::old('percent_cgpa') }} @endif">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-8 d-flex">
            <div class="form-group w-50" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="">Start Year</label>
                <div class="input-group">
                    <select name="start_year" class="form-control form-select" autocomplete="off" id="dropdownYear"
                        onchange="getEndYear()">
                        <option value="">Select Year</option>
                    </select>
                </div>

            </div>

            <div class="form-group w-50" style="margin-left:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Completion Year</label>
                <div class="input-group ">
                    <select name="pass_year" class="form-control form-select" autocomplete="off"
                        id="dropdownCompletionYear"  required>
                        <option value="">Select Year</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Course Status</label>
                <select class="form-control form-select" name="course_status" required>
                    <option value="">Select</option>
                    <option value="Completed" @if (Request::old('course_status') == 'Completed') selected @endif>Completed</option>
                    <option value="Withdrawn" @if (Request::old('course_status') == 'Withdrawn') selected @endif>Withdrawn</option>
                    <option value="Enrolled" @if (Request::old('course_status') == 'Enrolled') selected @endif>Enrolled</option>
                </select>
            </div>
        </div>
    </div>

    <div class="mt-4 text-center">
        <button type="submit" class="btn btn-primary" style="padding-left:40px;padding-right:40px;">Save</button>
    </div>
</form>

<script>
    $('#dropdownYear').each(function() {

        var year = (new Date()).getFullYear();
        var current = year;

        for (var i = 0; i < 50; i++) {
            $(this).append('<option value="' + (current - i) + '">' + (current - i) + '</option>');
        }
    })
    
    function getEndYear() {
    if ($('#dropdownYear').val()) {
        $("#dropdownCompletionYear").html(''); // Clear previous options
        var year =parseInt( $('#dropdownYear').val());   // Get selected year
        var operation= (new Date()).getFullYear()-year;

        var current = year;                    // Store the selected year
        $("#dropdownCompletionYear").append('<option value="">Select Year</option>');
        
        // Loop to generate the next 50 years
        for (var i = 0; i <= operation; i++) {
            $("#dropdownCompletionYear").append('<option value="' + (current + i) + '">' + (current + i) + '</option>');
        }
    }
}

    $('#dropdownCompletionYear').each(function() {
        var year = (new Date()).getFullYear();
        var current = year;

        for (var i = 0; i < 50; i++) {
            $(this).append('<option value="' + (current - i) + '">' + (current - i) + '</option>');
        }
    })
</script>
