<form method="post" action="{{route('admin.family.course_information.save')}}">
    @csrf
    <input type="hidden" id="add_family_information_user_id" name="userid">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">First Name</label>
                <input type="text" class="form-control" id="first_name" name="first_name" maxlength="50"
                    value="@if (Request::old('first_name')) {{ Request::old('first_name') }}@endif" placeholder="First Name"
                    required>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;"
                    class="required-field">Last Name</label>
                <input type="text" class="form-control" id="last_name"
                    name="last_name" maxlength="50"
                    value="@if (Request::old('last_name')) {{ Request::old('last_name') }}@endif" placeholder="Last Name"
                    required>
            </div>
        </div>
        <div class="col-md-4">
            <label class="">Email</label>
            <div class="">
                <input type="text" placeholder="Email ID"
                    class="form-control" name="email"
                    value="@if (Request::old('email')) {{ Request::old('email') }} @endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Gender</label>
                <div>
                    <div class="form-check form-check-inline">
                        <input type="radio"
                            class="radio-col-blue form-check-input"
                            name="gender" id="parent_male" value="male"
                            @if (Request::old('gender') == 'male') checked @endif required>
                        <label class="custom-control-label form-check-label"
                            for="parent_male">Male</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input type="radio"
                            class="radio-col-blue form-check-input"
                            name="gender" id="parent_female" value="female"
                            @if (Request::old('gender') == 'female') checked @endif required>
                        <label class="custom-control-label form-check-label"
                            for="parent_female">Female</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input type="radio"
                            class="radio-col-blue form-check-input"
                            name="gender" id="parent_other" value="other"
                            @if (Request::old('gender') == 'other') checked @endif
                            required>
                        <label class="custom-control-label form-check-label"
                            for="parent_other">Other</label>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <label class="">Mobile No.</label>
            <div class="input-group">
                <div class="input-group-prepend" style="width: 35%">
                    <select class="form-control form-select" id="dial_code"
                        name="dial_code"
                        style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                        <option value=''>Dialcode</option>
                        @foreach ($dialcodes as $dialcode)
                            <option
                                {{ Request::old('dial_code') == $dialcode->code ? 'selected' : '' }}
                                value="{{$dialcode->code}}">
                                {{ $dialcode->code }}</option>
                        @endforeach
                    </select>
                </div>
                <input type="tel" placeholder="Mobile No."
                    class="form-control"
                    name="mobile"
                    inputmode="numeric" 
    pattern="\d*" 
    oninput="this.value = this.value.replace(/[^0-9]/g, '');"
                   >
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">Date of Birth</label>
                <div class="input-group">
                    <input type="text" class="form-control mydatepicker" autocomplete="off"
                        id="birth_date" name="birth_date"
                        placeholder="dd-mm-yyyy"
                        value="@if (Request::old('birth_date')) {{ date('d-m-Y', strtotime(Request::old('birth_date'))) }} @endif">
                    <div class="input-group-append">
                        <span class="input-group-text" style="height: 35px !important;"><i class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">Country of Birth</label>
                <select class="form-control form-select" id="country_of_birth"
                    name="birth_country">
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}"
                            @if (Request::old('birth_country') == $country->id) selected @endif>
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">Usual Country of Residence</label>
                <select class="form-control form-select" id="residence_country"
                    name="residence_country" >
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}"
                            @if (Request::old('residence_country') == $country->id) selected @endif>
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Relationship</label>
                <select class="form-control form-select"
                    name="relationship" required>
                    <option value="">Select</option>
                    <option value="father" @if (Request::old('relationship') == "father") selected @endif>Father</option>
                    <option value="mother" @if (Request::old('relationship') == "mother") selected @endif>Mother</option>
                    <option value="step father" @if (Request::old('relationship') == "step father") selected @endif>Step Father</option>
                    <option value="step mother" @if (Request::old('relationship') == "step mother") selected @endif>Step Mother</option>
                    <option value="parental grand father" @if (Request::old('relationship') == "parental grand father") selected @endif>Parental Grand Father</option>
                    <option value="parental grand mother" @if (Request::old('relationship') == "parental grand mother") selected @endif>Parental Grand Mother</option>
                    <option value="maternal grand father" @if (Request::old('relationship') == "maternal grand father") selected @endif>Maternal Grand Father</option>
                    <option value="maternal grand mother" @if (Request::old('relationship') == "maternal grand mother") selected @endif>Maternal Grand Mother</option>
                </select>
            </div>
        </div>
    </div>

    <div class="mt-4 text-center">
        <button type="submit" class="btn btn-primary"
            style="padding-left:40px;padding-right:40px;">Save</button>
    </div>
</form>

<script>
   
    
    $('.mydatepicker').datetimepicker({
        timepicker: false,
        format: 'd-m-Y',
        scrollInput: false,
        maxDate: 0
    });


</script>
