<form method="post" action="{{ route('admin.profile.travel_history.save') }}">
    @csrf
    <input type="hidden" name="user_id" id="add_travel_history_user_id">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Country Visited</label>
                <select class="form-control form-select" name="country_visited" required>
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}" @if (Request::old('country_visited') == $country->id) selected @endif>
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Name Used on Entry</label>
                <input type="text" required class="form-control" placeholder="Name Used on Entry"
                    name="name_used_on_country" maxlength="50"
                    value="@if (Request::old('name_used_on_country')) {{ Request::old('name_used_on_country') }} @endif">

            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Visa Type</label>
                <input type="text" class="form-control" required placeholder="Visa Type" name="visa_type"
                    maxlength="50" value="@if (Request::old('visa_type')) {{ Request::old('visa_type') }} @endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Visa Issue At</label>
                <input type="text" required class="form-control" placeholder="Visa issue at" name="visa_issue_at"
                    maxlength="50" value="@if (Request::old('visa_issue_at')) {{ Request::old('visa_issue_at') }} @endif">

            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Date From </label>
                <div class="input-group">
                    <input type="text" required class="form-control mydateFrompicker" autocomplete="off"
                        name="date_from" onchange="dateUpTo()" placeholder="dd-mm-yyyy" 
                        value="@if (Request::old('date_from')) {{ date('d-m-Y', strtotime(Request::old('date_from'))) }} @endif">
                    <div class="input-group-append">
                        <span class="input-group-text" style="height: 35px !important;"><i
                                class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Date Up To </label>
                <div class="input-group">
                    <input type="text" required class="form-control mydateTopicker" autocomplete="off" 
                        name="date_up_to" placeholder="dd-mm-yyyy"
                        value="@if (Request::old('date_up_to')) {{ date('d-m-Y', strtotime(Request::old('date_up_to'))) }} @endif">
                    <div class="input-group-append">
                        <span class="input-group-text" style="height: 35px !important;"><i
                                class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Reason of Visit</label>
                <input type="text" class="form-control" required placeholder="Reason of Visit" name="reason_of_visit"
                    maxlength="50"
                    value="@if (Request::old('reason_of_visit')) {{ Request::old('reason_of_visit') }} @endif">
            </div>
        </div>
    </div>

    <div class="mt-4 text-center">
        <button type="submit" class="btn btn-primary" style="padding-left:40px;padding-right:40px;">Save</button>
    </div>
</form>

<script>
   
    $('.mydateFrompicker').datetimepicker({
        timepicker: false,
        format: 'd-m-Y',
        scrollInput: false,
        maxDate: 0
    });

    
    $('.mydateTopicker').datetimepicker({
        timepicker: false,
        format: 'd-m-Y',
        scrollInput: false,
        maxDate: 0
    });

    
    function dateUpTo() {
        if ($(".mydateFrompicker").val()) {

            var fromDate = $(".mydateFrompicker").val(); 
            
           
            var dateParts = fromDate.split("-");
            var formattedFromDate = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]); 
            $('.mydateTopicker').val("");
            
            $('.mydateTopicker').datetimepicker({
                minDate: formattedFromDate 
            });
        }
    }
</script>
