<form method="post" action="{{ route('admin.profile.visa_history.save') }}">
    @csrf
    <input type="hidden" name="user_id" id="add_visa_history_user_id">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Country Applied For</label>
                <select class="form-control form-select"
                    name="country_applied_for_visa" required>
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}"
                            @if (Request::old('country_applied_for_visa') == $country->id) selected @endif>
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Name Used</label>
                <input type="text" class="form-control" required placeholder="Name Used" name="name_used_for_visa_apply" maxlength="50" value="@if (Request::old('name_used_for_visa_apply')) {{ Request::old('name_used_for_visa_apply') }}@endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Visa Name/Type</label>
                <input type="text" class="form-control" required placeholder="Visa Name" name="visa_apply_visa_type" maxlength="50" value="@if (Request::old('visa_apply_visa_type')) {{ Request::old('visa_apply_visa_type') }}@endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Application Date</label>
                <div class="input-group">
                    <input type="text" required class="form-control mydatepicker" autocomplete="off"
                        name="visa_apply_application_date"
                        placeholder="dd-mm-yyyy"
                        value="@if (Request::old('visa_apply_application_date')) {{ date('d-m-Y', strtotime(Request::old('visa_apply_application_date'))) }}@endif">
                    <div class="input-group-append">
                        <span class="input-group-text" style="height: 35px !important;"><i class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Application Number</label>
                <input type="text" class="form-control" required placeholder="Application Number" name="visa_apply_application_number" maxlength="50" value="@if (Request::old('visa_apply_application_number')) {{ Request::old('visa_apply_application_number') }}@endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Outcome</label>
                <input type="text" class="form-control" required placeholder="Outcome" name="visa_apply_outcome" maxlength="50" value="@if (Request::old('visa_apply_outcome')) {{ Request::old('visa_apply_outcome') }}@endif">
            </div>
        </div>
    </div>

    <div class="mt-4 text-center">
        <button type="submit" class="btn btn-primary"
            style="padding-left:40px;padding-right:40px;">Save</button>
    </div>
</form>

<script>
     $('.mydatepicker').datetimepicker({
        timepicker: false,
        format: 'd-m-Y',
        scrollInput : false,
        maxDate: 0
    });
</script>
