<form method="post" action="{{ route('admin.profile.employment.save') }}">
    @csrf
    <input type="hidden" name="userid" id="edit_employment_history_user_id">
    <input type="hidden" name="employment_id" value="{{$profile_employment_detail->id}}">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group">
                <label style="margin-bottom: 0.2rem;" class="required-field">Employment Type</label>
                <select class="form-control" name="employment_histroy_type" id="employment_histroy_type" required>
                    <option value="">Select</option>
                    <option value="Paid" @if (Request::old('employment_histroy_type') == "Paid") selected @elseif($profile_employment_detail->employment_histroy_type == "Paid") selected @endif>Paid</option>
                    <option value="Unpaid" @if (Request::old('employment_histroy_type') == "Unpaid") selected @elseif($profile_employment_detail->employment_histroy_type == "Unpaid") selected @endif>Unpaid</option>
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Currently Working</label>
                <select class="form-control" required name="employment_history_currently_working" id="employment_history_currently_working">
                    <option value="">Select</option>
                    <option value="Yes" @if (Request::old('employment_history_currently_working') == "Yes") selected @elseif($profile_employment_detail->employment_history_currently_working == "Yes") selected @endif>Yes</option>
                    <option value="No" @if (Request::old('employment_history_currently_working') == "No") selected @elseif($profile_employment_detail->employment_history_currently_working == "No") selected @endif>No</option>
                </select>
            </div>
        </div> 
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Industry Type</label>
                <input type="text" class="form-control" required placeholder="Industry Type" name="employment_history_industry_type" maxlength="50" value="@if (Request::old('employment_history_industry_type')){{ Request::old('employment_history_industry_type')}}@else{{$profile_employment_detail->employment_history_industry_type}}@endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Your Working Position Designation</label>
                <input type="text" class="form-control" required placeholder="Your Working Position Designation" name="employment_history_working_position_occupation" maxlength="50" value="@if (Request::old('employment_history_working_position_occupation')) {{ Request::old('employment_history_working_position_occupation') }}@else{{$profile_employment_detail->employment_history_working_position_occupation}}@endif">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Organisation Name</label>
                <input type="text" class="form-control" required placeholder="Organisation Name" name="employment_history_organisation_name" maxlength="50" value="@if (Request::old('employment_history_organisation_name')){{ Request::old('employment_history_organisation_name')}}@else{{$profile_employment_detail->employment_history_organisation_name}}@endif">
            </div>
        </div> 
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Employer Phone</label>
                <input type="number" class="form-control" required placeholder="Employer Phone" name="employment_history_employer_phone" maxlength="50" value="@if (Request::old('employment_history_employer_phone')) {{ Request::old('employment_history_employer_phone') }}@else{{$profile_employment_detail->employment_history_employer_phone}}@endif">
            </div>
        </div>
    </div>
    <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Street Address</label>
                <input type="text" class="form-control" required placeholder="Street Address" name="employment_history_address" maxlength="150" value="@if (Request::old('employment_history_address')) {{ Request::old('employment_history_address') }}@else{{$profile_employment_detail->employment_history_address}}@endif">
            </div>
        </div> 
        <div class="col-md-3">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Country</label>
                <select class="form-control form-select" required id="employment_history_country"
                    name="employment_history_country" >
                    <option value="">Select</option>
                    @foreach ($countries as $country)
                        <option value="{{ $country->id }}"
                            @if (Request::old('employment_history_country') == $country->id) selected @elseif($profile_employment_detail->employment_history_country == $country->id) selected @endif>
                            {{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-group">
                <label style="margin-bottom: 0.2rem;"
                    class="required-field" class="required-field">State</label>
                <select class="form-control" required name="employment_history_state" id="employment_history_state">
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">City</label>
                <input type="text" class="form-control" required placeholder="City" name="employment_history_city" maxlength="50" value="@if (Request::old('employment_history_city')) {{ Request::old('employment_history_city') }}@else{{$profile_employment_detail->employment_history_city}}@endif">
            </div>
        </div> 
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">Postal Code</label>
                <input type="text" class="form-control" placeholder="Postal Code" name="employment_history_postcode" maxlength="10" value="@if (Request::old('employment_history_postcode')) {{ Request::old('employment_history_postcode') }}@else{{$profile_employment_detail->employment_history_postcode}}@endif">
            </div>
        </div>
    </div>
    <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Contact Person Name</label>
                <input type="text" class="form-control" required placeholder="Contact Person Name" name="employment_history_contact_person_name" maxlength="50" value="@if (Request::old('employment_history_contact_person_name')) {{ Request::old('employment_history_contact_person_name') }}@else{{$profile_employment_detail->employment_history_contact_person_name}}@endif">
            </div>
        </div>
       
        <div class="col-md-6">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">Contact Person Mobile No</label>
                <input type="number" class="form-control" placeholder="Contact Person Mobile No" name="employment_history_contact_person_mobile_number" maxlength="50" value="@if (Request::old('employment_history_contact_person_mobile_number')) {{ Request::old('employment_history_contact_person_mobile_number') }}@else{{$profile_employment_detail->employment_history_contact_person_mobile_number}}@endif">
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">Contact Person Business Phone</label>
                <input type="number" class="form-control" placeholder="Contact Person Business Phone" name="employment_history_contact_person_business_phone" maxlength="50" value="@if (Request::old('employment_history_contact_person_business_phone')) {{ Request::old('employment_history_contact_person_business_phone') }}@else{{$profile_employment_detail->employment_history_contact_person_business_phone}}@endif">
            </div>
        </div>
        
    </div>
    <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;" class="required-field">Date Start From</label>
                <div class="input-group">
                    <input type="text" class="form-control mydateFrompicker" autocomplete="off"
                        name="employment_history_start_date" required
                        placeholder="dd-mm-yyyy" onchange="dateUpTo()"
                        value="@if (Request::old('employment_history_start_date')) {{ date('d-m-Y', strtotime(Request::old('employment_history_start_date'))) }} @else {{ date('d-m-Y', strtotime($profile_employment_detail->employment_history_start_date)) }}@endif">
                    <div class="input-group-append">
                        <span class="input-group-text" style="height: 35px !important;"><i class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group" style="margin-bottom:15px !important;">
                <label style="margin-bottom: 0.2rem;">Date Working Ended</label>
                <div class="input-group">
                    <input type="text" class="form-control mydateTopicker" autocomplete="off"
                        name="employment_history_working_ended"
                        placeholder="dd-mm-yyyy"
                        value="@if (Request::old('employment_history_working_ended')){{date('d-m-Y', strtotime(Request::old('employment_history_working_ended')))}}@else{{ date('d-m-Y', strtotime($profile_employment_detail->employment_history_working_ended))}}@endif">
                    <div class="input-group-append">
                        <span class="input-group-text" style="height: 35px !important;"><i class="fa fa-calendar"></i></span>
                    </div>
                </div>
            </div>
        </div>        
    </div>
</div>
    <div class="mt-4 text-center">
        <button type="submit" class="btn btn-primary"
            style="padding-left:40px;padding-right:40px;">Save</button>
    </div>
</form>

<script>
     $('.mydateFrompicker').datetimepicker({
        timepicker: false,
        format: 'd-m-Y',
        scrollInput: false,
        maxDate: 0
    });

    
    $('.mydateTopicker').datetimepicker({
        timepicker: false,
        format: 'd-m-Y',
        scrollInput: false,
        maxDate: 0
    });

    
    function dateUpTo() {
        if ($(".mydateFrompicker").val()) {

            var fromDate = $(".mydateFrompicker").val(); 
            
           
            var dateParts = fromDate.split("-");
            var formattedFromDate = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]); 
            $('.mydateTopicker').val("");
            
            $('.mydateTopicker').datetimepicker({
                minDate: formattedFromDate 
            });
        }
    }

    $('#employment_history_country').on('change', function() {
        var idCountry = this.value;
        $("#employment_history_state").html('');
        $.ajax({
            url: "{{ url('api/fetch-states') }}",
            type: "POST",
            data: {
                country_id: idCountry,
                _token: '{{ csrf_token() }}'
            },
            dataType: 'json',
            success: function(result) {
                $('#employment_history_state').html('<option value="">Select State</option>');
                $.each(result.states, function(key, value) {
                    if (value.id ==
                            "{{ $profile_employment_detail ? $profile_employment_detail->employment_history_state : '' }}"
                        ) {
                            var selectedState = "selected=\"'selected'\"";
                        } else if (value.id ==
                        "{{ old('employment_history_state') }}") {
                        var selectedState = "selected=\"'selected'\"";
                    } else {
                        var selectedState = "";
                    }
                    $("#employment_history_state").append('<option ' + selectedState +
                        ' value="' + value.id + '">' + value.name +
                        '</option>');
                });
            }
        });
    });
    $('#employment_history_country').trigger('change');
</script>

