@extends('backend.layouts.app')

@section('title', "Campaign Details")

@section('content')
<div class="card">
    <div class="card-body">
        <ul class="nav nav-tabs mt-3">
            {!!get_automation_tabs('automation.campaigns')!!}
            <div class="col-sm-7 col-7 ms-auto ">
                <div class="btn-toolbar float-right mx-2" role="toolbar" style="margin-top: 0px;float: right;"> 
                    <a href="{{ route('admin.automation.campaigns') }}" class="btn btn-sm btn-primary" style="margin-bottom: 0px!important;" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
                </div>
            </div>
        </ul>
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                   {{$campaignData->title}}
                </h4>
            </div><!--col-->
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-7">
                <div style="margin-top:10px;">
                    <div class="row">
                        <div class="form-group col-md-12 mb-3">
                            <label><b>Communication Mode: </b></label>
                            {{ucfirst($campaignData->communication_mode)}}
                        </div>
                        <div class="form-group col-md-12 mb-3">
                            <label><b>Run At: </b></label>
                            {{date('d M Y', strtotime($campaignData->run_at))}} {{date('h:i', strtotime($campaignData->run_at))}} {{date('A', strtotime($campaignData->run_at))}}
                        </div>
                    </div>
                    
                    <div class="row">
                    <hr class="mt-0 mb-1">
                    <h5 class="mb-3">Target Audience</h5>
                    <div class="form-group col-md-12 mb-0">
                            <label><b>Target: </b></label>
                            {{$campaignData->target}}
                    </div> 
                    </div>
                    <div class="row">
                        @if($campaignData->target == 'leads' || $campaignData->target == 'students')
                            <div class="form-group mb-3 status_type_lead">
                                <label><b>Status: </b></label>
                                @if($campaignData->target == "leads")
                                    {{$campaignData->lead_status}}
                                @endif
                                @if($campaignData->target == "students")
                                    {{$campaignData->student_status}}
                                @endif
                            </div>
                        @endif
                        <div class="row field_wrapper">
                            <?php 
                                if($campaignData->target == "leads" && !empty($campaignData->lead_filters)){
                                    $criteria_values = json_decode($campaignData->lead_filters); 
                                }
                                else if($campaignData->target == "students" && !empty($campaignData->student_filters)){
                                    $criteria_values = json_decode($campaignData->student_filters);
                                }
                                else{
                                    $criteria_values = "";
                                }   
                                $cri = array();    
                            ?>
                             @if($criteria_values != "")
                             <?php
                                 if($campaignData->filter_condition == "and"){
                                    $fltr_cond = '<p class="mb-0">AND</p>';
                                 }
                                 else{
                                     $fltr_cond = '<p class="mb-0">OR</p>';
                                 }
                             ?> 
                            <label><b><u>Other Criteria</u></b></label>
                            @foreach($criteria_values as $criterias => $cri_vals)
                            <div class="row">
                            <div class="form-group mb-1 col-md-4">
                                @if($criterias == "Other Services Interested")
                                <?php 
                                $osi = explode("|",$cri_vals);
                                ?>
                                <b>{{$criterias}} :</b> 
                                @foreach($osi as $si)
                                    {{get_services($si)}}@if(!$loop->last),@endif 
                                @endforeach
                                @elseif($criterias == "Country of Residence")
                                    <?php 
                                    $cor = explode("|",$cri_vals);
                                    ?>
                                    <b>{{$criterias}} :</b> 
                                    @foreach($cor as $cr)
                                        {{get_country_name($cr)}}@if(!$loop->last),@endif 
                                    @endforeach
                                @else
                                <b>{{$criterias}} :</b> {{str_replace("|",", ",$cri_vals)}}
                                @if($cri_vals != end($criteria_values))
                                    {!!$fltr_cond!!}
                                @endif
                                @endif
                            </div>
                            </div>
                            @endforeach
                            @endif
                            <div class="col-md-3">
                            <button id="view_message" data-message="{{$campaignData->message_content}}" class="btn btn-sm btn-secondary">View Message</button>
                            </div>
                        </div>
                        
                    </div>

                    <div class="row mt-1">
                        <hr class="mt-0 mb-1">
                    <h5 class="mb-3">Execution Details</h5>
                        <div class="form-group col-md-4 mb-0">
                            <label><b>Message sent to: </b></label>
                            {{$campaignData->sent_count}}
                        </div> 
                    </div>
                    <div class="row mt-2">
                            <div class="form-group col-md-4 mb-0">
                                <label><b>Sent at: </b></label>
                                @if($campaignData->send_start)
                                {{date('d-M-Y H:s', strtotime($campaignData->send_start))}} <b style="font-size: 16px!important;">to</b>  {{date('d-M-Y H:s', strtotime($campaignData->send_end))}}
                                @else
                                    --
                                @endif
                            </div> 
                    </div>
                    <div class="row mt-3">
                        <div class="col-sm-12">
                            <h4 class="mb-2">Audience: </h4>
                            @if(count($execution_history))
                                <div class="filterBox" style=" border-radius: 10px; border:1px solid rgb(164 176 247) !important;">
                                <div style="max-height: 400px; overflow-y: auto;">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                            <td><b>SL No.</b></td>
                                            @if($campaignData->communication_mode == "email")
                                            <td><b>Email</b></td>
                                            @elseif($campaignData->communication_mode == "whatsapp")
                                            <td><b>Whatsapp No.</b></td>
                                            @else
                                            <td><b>Mobile No.</b></td>
                                            @endif
                                        </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($execution_history as $exe_history)
                                            <tr>
                                                <div class="mt-3">
                                                <td>{{$loop->iteration}}</td>
                                                @if($campaignData->communication_mode == "email")
                                                <td>{{get_user_email_by_id($exe_history->user_id)}}</td>
                                                @elseif($campaignData->communication_mode == "whatsapp")
                                                    <td>{{get_user_whatsapp_by_id($exe_history->user_id)}}</td>
                                                @else
                                                    <td>{{get_user_mobile_by_id($exe_history->user_id)}}</td>
                                                @endif
                                                </div>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            @else 
                            <div class="filterBox" style=" border-radius: 10px; border:1px solid rgb(164 176 247) !important;">
                                <div class="p-2" style="">
                                {{'No records found!'}}
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
<div class="modal fade" id="message_modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Message</h5>
                <button type="button" class="btn btn-sm btn-outline-dark" data-bs-dismiss="modal">&times;</button>
            </div>
                <div class="modal-body">
                    <div class="row mb-2">
                        <div class="col-sm-12 col-md-12">
                                <p id="msg_data"></p>
                        </div>
                    </div>
                </div>
        </div>

    </div>
</div>
@endsection
@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<style>
.duplicate {
    border: 1px solid red;
    color: red;
}
.dupli {
    color: red;
}
.fa-10x{
        font-size:1.6em !important;
    };
</style>
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
<script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script>
    $(document).ready(function () {
        $(".select2stats").select2({
            placeholder: "Select",
            allowClear: true
        });
        if($("#communication_mode").val()=='Email'){
                $('.template_href').attr('href',"{{route('admin.mailtemplates')}}");
            }
        if($("#communication_mode").val()=='Whatsapp'){
                $('.template_href').attr('href',"{{route('admin.whatsapptemplates')}}");
            }
        if($("#communication_mode").val()=='SMS'){
                $('.template_href').attr('href',"{{route('admin.smstemplates')}}");
        }

        $('.target').change(function() {
            $(".target,.start_date").attr('required',true);
            if (this.value == 'leads' || this.value == 'students') {
                $('.for_lead_blk').show();
                if(this.value == 'leads'){
                    $(".status_type_student").hide();
                    $(".status_type_lead").show();
                }
                if(this.value == 'students'){
                    $(".status_type_student").show();
                    $(".status_type_lead").hide();
                }
            }
            else {
                $('.for_lead_blk').hide();
            }
        });


        //Add more field
        var wrapper = $('.field_wrapper'); //Input field wrapper
        var fldCount = 1;
        $(document).on('click', '.add_more_button', function(){
        fldCount++;
        var html = '';
        html += '<div class="row dynaDiv"><div class="form-group mb-1 col-md-4"><label>And</label><select name="other_criteria[]" data-sub_id="'+fldCount+'" class="form-select other_criteria mb-1" required><option value="">Select</option><option value="Country Interested">Country Interested to Study In</option><option value="Course Interested to Study">Course Interested to Study</option><option value="Interested Study Level">Interested Study Level</option><option value="Intake">Intake</option><option value="Passout Year">Passout Year</option><option value="Country of Residence">Country of Residence</option><option value="Qualification">Qualification</option><option value="Lead Source">Lead Source</option><option value="Campaign ID">Lead Campaign ID</option><option value="Other Services Interested">Other Services Interested</option></select><span class="dupli_err dupli"></span></div>';
        html += '<div class="form-group col-md-7"><label></label><select name="criteria_value[]" id="criteria_value'+fldCount+'" class="form-select criteria_value"><option value="">Select</option></select></div>';
        html += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(wrapper).append(html);
        });
        $(document).on('click', '.remove_button', function(){
            $(this).parents('.dynaDiv').remove();
        });
        //Add more field


    });

    $(document).on('change', '.other_criteria', function(){
        $("#criteria_value"+sub_id).html('');
        var other_criteria_val = $(this).val();
        var sub_id = $(this).data('sub_id');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: other_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#criteria_value'+sub_id).html('<option value="">Select</option>');
                    $.each(result, function (key, value) {
                        $("#criteria_value"+sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                    });
          }
        })
      });


      $(document).on('change', '#communication_mode', function(){
       
        var comm_mode = $(this).val();

        $.ajax({
          url: "{{route('admin.automation.fetchTemplates')}}",
          method:"POST",
          data: {
                comm_mode: comm_mode,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('.message_template,.msg_message_template').html('<option value="">Select Template</option>');
                    $.each(result, function (key, value) {
                        $('.message_template,.msg_message_template').append('<option value="' +value+ '">' +value+ '</option>');
                    });
            if(comm_mode=='Email'){
                $('.template_href').attr('href',"{{route('admin.mailtemplates')}}");
            }
            if(comm_mode=='Whatsapp'){
                $('.template_href').attr('href',"{{route('admin.whatsapptemplates')}}");
            }
            if(comm_mode=='SMS'){
                $('.template_href').attr('href',"{{route('admin.smstemplates')}}");
            }
          }
        })
      });



$(document).on('click', '#calc_aud_btn', function(){
        var target = $("#target").val();
    if(target == ''){
        $("#trgt_err").show();
    }else{
        var lead_status = $("#lead_status").val();

        var other_criteria = [];
        var criteria_value = [];
        $('.other_criteria').each(function() {
        var oth_cri_value = $(this).val();
            other_criteria.push(oth_cri_value);
        });
        $('.criteria_value').each(function() {
        var cri_value = $(this).val();
        criteria_value.push(cri_value);
        });
        $.ajax({
          url: "{{route('admin.automation.fetchAudienceCount')}}",
          type: 'POST',
          data: {
                target: target,
                lead_status: lead_status,
                other_criteria: other_criteria,
                criteria_value: criteria_value,
                _token: '{{csrf_token()}}'
            },
            dataType: 'json',
          success:function(result)
          {
            console.log(result);
            $("#calc_values").html(result);
          }
        });
    }
        
    }); 

$(document).on('click', '#test_msg_btn', function(){
        $(".errs").hide();
        var target = $("#target").val();
        var email_template = $("#email_template").val();
        var sms_template = $("#sms_template").val();
        var whtsp_template = $("#whtsp_template").val();
        var message = $("#message").val();
        var message_html = editor.getData();
        var subject_val = $("#subject_val").val();
        var send_to = $("#test_msg_input").val();
        var msg_type = $("input[name='msg_type']:checked").val();
    // if(target == ''){
    //     $("#trgt_err").show();
    //     $("#target").focus();
    // }
    if(!msg_type){
        $("#msg_type_err").show();
    }
    else if(msg_type == '1' && email_template ==""){
        $("#email_temp_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && subject_val==''){
        $("#email_sub_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && message_html==''){
        $("#email_msg_err").show();
    }
    // else if(msg_type == '2' && sms_template ==""){
    //     $("#sms_temp_err").show();
    // }

    else if(msg_type == '2' && sms_template == "manual" && message==''){
        $("#sms_msg_err").show();
    }

    else if(msg_type == '4' && whtsp_template ==""){
         $("#whtsp_temp_err").show();
     }

    else if(msg_type == '4' && message==''){
        $("#whtsp_msg_err").show();
    }


    else if(send_to == '' && msg_type == '1'){
        $("#send_to_err").show();
        $("#send_to_err").html('Please Enter Email'); 
    }
    else if(send_to == '' && msg_type == '2'){
        $("#send_to_err").show();
        $("#send_to_err").html('Please Enter Mobile No.'); 
    }
    else if(send_to == '' && msg_type == '4'){
        $("#send_to_err").show();
        $("#send_to_err").html('Please Enter Whatsapp No.'); 
    }
    else{
        $(".errs").hide();
        var email_template = $("#email_template").val();
        var subject_val = $("#subject_val").val();
        var msg_type = $("input[name='msg_type']:checked").val();
        if(msg_type == '1'){
            var message = message_html;
        }else{
            var message = message;
        }
        $.ajax({
          url: "{{route('admin.automation.campaign.test-send')}}",
          type: 'POST',
          data: {
                email_template: email_template,
                sms_template: sms_template,
                subject_val: subject_val,
                whtsp_template: whtsp_template,
                msg_type: msg_type,
                message: message,
                send_to: send_to,
                _token: '{{csrf_token()}}'
            },
            dataType: 'json',
        beforeSend: function(){
            // Show image container
            $("#test_msg_loading").show();
            $("#test_msg_btn").attr('disabled',true);
        },
          success:function(result)
          {
            console.log(result);
            $("#test_msg_loading").hide();
            $("#test_msg_btn").attr('disabled',false);
            if(result.err){
                $.toast({
                        heading: 'Error',
                        text: result.err,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 8
                    });
                //$('#test_msg_err').html("<p class='text-danger m-0'>"+result.err+"</p>");
            }else if(result.success){
                $.toast({
                        heading: 'Success',
                        text: result.success,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3000,
                        stack: 6
                    });
                //$('#test_msg_err').html("<p class='text-success m-0'>"+result.success+"</p>");
            }
            else{
                $('#test_msg_err').html("<p class='text-danger m-0'>"+result+"</p>");
            }
            console.log(result);
            //$("#calc_values").html(result);
          }
        });
    }
        
    }); 
    
    
$(document).on("change", "#target", function(event){
    
    $(".field_wrapper").find("select").each(function () {
        this.selectedIndex = 0;
    });
    $(".select2stats").val('').trigger('change');
    $('.dynaDiv').remove();
    $("#calc_values").html('');
    $("#trgt_err").hide();
});

$("#radio_1").click(function() {
        $("#msg_type_err").hide();
            $("#test_msg_input").val('');
            $("#email_template_block").show();
            $("#test_msg_input").attr('type','email');
            $("#test_msg_input").attr('placeholder','Enter Email');
            $("#sms_template_block,#whtsp_template_block").hide();
            $("#subject").show();
            $("#message,#plus_sign").hide();
            $(".ck-editor").show();
            $('.ck-toolbar').show();
            // $('#test_msg_input').keypress(function(event) {
            //     if($('#test_msg_input').attr("type") == 'email'){
                    
            //     }
            // });
        });
        $("#radio_2").click(function() {
            $("#test_msg_input").val('');
            $("#sms_template_block").show();
            $("#test_msg_input").attr('type','text');
            $("#test_msg_input").attr('placeholder','Enter Mobile Number with Dialcode without space or -');
            $("#email_template_block,#whtsp_template_block").hide();
            $("#subject").hide();
            $("#message,#plus_sign").show();
            $("#message").prop('readonly', false);
            $(".ck-editor").hide();
            $('.ck-toolbar').hide();

            $('#test_msg_input').keypress(function(event) {
                if($('#test_msg_input').attr("type") == 'text'){
                    if (event.keyCode < 48 || event.keyCode > 57) {
                        event.preventDefault(); 
                    }
                }
            });
        });
        $("#radio_4").click(function() {
            $("#test_msg_input").val('');
            $("#whtsp_template_block").show();
            $("#test_msg_input").attr('type','text');
            $("#test_msg_input").attr('placeholder','Enter Whatsapp Number with Dialcode without space or -');
            $("#email_template_block,#sms_template_block").hide();
            $("#subject").hide();
            $("#message,#plus_sign").show();
            $("#message").prop('readonly', true);
            $(".ck-editor").hide();
            $('.ck-toolbar').hide();
            $('#test_msg_input').keypress(function(event) {
                if($('#test_msg_input').attr("type") == 'text'){
                    if (event.keyCode < 48 || event.keyCode > 57) {
                        event.preventDefault(); 
                    }
                }
            });
        });

    $('#email_template').change(function() {
        if (this.value == 'manual') {
            $('#subject_val').val('');
            window.editor.setData('');
        } else {
            $('.tpl_loading').show();
            $.post("{{route('admin.mailtemplates.ajaxgetmailtpl')}}", {
                'hook': this.value,
                '_token': $('meta[name="csrf-token"]').attr('content')
            },
            function(data, status) {
                var tpl = JSON.parse(data);
                $('.tpl_loading').hide();
                $('#subject_val').val(tpl.mail_tpl.subject);

                if(tpl.emailSignature.email_signature){
                    window.editor.setData(tpl.mail_tpl.message + "<br><br><br>" +tpl.emailSignature.email_signature);
                }else{
                    window.editor.setData(tpl.mail_tpl.message + "<br>");
                }
            });
        }
    });

    $('#sms_template').change(function() {
        if (this.value == 'manual') {
            $('#message').val('');
        } else {
            $('.tpl_loading').show();
            $.post("{{route('admin.smstemplates.ajaxgetsmstpl')}}", {
                    'hook': this.value,
                    '_token': $('meta[name="csrf-token"]').attr('content')
                },
                function(data, status) {
                    var tpl = JSON.parse(data);
                    $('.tpl_loading').hide();
                    $('#message').val(tpl.message);
                });
        }
    });

    $('#whtsp_template').change(function() {
        if (this.value == 'manual') {
            $('#message').val('');
        } else {
            $('.tpl_loading').show();
            $.post("{{route('admin.whatsapptemplates.ajaxgetwhtsptpl')}}", {
                    'hook': this.value,
                    '_token': $('meta[name="csrf-token"]').attr('content')
                },
                function(data, status) {
                    var tpl = JSON.parse(data);
                    $('.tpl_loading').hide();
                    $('#message').val(tpl.message);
                });
        }
    });

$('#send_now').click(function(e) {
    e.preventDefault();
    $(".errs").hide();
    var title = $("#title").val();
    var target = $("#target").val();
    var email_template = $("#email_template").val();
    var sms_template = $("#sms_template").val();
    var whtsp_template = $("#whtsp_template").val();
    var message = $("#message").val();
    var message_html = editor.getData();
    var subject_val = $("#subject_val").val();
    var send_to = $("#test_msg_input").val();
    var msg_type = $("input[name='msg_type']:checked").val();
    $('#run_at').prop('required', false);
    if(title == ''){
         $("#title_err").show();
         $("#title").focus();
    }
    else if(target == ''){
         $("#trgt_err").show();
         $("#target").focus();
    }
    else if(!msg_type){
        $("#msg_type_err").show();
    }
    else if(msg_type == '1' && email_template ==""){
        $("#email_temp_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && subject_val==''){
        $("#email_sub_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && message_html==''){
        $("#email_msg_err").show();
    }
    else if(msg_type == '2' && sms_template == "manual" && message==''){
        $("#sms_msg_err").show();
    }
    else if(msg_type == '4' && whtsp_template ==""){
         $("#whtsp_temp_err").show();
     }
     else if(msg_type == '4' && message==''){
        $("#whtsp_msg_err").show();
    }
    else{
        $('#sub_type').val('send_now');
        $('#campaignForm').submit();
    }
});

$('#create_now').click(function(e) {
    e.preventDefault();
    $(".errs").hide();
    var title = $("#title").val();
    var target = $("#target").val();
    var email_template = $("#email_template").val();
    var sms_template = $("#sms_template").val();
    var whtsp_template = $("#whtsp_template").val();
    var message = $("#message").val();
    var message_html = editor.getData();
    var subject_val = $("#subject_val").val();
    var send_to = $("#test_msg_input").val();
    var msg_type = $("input[name='msg_type']:checked").val();
    var run_at = $('#run_at').val();
    if(title == ''){
         $("#title_err").show();
         $("#title").focus();
    }
    else if(target == ''){
         $("#trgt_err").show();
         $("#target").focus();
    }
    else if(!msg_type){
        $("#msg_type_err").show();
    }
    else if(msg_type == '1' && email_template ==""){
        $("#email_temp_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && subject_val==''){
        $("#email_sub_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && message_html==''){
        $("#email_msg_err").show();
    }
    else if(msg_type == '2' && sms_template == "manual" && message==''){
        $("#sms_msg_err").show();
    }
    else if(msg_type == '4' && whtsp_template ==""){
         $("#whtsp_temp_err").show();
     }
    else if(msg_type == '4' && message==''){
        $("#whtsp_msg_err").show();
    }
    else if(run_at == ''){
         $("#run_at_err").show();
         $("#run_at").focus();
    }
    else{
        $('#sub_type').val('create_now');
        $('#campaignForm').submit();
    }
});

$('body').on('click', '#view_message', function(event) {
       
        var message = $(this).data('message');
        $('#message_modal').modal('show');
        $('#msg_data').html(message);
});


$('#campaignForm').on('submit', function(event) {
var arr = [];
    $('.other_criteria').each(function() {
        var lead_value = $(this).val();
        if (arr.indexOf(lead_value) == -1){
            arr.push(lead_value);
        }
        else{
            event.preventDefault();
            $(this).siblings('.dupli_err').html('Duplicate Value');
            $(this).siblings('.dupli_err').focus();
            $('html, body').animate({
                scrollTop: $(".filterBox").offset().top
            }, 30);
            $(this).addClass("duplicate");
        }
    });
});

</script>
@endpush