@extends('backend.layouts.app')
@section('title', "Automation- Campaigns")

@section('content')
<div class="card">
    <div class="card-body pt-3">
        <div class="row">
            <div class="col" style="margin-bottom:10px;">
                <h4 style="">Campaigns</h4>
            </div>
        </div>
        <ul class="nav nav-tabs">
            {!!get_automation_tabs('automation.campaigns')!!}
            <div class="col-sm-7 col-7 ms-auto ">
                <div class="btn-toolbar float-right mx-2" role="toolbar" aria-label="Add New Course"  style="margin-top: 0px;float: right;"> 
                    <a href="{{ route('admin.automation.create.campaign') }}" class="btn btn-primary btn-sm" style="margin-bottom: 0px!important;" data-toggle="tooltip" title="Add New Workflow"><i class="bi bi-plus-circle"></i> New Campaign</a>
                </div>
            </div>
        </ul>
        {{-- Filters --}}
        <div class="filterBox" style="">
            <div class="form-group row mt-4">
                <label class="col-sm-1" style="font-weight: normal !important;">Status</label>
                <div class="col-sm-12 col-md-3">
                    <select class="form-select" id="status_list" name="status_list">
                            <option value="">Select</option>
                            <option value="queued">Queued</option>
                            <option value="paused">Paused</option>
                            <option value="running">Running</option>
                            <option value="sent">Sent</option>
                    </select>
                </div>
                <div class="col-sm-12 col-md-2">
                    <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                    <button onclick="javascript:clearTable();" class=" btn btn-outline-primary btn-sm">Clear</button>
                </div>
            </div>
            </div>
        {{-- Filters --}}

        <div class="row mt-4">
            <div class="table-responsive">                
                <table class="table w-100" id="campaign_list" class="display">
                    <thead>
                        <tr>
                            <th style="">Title</th>
                            <th style="">Status</th>
                            <th style="">Scheduled/Sent At</th>
                            <th style="">Mode</th>
                            <th style="">Sent To</th>
                            <th>Actions</th> 
                        </tr>
                    </thead>
                </table>
            </div>
        </div> 

    </div>
</div>
@endsection  
@push ('after-styles')
<style>
.badge-secondary {
    color: #fff;
    background-color: #6c757d;
}
</style>
@endpush      
@push ('after-scripts')

<script type="text/javascript">
    loadData();
    // Ajax DataTable
    function loadData() {
        var table = $('#campaign_list').DataTable({
            processing: true,
            serverSide: true,
            language: {
                searchPlaceholder: ""
            },
            autoWidth: true,
            responsive: true,
            lengthMenu: [50, 100, 200],
            "ajax": {
                "url": "{{route('admin.ajaxcampaignslist')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'camp_status': $('#status_list').val(),
                },
            },
            "drawCallback": function( settings ) {
                addDeleteForms();
            },
            'order': [
                [2, 'desc']
            ],
            columns: [
                {
                    data: 'title',
                    orderable: true,
                },
                {
                    data: 'status',
                },
                {
                    data: 'run_at',
                },
                {
                    data: 'mode',
                },
                {
                    data: 'audience_count',
                },
                {
                    data: 'actions',
                    orderable: false,
                },
                
            ],
        });
        


    }

    function searchTable() {
        $("#campaign_list").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        $('#status_list').val('');
        $("#campaign_list").dataTable().fnDestroy();
        loadData();
    }

</script>
@endpush
