@extends('backend.layouts.app')

@section('title', "Edit Campaign")

@section('content')
<div class="card">
    <div class="card-body">
        <ul class="nav nav-tabs mt-3">
            {!!get_automation_tabs('automation.campaigns')!!}
            <div class="col-sm-7 col-7 ms-auto ">
                <div class="btn-toolbar float-right mx-2" role="toolbar" style="margin-top: 0px;float: right;"> 
                    <a href="{{ route('admin.automation.campaigns') }}" style="margin-bottom: 0px!important;" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
                </div>
            </div>
        </ul>
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Edit Campaign
                </h4>
            </div><!--col-->
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-7">
                {{ html()->form('POST', route('admin.automation.update.campaign'))->class('form-horizontal')->id('campaignForm')->attribute('enctype', 'multipart/form-data')->open() }}
                <input type="hidden" name="campaign_id" value="{{$campaignData->id}}">
                <div style="margin-top:10px;">
                    <div class="form-group mb-3">
                        <label>Title <span style="color: red;">*</span></label>
                        <input type="text" name="title" id="title" value="{{$campaignData->title}}" class="form-control" maxlength="100" required>
                        <span class="text-danger errs" style="display: none;" id="title_err">Title is Required </span>
                    </div>
                    <div class="form-group col-md-4 mb-3">
                        <label>Target Audience <span style="color: red;">*</span></label>
                        <select name="target" class="form-select target mb-1" id='target' required>
                            <option value="">Select</option>
                            <option value="leads" {{($campaignData->target == "leads")? 'selected' : ''}}>Leads</option>
                            <option value="students" {{($campaignData->target == "students")? 'selected' : ''}}>Students</option>
                            <option value="staff" {{($campaignData->target == "staff")? 'selected' : ''}}>Staff</option>
                            <option value="agents" {{($campaignData->target == "agents")? 'selected' : ''}}>Agents(Partners)</option>
                            <option value="all" {{($campaignData->target == "all")? 'selected' : ''}}>All</option>
                        </select>
                        <span class="text-danger errs" style="display: none;" id="trgt_err">Please Select Target</span>
                    </div> 
                    <?php $cri = array(); ?>
                    {{-- @if($campaignData->target == "leads" || $campaignData->target == "students") --}}
                    <div class="for_lead_blk filterBox" style="{{($campaignData->target == "leads" || $campaignData->target == "students")? 'display:block;' : 'display:none;'}} border-radius: 10px; border:1px solid rgb(164 176 247) !important;">
                        <div class="form-group mb-3 status_type_lead">
                            <?php 
                                if($campaignData->target == "leads"){
                                    $statsData = explode(',',$campaignData->lead_status);
                                }
                                if($campaignData->target == "students"){
                                    $statsData = explode(',',$campaignData->student_status);
                                } 
                            ?>
                            <label>Lead Status </label>
                            <select name="lead_status[]" id="lead_status" class="form-select select2stats" style="width:100%!important;" multiple>
                                @foreach(lead_status_list() as $status_data)
                                <option value="{{$status_data->status}}" {{(isset($statsData) && in_array($status_data->status,$statsData))? 'selected' : ''}}>{{$status_data->status}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group mb-3 status_type_student" style="display: none;">
                            <label>Student Status </label>
                            <select name="student_status[]" id="student_status" class="form-select select2stats" style="width:100%!important;" multiple>
                                @foreach(get_overseas_status_list() as $stu_status_data)
                                <option value="{{$stu_status_data->status}}" {{(isset($statsData) && in_array($stu_status_data->status,$statsData))? 'selected' : ''}}>{{$stu_status_data->status}}</option>
                                @endforeach
                            </select>
                        </div> 
                        <div class="row field_wrapper">
                            <?php 
                            if($campaignData->target == "leads" && !empty($campaignData->lead_filters)){
                                $criteria_values = json_decode($campaignData->lead_filters); 
                            }
                            else if($campaignData->target == "students" && !empty($campaignData->student_filters)){
                                $criteria_values = json_decode($campaignData->student_filters);
                            }
                            else{
                                $criteria_values = "";
                            }   
                        ?>
                    @if($criteria_values != "")
                    @foreach($criteria_values as $criterias => $cri_vals)
                    <?php $cri[] = explode("|",$cri_vals);
                    ?>
                    @if($loop->index == 1)
                    <div class="row"><div class="col-md-12"><select style="width:20%;" name="criteria_condition" class="form-select criteria_condition"><option value="OR" {{($campaignData->filter_condition == 'or')? 'selected' : ''}}>OR</option><option value="and" {{($campaignData->filter_condition == 'and')? 'selected' : ''}}>AND</option></select></div></div>
                    @elseif($loop->index > 1)
                    <div class="row"><div class="col-md-12"><label class="criteria_cond_lbl p-1" style="text-transform: uppercase!important;">{{($campaignData->filter_condition)? $campaignData->filter_condition: 'OR'}}</label></div></div>
                    @endif
                    @if($loop->index == 0)
                    <div class="row"><div class="col-md-12"><label class="">{{'Other Criteria'}}</label></div></div>
                    @endif
                        <div class="form-group mb-1 col-md-4">
                            <select name="other_criteria[]" data-sub_id='{{ $loop->index }}' class="form-select other_criteria">
                                <option value="">Select</option>
                                <option {{($criterias == "Country Interested") ? 'selected' : ''}} value="Country Interested">Country Interested to Study In</option>
                                <option {{($criterias == "Course Interested to Study") ? 'selected' : ''}} value="Course Interested to Study">Course Interested to Study</option>
                                <option {{($criterias == "Interested Study Level") ? 'selected' : ''}} value="Interested Study Level">Interested Study Level</option>
                                <option {{($criterias == "Intake") ? 'selected' : ''}} value="Intake">Intake</option>
                                <option {{($criterias == "Passout Year") ? 'selected' : ''}} value="Passout Year">Passout Year</option>
                                <option {{($criterias == "Country of Residence") ? 'selected' : ''}} value="Country of Residence">Country of Residence</option>
                                <option {{($criterias == "Qualification") ? 'selected' : ''}} value="Qualification">Qualification</option>
                                <option {{($criterias == "Lead Source") ? 'selected' : ''}} value="Lead Source">Lead Source</option>
                                <option {{($criterias == "Lead Campaign Name") ? 'selected' : ''}} value="Lead Campaign Name">Lead Campaign Name</option>
                                @if(env('ADDITIONAL_SERVICES_ENABLE'))
                                <option {{($criterias == "Other Services Interested") ? 'selected' : ''}} value="Other Services Interested">Other Services Interested</option>
                                @endif
                            </select>
                        </div>
                            <div class="form-group col-md-8">
                                <select name="criteria_value[]" id="criteria_value{{ $loop->index }}" class="form-select criteria_value" multiple>
                                <option value="">Select</option>
                            </select>
                            </div>
                        @endforeach
                        @else
                        <div class="form-group mb-1 col-md-4">
                            <label>Other Criteria</label>
                            <select name="other_criteria[]" data-sub_id='1' class="form-select other_criteria">
                                <option value="">Select</option>
                                <option value="Country Interested">Country Interested to Study In</option>
                                <option value="Course Interested to Study">Course Interested to Study</option>
                                <option value="Interested Study Level">Interested Study Level</option>
                                <option value="Intake">Intake</option>
                                <option value="Passout Year">Passout Year</option>
                                <option value="Country of Residence">Country of Residence</option>
                                <option value="Qualification">Qualification</option>
                                <option value="Lead Source">Lead Source</option>
                                <option value="Lead Campaign Name">Lead Campaign Name</option>
                                @if(env('ADDITIONAL_SERVICES_ENABLE'))
                                <option value="Other Services Interested">Other Services Interested</option>
                                @endif
                            </select>
                        </div>
                        <div class="form-group col-md-8">
                                <label></label>
                                <select name="criteria_value[]" id="criteria_value1" class="form-select criteria_value" multiple>
                                <option value="">Select</option>
                            </select>
                        </div>
                        @endif
                        </div>
                        <div class="col-sm-12 text-end">
                            <a href="javascript:void(0);" style="" class="add_more_button btn btn-sm btn-outline-success" title="Add field"><i style="font-size:15px;" class="bi bi-plus"></i>Add More</a>
                        </div>
                    </div>
                    {{-- @endif --}}
                    <div class="filterBox mt-1" style="border-radius: 10px; border:1px solid rgb(164 176 247) !important;">
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <p class=""><b>Matched Audience:</b> <span id="calc_values" style="font-size: 19px!important;"></span> <a href="javascript:void(0);" id="calc_aud_btn" style="text-decoration: revert; float:right;">Calculate</a></p>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <div class="form-group row">
                            <div class="col-sm-6">
                                <input type="radio" {{($campaignData->communication_mode == 'email')? 'checked' : ''}} class="radio-col-blue" id="radio_1" name="msg_type" value="1" required />
                                <label for="radio_1">Email</label>

                                &nbsp;<input type="radio" {{($campaignData->communication_mode == 'sms')? 'checked' : ''}} class="radio-col-blue" id="radio_2" name="msg_type" value="2" required />
                                <label for="radio_2">SMS</label>

                                @if(get_site_config('whatsapp_enabled'))
                                &nbsp;<input type="radio" {{($campaignData->communication_mode == 'whatsapp')? 'checked' : ''}} class="radio-col-blue" id="radio_4" name="msg_type" value="4" required />
                                <label for="radio_4">Whatsapp</label>
                                @endif
                                <span class="text-danger errs" style="display: none;" id="msg_type_err"><p class="mt-0 mb-1">Please Select Type</p></span>
                            </div>
                        </div>
                    </div>

                    
                    {{-- //Email Whatsapp SMS Content --}}
                    <div class="form-group" id="email_template_block" style="display:{{($campaignData->communication_mode == 'email')? 'block' : 'none'}};">
                        <select class="form-control form-select" id="email_template">
                            <option value="manual">Choose a template OR Type the message</option>
                            @foreach(get_email_templates() as $tpl)
                            <option {{($campaignData->message_template == $tpl)? 'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                        </select>
                        <span class="text-danger errs" id="email_temp_err" style="display: none;">Please Select Template</span>
                    </div>
                    <div class="form-group" id="sms_template_block" style="display:{{($campaignData->communication_mode == 'sms')? 'block' : 'none'}};">
                        <select class="form-control form-select" name="sms_template" id="sms_template">
                            <option value="manual">Choose a template OR Type the message</option>
                            @foreach(get_sms_templates() as $tpl)
                            <option {{($campaignData->message_template == $tpl)? 'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                        </select>
                        <span class="text-danger errs" id="sms_temp_err" style="display: none;">Please Select Template</span>
                    </div>
                    <div class="form-group" id="whtsp_template_block" style="display:{{($campaignData->communication_mode == 'whatsapp')? 'block' : 'none'}};">
                        <select class="form-control form-select" name="whtsp_template" id="whtsp_template">
                            <option value="">Choose a template</option>
                            @foreach(get_whatsapp_templates() as $tpl)
                            <option {{($campaignData->message_template == $tpl)? 'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                        </select>
                        <span class="text-danger errs" id="whtsp_temp_err" style="display: none;">Please Select Template</span>
                    </div>
    
                    <div class="tpl_loading" style="display:none;"><span style="color:red;">Loading... Please wait.</span></div>
    
                    <div class="form-group row" id="subject" style="display:{{($campaignData->communication_mode == 'email')? 'block' : 'none'}};">
                        <div class="col-sm-12">
                            <label>Subject</label>
                            <input id="subject_val" value="{{$campaignData->message_subject}}" class="form-control" name="subject">
                            <span class="text-danger mt-0 mb-1 errs" id="email_sub_err" style="display: none;">Please Provide Subject</span>
                        </div>
                    </div>
    
                    <div class="form-group row mb-3">
                        <div class="col-sm-12">
                            <textarea id="message" style="display:{{($campaignData->communication_mode != 'email')? 'block' : 'none'}};" class="form-control" name="message" rows="10" cols="150">{{($campaignData->communication_mode!='email')? $campaignData->message_content : ''}}</textarea>
                            
                            <textarea id="message_html" name="message_html" rows="10" style="height:300px;" class="ckeditor_toolbar_all form-control">{{($campaignData->communication_mode=='email')? $campaignData->message_content : ''}}</textarea>
                            <span class="text-danger mt-0 mb-1 errs" id="sms_msg_err" style="display: none;">Please Type Message</span>
                            <span class="text-danger mt-0 mb-1 errs" id="email_msg_err" style="display: none;">Please Type Message</span>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <strong>Note:</strong>
                    </div>
                    <div class="col-sm-12">
                        <strong>Following variables can be used in the message content:</strong>
                        <br>#first_name# - Replaces with User First name
                        <br>#full_name# - Replaces with User Full name
                        <br>#sitename# - Website Name
                        <br>#siteurl# - Website URL
                    </div>
                    <div class="filterBox mt-1" style="border-radius: 10px; border:1px solid rgb(164 176 247) !important;">
                        <div class="row mt-4">
                            <div class="col-md-12 ">
                                <p><strong>Test campaign message</strong></p>
                                <p class="mb-1"><b>Send To:</b> <span id="plus_sign" style="font-size: 15px;font-size:18px!important;
                                    font-weight: 700;display:none;">+</span><input id="test_msg_input" name="send_to" style="width:60%;display: inline;" class="form-control" type="text"> <button type="button" id="test_msg_btn" class="btn btn-primary btn-sm">Send Message</button><i id="test_msg_loading" style="display: none;" class="fa fa-cog fa-spin fa-10x fa-fw"></i></p>
                                <span class="text-danger mt-0 mb-1 errs" id="send_to_err" style="display: none;"></span>
                                <span id="test_msg_err"></span>
                                <p><small>Note: Any personalization variables will be replaced with blank in this message</small></p>
                            </div>
                            
                        </div>
                    </div>
                    {{-- <h5 class="mb-3">Run at</h5> --}}
                    <div class="row mt-4">
                        <div class="col-md-5">
                            <label>Run at<span style="color: red;">*</span></label>
                            <input type="text" value="{{date("d-M-Y H:i", strtotime($campaignData->run_at))}}" placeholder="Select Date & Time" name="run_at" class="form-control runat_datetimepicker" autocomplete="off" id='run_at' required>
                            <span class="text-danger mt-0 mb-1 errs" id="run_at_err" style="display: none;">Date & Time is Required</span>
                        </div>
                        <div class="col-md-1 align-self-center text-center">
                            OR
                        </div>
                        <div class="col-md-3 align-self-center">
                            <button type='submit' name="submit_action" id="send_now" value="send_now" style="margin-bottom:0px!important;" class="btn btn-secondary mb-0">Send Now</button>
                        </div>
                        
                    </div>
                    <hr>
                    <div class="row mt-4">
                        
                    <div class="form-group" style="text-align: center">
                        <button type="submit" name="submit_action" id="create_now" value="create_now" class="btn btn-sm btn-primary">Update</button>
                        <input type="hidden" name="submit_action" id="sub_type">
                        <a href="{{ route('admin.automation.campaigns') }}" class="btn btn-sm btn-secondary">Cancel</a>
                    </div>
                    </div>
                    {{ html()->form()->close() }}  
                </div>
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection
@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<style>
.duplicate {
    border: 1px solid red;
    color: red;
}
.dupli {
    color: red;
}
.fa-10x{
        font-size:1.6em !important;
    };
</style>
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
<script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script>
    $(document).ready(function () {
        $(".select2stats").select2({
            placeholder: "Select",
            allowClear: true
        });
        $('#criteria_value1').select2({
            placeholder: "Select",
            allowClear: true
        });
    $('.runat_datetimepicker').datetimepicker({
        timepicker: true,
        format: 'd-M-Y H:i',
        step: 15,
        minDate: 0,
    });

//onload
    @if($campaignData->target=="leads")
        $(".status_type_student").hide();
        $(".status_type_lead").show();
    @elseif($campaignData->target=="students")
        $(".status_type_student").show();
        $(".status_type_lead").hide();
    @else
    $(".status_type_lead,.status_type_student").hide();
    @endif


    var criarray = JSON.parse('<?php echo json_encode($cri); ?>');
    $('.other_criteria').each(function(index) {
        var load_criteria_val = $(this).val();
        var sub_id = $(this).data('sub_id');
        $("#criteria_value"+sub_id).html('');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: load_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#criteria_value'+sub_id).select2({
            placeholder: "Select",
            allowClear: true
            });
            $('#criteria_value'+sub_id).html('<option value="">Select</option>');
            //console.log(index);
            // $.each(result, function (key, value) {
            //     if(value.val == criarray[index]){
            //         var selectedVal = "selected";
            //     }
            //     else{
            //         var selectedVal = "";
            //     }
            //     $("#criteria_value"+sub_id).append('<option '+selectedVal+' value="' + value
            //         .val + '">' + value.title + '</option>');
            // });
            $.each(result, function (key, value) {
                $("#criteria_value"+sub_id).append('<option value="' + value
                    .val + '">' + value.title + '</option>');
                $('#criteria_value'+sub_id).val(criarray[index]).change();
                $('#criteria_value'+sub_id).attr('name',load_criteria_val.replace(/[\s;]+/g, "_")+"[]");
            });
          }
        });
    });

    @if($campaignData->communication_mode != 'email')
        $(".ck-editor").hide();
        $('.ck-toolbar').hide();
    @endif
//onload




        if($("#communication_mode").val()=='Email'){
                $('.template_href').attr('href',"{{route('admin.mailtemplates')}}");
            }
        if($("#communication_mode").val()=='Whatsapp'){
                $('.template_href').attr('href',"{{route('admin.whatsapptemplates')}}");
            }
        if($("#communication_mode").val()=='SMS'){
                $('.template_href').attr('href',"{{route('admin.smstemplates')}}");
        }

        $('.target').change(function() {
            $(".target,.start_date").attr('required',true);
            if (this.value == 'leads' || this.value == 'students') {
                $('.for_lead_blk').show();
                if(this.value == 'leads'){
                    $(".status_type_student").hide();
                    $(".status_type_lead").show();
                }
                if(this.value == 'students'){
                    $(".status_type_student").show();
                    $(".status_type_lead").hide();
                }
            }
            else {
                $('.for_lead_blk').hide();
            }
        });


        //Add more field
        var wrapper = $('.field_wrapper'); //Input field wrapper
        var issetcriarray = JSON.parse('<?php echo json_encode($cri); ?>');
        if(issetcriarray.length > 1){
            var fldCount = issetcriarray.length;   
        }else{
            var fldCount = 1;
        }
        $(document).on('click', '.add_more_button', function(){
        fldCount++;
        var html = '';
        html += '<div class="row dynaDiv"><div class="col-md-12">';
            //console.log(fldCount);
            
            if(fldCount == 2 && issetcriarray == ""){
                html += '<select style="width:20%;" name="criteria_condition" class="form-select criteria_condition"><option value="OR">OR</option><option value="and">AND</option></select>';
            }
            else if(fldCount == 2 && issetcriarray.length == 1){
                html += '<select style="width:20%;" name="criteria_condition" class="form-select criteria_condition"><option value="OR">OR</option><option value="and">AND</option></select>';
            }
            else{
                html += '<label class="criteria_cond_lbl p-1" style="text-transform: uppercase!important;"></label>';
            }
        html += '</div>';
        html += '<div class="row dynaDiv"><div class="form-group mb-1 col-md-4"><select name="other_criteria[]" data-sub_id="'+fldCount+'" class="form-select other_criteria mb-1" required><option value="">Select</option><option value="Country Interested">Country Interested to Study In</option><option value="Course Interested to Study">Course Interested to Study</option><option value="Interested Study Level">Interested Study Level</option><option value="Intake">Intake</option><option value="Passout Year">Passout Year</option><option value="Country of Residence">Country of Residence</option><option value="Qualification">Qualification</option><option value="Lead Source">Lead Source</option><option value="Lead Campaign Name">Lead Campaign Name</option><option value="Other Services Interested">Other Services Interested</option></select><span class="dupli_err dupli"></span></div>';
        html += '<div class="form-group col-md-7"><select name="criteria_value[]" id="criteria_value'+fldCount+'" class="form-select criteria_value" multiple></select></div>';
        html += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(wrapper).append(html);
        var old_cond_val = $('.criteria_condition').children("option:selected").val();
        $(".criteria_cond_lbl").html(old_cond_val);
        $('#criteria_value'+fldCount).select2({
                placeholder: "Select",
                allowClear: true
            });
        });
        $(document).on('click', '.remove_button', function(){
            fldCount--;
            $(this).parents('.dynaDiv').remove();
        });
        //Add more field


    });

    $(document).on('change', '.other_criteria', function(){
        var other_criteria_val = $(this).val();
        var sub_id = $(this).data('sub_id');
        $("#criteria_value"+sub_id).html('');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: other_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#criteria_value'+sub_id).html('<option value="">Select</option>');
            $('#criteria_value'+sub_id).attr('name',other_criteria_val.replace(/[\s;]+/g, "_")+"[]");
                    $.each(result, function (key, value) {
                        $("#criteria_value"+sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                    });
          }
        })
      });


      $(document).on('change', '#communication_mode', function(){
       
        var comm_mode = $(this).val();

        $.ajax({
          url: "{{route('admin.automation.fetchTemplates')}}",
          method:"POST",
          data: {
                comm_mode: comm_mode,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('.message_template,.msg_message_template').html('<option value="">Select Template</option>');
                    $.each(result, function (key, value) {
                        $('.message_template,.msg_message_template').append('<option value="' +value+ '">' +value+ '</option>');
                    });
            if(comm_mode=='Email'){
                $('.template_href').attr('href',"{{route('admin.mailtemplates')}}");
            }
            if(comm_mode=='Whatsapp'){
                $('.template_href').attr('href',"{{route('admin.whatsapptemplates')}}");
            }
            if(comm_mode=='SMS'){
                $('.template_href').attr('href',"{{route('admin.smstemplates')}}");
            }
          }
        })
      });



$(document).on('click', '#calc_aud_btn', function(){
        var target = $("#target").val();
    if(target == ''){
        $("#trgt_err").show();
    }else{
        var lead_status = $("#lead_status").val();
        var filter_condition = $(".criteria_condition").val();
        var student_status = $("#student_status").val();
        var other_criteria = [];
        var criteria_value = [];
        $('.other_criteria').each(function() {
        var oth_cri_value = $(this).val();
            other_criteria.push(oth_cri_value);
        });
        $('.criteria_value').each(function() {
        var cri_value = $(this).val();
        criteria_value.push(cri_value);
        });
        $.ajax({
          url: "{{route('admin.automation.fetchAudienceCount')}}",
          type: 'POST',
          data: {
                target: target,
                lead_status: lead_status,
                student_status: student_status,
                filter_condition: filter_condition,
                other_criteria: other_criteria,
                criteria_value: criteria_value,
                _token: '{{csrf_token()}}'
            },
            dataType: 'json',
          success:function(result)
          {
            console.log(result);
            $("#calc_values").html(result);
          }
        });
    }
        
    }); 

$(document).on('click', '#test_msg_btn', function(){
        $(".errs").hide();
        var target = $("#target").val();
        var email_template = $("#email_template").val();
        var sms_template = $("#sms_template").val();
        var whtsp_template = $("#whtsp_template").val();
        var message = $("#message").val();
        var message_html = editor.getData();
        var subject_val = $("#subject_val").val();
        var send_to = $("#test_msg_input").val();
        var msg_type = $("input[name='msg_type']:checked").val();
    // if(target == ''){
    //     $("#trgt_err").show();
    //     $("#target").focus();
    // }
    if(!msg_type){
        $("#msg_type_err").show();
    }
    else if(msg_type == '1' && email_template ==""){
        $("#email_temp_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && subject_val==''){
        $("#email_sub_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && message_html==''){
        $("#email_msg_err").show();
    }
    // else if(msg_type == '2' && sms_template ==""){
    //     $("#sms_temp_err").show();
    // }

    else if(msg_type == '2' && sms_template == "manual" && message==''){
        $("#sms_msg_err").show();
    }

    else if(msg_type == '4' && whtsp_template ==""){
         $("#whtsp_temp_err").show();
     }

    else if(msg_type == '4' && message==''){
        $("#whtsp_msg_err").show();
    }


    else if(send_to == '' && msg_type == '1'){
        $("#send_to_err").show();
        $("#send_to_err").html('Please Enter Email'); 
    }
    else if(send_to == '' && msg_type == '2'){
        $("#send_to_err").show();
        $("#send_to_err").html('Please Enter Mobile No.'); 
    }
    else if(send_to == '' && msg_type == '4'){
        $("#send_to_err").show();
        $("#send_to_err").html('Please Enter Whatsapp No.'); 
    }
    else{
        $(".errs").hide();
        var email_template = $("#email_template").val();
        var subject_val = $("#subject_val").val();
        var msg_type = $("input[name='msg_type']:checked").val();
        if(msg_type == '1'){
            var message = message_html;
        }else{
            var message = message;
        }
        $.ajax({
          url: "{{route('admin.automation.campaign.test-send')}}",
          type: 'POST',
          data: {
                email_template: email_template,
                sms_template: sms_template,
                subject_val: subject_val,
                whtsp_template: whtsp_template,
                msg_type: msg_type,
                message: message,
                send_to: send_to,
                _token: '{{csrf_token()}}'
            },
            dataType: 'json',
        beforeSend: function(){
            // Show image container
            $("#test_msg_loading").show();
            $("#test_msg_btn").attr('disabled',true);
        },
          success:function(result)
          {
            console.log(result);
            $("#test_msg_loading").hide();
            $("#test_msg_btn").attr('disabled',false);
            if(result.err){
                $.toast({
                        heading: 'Error',
                        text: result.err,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 8
                    });
                //$('#test_msg_err').html("<p class='text-danger m-0'>"+result.err+"</p>");
            }else if(result.success){
                $.toast({
                        heading: 'Success',
                        text: result.success,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3000,
                        stack: 6
                    });
                //$('#test_msg_err').html("<p class='text-success m-0'>"+result.success+"</p>");
            }
            else{
                $('#test_msg_err').html("<p class='text-danger m-0'>"+result+"</p>");
            }
            console.log(result);
            //$("#calc_values").html(result);
          }
        });
    }
        
    }); 
    
    
$(document).on("change", "#target", function(event){
    
    $(".field_wrapper").find("select").each(function () {
        this.selectedIndex = 0;
    });
    $(".select2stats").val('').trigger('change');
    $('.dynaDiv').remove();
    $("#calc_values").html('');
    $("#trgt_err").hide();
});

$("#radio_1").click(function() {
        $("#msg_type_err").hide();
            $("#test_msg_input").val('');
            $("#email_template_block").show();
            $("#test_msg_input").attr('type','email');
            $("#test_msg_input").attr('placeholder','Enter Email');
            $("#sms_template_block,#whtsp_template_block").hide();
            $("#subject").show();
            $("#message,#plus_sign").hide();
            $(".ck-editor").show();
            $('.ck-toolbar').show();
            // $('#test_msg_input').keypress(function(event) {
            //     if($('#test_msg_input').attr("type") == 'email'){
                    
            //     }
            // });
        });
        $("#radio_2").click(function() {
            $("#test_msg_input").val('');
            $("#sms_template_block").show();
            $("#test_msg_input").attr('type','text');
            $("#test_msg_input").attr('placeholder','Enter Mobile Number with Dialcode without space or -');
            $("#email_template_block,#whtsp_template_block").hide();
            $("#subject").hide();
            $("#message,#plus_sign").show();
            $("#message").prop('readonly', false);
            $(".ck-editor").hide();
            $('.ck-toolbar').hide();

            $('#test_msg_input').keypress(function(event) {
                if($('#test_msg_input').attr("type") == 'text'){
                    if (event.keyCode < 48 || event.keyCode > 57) {
                        event.preventDefault(); 
                    }
                }
            });
        });
        $("#radio_4").click(function() {
            $("#test_msg_input").val('');
            $("#whtsp_template_block").show();
            $("#test_msg_input").attr('type','text');
            $("#test_msg_input").attr('placeholder','Enter Whatsapp Number with Dialcode without space or -');
            $("#email_template_block,#sms_template_block").hide();
            $("#subject").hide();
            $("#message,#plus_sign").show();
            $("#message").prop('readonly', true);
            $(".ck-editor").hide();
            $('.ck-toolbar').hide();
            $('#test_msg_input').keypress(function(event) {
                if($('#test_msg_input').attr("type") == 'text'){
                    if (event.keyCode < 48 || event.keyCode > 57) {
                        event.preventDefault(); 
                    }
                }
            });
        });

    $('#email_template').change(function() {
        if (this.value == 'manual') {
            $('#subject_val').val('');
            window.editor.setData('');
        } else {
            $('.tpl_loading').show();
            $.post("{{route('admin.mailtemplates.ajaxgetmailtpl')}}", {
                'hook': this.value,
                '_token': $('meta[name="csrf-token"]').attr('content')
            },
            function(data, status) {
                var tpl = JSON.parse(data);
                $('.tpl_loading').hide();
                $('#subject_val').val(tpl.mail_tpl.subject);

                if(tpl.emailSignature.email_signature){
                    window.editor.setData(tpl.mail_tpl.message + "<br><br><br>" +tpl.emailSignature.email_signature);
                }else{
                    window.editor.setData(tpl.mail_tpl.message + "<br>");
                }
            });
        }
    });

    $('#sms_template').change(function() {
        if (this.value == 'manual') {
            $('#message').val('');
        } else {
            $('.tpl_loading').show();
            $.post("{{route('admin.smstemplates.ajaxgetsmstpl')}}", {
                    'hook': this.value,
                    '_token': $('meta[name="csrf-token"]').attr('content')
                },
                function(data, status) {
                    var tpl = JSON.parse(data);
                    $('.tpl_loading').hide();
                    $('#message').val(tpl.message);
                });
        }
    });

    $('#whtsp_template').change(function() {
        if (this.value == 'manual') {
            $('#message').val('');
        } else {
            $('.tpl_loading').show();
            $.post("{{route('admin.whatsapptemplates.ajaxgetwhtsptpl')}}", {
                    'hook': this.value,
                    '_token': $('meta[name="csrf-token"]').attr('content')
                },
                function(data, status) {
                    var tpl = JSON.parse(data);
                    $('.tpl_loading').hide();
                    $('#message').val(tpl.message);
                });
        }
    });

$('#send_now').click(function(e) {
    e.preventDefault();
    $(".errs").hide();
    var title = $("#title").val();
    var target = $("#target").val();
    var email_template = $("#email_template").val();
    var sms_template = $("#sms_template").val();
    var whtsp_template = $("#whtsp_template").val();
    var message = $("#message").val();
    var message_html = editor.getData();
    var subject_val = $("#subject_val").val();
    var send_to = $("#test_msg_input").val();
    var msg_type = $("input[name='msg_type']:checked").val();
    $('#run_at').prop('required', false);
    if(title == ''){
         $("#title_err").show();
         $("#title").focus();
    }
    else if(target == ''){
         $("#trgt_err").show();
         $("#target").focus();
    }
    else if(!msg_type){
        $("#msg_type_err").show();
    }
    else if(msg_type == '1' && email_template ==""){
        $("#email_temp_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && subject_val==''){
        $("#email_sub_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && message_html==''){
        $("#email_msg_err").show();
    }
    else if(msg_type == '2' && sms_template == "manual" && message==''){
        $("#sms_msg_err").show();
    }
    else if(msg_type == '4' && whtsp_template ==""){
         $("#whtsp_temp_err").show();
     }
     else if(msg_type == '4' && message==''){
        $("#whtsp_msg_err").show();
    }
    else{
        $('#sub_type').val('send_now');
        $('#campaignForm').submit();
    }
});

$('#create_now').click(function(e) {
    e.preventDefault();
    $(".errs").hide();
    var title = $("#title").val();
    var target = $("#target").val();
    var email_template = $("#email_template").val();
    var sms_template = $("#sms_template").val();
    var whtsp_template = $("#whtsp_template").val();
    var message = $("#message").val();
    var message_html = editor.getData();
    var subject_val = $("#subject_val").val();
    var send_to = $("#test_msg_input").val();
    var msg_type = $("input[name='msg_type']:checked").val();
    var run_at = $('#run_at').val();
    if(title == ''){
         $("#title_err").show();
         $("#title").focus();
    }
    else if(target == ''){
         $("#trgt_err").show();
         $("#target").focus();
    }
    else if(!msg_type){
        $("#msg_type_err").show();
    }
    else if(msg_type == '1' && email_template ==""){
        $("#email_temp_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && subject_val==''){
        $("#email_sub_err").show();
    }
    else if(msg_type == '1' && email_template == "manual" && message_html==''){
        $("#email_msg_err").show();
    }
    else if(msg_type == '2' && sms_template == "manual" && message==''){
        $("#sms_msg_err").show();
    }
    else if(msg_type == '4' && whtsp_template ==""){
         $("#whtsp_temp_err").show();
     }
    else if(msg_type == '4' && message==''){
        $("#whtsp_msg_err").show();
    }
    else if(run_at == ''){
         $("#run_at_err").show();
         $("#run_at").focus();
    }
    else{
        $('#sub_type').val('create_now');
        $('#campaignForm').submit();
    }
});

$(document).on('change', '.criteria_condition', function(){
        var tab = $(this).children("option:selected").val();
        $(".criteria_cond_lbl").html(tab);
});

$('#campaignForm').on('submit', function(event) {
var arr = [];
    $('.other_criteria').each(function() {
        var lead_value = $(this).val();
        if (arr.indexOf(lead_value) == -1){
            arr.push(lead_value);
        }
        else{
            event.preventDefault();
            $(this).siblings('.dupli_err').html('Duplicate Value');
            $(this).siblings('.dupli_err').focus();
            $('html, body').animate({
                scrollTop: $(".filterBox").offset().top
            }, 30);
            $(this).addClass("duplicate");
        }
    });
});

</script>
@endpush