@extends('backend.layouts.app')

@section('title', "Edit Workflow")

@section('content')
<div class="card">
    <div class="card-body">
        <ul class="nav nav-tabs mt-3">
            {!!get_automation_tabs('workflows')!!}
            <div class="col-sm-7 col-7 ms-auto ">
                <div class="btn-toolbar float-right mx-2" role="toolbar" style="margin-top: 0px;float: right;"> 
                    <a href="{{ route('admin.automation') }}" style="margin-bottom: 0px!important;" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
                </div>
            </div>
        </ul>
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Edit Workflow
                </h4>
            </div><!--col-->
            {{-- <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <a href="{{ route('admin.automation') }}" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
            </div> --}}
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-7">


                {{ html()->form('POST', route('admin.automation.update.workflow'))->class('form-horizontal')->id('createForm')->attribute('enctype', 'multipart/form-data')->open() }}
                <input type="hidden" name="workflow_id" value="{{$workflowData->id}}">
                <div style="margin-top:10px;">
                    <div class="form-group mb-3">
                        <label>Title <span style="color: red;">*</span></label>
                        <input type="text" name="title" value="{{$workflowData->title}}" class="form-control" maxlength="100" required>
                    </div>
                    <div class="form-group mb-3">
                        <label>Workflow Type <span style="color: red;">*</span></label>
                        <select name="workflow_type" id="workflow_type" class="form-select" disabled>
                            <option value="">Select</option>
                            <option {{($workflowData->workflow_type == "lead_nurture_sequence") ? 'selected' : ''}}>Lead Nurture Sequence</option>
                            <option {{($workflowData->workflow_type == "message_sequence") ? 'selected' : ''}} >Message Sequence</option>
                            <option {{($workflowData->workflow_type == "specific_event") ? 'selected' : ''}}>Specific Event</option>
                        </select>
                        <div style="display: none;" id="flow_desc" class="alert alert-warning" role="alert"></div>
                    </div> 
                    <div class="row">
                        <div class="form-group col-md-3 mb-3">
                            <label>Send<span style="color: red;">*</span></label>
                            <select name="communication_mode" id="communication_mode" class="form-select" disabled>
                                <option {{($workflowData->communication_mode == "email") ? 'selected' : ''}}>Email</option>
                                <option {{($workflowData->communication_mode == "whatsapp") ? 'selected' : ''}}>Whatsapp</option>
                                <option {{($workflowData->communication_mode == "sms") ? 'selected' : ''}}>SMS</option>
                            </select>
                        </div>
                        <?php
                            $start = "01:00";
                            $end = "12:55";

                            $tStart = strtotime($start);
                            $tEnd = strtotime($end);
                            $tNow = $tStart;
                        ?> 
                        <div class="form-group col-md-3 mb-3">
                            <label>At<span style="color: red;">*</span></label>
                            <select name="run_at_time" id="run_at_time" class="form-select" required>
                                <?php
                                while($tNow <= $tEnd){
                                    if(date('h:i:s', strtotime($workflowData->run_at)) == date("h:i:s",$tNow)){
                                        $run_at_selected = "selected";
                                    }else{
                                        $run_at_selected = "";
                                    }
                                    echo '<option '.$run_at_selected.' value="'.date("H:i",$tNow).'">'.date("H:i",$tNow).'</option>';
                                    $tNow = strtotime('+5 minutes',$tNow);
                                }?>
                            </select>
                        </div>
                        <div class="form-group col-md-2 mb-3">
                            <?php
                                $am_pm = date('A', strtotime($workflowData->run_at));
                            ?>
                            <label></label>
                            <select name="run_at" id="run_at" class="form-select" required>
                            <option {{($am_pm == "AM")? 'selected' : ''}} value="AM">AM</option> 
                            <option  {{($am_pm == "PM")? 'selected' : ''}} value="PM">PM</option>     
                            </select>
                        </div>
                    </div>

@if($workflowData->workflow_type == "lead_nurture_sequence")             
<div id="lead_nurture_blk">
                    <hr class="mt-0 mb-1">
                    <h5 class="mb-3">Target Audience</h5>
                    <div class="form-group mb-3">
                        <?php 
                            $lead_statuses = explode(",", $workflowData->lead_status);     
                        ?>
                        <label>Lead Status <span style="color: red;">*</span></label>
                        <select name="lead_status[]" class="form-select select2stats" multiple required>
                            @foreach(lead_status_list() as $status_data)
                            <option value="{{$status_data->status}}" {{(in_array($status_data->status,$lead_statuses))? 'selected' : ''}}>{{$status_data->status}}</option>
                            @endforeach
                        </select>
                    </div> 
                     
                    <div class="row field_wrapper">
                    <?php 
                        if($workflowData->target == "leads" && !empty($workflowData->lead_filters)){
                            $criteria_values = json_decode($workflowData->lead_filters); 
                        }
                        else if($workflowData->target == "students" && !empty($workflowData->student_filters)){
                            $criteria_values = json_decode($workflowData->student_filters);
                        }
                        else{
                            $criteria_values = "";
                        }   
                        $cri = array();    
                    ?>
                    @if($criteria_values != "")
                    @foreach($criteria_values as $criterias => $cri_vals)
                    <?php $cri[] = explode("|",$cri_vals);
                    ?>
                    @if($loop->index == 1)
                    <div class="row"><div class="col-md-12"><select style="width:20%;" name="criteria_condition" class="form-select criteria_condition"><option value="OR" {{($workflowData->filter_condition == 'or')? 'selected' : ''}}>OR</option><option value="and" {{($workflowData->filter_condition == 'and')? 'selected' : ''}}>AND</option></select></div></div>
                    @elseif($loop->index > 1)
                    <div class="row"><div class="col-md-12"><label class="criteria_cond_lbl p-1" style="text-transform: uppercase!important;">{{($workflowData->filter_condition)? $workflowData->filter_condition: 'OR'}}</label></div></div>
                    @endif
                    @if($loop->index == 0)
                    <div class="row"><div class="col-md-12"><label class="">{{'Other Criteria'}}</label></div></div>
                    @endif
                    <div class="form-group mb-1 col-md-4">
                        <select name="other_criteria[]" data-sub_id='{{ $loop->index }}' class="form-select other_criteria">
                            <option value="">Select</option>
                            <option {{($criterias == "Country Interested") ? 'selected' : ''}} value="Country Interested">Country Interested to Study In</option>
                            <option {{($criterias == "Course Interested to Study") ? 'selected' : ''}} value="Course Interested to Study">Course Interested to Study</option>
                            <option {{($criterias == "Interested Study Level") ? 'selected' : ''}} value="Interested Study Level">Interested Study Level</option>
                            <option {{($criterias == "Intake") ? 'selected' : ''}} value="Intake">Intake</option>
                            <option {{($criterias == "Passout Year") ? 'selected' : ''}} value="Passout Year">Passout Year</option>
                            <option {{($criterias == "Country of Residence") ? 'selected' : ''}} value="Country of Residence">Country of Residence</option>
                            <option {{($criterias == "Qualification") ? 'selected' : ''}} value="Qualification">Qualification</option>
                            <option {{($criterias == "Lead Source") ? 'selected' : ''}} value="Lead Source">Lead Source</option>
                            <option {{($criterias == "Lead Campaign Name") ? 'selected' : ''}} value="Lead Campaign Name">Lead Campaign Name</option>
                            @if(env('ADDITIONAL_SERVICES_ENABLE'))
                            <option {{($criterias == "Other Services Interested") ? 'selected' : ''}} value="Other Services Interested">Other Services Interested</option>
                            @endif
                        </select>
                    </div>

                        <div class="form-group col-md-8">
                            {{-- @if($loop->index != 1)
                            <label></label>
                            @endif --}}
                            <select name="criteria_value[]" id="criteria_value{{ $loop->index }}" class="form-select" multiple>
                            <option value="">Select</option>
                        </select>
                        </div>
                    @endforeach
                    @else
                    <div class="form-group mb-1 col-md-4">
                        <label>Other Criteria</label>
                        <select name="other_criteria[]" data-sub_id='1' class="form-select other_criteria">
                            <option value="">Select</option>
                            <option value="Country Interested">Country Interested to Study In</option>
                            <option value="Course Interested to Study">Course Interested to Study</option>
                            <option value="Interested Study Level">Interested Study Level</option>
                            <option value="Intake">Intake</option>
                            <option value="Passout Year">Passout Year</option>
                            <option value="Country of Residence">Country of Residence</option>
                            <option value="Qualification">Qualification</option>
                            <option value="Lead Source">Lead Source</option>
                            <option value="Lead Campaign Name">Lead Campaign Name</option>
                            @if(env('ADDITIONAL_SERVICES_ENABLE'))
                            <option value="Other Services Interested">Other Services Interested</option>
                            @endif
                        </select>
                    </div>

                        <div class="form-group col-md-8">
                            <label></label>
                            <select name="criteria_value[]" id="criteria_value1" class="form-select" multiple>
                            <option value="">Select</option>
                        </select>
                        </div>
                    @endif
                    </div>
                    <div class="col-sm-12 text-end">
                        <a href="javascript:void(0);" style="" class="add_more_button btn btn-sm btn-outline-success" title="Add field"><i style="font-size:15px;" class="bi bi-plus"></i>Add More</a>
                    </div>
                    <hr class="mt-2 mb-1">
                    <h5 class="mb-3">Messages</h5>
                   <div class="row msg_field_wrapper">

                    <?php 
                        $message_values = json_decode($workflowData->message_details); 
                        $mes = array();    
                    ?>
                    @if($message_values != "")
                    @foreach($message_values as $messages => $msg_vals)
                    <?php $mes[] = $msg_vals;
                    ?>
                    <div class="form-group col-md-4 mb-1 p1">
                        <label>When Lead age is (Days)<span style="color: red;">*</span></label>
                        <input type="number" name="lead_age[]" value="{{$messages}}" class="form-control lead_age" id='lead_age' required>
                    </div>
                    <div class="form-group col-md-8 mb-1">
                        <label>Send Message <span style="color: red;">*</span></label>
                        <select name="message_template[]" class="form-select message_template mb-1" id='message_template' required>
                            <option value="">Select Template</option>
                            @if($workflowData->communication_mode == "email")
                            @foreach(get_email_templates() as $tpl)
                                <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @elseif($workflowData->communication_mode == "whatsapp")
                            @foreach(get_whatsapp_templates() as $tpl)
                                <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @else
                            @foreach(get_sms_templates() as $tpl)
                                <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @endif
                        </select>
                        <a style="float: right;text-decoration: revert;" class="mb-2 template_href" target="_blank" href="#">Manage Templates</a>
                    </div> 
                    @endforeach
                    @else
                    <div class="form-group col-md-4 mb-1 p1">
                        <label>When Lead age is (Days)<span style="color: red;">*</span></label>
                        <input type="number" name="lead_age[]" class="form-control lead_age" id='lead_age' required>
                    </div>
                    <div class="form-group col-md-8 mb-1">
                        <label>Send Message <span style="color: red;">*</span></label>
                        <select name="message_template[]" class="form-select message_template mb-1" id='message_template' required>
                            <option value="">Select Template</option>
                            @if($workflowData->communication_mode == "email")
                            @foreach(get_email_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @elseif($workflowData->communication_mode == "whatsapp")
                            @foreach(get_whatsapp_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @else
                            @foreach(get_sms_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @endif
                        </select>
                        <a style="float: right;text-decoration: revert;" class="mb-2 template_href" target="_blank" href="#">Manage Templates</a>
                    </div>
                    @endif
                   </div>
                   <div class="col-sm-12 text-end">
                        <a href="javascript:void(0);" style="" class="add_more_msg_button btn btn-sm btn-outline-success" title="Add field"><i style="font-size:15px;" class="bi bi-plus"></i>Add More</a>
                    </div>

                    <hr class="mt-3 mb-3">
                    <div class="form-group" style="text-align: center">
                        {{ form_submit("Submit") }}
                    </div>
                </div>
@endif


{{-- //message sequence --}}
@if($workflowData->workflow_type == "message_sequence")
    <div id="message_sequence_blk">
                    <hr class="mt-0 mb-1">
                    <h5 class="mb-3">Target Audience</h5>
                    <div class="form-group mb-3">
                        <label>Target <span style="color: red;">*</span></label>
                        <select name="msg_target" class="form-select target" id='target' required>
                            <option value="">Select</option>
                            <option value="leads" {{($workflowData->target == "leads")? 'selected' : ''}}>Leads</option>
                            <option value="students" {{($workflowData->target == "students")? 'selected' : ''}}>Students</option>
                            <option value="leads_and_students" {{($workflowData->target == "leads_and_students")? 'selected' : ''}}>All Leads & Students</option>
                            <option value="staff" {{($workflowData->target == "staff")? 'selected' : ''}}>Staff</option>
                            <option value="agents" {{($workflowData->target == "agents")? 'selected' : ''}}>Agents(Partners)</option>
                        </select>
                    </div> 

                <div class="for_lead_blk" style="display: {{($workflowData->target == "leads" || $workflowData->target == "students")? 'block' : 'none'}};">
                        <div class="form-group mb-3 status_type_lead">
                            <?php 
                                $statsData = array();
                                if($workflowData->target == "leads"){
                                    $statsData = explode(',',$workflowData->lead_status);
                                }
                                if($workflowData->target == "students"){
                                    $statsData = explode(',',$workflowData->student_status);
                                }
                            ?>
                        <label>Lead Status <span style="color: red;">*</span></label>
                        <select name="lead_status[]" class="form-select select2stats" multiple {{($workflowData->target == "leads")? "required" : ""}}>
                            @foreach(lead_status_list() as $status_data)
                            <option value="{{$status_data->status}}" {{(in_array($status_data->status,$statsData))? 'selected' : ''}}>{{$status_data->status}}</option>
                            @endforeach
                        </select>
                        </div>
                        <div class="form-group mb-3 status_type_student" style="display: none;">
                            <label>Student Status <span style="color: red;">*</span></label>
                            <select name="student_status[]" class="form-select select2stats" multiple {{($workflowData->target == "students")? "required" : ""}}>
                                @foreach(get_overseas_status_list() as $stu_status_data)
                                <option value="{{$stu_status_data->status}}" {{(in_array($stu_status_data->status,$statsData))? 'selected' : ''}}>{{$stu_status_data->status}}</option>
                                @endforeach
                            </select>
                        </div> 
                        <div class="row msg_blk_field_wrapper">
                        <?php 
                            if($workflowData->target == "leads" && !empty($workflowData->lead_filters)){
                                $criteria_values = json_decode($workflowData->lead_filters); 
                            }
                            else if($workflowData->target == "students" && !empty($workflowData->student_filters)){
                                $criteria_values = json_decode($workflowData->student_filters);
                            }
                            else{
                                $criteria_values = "";
                            }   
                            $cri = array();    
                        ?>
                    @if($criteria_values != "")
                    @foreach($criteria_values as $criterias => $cri_vals)
                    <?php $cri[] = explode("|",$cri_vals);
                    ?>
                     @if($loop->index == 1)
                     <div class="row"><div class="col-md-12"><select style="width:20%;" name="criteria_condition" class="form-select msg_blk_criteria_condition"><option value="OR" {{($workflowData->filter_condition == 'or')? 'selected' : ''}}>OR</option><option value="and" {{($workflowData->filter_condition == 'and')? 'selected' : ''}}>AND</option></select></div></div>
                     @elseif($loop->index > 1)
                     <div class="row"><div class="col-md-12"><label class="msg_blk_criteria_cond_lbl p-1" style="text-transform: uppercase!important;">{{($workflowData->filter_condition)? $workflowData->filter_condition: 'OR'}}</label></div></div>
                     @endif
                     @if($loop->index == 0)
                        <div class="row"><div class="col-md-12"><label class="">{{'Other Criteria'}}</label></div></div>
                    @endif
                        <div class="form-group mb-1 col-md-4">
                            <select name="other_criteria[]" data-sub_id='{{ $loop->index }}' class="form-select msg_other_criteria">
                                <option value="">Select</option>
                                <option {{($criterias == "Country Interested") ? 'selected' : ''}} value="Country Interested">Country Interested to Study In</option>
                                <option {{($criterias == "Course Interested to Study") ? 'selected' : ''}} value="Course Interested to Study">Course Interested to Study</option>
                                <option {{($criterias == "Interested Study Level") ? 'selected' : ''}} value="Interested Study Level">Interested Study Level</option>
                                <option {{($criterias == "Intake") ? 'selected' : ''}} value="Intake">Intake</option>
                                <option {{($criterias == "Passout Year") ? 'selected' : ''}} value="Passout Year">Passout Year</option>
                                <option {{($criterias == "Country of Residence") ? 'selected' : ''}} value="Country of Residence">Country of Residence</option>
                                <option {{($criterias == "Qualification") ? 'selected' : ''}} value="Qualification">Qualification</option>
                                <option {{($criterias == "Lead Source") ? 'selected' : ''}} value="Lead Source">Lead Source</option>
                                <option {{($criterias == "Lead Campaign Name") ? 'selected' : ''}} value="Lead Campaign Name">Lead Campaign Name</option>
                                @if(env('ADDITIONAL_SERVICES_ENABLE'))
                                <option {{($criterias == "Other Services Interested") ? 'selected' : ''}} value="Other Services Interested">Other Services Interested</option>
                                @endif
                            </select>
                        </div>
                            <div class="form-group col-md-8">
                                {{-- @if($loop->index != 1)
                                <label></label>
                                @endif --}}
                                <select name="criteria_value[]" id="msg_criteria_value{{ $loop->index }}" class="form-select" multiple>
                                <option value="">Select</option>
                            </select>
                            </div>
                        @endforeach
                        @else
                        <div class="form-group mb-1 col-md-4">
                            <label>Other Criteria</label>
                            <select name="other_criteria[]" data-sub_id='1' class="form-select msg_other_criteria">
                                <option value="">Select</option>
                                <option value="Country Interested">Country Interested to Study In</option>
                                <option value="Course Interested to Study">Course Interested to Study</option>
                                <option value="Interested Study Level">Interested Study Level</option>
                                <option value="Intake">Intake</option>
                                <option value="Passout Year">Passout Year</option>
                                <option value="Country of Residence">Country of Residence</option>
                                <option value="Qualification">Qualification</option>
                                <option value="Lead Source">Lead Source</option>
                                <option value="Lead Campaign Name">Lead Campaign Name</option>
                                @if(env('ADDITIONAL_SERVICES_ENABLE'))
                                <option value="Other Services Interested">Other Services Interested</option>
                                @endif
                            </select>
                        </div>
                        <div class="form-group col-md-8">
                                <label></label>
                                <select name="criteria_value[]" id="msg_criteria_value1" class="form-select" multiple>
                                <option value="">Select</option>
                            </select>
                        </div>
                        @endif
                        </div>
                        <div class="col-sm-12 text-end">
                            <a href="javascript:void(0);" style="" class="msg_blk_add_more_button btn btn-sm btn-outline-success" title="Add field"><i style="font-size:15px;" class="bi bi-plus"></i>Add More</a>
                        </div>
                    </div>
                    <hr class="mt-4 mb-1">
                    <h5 class="mb-3">Messages</h5>
                    <div class="row">
                        <div class="form-group col-md-4 mb-1 p1">
                            <label>On(Date)<span style="color: red;">*</span></label>
                            <input type="text" placeholder="Select Date" name="msg_start_date" class="form-control work_datepicker start_date" autocomplete="off" id='start_date' value="{{ date('d-m-Y', strtotime($workflowData->start_date)) }}" required>
                        </div>
                        <?php 
                            $message_values = json_decode($workflowData->message_details); 
                            $mes = array();    
                        ?>
                        @if($message_values != "")
                        @foreach($message_values as $messages => $msg_vals)
                        <?php
                            if($messages == "00"){
                        ?>
                        <div class="form-group col-md-8 mb-1">
                            <label>Send Message <span style="color: red;">*</span></label>
                            <select name="msg_message_template[]" class="form-select msg_message_template"  required>
                                <option value="">Select Template</option>
                                @if($workflowData->communication_mode == "email")
                                @foreach(get_email_templates() as $tpl)
                                    <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                                @endforeach
                                @elseif($workflowData->communication_mode == "whatsapp")
                                @foreach(get_whatsapp_templates() as $tpl)
                                    <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                                @endforeach
                                @else
                                @foreach(get_sms_templates() as $tpl)
                                    <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                                @endforeach
                                @endif
                            </select>
                            <a style="float: right;text-decoration: revert;" class="mb-2 template_href" target="_blank" href="#">Manage Templates</a>
                        </div> 
                        <?php } ?>
                        @endforeach
                        @else
                        <div class="form-group col-md-8 mb-1">
                            <label>Send Message <span style="color: red;">*</span></label>
                            <select name="msg_message_template[]" class="form-select msg_message_template"  required>
                                <option value="">Select Template</option>
                                @if($workflowData->communication_mode == "email")
                                @foreach(get_email_templates() as $tpl)
                                    <option value="{{$tpl}}">{{$tpl}}</option>
                                @endforeach
                                @elseif($workflowData->communication_mode == "whatsapp")
                                @foreach(get_whatsapp_templates() as $tpl)
                                    <option value="{{$tpl}}">{{$tpl}}</option>
                                @endforeach
                                @else
                                @foreach(get_sms_templates() as $tpl)
                                    <option value="{{$tpl}}">{{$tpl}}</option>
                                @endforeach
                                @endif
                            </select>
                            <a style="float: right;text-decoration: revert;" class="mb-2 template_href" target="_blank" href="#">Manage Templates</a>
                        </div> 
                        @endif
                    </div>
                   <div class="row msg_seq_field_wrapper">
                    <?php 
                        $message_values = json_decode($workflowData->message_details); 
                        $mes = array();    
                    ?>
                    @if($message_values != "")
                    @foreach($message_values as $messages => $msg_vals)
                    <?php 
                        if($messages != "00"){
                        $mes[] = $msg_vals;
                    ?>
                    <div class="form-group col-md-4 mb-1 p1">
                        <label>After(Days)<span style="color: red;">*</span></label>
                        <input type="number" value="{{$messages}}" name="after_days[]" class="form-control" id='after_days'>
                    </div>
                    <div class="form-group col-md-8 mb-1">
                        <label>Send Message <span style="color: red;">*</span></label>
                        <select name="msg_message_template[]" class="form-select msg_message_template" >
                            <option value="">Select Template</option>
                            @if($workflowData->communication_mode == "email")
                            @foreach(get_email_templates() as $tpl)
                                <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @elseif($workflowData->communication_mode == "whatsapp")
                            @foreach(get_whatsapp_templates() as $tpl)
                                <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @else
                            @foreach(get_sms_templates() as $tpl)
                                <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @endif
                        </select>
                    </div> 
                    <?php } ?>
                    @endforeach
                    @else
                    <div class="form-group col-md-4 mb-1 p1">
                        <label>After(Days)<span style="color: red;">*</span></label>
                        <input type="number" name="after_days[]" class="form-control" id='after_days'>
                    </div>
                    <div class="form-group col-md-8 mb-1">
                        <label>Send Message <span style="color: red;">*</span></label>
                        <select name="msg_message_template[]" class="form-select msg_message_template" >
                            <option value="">Select Template</option>
                            @if($workflowData->communication_mode == "email")
                            @foreach(get_email_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @elseif($workflowData->communication_mode == "whatsapp")
                            @foreach(get_whatsapp_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @else
                            @foreach(get_sms_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @endif
                        </select>
                    </div> 
                    @endif
                   </div>
                   <div class="col-sm-12 text-end">
                        <a href="javascript:void(0);" style="" class="add_more_msg_seq_button btn btn-sm btn-outline-success" title="Add field"><i style="font-size:15px;" class="bi bi-plus"></i>Add More</a>
                    </div>

                    <hr class="mt-3 mb-3">
                    <div class="form-group" style="text-align: center">
                        {{ form_submit("Submit") }}
                    </div>
                </div>
@endif
{{-- //message sequence --}}         


{{-- //specific event --}}
@if($workflowData->workflow_type == "specific_event")
<div id="specific_event_blk">
    <hr class="mt-0 mb-1">
    <h5 class="mb-3">Target Audience</h5>
    <div class="form-group mb-3">
        <label>Target <span style="color: red;">*</span></label>
        <select name="specific_target" class="form-select specific_target" id='target' required>
            <option value="">Select</option>
            <option value="leads" {{($workflowData->target == "leads")? 'selected' : ''}}>Leads</option>
            <option value="students" {{($workflowData->target == "students")? 'selected' : ''}}>Students</option>
            <option value="leads_and_students" {{($workflowData->target == "leads_and_students")? 'selected' : ''}}>All Leads & Students</option>
            <option value="staff" {{($workflowData->target == "staff")? 'selected' : ''}}>Staff</option>
            <option value="agents" {{($workflowData->target == "agents")? 'selected' : ''}}>Agents(Partners)</option>
            <option value="all" {{($workflowData->target == "all")? 'selected' : ''}}>All</option>
        </select>
    </div> 

    <div class="for_specific_lead_blk" style="display: {{($workflowData->target == "leads" || $workflowData->target == "students")? 'block' : 'none'}};">
        <div class="form-group mb-3 specific_status_type_lead">
            <?php 
                $statsData =array();
                if($workflowData->target == "leads"){
                    $statsData = explode(',',$workflowData->lead_status);
                }
                if($workflowData->target == "students"){
                    $statsData = explode(',',$workflowData->student_status);
                } 
            ?>
            <label>Lead Status <span style="color: red;">*</span></label>
            <select name="lead_status[]" class="form-select select2stats" multiple {{($workflowData->target == "leads")? "required" : ""}}>
                @foreach(lead_status_list() as $status_data)
                <option value="{{$status_data->status}}" {{(in_array($status_data->status,$statsData))? 'selected' : ''}}>{{$status_data->status}}</option>
                @endforeach
            </select>
        </div>
        <div class="form-group mb-3 specific_status_type_student" style="display: none;">
            <label>Student Status <span style="color: red;">*</span></label>
            <select name="student_status[]" class="form-select select2stats" multiple {{($workflowData->target == "students")? "required" : ""}}>
                @foreach(get_overseas_status_list() as $stu_status_data)
                    <option value="{{$stu_status_data->status}}" {{(in_array($stu_status_data->status,$statsData))? 'selected' : ''}}>{{$stu_status_data->status}}</option>
                @endforeach
            </select>
        </div> 
        <div class="row specific_blk_field_wrapper">
            <?php 
                if($workflowData->target == "leads" && !empty($workflowData->lead_filters)){
                    $criteria_values = json_decode($workflowData->lead_filters); 
                }
                else if($workflowData->target == "students" && !empty($workflowData->student_filters)){
                    $criteria_values = json_decode($workflowData->student_filters);
                }
                else{
                    $criteria_values = "";
                }   
                $cri = array();    
            ?>
            @if($criteria_values != "")
            @foreach($criteria_values as $criterias => $cri_vals)
            <?php 
                $cri[] = explode("|",$cri_vals);
            ?>
        @if($loop->index == 1)
            <div class="row"><div class="col-md-12"><select style="width:20%;" name="criteria_condition" class="form-select specific_blk_criteria_condition"><option value="OR" {{($workflowData->filter_condition == 'or')? 'selected' : ''}}>OR</option><option value="and" {{($workflowData->filter_condition == 'and')? 'selected' : ''}}>AND</option></select></div></div>
        @elseif($loop->index > 1)
            <div class="row"><div class="col-md-12"><label class="specific_blk_criteria_cond_lbl p-1" style="text-transform: uppercase!important;">{{($workflowData->filter_condition)? $workflowData->filter_condition: 'OR'}}</label></div></div>
        @endif
        @if($loop->index == 0)
               <div class="row"><div class="col-md-12"><label class="">{{'Other Criteria'}}</label></div></div>
        @endif
        <div class="form-group mb-1 col-md-4">
            <select name="other_criteria[]" data-sub_id='{{ $loop->index }}' class="form-select specific_other_criteria">
                <option value="">Select</option>
                <option {{($criterias == "Country Interested") ? 'selected' : ''}} value="Country Interested">Country Interested to Study In</option>
                <option {{($criterias == "Course Interested to Study") ? 'selected' : ''}} value="Course Interested to Study">Course Interested to Study</option>
                <option {{($criterias == "Interested Study Level") ? 'selected' : ''}} value="Interested Study Level">Interested Study Level</option>
                <option {{($criterias == "Intake") ? 'selected' : ''}} value="Intake">Intake</option>
                <option {{($criterias == "Passout Year") ? 'selected' : ''}} value="Passout Year">Passout Year</option>
                <option {{($criterias == "Country of Residence") ? 'selected' : ''}} value="Country of Residence">Country of Residence</option>
                <option {{($criterias == "Qualification") ? 'selected' : ''}} value="Qualification">Qualification</option>
                <option {{($criterias == "Lead Source") ? 'selected' : ''}} value="Lead Source">Lead Source</option>
                <option {{($criterias == "Lead Campaign Name") ? 'selected' : ''}} value="Lead Campaign Name">Lead Campaign Name</option>
                @if(env('ADDITIONAL_SERVICES_ENABLE'))
                <option {{($criterias == "Other Services Interested") ? 'selected' : ''}} value="Other Services Interested">Other Services Interested</option>
                @endif
            </select>
        </div>
            <div class="form-group col-md-8">
                <select name="criteria_value[]" id="specific_criteria_value{{ $loop->index }}" class="form-select" multiple>
                <option value="">Select</option>
            </select>
            </div>
            @endforeach
            @else
            <div class="form-group mb-1 col-md-4">
                <label>Other Criteria</label>
                <select name="other_criteria[]" data-sub_id='1' class="form-select specific_other_criteria">
                    <option value="">Select</option>
                    <option value="Country Interested">Country Interested to Study In</option>
                    <option value="Course Interested to Study">Course Interested to Study</option>
                    <option value="Interested Study Level">Interested Study Level</option>
                    <option value="Intake">Intake</option>
                    <option value="Passout Year">Passout Year</option>
                    <option value="Country of Residence">Country of Residence</option>
                    <option value="Qualification">Qualification</option>
                    <option value="Lead Source">Lead Source</option>
                    <option value="Lead Campaign Name">Lead Campaign Name</option>
                    @if(env('ADDITIONAL_SERVICES_ENABLE'))
                    <option value="Other Services Interested">Other Services Interested</option>
                    @endif
                </select>
            </div>
                <div class="form-group col-md-8">
                    <label></label>
                    <select name="criteria_value[]" id="specific_criteria_value1" class="form-select" multiple>
                    <option value="">Select</option>
                </select>
                </div>
            @endif
        </div>
        <div class="col-sm-12 text-end">
            <a href="javascript:void(0);" style="" class="specific_blk_add_more_button btn btn-sm btn-outline-success" title="Add field"><i style="font-size:15px;" class="bi bi-plus"></i>Add More</a>
        </div>
    </div>
    <hr class="mt-4 mb-1">
    <h5 class="mb-3">Schedule and Messages</h5>
    <div class="row">
        <div class="form-group col-md-4 mb-1 p1">
            <label>On(Date)<span style="color: red;">*</span></label>
            <input type="text" placeholder="Select Date" name="specific_start_date" class="form-control work_datepicker specific_start_date" autocomplete="off" id='start_date' value="{{ date('d-m-Y', strtotime($workflowData->start_date)) }}" required>
        </div>
        <div class="form-group col-md-8 mb-1">
            <?php 
                $message_values = json_decode($workflowData->message_details); 
                $mes = array();    
            ?>
            @if($message_values != "")
            @foreach($message_values as $messages => $msg_vals)
            <?php
                if($messages == "00"){
            ?>
            <label>Send Message <span style="color: red;">*</span></label>
            <select name="specific_message_template[]" class="form-select msg_message_template"  required>
                <option value="">Select Template</option>
                        @if($workflowData->communication_mode == "email")
                            @foreach(get_email_templates() as $tpl)
                                <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                        @elseif($workflowData->communication_mode == "whatsapp")
                            @foreach(get_whatsapp_templates() as $tpl)
                                <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                        @else
                            @foreach(get_sms_templates() as $tpl)
                                <option {{($msg_vals == $tpl)?'selected' : ''}} value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                        @endif
                        </select>
                        <?php } ?>
                    
                 @endforeach
                </div> 
            @else
            <label>Send Message <span style="color: red;">*</span></label>
            <select name="specific_message_template[]" class="form-select msg_message_template"  required>
                <option value="">Select Template</option>
                        @if($workflowData->communication_mode == "email")
                            @foreach(get_email_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @elseif($workflowData->communication_mode == "whatsapp")
                            @foreach(get_whatsapp_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @else
                            @foreach(get_sms_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                        @endif
                        </select>
        <a style="float: right;text-decoration: revert;" class="mb-2 template_href" target="_blank" href="#">Manage Templates</a>
        @endif 
    </div>


   <div class="row ">
    <div class="form-group col-md-4 mb-1">
        <label>Repeats<span style="color: red;">*</span></label>
        <select name="repeats" class="form-select" >
            <option {{($workflowData->repeats == "no")?'selected':''}} value="no">No</option>
            <option {{($workflowData->repeats == "monthly")?'selected':''}} value="monthly">Monthly</option>
            <option {{($workflowData->repeats == "yearly")?'selected':''}} value="yearly">Yearly</option>
        </select>
    </div> 
   </div>
    <hr class="mt-3 mb-3">
    <div class="form-group" style="text-align: center">
        {{ form_submit("Submit") }}
    </div>
</div>
@endif

{{-- //specific event --}}          



                    {{ html()->form()->close() }}  
                </div>
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection
@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
<style>
.duplicate {
    border: 1px solid red;
    color: red;
}
.dupli {
    color: red;
}
.select2-container {
  width: 100%!important;
}
</style>
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
<script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
<script>
    $(document).ready(function () {
        $(".select2stats").select2({
            placeholder: "Select",
        });
        $('#criteria_value1').select2({
            placeholder: "Select",
            allowClear: true
        });
        $('#msg_criteria_value1').select2({
            placeholder: "Select",
            allowClear: true
        });
        
        $('#specific_criteria_value1').select2({
            placeholder: "Select",
            allowClear: true
        });
        $('.work_datepicker').datetimepicker({
                timepicker: false,
                format: 'd-m-Y',
                scrollInput : false,
                minDate: 0,
        });
        if($("#communication_mode").val()=='Email'){
                $('.template_href').attr('href',"{{route('admin.mailtemplates')}}");
            }
        if($("#communication_mode").val()=='Whatsapp'){
                $('.template_href').attr('href',"{{route('admin.whatsapptemplates')}}");
            }
        if($("#communication_mode").val()=='SMS'){
                $('.template_href').attr('href',"{{route('admin.smstemplates')}}");
        }

        $('#workflow_type').change(function() {
            if (this.value == 'lead_nurture_sequence') {
                $(".lead_age").attr('required',true);
                $(".target,.specific_target,.start_date,.specific_start_date,.msg_message_template,.specific_message_template").attr('required',false);
                $(".message_template").attr('required',true);
                $("#ln_lead_status").attr('required',true);
                $("#ms_lead_status,#se_lead_status,#ms_stu_status,#se_stu_status").attr('required',false);
                
                $('#message_sequence_blk,#specific_event_blk').hide();
                $('#lead_nurture_blk,#flow_desc').show();
                $("#flow_desc").html("This allows you to send a series of messages to leads based on Lead Age. You must define the messages as message templates before you can setup a workflow.");
            }
            else if (this.value == 'message_sequence') {
                $(".lead_age").attr('required',false);
                $(".message_template,.msg_message_template,.specific_message_template").attr('required',false);
                $('.target').attr('required',true);
                $('.specific_target').attr('required',false);
                // $("#ln_lead_status").attr('required',true);
                $("#se_lead_status,#se_stu_status,#ln_lead_status").attr('required',false);
                $('#lead_nurture_blk,#specific_event_blk').hide();
                $('#message_sequence_blk,#flow_desc').show();
                $("#flow_desc").html("This allows you to send a series of messages to leads, students, partners, staff at specified date intervals. You must define the messages as message templates before you can setup a workflow.");
            }
            else if (this.value == 'specific_event') {
                $(".lead_age").attr('required',false);
                $(".message_template,.msg_message_template").attr('required',false);

                $('.target').attr('required',false);
                $('.specific_target,.specific_start_date,.specific_message_template').attr('required',true);

                $("#ms_lead_status,#ms_stu_status,#ln_lead_status").attr('required',false);
                $('#lead_nurture_blk,#message_sequence_blk').hide();
                $('#specific_event_blk,#flow_desc').show();
                $("#flow_desc").html("This allows you to send a message to leads, students, partners, staff at specified date. You can also make it repeat monthly or yearly. You must define the message as message template before you can setup a workflow.");
            }
            else {
                $('#lead_nurture_blk,#message_sequence_blk,#specific_event_blk,#flow_desc').hide();
            }
        });

        $('.target').change(function() {
            $(".specific_target,.specific_start_date").attr('required',false);
            $(".target,.start_date").attr('required',true);
            if (this.value == 'leads' || this.value == 'students') {
                $('.for_lead_blk').show();
                if(this.value == 'leads'){
                    $(".status_type_student").hide();
                    $(".status_type_lead").show();
                    $("#ms_lead_status").attr('required',true);
                    $("#se_lead_status,#ms_stu_status,#se_stu_status,#ln_lead_status").attr('required',false);
                }
                if(this.value == 'students'){
                    $(".status_type_student").show();
                    $(".status_type_lead").hide();
                    $("#ms_stu_status").attr('required',true);
                    $("#ms_lead_status,#se_lead_status,#se_stu_status,#ln_lead_status").attr('required',false);
                }
            }
            else {
                $('.for_lead_blk').hide();
            }
        });
        $('.specific_target').change(function() {
            $(".target,.start_date").attr('required',false);
            $(".specific_target,.specific_start_date").attr('required',true);
            if (this.value == 'leads' || this.value == 'students') {
                $('.for_specific_lead_blk').show();
                if(this.value == 'leads'){
                    $(".specific_status_type_student").hide();
                    $(".specific_status_type_lead").show();
                    $("#se_lead_status").attr('required',true);
                    $("#ms_stu_status,#se_stu_status,#ln_lead_status").attr('required',false);
                }
                if(this.value == 'students'){
                    $(".specific_status_type_student").show();
                    $(".specific_status_type_lead").hide();
                    $("#se_stu_status").attr('required',true);
                    $("#ms_lead_status,#se_lead_status,#ln_lead_status").attr('required',false);
                }
            }
            else {
                $("#ms_stu_status,#se_stu_status,#ln_lead_status,#ms_lead_status,#se_lead_status,#ln_lead_status,[name^='lead_status']").attr('required',false);
                $('.for_specific_lead_blk').hide();
            }
        });


        //Add more field
        var wrapper = $('.field_wrapper'); //Input field wrapper
        var issetcriarray = JSON.parse('<?php echo json_encode($cri); ?>');
        if(issetcriarray.length > 1){
            var fldCount = issetcriarray.length;   
        }else{
            var fldCount = 1;
        }
        $(document).on('click', '.add_more_button', function(){
        fldCount++;
        var html = '';
        html += '<div class="row dynaDiv"><div class="col-md-12">';
           
            // console.log(fldCount+"---"+issetcriarray);
            // console.log("Fld: "+fldCount);
            if(fldCount == 2 && issetcriarray == ""){
                html += '<select style="width:20%;" name="criteria_condition" class="form-select criteria_condition"><option value="OR">OR</option><option value="and">AND</option></select>';
            }
            else if(fldCount == 2 && issetcriarray.length == 1){
                html += '<select style="width:20%;" name="criteria_condition" class="form-select criteria_condition"><option value="OR">OR</option><option value="and">AND</option></select>';
            }
            else{
                html += '<label class="criteria_cond_lbl p-1" style="text-transform: uppercase!important;"></label>';
            }
        html += '</div>';
        html += '<div class="row dynaDiv"><div class="form-group mb-1 col-md-4"><select name="other_criteria[]" data-sub_id="'+fldCount+'" class="form-select other_criteria mb-1" required><option value="">Select</option><option value="Country Interested">Country Interested to Study In</option><option value="Course Interested to Study">Course Interested to Study</option><option value="Interested Study Level">Interested Study Level</option><option value="Intake">Intake</option><option value="Passout Year">Passout Year</option><option value="Country of Residence">Country of Residence</option><option value="Qualification">Qualification</option><option value="Lead Source">Lead Source</option><option value="Lead Campaign Name">Lead Campaign Name</option><option value="Other Services Interested">Other Services Interested</option></select><span class="dupli_err dupli"></span></div>';
        html += '<div class="form-group col-md-7"><select name="criteria_value[]" id="criteria_value'+fldCount+'" class="form-select" multiple></select></div>';
        html += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(wrapper).append(html);
        var old_cond_val = $('.criteria_condition').children("option:selected").val();
        $(".criteria_cond_lbl").html(old_cond_val);
        $('#criteria_value'+fldCount).select2({
                placeholder: "Select",
                allowClear: true
            });
        });
        $(document).on('click', '.remove_button', function(){
            fldCount--;
            $(this).parents('.dynaDiv').remove();
        });
        //Add more field


//Add more msg field
        var msg_wrapper = $('.msg_field_wrapper'); //Input field wrapper
        var msgfldCount = 1;
        $(document).on('click', '.add_more_msg_button', function(){
        msgfldCount++;
        var comm_mode = $("#communication_mode").val();
        $.ajax({
          url: "{{route('admin.automation.fetchTemplates')}}",
          method:"POST",
          data: {
                comm_mode: comm_mode,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('.temp_'+msgfldCount).html('<option value="">Select Template</option>');
                    $.each(result, function (key, value) {
                        $('.temp_'+msgfldCount).append('<option value="' +value+ '">' +value+ '</option>');
                    });
          }
        })
            // get the current last input, save its value.
            //  This will be used as the min value for the new el
        var newMin = Number($("input[name^=lead_age]").last().val()) + Number(1) || 1;
        var msghtml = '';
        msghtml += '<div class="row dynaMsgDiv"><div class="form-group col-md-4 mb-1 p1"><label>When Lead age is <span style="color: red;">*</span></label><input type="number" name="lead_age[]" min="'+newMin+'" class="form-control" id=""></div>';
        msghtml += '<div class="form-group col-md-7 mb-1"><label>Send Message <span style="color: red;">*</span></label><select name="message_template[]" class="form-select message_template temp_'+msgfldCount+'" id="message_template"></select></div> ';
        msghtml += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="msg_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(msg_wrapper).append(msghtml);
        });

        $(document).on('click', '.msg_remove_button', function(){
            $(this).parents('.dynaMsgDiv').remove();
        });
        //Add more msg field




//For message sequence
        //Add more msg field
        var msg_seq_wrapper = $('.msg_seq_field_wrapper'); //Input field wrapper
        var msgSeqFldCount = 1;
        $(document).on('click', '.add_more_msg_seq_button', function(){
        msgSeqFldCount++;
        var comm_mode = $("#communication_mode").val();
        $.ajax({
          url: "{{route('admin.automation.fetchTemplates')}}",
          method:"POST",
          data: {
                comm_mode: comm_mode,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('.temp_'+msgSeqFldCount).html('<option value="">Select Template</option>');
                    $.each(result, function (key, value) {
                        $('.temp_'+msgSeqFldCount).append('<option value="' +value+ '">' +value+ '</option>');
                    });
          }
        })
        var newSeqMin = Number($("input[name^=after_days]").last().val()) + Number(1) || 1;
        var msgseqhtml = '';
        msgseqhtml += '<div class="row dynaMsgDiv"><div class="form-group col-md-4 mb-1 p1"><label>After(Days)</label><input type="number" name="after_days[]" min="'+newSeqMin+'" class="form-control" id=""></div>';
        msgseqhtml += '<div class="form-group col-md-7 mb-1"><label>Send Message</label><select name="msg_message_template[]" class="form-select msg_message_template temp_'+msgSeqFldCount+'" ></select></div> ';
        msgseqhtml += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="msg_seq_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(msg_seq_wrapper).append(msgseqhtml);
        });
        
        $(document).on('click', '.msg_seq_remove_button', function(){
            $(this).parents('.dynaMsgDiv').remove();
        });
        //Add more msg field


    });
//onload gather data
var jquerycriarray = JSON.parse('<?php echo json_encode($cri); ?>');

    $('.other_criteria').each(function(index) {
        var load_criteria_val = $(this).val();
        var sub_id = $(this).data('sub_id');
        $("#criteria_value"+sub_id).html('');
        
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: load_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#criteria_value'+sub_id).select2({
            placeholder: "Select",
            allowClear: true
            });
            $('#criteria_value'+sub_id).html('<option value="">Select</option>');
            //console.log(index);
                    $.each(result, function (key, value) {
                        //console.log(jquerycriarray[index]);
                        
                        // if($.inArray(value.val,jquerycriarray)){
                        //     var selectedVal = "selected";
                        // }
                        // else{
                        //     var selectedVal = "";
                        // }
                        $("#criteria_value"+sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                        $('#criteria_value'+sub_id).val(jquerycriarray[index]).change();
                        $('#criteria_value'+sub_id).attr('name',load_criteria_val.replace(/[\s;]+/g, "_")+"[]");
                    });
          }
        });
    });

//msg block
var msgcriarray = JSON.parse('<?php echo json_encode($cri); ?>');

    $('.msg_other_criteria').each(function(index) {
        var load_criteria_val = $(this).val();
        $("#msg_criteria_value"+sub_id).html('');
        var sub_id = $(this).data('sub_id');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: load_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#msg_criteria_value'+sub_id).select2({
            placeholder: "Select",
            allowClear: true
            });
            $('#msg_criteria_value'+sub_id).html('<option value="">Select</option>');
            console.log(index);
                    $.each(result, function (key, value) {
                        // if(value.val == msgcriarray[index]){
                        //     var selectedVal = "selected=\"'selected'\"";
                        // }
                        // else{
                        //     var selectedVal = "";
                        // }
                        // $("#msg_criteria_value"+sub_id).append('<option '+selectedVal+' value="' + value
                        //     .val + '">' + value.title + '</option>');
                        $("#msg_criteria_value"+sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                        $('#msg_criteria_value'+sub_id).val(msgcriarray[index]).change();
                        $('#msg_criteria_value'+sub_id).attr('name',load_criteria_val.replace(/[\s;]+/g, "_")+"[]");
                    });
          }
        });
    });


var speccriarray = JSON.parse('<?php echo json_encode($cri); ?>');

    $('.specific_other_criteria').each(function(index) {
        var load_criteria_val = $(this).val();
        $("#specific_criteria_value"+sub_id).html('');
        var sub_id = $(this).data('sub_id');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: load_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#specific_criteria_value'+sub_id).select2({
            placeholder: "Select",
            allowClear: true
            });
            $('#specific_criteria_value'+sub_id).html('<option value="">Select</option>');
            console.log(index);
                    $.each(result, function (key, value) {
                       
                        $("#specific_criteria_value"+sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                        $('#specific_criteria_value'+sub_id).val(speccriarray[index]).change();
                        $('#specific_criteria_value'+sub_id).attr('name',load_criteria_val.replace(/[\s;]+/g, "_")+"[]");
                    });
          }
        });
    });

@if($workflowData->workflow_type=="message_sequence")
        $(".specific_target,.specific_start_date").attr('required',false);
        $(".target,.start_date").attr('required',true);
    var tar_val = $('.target').val();
            if (tar_val == 'leads' || tar_val == 'students') {
                $('.for_lead_blk').show();
                if(tar_val == 'leads'){
                    $(".status_type_student").hide();
                    $(".status_type_lead").show();
                }
                if(tar_val == 'students'){
                    $(".status_type_student").show();
                    $(".status_type_lead").hide();
                }
            }
            else {
                $('.for_lead_blk').hide();
            }
    
@endif
@if($workflowData->workflow_type=="specific_event")
        $(".target,.start_date").attr('required',false);
        $(".specific_target,.specific_start_date").attr('required',true);
    var spec_tar_val = $('.specific_target').val();

            if (spec_tar_val == 'leads' || spec_tar_val == 'students') {
                $('.for_specific_lead_blk').show();
                if(spec_tar_val == 'leads'){
                    $(".specific_status_type_student").hide();
                    $(".specific_status_type_lead").show();
                }
                if(spec_tar_val == 'students'){
                    $(".specific_status_type_student").show();
                    $(".specific_status_type_lead").hide();
                }
            }
            else {
                $('.for_specific_lead_blk').hide();
            }
    
@endif
    // var comm_mode = $('#communication_mode').val();
    //     $.ajax({
    //       url: "{{route('admin.automation.fetchTemplates')}}",
    //       method:"POST",
    //       data: {
    //             comm_mode: comm_mode,
    //             _token: '{{csrf_token()}}'
    //             },
    //       success:function(result)
    //       {
    //         $('.message_template,.msg_message_template').html('<option value="">Select Template</option>');
    //                 $.each(result, function (key, value) {
    //                     $('.message_template,.msg_message_template').append('<option value="' +value+ '">' +value+ '</option>');
    //                 });
    //         if(comm_mode=='Email'){
    //             $('.template_href').attr('href',"{{route('admin.mailtemplates')}}");
    //         }
    //         if(comm_mode=='Whatsapp'){
    //             $('.template_href').attr('href',"{{route('admin.whatsapptemplates')}}");
    //         }
    //         if(comm_mode=='SMS'){
    //             $('.template_href').attr('href',"{{route('admin.smstemplates')}}");
    //         }
    //       }
    //   });
//onload gather data


    $(document).on('change', '.other_criteria', function(){
        var other_criteria_val = $(this).val();
        var sub_id = $(this).data('sub_id');
        $("#criteria_value"+sub_id).html('');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: other_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#criteria_value'+sub_id).html('<option value="">Select</option>');
            $('#criteria_value'+sub_id).attr('name',other_criteria_val.replace(/[\s;]+/g, "_")+"[]");
                    $.each(result, function (key, value) {
                        $("#criteria_value"+sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                    });
          }
        })
      });


//message blk
        //Add more field
        var msg_blk_field_wrapper = $('.msg_blk_field_wrapper'); //Input field wrapper
        //var msg_fldCount = 1;
        var issetmsgcriarray = JSON.parse('<?php echo json_encode($cri); ?>');
        if(issetmsgcriarray.length > 1){
            var msg_fldCount = issetmsgcriarray.length;   
        }else{
            var msg_fldCount = 1;
        }
        $(document).on('click', '.msg_blk_add_more_button', function(){
        msg_fldCount++;
        var html = '';
        html += '<div class="row dynaDiv"><div class="col-md-12">';
            // var issetmsgcriarray = JSON.parse('<?php echo json_encode($cri); ?>');
            if(msg_fldCount == 2 && issetmsgcriarray == ""){
                html += '<select style="width:20%;" name="criteria_condition" class="form-select msg_blk_criteria_condition"><option value="OR">OR</option><option value="and">AND</option></select>';
            }
            else if(msg_fldCount == 2 && issetmsgcriarray.length == 1){
                html += '<select style="width:20%;" name="criteria_condition" class="form-select msg_blk_criteria_condition"><option value="OR">OR</option><option value="and">AND</option></select>';
            }
            else{
                html += '<label class="msg_blk_criteria_cond_lbl p-1" style="text-transform: uppercase!important;"></label>';
            }

        html += '</div>';
        html += '<div class="row dynaDiv"><div class="form-group mb-1 col-md-4"><select name="other_criteria[]" data-sub_id="'+msg_fldCount+'" class="form-select msg_other_criteria mb-1" required><option value="">Select</option><option value="Country Interested">Country Interested to Study In</option><option value="Course Interested to Study">Course Interested to Study</option><option value="Interested Study Level">Interested Study Level</option><option value="Intake">Intake</option><option value="Passout Year">Passout Year</option><option value="Country of Residence">Country of Residence</option><option value="Qualification">Qualification</option><option value="Lead Source">Lead Source</option><option value="Lead Campaign Name">Lead Campaign Name</option><option value="Other Services Interested">Other Services Interested</option></select><span class="msg_dupli_err dupli"></span></div>';
        html += '<div class="form-group col-md-7"><select name="criteria_value[]" id="msg_criteria_value'+msg_fldCount+'" class="form-select" multiple></select></div>';
        html += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="msg_blk_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(msg_blk_field_wrapper).append(html);
        var msg_blk_old_cond_val = $('.msg_blk_criteria_condition').children("option:selected").val();
        $(".msg_blk_criteria_cond_lbl").html(msg_blk_old_cond_val);
        $('#msg_criteria_value'+msg_fldCount).select2({
                placeholder: "Select",
                allowClear: true
            });
        });
        $(document).on('click', '.msg_blk_remove_button', function(){
            msg_fldCount--;
            $(this).parents('.dynaDiv').remove();
        });
        //Add more field
    $(document).on('change', '.msg_other_criteria', function(){
        var msg_other_criteria_val = $(this).val();
        var msg_sub_id = $(this).data('sub_id');
        $("#msg_criteria_value"+msg_sub_id).html('');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: msg_other_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#msg_criteria_value'+msg_sub_id).html('<option value="">Select</option>');
            $('#msg_criteria_value'+msg_sub_id).attr('name',msg_other_criteria_val.replace(/[\s;]+/g, "_")+"[]");
                    $.each(result, function (key, value) {
                        $("#msg_criteria_value"+msg_sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                    });
          }
        })
      });


//Specific event blk
        //Add more field
        var wrapper = $('.specific_blk_field_wrapper'); //Input field wrapper
        // var specific_fldCount = 1;
        var issetspeccriarray = JSON.parse('<?php echo json_encode($cri); ?>');
        if(issetspeccriarray.length > 1){
            var specific_fldCount = issetspeccriarray.length;   
        }else{
            var specific_fldCount = 1;
        }
        $(document).on('click', '.specific_blk_add_more_button', function(){
        specific_fldCount++;
        var html = '';
        html += '<div class="row dynaDiv"><div class="col-md-12">';
            if(specific_fldCount == 2 && issetspeccriarray == ""){
                html += '<select style="width:20%;" name="criteria_condition" class="form-select specific_blk_criteria_condition"><option value="OR">OR</option><option value="and">AND</option></select>';
            }
            else if(specific_fldCount == 2 && issetspeccriarray.length == 1){
                html += '<select style="width:20%;" name="criteria_condition" class="form-select specific_blk_criteria_condition"><option value="OR">OR</option><option value="and">AND</option></select>';
            }
            else{
                html += '<label class="specific_blk_criteria_cond_lbl p-1" style="text-transform: uppercase!important;"></label>';
            }


        html += '</div>';
        html += '<div class="row dynaDiv"><div class="form-group mb-1 col-md-4"><select name="other_criteria[]" data-sub_id="'+specific_fldCount+'" class="form-select specific_other_criteria mb-1" required><option value="">Select</option><option value="Country Interested">Country Interested to Study In</option><option value="Course Interested to Study">Course Interested to Study</option><option value="Interested Study Level">Interested Study Level</option><option value="Intake">Intake</option><option value="Passout Year">Passout Year</option><option value="Country of Residence">Country of Residence</option><option value="Qualification">Qualification</option><option value="Lead Source">Lead Source</option><option value="Lead Campaign Name">Lead Campaign Name</option><option value="Other Services Interested">Other Services Interested</option></select><span class="specific_dupli_err dupli"></span></div>';
        html += '<div class="form-group col-md-7"><select name="criteria_value[]" id="specific_criteria_value'+specific_fldCount+'" class="form-select" multiple></select></div>';
        html += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="specific_blk_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(wrapper).append(html);
        var specific_blk_old_cond_val = $('.specific_blk_criteria_condition').children("option:selected").val();
        $(".specific_blk_criteria_cond_lbl").html(specific_blk_old_cond_val);
        $('#specific_criteria_value'+specific_fldCount).select2({
                placeholder: "Select",
                allowClear: true
            });
        });
        $(document).on('click', '.specific_blk_remove_button', function(){
            specific_fldCount--;
            $(this).parents('.dynaDiv').remove();
        });
        //Add more field
    $(document).on('change', '.specific_other_criteria', function(){
        var specific_other_criteria_val = $(this).val();
        var specific_sub_id = $(this).data('sub_id');
        $("#specific_criteria_value"+specific_sub_id).html('');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: specific_other_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#specific_criteria_value'+specific_sub_id).html('<option value="">Select</option>');
            $('#specific_criteria_value'+specific_sub_id).attr('name',specific_other_criteria_val.replace(/[\s;]+/g, "_")+"[]");
                    $.each(result, function (key, value) {
                        $("#specific_criteria_value"+specific_sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                    });
          }
        })
      });




$('#createForm').on('submit', function(event) {
var arr = [];
if($('#workflow_type').val() == 'lead_nurture_sequence'){
    $('.other_criteria').each(function() {
        var lead_value = $(this).val();
        if (arr.indexOf(lead_value) == -1){
            arr.push(lead_value);
        }
        else{
            event.preventDefault();
            $(this).siblings('.dupli_err').html('Duplicate Value');
            $(this).addClass("duplicate");
        }
    });
}
if($('#workflow_type').val() == 'message_sequence'){
    $('.msg_other_criteria').each(function() {
        var msg_value = $(this).val();
        if (arr.indexOf(msg_value) == -1){
            arr.push(msg_value);
        }
        else{
            event.preventDefault();
            $(this).siblings('.msg_dupli_err').html('Duplicate Value');
            $(this).addClass("duplicate");
        }
    });
}
if($('#workflow_type').val() == 'specific_event'){
    $('.specific_other_criteria').each(function() {
        var specific_value = $(this).val();
        if (arr.indexOf(specific_value) == -1){
            arr.push(specific_value);
        }
        else{
            event.preventDefault();
            $(this).siblings('.specific_dupli_err').html('Duplicate Value');
            $(this).addClass("duplicate");
        }
    });
}


});

$(document).on('change', '.criteria_condition', function(){
        var tab = $(this).children("option:selected").val();
        //console.log(tab);
        $(".criteria_cond_lbl").html(tab);
    });

    $(document).on('change', '.msg_blk_criteria_condition', function(){
        var tab = $(this).children("option:selected").val();
        //console.log(tab);
        $(".msg_blk_criteria_cond_lbl").html(tab);
    });

    $(document).on('change', '.specific_blk_criteria_condition', function(){
        var tab = $(this).children("option:selected").val();
        console.log(tab);
        $(".specific_blk_criteria_cond_lbl").html(tab);
    });
</script>
@endpush