@extends('backend.layouts.app')
@section('title', "Automation")

@section('content')

<div class="card">
    <div class="card-body pt-3">
        <div class="row">
            <div class="col" style="margin-bottom:10px;">
                <h4 style="">Workflows</h4>
            </div>
        </div>
        <ul class="nav nav-tabs">
            {!!get_automation_tabs('workflows')!!}
            <div class="col-sm-7 col-7 ms-auto ">
                <div class="btn-toolbar float-right mx-2" role="toolbar" aria-label="Add New Workflow"  style="margin-top: 0px;float: right;"> 
                    <a href="{{ route('admin.automation.create.workflow') }}" class="btn btn-primary btn-sm" style="margin-bottom: 0px!important;" data-toggle="tooltip" title="Add New Workflow"><i class="bi bi-plus-circle"></i> New Workflow</a>
                </div>
            </div>
        </ul>


        <div class="row mt-4">
            <div class="table-responsive">                
                <table class="table w-100" id="workflow_list" class="display">
                    <thead>
                        <tr>
                            <th style="">Title</th>
                            <th style="">Mode</th>
                            <th style="">Type</th>
                            <th style="">No. of Messages</th>
                            <th style="">Status</th>
                            <th>Actions</th> 
                            <th style="display: none;">Created At</th> 
                        </tr>
                    </thead>
                </table>
            </div>
        </div> 

    </div>
</div>
@endsection        
@push ('after-scripts')

<script type="text/javascript">
    loadData();
   
    // Ajax DataTable

    function loadData() {
        var table = $('#workflow_list').DataTable({
            processing: true,
            serverSide: true,
            language: {
                searchPlaceholder: ""
            },
            autoWidth: true,
            responsive: true,
            lengthMenu: [50, 100, 200],
            "ajax": {
                "url": "{{route('admin.ajaxworkflowslist')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
            },
            "drawCallback": function( settings ) {
                addDeleteForms();
            },
            'order': [
                [6, 'desc']
            ],
            columns: [
                {
                    data: 'title',
                },
                {
                    data: 'mode',
                },
                {
                    data: 'type',
                },
                {
                    data: 'messages',
                },
                {
                    data: 'status',
                },
                {
                    data: 'actions',
                    orderable: false,
                },
                {
                    data: 'created_at',
                    visible:false,
                },
                
            ],
        });
        


    }

    // function searchTable() {
    //     $("#course_list").dataTable().fnDestroy();
    //     loadData();
    // }

    // function clearTable() {
    //     $('#study_level').val('');
    //     $('#category').val('');
    //     $('#sub-cat').val('');
    //     $("#country").select2('destroy').val('').select2();
    //     $("#course_list").dataTable().fnDestroy();
    //     loadData();
    // }

</script>
@endpush

