@extends('backend.layouts.app')

@section('title', "Workflow Details")

@section('content')
<div class="card">
    <div class="card-body">
        <ul class="nav nav-tabs mt-3">
            {!!get_automation_tabs('workflows')!!}
            <div class="col-sm-7 col-7 ms-auto ">
                <div class="btn-toolbar float-right mx-2" role="toolbar" style="margin-top: 0px;float: right;"> 
                    <a href="{{ route('admin.automation') }}" style="margin-bottom: 0px!important;" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
                </div>
            </div>
        </ul>
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    {{$workflowData->title}}
                </h4>
            </div><!--col-->
        </div><!--row-->    

        <div class="row mt-2">
            <div class="col-md-7">
                <div style="margin-top:5px;">
                    <div class="form-group mb-3">
                        <label><b>Workflow Type: </b></label>
                            {{($workflowData->workflow_type == "lead_nurture_sequence") ? 'Lead Nurture Sequence' : ''}}
                            {{($workflowData->workflow_type == "message_sequence") ? 'Message Sequence' : ''}}
                            {{($workflowData->workflow_type == "specific_event") ? 'Specific Event' : ''}}
                        
                    </div> 
                    <div class="row">
                        <div class="form-group col-md-12 mb-3">
                            <label><b>Mode: </b></label>
                            {{ucfirst($workflowData->communication_mode)}}
                            &nbsp;&nbsp;<label><b>At: </b></label>
                            {{date('h:i', strtotime($workflowData->run_at))}} {{date('A', strtotime($workflowData->run_at))}}
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-12 mb-3">
                            <label><b>Created: </b></label>
                            {{ date('d M Y H:i', strtotime($workflowData->created_at)) }}
                        </div>
                    </div>

@if($workflowData->workflow_type == "lead_nurture_sequence")             
<div id="lead_nurture_blk">
                    <hr class="mt-0 mb-1">
                    <h5 class="mb-3">Target Audience <span style="float:right;font-size:20px!important;">Matched Users: <b style="font-size:22px!important;">{{$userDataCount}}</b></span></h5>
                   
                    <div class="form-group mb-3">
                    <label><b>Lead Status:</b></label>
                        {{str_replace(",",", ",$workflowData->lead_status)}}
                    </div> 
                     
                    <div class="row field_wrapper">
                    <?php 
                        if($workflowData->target == "leads" && !empty($workflowData->lead_filters)){
                            $criteria_values = json_decode($workflowData->lead_filters); 
                        }
                        else if($workflowData->target == "students" && !empty($workflowData->student_filters)){
                            $criteria_values = json_decode($workflowData->student_filters);
                        }
                        else{
                            $criteria_values = "";
                        }   
                        $cri = array();    
                    ?>
                    @if($criteria_values != "")
                    <?php
                        if($workflowData->filter_condition == "and"){
                           $fltr_cond = '<p class="mb-0">AND</p>';
                        }
                        else{
                            $fltr_cond = '<p class="mb-0">OR</p>';
                        }
                    ?> 
                    
                    <label><b><u>Other Criteria</u></b></label>
                    @foreach($criteria_values as $criterias => $cri_vals)
                    <div class="row">
                    <div class="form-group mb-1 col-md-12">
                        @if($criterias == "Other Services Interested")
                        <?php 
                        $osi = explode("|",$cri_vals);
                        ?>
                        <b>{{$criterias}} :</b> 
                        @foreach($osi as $si)
                            {{get_services($si)}}@if(!$loop->last),@endif 
                        @endforeach
                        @elseif($criterias == "Country of Residence")
                            <?php 
                            $cor = explode("|",$cri_vals);
                            ?>
                            <b>{{$criterias}} :</b> 
                            @foreach($cor as $cr)
                                {{get_country_name($cr)}}@if(!$loop->last),@endif 
                            @endforeach
                        @else
                        <b>{{$criterias}} :</b> {{str_replace("|",", ",$cri_vals)}}
                        @if($cri_vals != end($criteria_values))
                            {!!$fltr_cond!!}
                        @endif
                        @endif
                    </div>
                    </div>
                    @endforeach
                    @endif
                    </div>
                   
                    <hr class="mt-2 mb-1">
                    <h5 class="mb-3">Messages</h5>
                   <div class="row msg_field_wrapper">
                    <?php 
                        $message_values = json_decode($workflowData->message_details); 
                        $mes = array();    
                    ?>
                    @if($message_values != "")
                    @foreach($message_values as $messages => $msg_vals)
                    
                    <div class="form-group col-md-5 mb-1 p1">
                        <label><b>When Lead age is: </b></label>
                        {{$messages}} Day(s)
                    </div>
                    <div class="form-group col-md-7 mb-1">
                        <label><b>Send Message: </b></label>
                            {{$msg_vals}}
                    </div> 
                    @endforeach
                    @else
                    <div class="form-group col-md-5 mb-1 p1">
                        <label>When Lead age is (Days)<span style="color: red;">*</span></label>
                        <input type="number" name="lead_age[]" class="form-control lead_age" id='lead_age' required>
                    </div>
                    <div class="form-group col-md-7 mb-1">
                        <label>Send Message <span style="color: red;">*</span></label>
                        <select name="message_template[]" class="form-select message_template mb-1" id='message_template' required>
                            <option value="">Select Template</option>
                            @if($workflowData->communication_mode == "email")
                            @foreach(get_email_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @elseif($workflowData->communication_mode == "whatsapp")
                            @foreach(get_whatsapp_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @else
                            @foreach(get_sms_templates() as $tpl)
                                <option value="{{$tpl}}">{{$tpl}}</option>
                            @endforeach
                            @endif
                        </select>
                    </div>
                    @endif
                   </div>
                   <hr class="mt-3 mb-3">
                </div>
@endif


{{-- //message sequence --}}
@if($workflowData->workflow_type == "message_sequence")
    <div id="message_sequence_blk">
                    <hr class="mt-0 mb-1">
                    <h5 class="mb-3">Target Audience<span style="float:right;font-size:20px!important;">Matched Users: <b style="font-size:22px!important;">{{$userDataCount}}</b></span></h5>
                    <div class="form-group mb-3">
                        <label><b>Target: </b></label>
                        {{$workflowData->target}}
                    </div> 

                <div class="">
                        <div class="form-group mb-3 status_type_lead">
                            <label><b>Status:</b></label>
                                @if($workflowData->target == "leads")
                                    {{str_replace(",",", ",$workflowData->lead_status)}}
                                @endif
                                @if($workflowData->target == "students")
                                    {{str_replace(",",", ",$workflowData->student_status)}}
                                @endif
                        </div>
                        <div class="row field_wrapper">
                            <?php 
                                if($workflowData->target == "leads" && !empty($workflowData->lead_filters)){
                                    $criteria_values = json_decode($workflowData->lead_filters); 
                                }
                                else if($workflowData->target == "students" && !empty($workflowData->student_filters)){
                                    $criteria_values = json_decode($workflowData->student_filters);
                                }
                                else{
                                    $criteria_values = "";
                                }   
                                $cri = array();    
                            ?>
                            @if($criteria_values != "")
                            <?php
                                if($workflowData->filter_condition == "and"){
                                $fltr_cond = '<p class="mb-0">AND</p>';
                                }
                                else{
                                    $fltr_cond = '<p class="mb-0">OR</p>';
                                }
                            ?> 
                            <label><b><u>Other Criteria</u></b></label>
                            @foreach($criteria_values as $criterias => $cri_vals)
                            <div class="row">
                            <div class="form-group mb-1 col-md-4">
                                @if($criterias == "Other Services Interested")
                                <?php 
                                $osi = explode("|",$cri_vals);
                                ?>
                                <b>{{$criterias}} :</b> 
                                @foreach($osi as $si)
                                    {{get_services($si)}}@if(!$loop->last),@endif 
                                @endforeach
                                @elseif($criterias == "Country of Residence")
                                <?php 
                                $cor = explode("|",$cri_vals);
                                ?>
                                <b>{{$criterias}} :</b> 
                                @foreach($cor as $cr)
                                    {{get_country_name($cr)}}@if(!$loop->last),@endif 
                                @endforeach
                                @else
                                <b>{{$criterias}} :</b> {{str_replace("|",", ",$cri_vals)}}
                                @if($cri_vals != end($criteria_values))
                                    {!!$fltr_cond!!}
                                @endif
                                @endif
                            </div>
                            </div>
                            @endforeach
                            @endif
                        </div>
                    <hr class="mt-4 mb-1">
                    <h5 class="mb-3">Messages</h5>
                    <div class="row">
                        <div class="form-group col-md-3 mb-1 p1">
                            <label><b>On: </b></label>
                            {{ date('d-m-Y', strtotime($workflowData->start_date)) }}
                        </div>
                        <?php 
                            $message_values = json_decode($workflowData->message_details); 
                            $mes = array();    
                        ?>
                        @if($message_values != "")
                        @foreach($message_values as $messages => $msg_vals)
                        <?php
                            if($messages == "00"){
                        ?>
                        <div class="form-group col-md-8 mb-1">
                            <label><b>Send Message: </b></label>
                                    {{$msg_vals }}
                        <?php } ?>
                        @endforeach
                        
                        @endif
                    </div>
                   <div class="row msg_seq_field_wrapper">
                    <?php 
                        $message_values = json_decode($workflowData->message_details); 
                        $mes = array();    
                    ?>
                    @if($message_values != "")
                    @foreach($message_values as $messages => $msg_vals)
                    <?php 
                        if($messages != "00"){
                        $mes[] = $msg_vals;
                    ?>
                    <div class="form-group col-md-3 mb-1 p1">
                        <label><b>After</b></label>
                        {{$messages}}Day(s)
                    </div>
                    <div class="form-group col-md-8 mb-1">
                        <label><b>Send Message : </b></label>
                        {{$msg_vals}} 
                    </div> 
                    <?php } ?>
                    @endforeach
                    @endif
                   </div>
                    <hr class="mt-3 mb-3">
                </div>
@endif
{{-- //message sequence --}}         


{{-- //specific event --}}
@if($workflowData->workflow_type == "specific_event")
<div id="specific_event_blk">
    <hr class="mt-0 mb-1">
    <h5 class="mb-3">Target Audience<span style="float:right;font-size:20px!important;">Matched Users: <b style="font-size:22px!important;">{{$userDataCount}}</b></span></h5>
    <div class="form-group mb-3">
        <label><b>Target: </b></label>
        {{$workflowData->target}}
    </div> 

    <div class="">
        <div class="form-group mb-3 status_type_lead">
            <label><b>Status:</b></label>
                @if($workflowData->target == "leads")
                    {{str_replace(",",", ",$workflowData->lead_status)}}
                @endif
                @if($workflowData->target == "students")
                   {{str_replace(",",", ",$workflowData->student_status)}}
                @endif
        </div>
        
        <div class="row field_wrapper">
            <?php 
                if($workflowData->target == "leads" && !empty($workflowData->lead_filters)){
                    $criteria_values = json_decode($workflowData->lead_filters); 
                }
                else if($workflowData->target == "students" && !empty($workflowData->student_filters)){
                    $criteria_values = json_decode($workflowData->student_filters);
                }
                else{
                    $criteria_values = "";
                }   
                $cri = array();    
            ?>
            @if($criteria_values != "")
            <?php
                if($workflowData->filter_condition == "and"){
                $fltr_cond = '<p class="mb-0">AND</p>';
                }
                else{
                    $fltr_cond = '<p class="mb-0">OR</p>';
                }
            ?> 
            <label><b><u>Other Criteria</u></b></label>
            @foreach($criteria_values as $criterias => $cri_vals)
            <div class="row">
            <div class="form-group mb-1 col-md-4">
                @if($criterias == "Other Services Interested")
                <?php 
                   $osi = explode("|",$cri_vals);
                ?>
                <b>{{$criterias}} :</b> 
                @foreach($osi as $si)
                    {{get_services($si)}}@if(!$loop->last),@endif 
                @endforeach
                @elseif($criterias == "Country of Residence")
                    <?php 
                    $cor = explode("|",$cri_vals);
                    ?>
                    <b>{{$criterias}} :</b> 
                    @foreach($cor as $cr)
                        {{get_country_name($cr)}}@if(!$loop->last),@endif 
                    @endforeach
                @else
                <b>{{$criterias}} :</b> {{str_replace("|",", ",$cri_vals)}}
                @if($cri_vals != end($criteria_values))
                    {!!$fltr_cond!!}
                @endif
                @endif
            </div>
            </div>
            @endforeach
            @endif
        </div>
    </div>
    <hr class="mt-4 mb-1">
    <h5 class="mb-3">Schedule and Messages</h5>
    <div class="row">
        <div class="form-group col-md-3 mb-1 p1">
            <label><b>On: </b></label>
            {{ date('d-m-Y', strtotime($workflowData->start_date)) }}
        </div>
        <div class="form-group col-md-8 mb-1">
            <?php 
                $message_values = json_decode($workflowData->message_details);    
            ?>
            @if($message_values != "")
            @foreach($message_values as $messages => $msg_vals)
            <?php
                if($messages == "00"){
            ?>
            <label><b>Send Message: </b></label>
            {{$msg_vals}}
            <?php } ?>
            @endforeach
            </div> 
        @endif 
    </div>
   <div class="row ">
    <div class="form-group col-md-4 mb-1">
        <label><b>Repeats: </b></label>
        {{$workflowData->repeats }}
    </div> 
   </div>
    <hr class="mt-3 mb-3">
    
</div>
@endif

{{-- //specific event --}}
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row mt-3">
            <div class="col-sm-12">
                <h4 class="mb-4">Execution History <span style="float:right;font-size:20px!important;"><b style="font-size:22px!important;"><a href="{{route('admin.automation.workflow.message-history',$workflowData->id)}}" style="text-decoration: revert;">Message History</a></b></span></h4>
                @if(count($execution_history))
                    <div class="filterBox" style=" border-radius: 10px; border:1px solid rgb(164 176 247) !important;">
                    <div style="max-height: 500px; overflow-y: auto;">
                        <table class="table">
                            <thead>
                                <tr>
                                <td><b>Date</b></td>
                                <td><b>Sequence Index</b></td>
                                <td><b>Message Sent</b></td>
                                <td><b>Message</b></td>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($execution_history as $exe_history)
                                <tr>
                                    <div class="mt-3">
                                    <td>{{date('d M Y',strtotime($exe_history->created_at))}}</td>
                                    <td>{{$exe_history->sequence_index}}</td>
                                    <td>{{$exe_history->matched_count}}</td>
                                    <td>{{$exe_history->message_template}}</td>
                                    </div>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                @else 
                <div class="filterBox" style=" border-radius: 10px; border:1px solid rgb(164 176 247) !important;">
                    <div class="p-2" style="">
                    {{'No records found!'}}
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

</div>
@endsection
@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
<style>
.duplicate {
    border: 1px solid red;
    color: red;
}
.dupli {
    color: red;
}
</style>
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
<script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
<script>
    $(document).ready(function () {
        $(".select2stats").select2({
            placeholder: "Select",
        });
        if($("#communication_mode").val()=='Email'){
                $('.template_href').attr('href',"{{route('admin.mailtemplates')}}");
            }
        if($("#communication_mode").val()=='Whatsapp'){
                $('.template_href').attr('href',"{{route('admin.whatsapptemplates')}}");
            }
        if($("#communication_mode").val()=='SMS'){
                $('.template_href').attr('href',"{{route('admin.smstemplates')}}");
        }

        $('#workflow_type').change(function() {
            if (this.value == 'lead_nurture_sequence') {
                $(".lead_age").attr('required',true);
                $(".target,.specific_target,.start_date,.specific_start_date,.msg_message_template").attr('required',false);
                $(".message_template").attr('required',true);
                $('#message_sequence_blk,#specific_event_blk').hide();
                $('#lead_nurture_blk,#flow_desc').show();
                $("#flow_desc").html("Lead Nurture Desc");
            }
            else if (this.value == 'message_sequence') {
                $(".lead_age").attr('required',false);
                $(".message_template,.msg_message_template").attr('required',false);
                $('#lead_nurture_blk,#specific_event_blk').hide();
                $('#message_sequence_blk,#flow_desc').show();
                $("#flow_desc").html("Message Desc");
            }
            else if (this.value == 'specific_event') {
                $(".lead_age").attr('required',false);
                $(".message_template,.msg_message_template").attr('required',false);
                $('#lead_nurture_blk,#message_sequence_blk').hide();
                $('#specific_event_blk,#flow_desc').show();
                $("#flow_desc").html("Specific Event Desc");
            }
            else {
                $('#lead_nurture_blk,#message_sequence_blk,#specific_event_blk,#flow_desc').hide();
            }
        });

        $('.target').change(function() {
            $(".specific_target,.specific_start_date").attr('required',false);
            $(".target,.start_date").attr('required',true);
            if (this.value == 'leads' || this.value == 'students') {
                $('.for_lead_blk').show();
                if(this.value == 'leads'){
                    $(".status_type_student").hide();
                    $(".status_type_lead").show();
                }
                if(this.value == 'students'){
                    $(".status_type_student").show();
                    $(".status_type_lead").hide();
                }
            }
            else {
                $('.for_lead_blk').hide();
            }
        });
        $('.specific_target').change(function() {
            $(".target,.start_date").attr('required',false);
            $(".specific_target,.specific_start_date").attr('required',true);
            if (this.value == 'leads' || this.value == 'students') {
                $('.for_specific_lead_blk').show();
                if(this.value == 'leads'){
                    $(".specific_status_type_student").hide();
                    $(".specific_status_type_lead").show();
                }
                if(this.value == 'students'){
                    $(".specific_status_type_student").show();
                    $(".specific_status_type_lead").hide();
                }
            }
            else {
                $('.for_specific_lead_blk').hide();
            }
        });


        //Add more field
        var wrapper = $('.field_wrapper'); //Input field wrapper
        var fldCount = 1;
        $(document).on('click', '.add_more_button', function(){
        fldCount++;
        var html = '';
        html += '<div class="row dynaDiv"><div class="form-group mb-1 col-md-4"><label>And</label><select name="other_criteria[]" data-sub_id="'+fldCount+'" class="form-select other_criteria mb-1" required><option value="">Select</option><option value="Country Interested to Study In">Country Interested to Study In</option><option value="Course Interested to Study">Course Interested to Study</option><option value="Interested Study Level">Interested Study Level</option><option value="Intake">Intake</option><option value="Passout Year">Passout Year</option><option value="Country of Residence">Country of Residence</option><option value="Qualification">Qualification</option><option value="Lead Source">Lead Source</option><option value="Campaign ID">Lead Campaign ID</option><option value="Other Services Interested">Other Services Interested</option></select><span class="dupli_err dupli"></span></div>';
        html += '<div class="form-group col-md-7"><label></label><select name="criteria_value[]" id="criteria_value'+fldCount+'" class="form-select"><option value="">Select</option></select></div>';
        html += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(wrapper).append(html);
        });
        $(document).on('click', '.remove_button', function(){
            $(this).parents('.dynaDiv').remove();
        });
        //Add more field


        //Add more msg field
        var msg_wrapper = $('.msg_field_wrapper'); //Input field wrapper
        var msgfldCount = 1;
        $(document).on('click', '.add_more_msg_button', function(){
        msgfldCount++;
        var comm_mode = $("#communication_mode").val();
        $.ajax({
          url: "{{route('admin.automation.fetchTemplates')}}",
          method:"POST",
          data: {
                comm_mode: comm_mode,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('.temp_'+msgfldCount).html('<option value="">Select Template</option>');
                    $.each(result, function (key, value) {
                        $('.temp_'+msgfldCount).append('<option value="' +value+ '">' +value+ '</option>');
                    });
          }
        })
            // get the current last input, save its value.
            //  This will be used as the min value for the new el
        var newMin = Number($("input[name^=lead_age]").last().val()) + Number(1) || 1;
        var msghtml = '';
        msghtml += '<div class="row dynaMsgDiv"><div class="form-group col-md-4 mb-1 p1"><label>When Lead age is <span style="color: red;">*</span></label><input type="number" name="lead_age[]" min="'+newMin+'" class="form-control" id=""></div>';
        msghtml += '<div class="form-group col-md-7 mb-1"><label>Send Message <span style="color: red;">*</span></label><select name="message_template[]" class="form-select message_template temp_'+msgfldCount+'" id="message_template"></select></div> ';
        msghtml += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="msg_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(msg_wrapper).append(msghtml);
        });

        $(document).on('click', '.msg_remove_button', function(){
            $(this).parents('.dynaMsgDiv').remove();
        });
        //Add more msg field




//For message sequence
        //Add more msg field
        var msg_seq_wrapper = $('.msg_seq_field_wrapper'); //Input field wrapper
        var msgSeqFldCount = 1;
        $(document).on('click', '.add_more_msg_seq_button', function(){
        msgSeqFldCount++;
        var comm_mode = $("#communication_mode").val();
        $.ajax({
          url: "{{route('admin.automation.fetchTemplates')}}",
          method:"POST",
          data: {
                comm_mode: comm_mode,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('.temp_'+msgSeqFldCount).html('<option value="">Select Template</option>');
                    $.each(result, function (key, value) {
                        $('.temp_'+msgSeqFldCount).append('<option value="' +value+ '">' +value+ '</option>');
                    });
          }
        })
        var newSeqMin = Number($("input[name^=after_days]").last().val()) + Number(1) || 1;
        var msgseqhtml = '';
        msgseqhtml += '<div class="row dynaMsgDiv"><div class="form-group col-md-4 mb-1 p1"><label>After(Days)</label><input type="number" name="after_days[]" min="'+newSeqMin+'" class="form-control" id=""></div>';
        msgseqhtml += '<div class="form-group col-md-7 mb-1"><label>Send Message</label><select name="msg_message_template[]" class="form-select msg_message_template temp_'+msgSeqFldCount+'" ></select></div> ';
        msgseqhtml += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="msg_seq_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(msg_seq_wrapper).append(msgseqhtml);
        });
        
        $(document).on('click', '.msg_seq_remove_button', function(){
            $(this).parents('.dynaMsgDiv').remove();
        });
        //Add more msg field


    });
//onload gather data
var jquerycriarray = JSON.parse('<?php echo json_encode($cri); ?>');

    $('.other_criteria').each(function(index) {
        var load_criteria_val = $(this).val();
        $("#criteria_value"+sub_id).html('');
        var sub_id = $(this).data('sub_id');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: load_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#criteria_value'+sub_id).html('<option value="">Select</option>');
            console.log(index);
                    $.each(result, function (key, value) {
                        if(value.val == jquerycriarray[index]){
                            var selectedVal = "selected=\"'selected'\"";
                        }
                        else{
                            var selectedVal = "";
                        }
                        $("#criteria_value"+sub_id).append('<option '+selectedVal+' value="' + value
                            .val + '">' + value.title + '</option>');
                    });
          }
        });
    });

//msg block
var msgcriarray = JSON.parse('<?php echo json_encode($cri); ?>');

    $('.msg_other_criteria').each(function(index) {
        var load_criteria_val = $(this).val();
        $("#msg_criteria_value"+sub_id).html('');
        var sub_id = $(this).data('sub_id');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: load_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#msg_criteria_value'+sub_id).html('<option value="">Select</option>');
            console.log(index);
                    $.each(result, function (key, value) {
                        if(value.val == msgcriarray[index]){
                            var selectedVal = "selected=\"'selected'\"";
                        }
                        else{
                            var selectedVal = "";
                        }
                        $("#msg_criteria_value"+sub_id).append('<option '+selectedVal+' value="' + value
                            .val + '">' + value.title + '</option>');
                    });
          }
        });
    });

@if($workflowData->workflow_type=="message_sequence")
        $(".specific_target,.specific_start_date").attr('required',false);
        $(".target,.start_date").attr('required',true);
    var tar_val = $('.target').val();
            if (tar_val == 'leads' || tar_val == 'students') {
                $('.for_lead_blk').show();
                if(tar_val == 'leads'){
                    $(".status_type_student").hide();
                    $(".status_type_lead").show();
                }
                if(tar_val == 'students'){
                    $(".status_type_student").show();
                    $(".status_type_lead").hide();
                }
            }
            else {
                $('.for_lead_blk').hide();
            }
    
@endif
@if($workflowData->workflow_type=="specific_event")
        $(".target,.start_date").attr('required',false);
        $(".specific_target,.specific_start_date").attr('required',true);
    var spec_tar_val = $('.specific_target').val();

            if (spec_tar_val == 'leads' || spec_tar_val == 'students') {
                $('.for_specific_lead_blk').show();
                if(spec_tar_val == 'leads'){
                    $(".specific_status_type_student").hide();
                    $(".specific_status_type_lead").show();
                }
                if(spec_tar_val == 'students'){
                    $(".specific_status_type_student").show();
                    $(".specific_status_type_lead").hide();
                }
            }
            else {
                $('.for_specific_lead_blk').hide();
            }
    
@endif
    // var comm_mode = $('#communication_mode').val();
    //     $.ajax({
    //       url: "{{route('admin.automation.fetchTemplates')}}",
    //       method:"POST",
    //       data: {
    //             comm_mode: comm_mode,
    //             _token: '{{csrf_token()}}'
    //             },
    //       success:function(result)
    //       {
    //         $('.message_template,.msg_message_template').html('<option value="">Select Template</option>');
    //                 $.each(result, function (key, value) {
    //                     $('.message_template,.msg_message_template').append('<option value="' +value+ '">' +value+ '</option>');
    //                 });
    //         if(comm_mode=='Email'){
    //             $('.template_href').attr('href',"{{route('admin.mailtemplates')}}");
    //         }
    //         if(comm_mode=='Whatsapp'){
    //             $('.template_href').attr('href',"{{route('admin.whatsapptemplates')}}");
    //         }
    //         if(comm_mode=='SMS'){
    //             $('.template_href').attr('href',"{{route('admin.smstemplates')}}");
    //         }
    //       }
    //   });
//onload gather data


    $(document).on('change', '.other_criteria', function(){
        $("#criteria_value"+sub_id).html('');
        var other_criteria_val = $(this).val();
        var sub_id = $(this).data('sub_id');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: other_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#criteria_value'+sub_id).html('<option value="">Select</option>');
                    $.each(result, function (key, value) {
                        $("#criteria_value"+sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                    });
          }
        })
      });


//message blk
        //Add more field
        var msg_blk_field_wrapper = $('.msg_blk_field_wrapper'); //Input field wrapper
        var fldCount = 1;
        $(document).on('click', '.msg_blk_add_more_button', function(){
        fldCount++;
        var html = '';
        html += '<div class="row dynaDiv"><div class="form-group mb-1 col-md-4"><label>And</label><select name="other_criteria[]" data-sub_id="'+fldCount+'" class="form-select msg_other_criteria mb-1" required><option value="">Select</option><option value="Country Interested to Study In">Country Interested to Study In</option><option value="Course Interested to Study">Course Interested to Study</option><option value="Interested Study Level">Interested Study Level</option><option value="Intake">Intake</option><option value="Passout Year">Passout Year</option><option value="Country of Residence">Country of Residence</option><option value="Qualification">Qualification</option><option value="Lead Source">Lead Source</option><option value="Campaign ID">Lead Campaign ID</option><option value="Other Services Interested">Other Services Interested</option></select><span class="msg_dupli_err dupli"></span></div>';
        html += '<div class="form-group col-md-7"><label></label><select name="criteria_value[]" id="msg_criteria_value'+fldCount+'" class="form-select"><option value="">Select</option></select></div>';
        html += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="msg_blk_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(msg_blk_field_wrapper).append(html);
        });
        $(document).on('click', '.msg_blk_remove_button', function(){
            $(this).parents('.dynaDiv').remove();
        });
        //Add more field
    $(document).on('change', '.msg_other_criteria', function(){
        $("#msg_criteria_value"+msg_sub_id).html('');
        var msg_other_criteria_val = $(this).val();
        var msg_sub_id = $(this).data('sub_id');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: msg_other_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#msg_criteria_value'+msg_sub_id).html('<option value="">Select</option>');
                    $.each(result, function (key, value) {
                        $("#msg_criteria_value"+msg_sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                    });
          }
        })
      });


//Specific event blk
        //Add more field
        var wrapper = $('.specific_blk_field_wrapper'); //Input field wrapper
        var fldCount = 1;
        $(document).on('click', '.specific_blk_add_more_button', function(){
        fldCount++;
        var html = '';
        html += '<div class="row dynaDiv"><div class="form-group mb-1 col-md-4"><label>And</label><select name="other_criteria[]" data-sub_id="'+fldCount+'" class="form-select specific_other_criteria mb-1" required><option value="">Select</option><option value="Country Interested to Study In">Country Interested to Study In</option><option value="Course Interested to Study">Course Interested to Study</option><option value="Interested Study Level">Interested Study Level</option><option value="Intake">Intake</option><option value="Passout Year">Passout Year</option><option value="Country of Residence">Country of Residence</option><option value="Qualification">Qualification</option><option value="Lead Source">Lead Source</option><option value="Campaign ID">Lead Campaign ID</option><option value="Other Services Interested">Other Services Interested</option></select><span class="specific_dupli_err dupli"></span></div>';
        html += '<div class="form-group col-md-7"><label></label><select name="criteria_value[]" id="specific_criteria_value'+fldCount+'" class="form-select"><option value="">Select</option></select></div>';
        html += '<div class="form-group mb-0 col-md-1 d-flex align-items-center"><label></label><a style="" href="javascript:void(0);" class="specific_blk_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div></div>';
        $(wrapper).append(html);
        });
        $(document).on('click', '.specific_blk_remove_button', function(){
            $(this).parents('.dynaDiv').remove();
        });
        //Add more field
    $(document).on('change', '.specific_other_criteria', function(){
        $("#specific_criteria_value"+specific_sub_id).html('');
        var specific_other_criteria_val = $(this).val();
        var specific_sub_id = $(this).data('sub_id');
        $.ajax({
          url: "{{route('admin.automation.fetchCriteriaValues')}}",
          method:"POST",
          data: {
                criteria_type: specific_other_criteria_val,
                _token: '{{csrf_token()}}'
                },
          success:function(result)
          {
            $('#specific_criteria_value'+specific_sub_id).html('<option value="">Select</option>');
                    $.each(result, function (key, value) {
                        $("#specific_criteria_value"+specific_sub_id).append('<option value="' + value
                            .val + '">' + value.title + '</option>');
                    });
          }
        })
      });




$('#createForm').on('submit', function(event) {
var arr = [];
if($('#workflow_type').val() == 'lead_nurture_sequence'){
    $('.other_criteria').each(function() {
        var lead_value = $(this).val();
        if (arr.indexOf(lead_value) == -1){
            arr.push(lead_value);
        }
        else{
            event.preventDefault();
            $(this).siblings('.dupli_err').html('Duplicate Value');
            $(this).addClass("duplicate");
        }
    });
}
if($('#workflow_type').val() == 'message_sequence'){
    $('.msg_other_criteria').each(function() {
        var msg_value = $(this).val();
        if (arr.indexOf(msg_value) == -1){
            arr.push(msg_value);
        }
        else{
            event.preventDefault();
            $(this).siblings('.msg_dupli_err').html('Duplicate Value');
            $(this).addClass("duplicate");
        }
    });
}
if($('#workflow_type').val() == 'specific_event'){
    $('.specific_other_criteria').each(function() {
        var specific_value = $(this).val();
        if (arr.indexOf(specific_value) == -1){
            arr.push(specific_value);
        }
        else{
            event.preventDefault();
            $(this).siblings('.specific_dupli_err').html('Duplicate Value');
            $(this).addClass("duplicate");
        }
    });
}


});

//     $(document).on('keyup', 'input[name^=lead_age]', function(){
//         var cur_age_val = $(this).val();
//         var newMin = Number(cur_age_val) + Number(1);
//         console.log(newMin);
//         // $(this).parent().nextAll('div').html("aaaaaaaaaa");
//         $(this).parent().nextAll("input").attr('min', newMin);
//       });
// // function higherThanBefore(this_val) {
// //     var newMin = Number(this_val) + Number(1);
// //     console.log(newMin);
// //     $(this).attr('placeholder',"ok,,,");
// //     //$(this).closest('div').next().find("input[name^=lead_age]").attr('min', newMin);
// // }
</script>
@endpush