@extends('backend.layouts.app')
@section('title', "Backups")
@section('content')

<div class="container my-2">
    <h2>Backups</h2>
    <div class="card my-4">
        <div class="card-header bg-light">
            <h4>Generate & download database backup</h4>
        </div>
        <div class="card-body p-4">
            <button class="btn btn-primary" @if(env('DEMO_MODE')) disabled @endif onclick="window.location.href='{{ route('admin.backups.export') }}'">Download</button>
            @if(env('DEMO_MODE'))
            <small class="text-muted d-block mt-2">This feature is disabled in demo</small>
            @endif
        </div>
    </div>

    <div class="card my-4">
        <div class="card-header bg-light">
            <h4>Backup uploaded documents/files</h4>
        </div>
        <div class="card-body p-4">
            <h5 class="bold">If you have access to SSH/Terminal(Command line)</h5>

<p>Login to the server & go to your user home folder. For ex: <code>/home/root.</code> Run the command:</p>

<p>zip -r filesbackup.zip <code>/var/www/sitefoldername/storage/app/public</code></p>

<p>Here <code>/var/www/sitefoldername</code> must be correct path of your website</p>

<p>This will generate filesbackup.zip file in the current folder</p>

<h5 class="bold">If you don't have access to SSH/Terminal(Command line)</h5>

<p>Go to file manager and access the <code>storage/app/public</code> folder & zip it & move it to parent folder of web root folder.</p>


        </div>
    </div>

    <div class="card my-4">
        <div class="card-header bg-light">
            <h4>Regular automated backups</h4>
        </div>
        <div class="card-body p-4">
            <h5 class="bold">If you have access to SSH/Terminal (Command line)</h5>

            <div class="mt-3">
                <h6 class="bold">Database Backup</h6>
                <p>Create a folder "BACKUPS" in your user home directory. For example: <code>/home/root/BACKUPS</code>.</p>
                <p>Create a file <code>dbbackup.sh</code> in that folder </p>
                <p> add the following content:</p>

                <textarea readonly rows="10" style="max-height:200px; width:100%; border:1px solid #ccc; padding:10px; background-color:#f9f9f9;">
                    
#!/bin/bash

# DB Credentials
dbname="db1"
dbuser="user1"
dbpassword="somepassword"
dbhost="localhost"
dbport="3306"

# Backup path
backup_path="/home/root/BACKUPS"
date=$(date +"%d-%b-%Y")

# Set default file permissions
umask 177

# Dump database into SQL file
mysqldump --user=$dbuser --password=$dbpassword --host=$dbhost --port=$dbport --single-transaction --set-gtid-purged=OFF $dbname | gzip > $backup_path/$dbname-$date.sql.gz
echo -e "$(date +'%d-%b-%y  %r '):ALERT:Database $dbname Backup done" >> $backup_path/dbbackup.log
</textarea>

            <div class="mt-4">
                <p>Update db credentials and folder path to correct values. Save the file.</p>

<p>To setup the cron job to backup db daily midnight, add this line to the cron file. i.e run <code>crontab -e</code> & add this line:</p>

<p><code>0 0 * * * /home/root/BACKUPS/dbbackup.sh >> /dev/null 2>&1</code></p>

<h6 class="bold">Uploaded files/documents backup</h6>

<p>Create a file <code>filesbackup.sh</code> in BACKUPS folder</p>

<p>Add the following content in the file:</p>


<textarea readonly rows="10" style="max-height:200px; width:100%; border:1px solid #ccc; padding:10px; background-color:#f9f9f9;">
#!/bin/bash

site_name="yourwebsitename"
site_folder="yourwebsitefoldername"
backup_path="/home/root/BACKUPS"
date=$(date +"%d-%b-%Y")
                        
# Set default file permissions
umask 177
                        
zip -q -r $backup_path/$site_name-$date.zip /var/www/$site_folder/storage/app/public
echo -e "$(date +'%d-%b-%y  %r '):ALERT: $site_name Files Backup done" >> $backup_path/filesbackup.log
</textarea>
               <p>Update the variables with correct values. Save the file.</p> 

               <p>To setup the cron job to backup uploaded files every week(sunday midnight), add this line to the cron file. 
                i.e run <code>crontab -e</code> & add this line:</p> 
                
               <p><code>0 0 * * 1 /home/root/BACKUPS/filesbackup.sh >> /dev/null 2>&1</code></p> 
            </div>
        </div>
    </div>
</div>
@endsection
