@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('banners')!!}
                        </ul>
                    </div>

                    <div class="col-10">

                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general active show" id="banners">

                                <div class="row">
                                    <div class="col-sm-12 col-md-9">
                                        <h4>Add New Homepage Banner</h4>
                                        <form action="{{route('admin.banners.save')}}" method="post" enctype="multipart/form-data">
                                            @csrf
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group mb-3">
                                                        <label>Banner Text</label>
                                                        <input type="text" class="form-control" name="banner_text" maxlength="200" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-5">
                                                    <div class="form-group mb-3">
                                                        <label>Button Text</label>
                                                        <input type="text" class="form-control" name="button_text" maxlength="100" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group mb-3">
                                                        <label>Banner Hyperlink</label>
                                                        <input type="text" class="form-control" name="banner_link" maxlength="500" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group mb-3">
                                                        <label class="required-field">Banner Image</label>
                                                        <input class="form-control" type="file" name="banner_file" required>
                                                        <small>Preferred dimension 1400x930 px</small>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-5">
                                                    <div class="form-group mb-3">
                                                        <label class="required-field">Display Order</label>
                                                        <input type="number" class="form-control" name="display_order" value="1" required />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="text-center">
                                                <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                            </div>

                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-12">
                                        <hr>
                                        <h4>Uploaded Banners</h4>

                                        <div class="table-responsive">
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th>Banner</th>
                                                        <th>Details</th>
                                                        <th>Display Order</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($banners as $banner)
                                                    <tr>
                                                        <td><img src="{{asset('storage/'.$banner->banner_file)}}" style="width:300px;"></td>
                                                        <td>
                                                            <strong>Text:</strong><br />{{$banner->banner_text}}<br />
                                                            <strong>Button:</strong><br />{{$banner->button_text}}<br />
                                                            <strong>Link:</strong><br />{{$banner->banner_link}}
                                                        </td>
                                                        <td>{{ $banner->display_order }}</td>
                                                        <td>
                                                            <a href="{{ route('admin.banners.edit', $banner->id)}}"><i class='fas fa-edit text-primary' style='font-size:17px'></i></a>&nbsp;
                                                            <a href="{{ route('admin.banners.delete', $banner->id)}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure?"><i class='fas fa-trash-alt text-danger' style='font-size:17px'></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>
                                </div>

                            </div>

                        </div><!-- End Bordered Tabs -->

                    </div>
                </div>

            </div>
        </div>

    </div>
</div>
@endsection

@push('after-scripts')
<script>
    addDeleteForms();
</script>
@endpush