@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')
<div class="row">
    <div class="col" style="margin-bottom:10px;">
        <h4 style="">Settings</h4>
    </div>
</div>

<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('banners')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade general active show" id="banners">
                                <div class="row">
                                    <div class="col-sm-12 col-md-9">
                                        <h4>Edit Banner</h4>
                                        <form action="{{route('admin.banners.save')}}" method="post" enctype="multipart/form-data">
                                            @csrf
                                            <input type="hidden" name="id" value="{{$banner->id}}" />
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group mb-3">
                                                        <label>Banner Text</label>
                                                        <input type="text" class="form-control" name="banner_text" maxlength="200" value="{{$banner->banner_text}}" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-5">
                                                    <div class="form-group mb-3">
                                                        <label>Button Text</label>
                                                        <input type="text" class="form-control" name="button_text" maxlength="100" value="{{$banner->button_text}}" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group mb-3">
                                                        <label>Banner Hyperlink</label>
                                                        <input type="text" class="form-control" name="banner_link" maxlength="500" value="{{$banner->banner_link}}" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group mb-3">
                                                        <img src="{{asset('storage/'.$banner->banner_file)}}" style="height:100px;">
                                                        <br />
                                                        <label>New Banner Image</label>
                                                        <input class="form-control" type="file" name="banner_file">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-5">
                                                    <div class="form-group mb-3">
                                                        <label class="required-field">Display Order</label>
                                                        <input type="number" class="form-control" name="display_order" value="{{$banner->display_order}}" required />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="text-center">
                                                <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                                <button type="button" class="btn btn-secondary btn-sm" onclick="document.location='{{route('admin.banners')}}'">Cancel</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection