@extends('backend.layouts.app')
@section('title', 'Add Branch')
@section('content')
<div class="row">
    <div class="col-xl-12">
    <div class="card">
        <div class="card-body pt-3">
            <div class="row">
                <div class="col" style="margin-bottom:10px;">
                    <h4 style="">Settings</h4>
                </div>
            </div>
            <!-- Bordered Tabs -->
    
            <div class="row">
                <div class="col-2">
                    <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                        {!!get_settings_tabs('branch')!!}
                    </ul>
                </div>
    
        <div class="col-10">
            <div class="tab-content pt-4">
                <div class="tab-pane fade active show" id="">
                    <div class="row">
                        <div class="col-sm-10">
                            <h4>Create Branch</h4>
                        </div>
                <div class="col-sm-2 col-2" style="margin-top:0px;text-align: right;">
                    <button type="cancel" name="back" class="btn btn-sm btn-primary " value="Back" onclick="document.location ='{{ route('admin.settings.branch') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>

            </div>
            {{ html()->form('POST', route('admin.settings.branch.store'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
            <div class="form-group row">
                <div class="col-sm-6">
                    <label class="col-sm-3 col-form-label">Branch Name<span class="error">*</span></label>
                    <input type="text" name="branch_name" value="" class='form-control' placeholder="Enter Branch Name"
                        value="" autocomplete="off" required />
                </div>
            </div>
            <div class="form-group row">
                <div class="col-sm-6">
                    <label class="col-sm-3 col-form-label">Address</label>
                    <input type="text" name="branch_address" value="" class='form-control' placeholder="Enter Branch Address"
                        value="" autocomplete="off" />
                </div>
            </div>
            <div class="form-group row">
                <div class="col-sm-12 col-md-3">
                    <label class="col-form-label">City</label>
                    <input type="text" placeholder="City" value="{{ Request::old('city') }}" class="form-control" id="city" name="city">
                </div>
                <div class="col-sm-12 col-md-3">
                    <label class="col-form-label">Country</label>
                    <select class="form-select" id="country" name="country">
                        <option value="">Select</option>
                        @foreach ($country_list as $key => $value)
                        <option value="{{ $key }}" @if(old('country') == $key) selected @endif>{{ $value }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group row">
                <div class="col-sm-6">
                    <label class="col-sm-3 col-form-label">Contact Phone</label>
                    <input type="text"
                        {{-- minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" 
                        maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" 
                        onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"  --}}
                        name="phone" value="" class='form-control' placeholder="Enter Contact Phone"
                        value="" autocomplete="off" />
                </div>
            </div>
            <div class="form-group row">
                <div class="col-sm-6">
                    <label class="col-sm-3 col-form-label">Contact Email</label>
                    <input type="text" name="email" value="" class='form-control' placeholder="Enter Contact Email"
                        value="" autocomplete="off" />
                </div>
            </div>
            @unless(env('SAAS_MAIL_SERVER'))
            <div class="form-group row">
                <div class="col-md-12 pt-2 pb-2">
                    <label class="col-form-label"><input style="height: 15px;width:15px;" type="checkbox" name="use_custom_smtp" value="1" class=''> Use Custom Outgoing Email SMTP Server</label>
                </div>
            </div>
            @endunless
            <div id="smtp_blk" style="display: none;">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label required-field">Email/Username</label>
                    <div class="col-sm-4">
                        <input type="text" name="username" value="{{get_site_config('smtp_email')}}" class="form-control req_smtp" placeholder="SMTP Username">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label required-field">Password</label>
                    <div class="col-md-4">
                        <input type="text" name="password" value="{{get_site_config('smtp_password')}}" class="form-control req_smtp" placeholder="Password">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label required-field">Outgoing SMTP Hostname</label>
                    <div class="col-sm-4">
                        <input type="text" name="host" value="{{get_site_config('smtp_host')}}" class="form-control req_smtp" placeholder="SMTP Hostname">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label required-field">Port No.</label>
                    <div class="col-sm-4">
                        <input type="number" name="port" value="{{get_site_config('smtp_port')}}" class="form-control req_smtp" placeholder="Port No.">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label required-field">Connection Type</label>
                    <div class="col-sm-2">
                        <select class="form-select form-control req_smtp" name="connection_type">
                            <option value="">Select</option>
                            <option @if(get_site_config('smtp_connection') == "tls") selected @endif value="tls">TLS</option>
                            <option @if(get_site_config('smtp_connection') == "ssl") selected @endif value="ssl">SSL</option>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label required-field">Email From Name</label>
                    <div class="col-sm-4">
                        <input type="text" name="email_from_name" value="{{get_site_config('app_name')}}" class="form-control req_smtp" placeholder="Email from Name">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label required-field">Reply To Email</label>
                    <div class="col-sm-4">
                        <input type="text" name="reply_to_email" value="{{get_site_config('smtp_reply_to')}}" class="form-control req_smtp" placeholder="Reply to Email ID">
                    </div>
                </div>
            </div>
            <div class="row" style="margin-top: 30px;">
                <div class="col-md-6">
                    <div class="form-group mb-1 text-center">
                        {{ form_submit('Save') }}
                        <button type="button" class="btn btn-secondary btn-sm" style="margin-left:6px;" onclick="document.location='{{route('admin.settings.branch')}}'">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
        </form>
    </div>
    </div>
        </div>
    </div>
</div>
</div>
</div>
@endsection

@push('after-styles')
    {{-- <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css"> --}}
    {{-- <link rel="stylesheet" href="/resources/demos/style.css"> --}}
    {{-- <link href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.1/themes/base/jquery-ui.css" rel="stylesheet" />
    /> --}}
@endpush
@push('after-scripts')
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script>
    $(document).ready(function() {
    // hide show title on load
    if ($("input[name='use_custom_smtp']:checked").length) { 
      $("#smtp_blk").show();
      $('.req_smtp').attr('required','required');
    } else {
      $("#smtp_blk").hide();
      $('.req_smtp').attr('required',false);
    }
    $("input[name='use_custom_smtp']").on('change', function() { 
      if (this.checked) {
        $("#smtp_blk").show();
        $('.req_smtp').attr('required','required');  
      } else {
        $("#smtp_blk").hide();
        $('.req_smtp').attr('required',false);
      }
    })
});
    </script>
@endpush
