@extends('backend.layouts.app')
@section('title', "Edit Branch")
@section('content')
<div class="row">
    <div class="col-xl-12">
    <div class="card">
        <div class="card-body pt-3">
            <div class="row">
                <div class="col" style="margin-bottom:10px;">
                    <h4 style="">Settings</h4>
                </div>
            </div>
            <!-- Bordered Tabs -->
    
            <div class="row">
                <div class="col-2">
                    <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                        {!!get_settings_tabs('branch')!!}
                    </ul>
                </div>
    
        <div class="col-10">
            <div class="tab-content pt-4">
                <div class="tab-pane fade active show" id="">
                    <div class="row">
                        <div class="col-sm-10">
                            <h4>Edit Branch</h4>
                        </div>
            <div class="col-sm-2 col-2" style="margin-top:0px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-sm btn-primary " value="Back" onclick="document.location ='{{ route('admin.settings.branch') }}'" title="Back">  <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div><!--row-->    
        <div class="row mt-4">
            <div class="col-md-12">
                    {{ html()->form('POST', route('admin.settings.branch.update', $value->id))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                    @method('PATCH')
                        <div class="form-group row">
                            <div class="col-sm-6">
                                <label class="col-form-label required-field">Branch Name</label>
                                <input tyle="text" name="branch_name" class="form-control" maxlength="100" value="{{ $value->branch_name }}" placeholder="Enter Branch Name" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-6">
                                <label>Address</label>
                                <input tyle="text" name="branch_address" placeholder="Enter Branch Address" class="form-control" maxlength="200" value="{{ $value->branch_address }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-12 col-md-3">
                                <label class="col-form-label">City</label>
                                <input type="text" placeholder="City" value="{{ $value->city }}" placeholder="City" class="form-control" name="city">
                            </div>
                            <div class="col-sm-12 col-md-3">
                                <label class="col-form-label">Country</label>
                                <select class="form-select" id="country" name="country">
                                    <option value="">Select</option>
                                    @foreach ($country_list as $key => $convalue)
                                    <option value="{{ $key }}" @if($value->country == $key) selected @endif>{{ $convalue }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-6">
                                <label class="col-sm-3 col-form-label">Contact Phone</label>
                                <input type="text"
                                {{-- minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" 
                                maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}"  --}}
                                {{-- onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"  --}}
                                name="phone" value="{{ $value->phone }}" class='form-control' placeholder="Enter Contact Phone"
                                    value="" autocomplete="off" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-6">
                                <label class="col-sm-3 col-form-label">Contact Email</label>
                                <input type="text" name="email" value="{{ $value->email }}" class='form-control' placeholder="Enter Contact Email"
                                    value="" autocomplete="off" />
                            </div>
                        </div>
                        @unless(env('SAAS_MAIL_SERVER'))
                        <div class="form-group row">
                            <div class="col-md-12 pt-2 pb-2">
                                <label class="col-form-label"><input style="height: 15px;width:15px;" type="checkbox" name="use_custom_smtp" value="1" {{($value->custom_smtp)?'checked':''}}> Use Custom Outgoing Email SMTP Server</label>
                            </div>
                        </div>
                        @endunless
                        <div id="smtp_blk" style="display: none;">
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label required-field">Email/Username</label>
                                <div class="col-sm-4">
                                    <input type="text" name="username" value="{{ $value->smtp_email }}" class="form-control req_smtp" placeholder="SMTP Username">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label required-field">Password</label>
                                <div class="col-md-4">
                                    <input type="text" name="password" value="{{ $value->smtp_password }}" class="form-control req_smtp" placeholder="Password">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label required-field">Outgoing SMTP Hostname</label>
                                <div class="col-sm-4">
                                    <input type="text" name="host" value="{{ $value->smtp_host }}" class="form-control req_smtp" placeholder="SMTP Hostname">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label required-field">Port No.</label>
                                <div class="col-sm-4">
                                    <input type="text" name="port" value="{{ $value->smtp_port }}" class="form-control req_smtp" placeholder="Port No.">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label required-field">Connection Type</label>
                                <div class="col-sm-2">
                                    <select class="form-select form-control req_smtp" name="connection_type">
                                        <option value="">Select</option>
                                        <option {{($value->smtp_connection == 'tls')?'selected':''}} value="tls">TLS</option>
                                        <option {{($value->smtp_connection == 'ssl')?'selected':''}} value="ssl">SSL</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label required-field">Email From Name</label>
                                <div class="col-sm-4">
                                    <input type="text" value="{{ $value->smtp_from_name }}" name="email_from_name" class="form-control req_smtp" placeholder="e.g: {{app_name()}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label required-field">Reply To Email</label>
                                <div class="col-sm-4">
                                    <input type="email" value="{{ $value->smtp_reply_to }}" name="reply_to_email" class="form-control req_smtp" placeholder="Reply to Email ID">
                                </div>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 30px;">
                            <div class="col-md-6">
                                <div class="form-group mb-1 text-center">
                                    {{ form_submit('Save') }}
                                    <button type="button" class="btn btn-secondary btn-sm" style="margin-left:6px;" onclick="document.location='{{route('admin.settings.branch')}}'">Cancel</button>
                                </div>
                            </div>
                        </div>
                    
                        {{ html()->form()->close() }}  
                    </div>
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
</div>
</div>
</div>
</div>
</div>
@endsection     
@push('after-scripts')
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script>
    $(document).ready(function() {
    // hide show title on load
    if ($("input[name='use_custom_smtp']:checked").length) { 
      $("#smtp_blk").show();
      $('.req_smtp').attr('required','required');
    } else {
      $("#smtp_blk").hide();
      $('.req_smtp').attr('required',false);
    }
    $("input[name='use_custom_smtp']").on('change', function() { 
      if (this.checked) {
        $("#smtp_blk").show();
        $('.req_smtp').attr('required','required');  
      } else {
        $("#smtp_blk").hide();
        $('.req_smtp').attr('required',false);
      }
    })
});
    </script>
@endpush   