@extends('backend.layouts.app')
@section('title', 'Settings: Branch')
@section('content')

<div class="row">
<div class="col-xl-12">
<div class="card">
    <div class="card-body pt-3">
        <div class="row">
            <div class="col" style="margin-bottom:10px;">
                <h4 style="">Settings</h4>
            </div>
        </div>
        <!-- Bordered Tabs -->

        <div class="row">
            <div class="col-2">
                <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                    {!!get_settings_tabs('branch')!!}
                </ul>
            </div>

            <div class="col-10">
                <div class="tab-content pt-4">
                    <div class="tab-pane fade active show" id="">
                        <div class="row">
                            <div class="col-sm-9">
                                <h4>Branch Management</h4>
                            </div>
                            <div class="col-sm-3">
                                <div class="btn-toolbar float-right" role="toolbar" aria-label="New Business Config." style="float: right;">
                                    {{-- <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Application Stage"><i class="bi bi-plus-circle"></i> New</button> --}}
                                    <a href="{{ route('admin.settings.branch.create') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip"
                            title="Add New Page"><i class="bi bi-plus-circle"></i> Create</a>
                                </div>
                            </div>
                        </div>

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
                        <table class="table table-striped bg-none mb-0" id="batch_tbl">
                            <thead class="tableHeading">
                                <tr>
                                    <th><label>Branch Name</label></th>
                                    <th><label>Address</label></th>
                                    <!-- <th><label>Using Custom SMTP</label></th> -->
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($values as $value)
                                    <tr>
                                        <td>{{ $value->branch_name }}</td>
                                        <td>{{ $value->branch_address }}
                                            @if($value->city)<br>{{$value->city}}@endif
                                            @if($value->country)<br>{{get_country_name($value->country)}}@endif
                                            @if($value->phone)<p class="mb-0"><b>Phone:</b> {{$value->phone}}</p>@endif
                                            @if($value->email)<p class="mb-0"><b>Email:</b> {{$value->email}}</p>@endif
                                        </td>
                                        <!-- <td>{{ ($value->custom_smtp) ? "Yes" : "" }}</td> -->
                                        <td>
                                            <a 
                                            href="{{ route('admin.settings.branch.edit', $value->id) }}"
                                                class="btn btn-primary btn-sm"><i class="fas fa-edit" style="font-size:17px"></i> Edit</a>
                                            <a 
                                            href="{{ route('admin.settings.branch.destroy', $value->id) }}"
                                                data-method="delete" data-trans-button-cancel="Cancel"
                                                data-trans-button-confirm="Delete" data-trans-title="Are you sure?"
                                                class="btn btn-danger btn-sm" class="btn btn-primary"><i class="fa fa-trash"></i></a>
                                        </td>
                                    </tr>

                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>
</div>
</div>
</div>
@endsection

@push('after-styles')
  
@endpush
@push('after-scripts')
@endpush
