@extends('backend.layouts.app')
@section('title', "Orders")
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Broadcast History
                </h4>
            </div>
            <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <a href="{{route('admin.broadcast.index')}}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Create Batch">Back to Broadcast page</a>
                </div>
                <!--btn-toolbar-->
            </div>
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="history-table">
                        <thead>
                            <tr>
                                <th style="width:10%">Date & Time</th>
                                <th style="width:10%">Type</th>
                                <th style="width:10%">Subject</th>
                                <th style="width:30%">Message</th>
                                <th style="width:20%">Sent To</th>
                                <th>Staff</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div><!--col-->

        </div><!--row-->
    </div>
</div>
@endsection      

@push ('after-scripts')
<!-- DataTables Core and Extensions -->
<script type="text/javascript">
$('#history-table').DataTable({
        "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',
        processing: true,
        serverSide: true,
        autoWidth: true,
        responsive: true,
        ajax: '{{ route("admin.broadcast-history-list") }}',
        columns: [
            {data: 'date',name:'date'},
            {data: 'msg_type', name: 'msg_type'},
            {data: 'subject', name: 'subject'},
            {data: 'message', name: 'message'},
            {data: 'sent_to', name: 'sent_to'},
            {data: 'staff', name: 'staff'},
        ],
         "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
            ]          
    });
</script>
@endpush
