@extends('backend.layouts.app')

@section('title', "Broadcast")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Broadcast
                </h4>
            </div>
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.broadcast.broadcast-history') }}" class="btn btn-primary ml-1 btn-sm" data-toggle="tooltip" title="Broadcast History" style="margin-left:10px;"><i class="bi bi-clock-history"></i> &nbsp;Broadcast History</a>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->
        <div class="row mt-4">
            <div class="col-sm-12 col-md-8">
                {{ html()->form('POST', route('admin.broadcast.preview'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                <div style="margin-top:10px;">
                    <div class="form-group">
                        <label>Target Group</label>
                        <select name="target" id="target" class="form-select" required>
                            <option value="">Select Target Group</option>
                            @if(\Auth::user()->isAdmin() || \Auth::user()->can('broadcast to leads and students'))
                            <option value="Leads">Leads</option>
                            <option value="Students">Students</option>
                            @endif
                            @if(\Auth::user()->isAdmin() || \Auth::user()->can('broadcast to agents'))
                            <option value="Agents">Agents/Parters</option>
                            @endif
                            @if(\Auth::user()->isAdmin() || \Auth::user()->can('broadcast to staff'))
                            <option value="Staff">Staff Members</option>
                            @endif
                        </select>
                    </div>

                    <div class="form-group" id="leadcountry" style="display:none;">
                        <label>Country Interested</label>
                        <select name="countrys" id="leadcountry" style="" class="form-select">
                            <option value="">Country Interested to Study In</option>
                            <option value="">-ANY-</option>
                            @foreach($leadcountry as $leadcountrys)
                            <option value="{{$leadcountrys->country}}">{{ $leadcountrys->country }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group" id="leadstatus" style="display:none;">
                        <label>Lead Status</label><br />
                        <select name="lead_status[]" id="lead" style="width:100%;" class="form-select select2" multiple="multiple">
                            @foreach(lead_status_list() as $lead_status)
                            <option value="{{ $lead_status->status }}">{{ $lead_status->status }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group" id="student_overseas_status" style="display:none;">
                        <label class="required-field">Student Status</label><br />
                        <select name="overseas_status[]" style="width:100%;" class="form-select select2" id="student_status" multiple="multiple">
                            @foreach(get_overseas_status_list() as $stu_status_data)
                            <option value="{{$stu_status_data->status}}">{{$stu_status_data->status}}</option>
                            @endforeach
                        </select>
                        <input type="checkbox" class="radio-col-blue" id="check_1" name="agent_students" value="1" checked/>
                        <label for="check_1">Exclude agent students</label>
                    </div>

                    <div class="form-group row">
                        <div class="col-sm-6">
                            <input type="radio" class="radio-col-blue" id="radio_1" name="msg_type" value="1" required />
                            <label for="radio_1">Email</label>

                            &nbsp;<input type="radio" class="radio-col-blue" id="radio_2" name="msg_type" value="2" required />
                            <label for="radio_2">SMS</label>

                            {{-- &nbsp;<input type="radio" class="radio-col-blue" id="radio_3" name="msg_type" value="3" required />
                            <label for="radio_3">Email & SMS</label> --}}

                            @if(get_site_config('whatsapp_enabled'))
                            &nbsp;<input type="radio" class="radio-col-blue" id="radio_4" name="msg_type" value="4" required />
                            <label for="radio_4">Whatsapp</label>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="form-group" id="email_template_block" style="display:none;">
                    <select class="form-control form-select" id="email_template">
                        <option value="manual">Choose a template OR Type the message</option>
                        @foreach(get_email_templates() as $tpl)
                        <option value="{{$tpl}}">{{$tpl}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group" id="sms_template_block" style="display:none;">
                    <select class="form-control form-select" name="sms_template" id="sms_template">
                        <option value="manual">Choose a template OR Type the message</option>
                        @foreach(get_sms_templates() as $tpl)
                        <option value="{{$tpl}}">{{$tpl}}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group" id="whtsp_template_block" style="display:none;">
                    <select class="form-control form-select" name="whtsp_template" id="whtsp_template">
                        <option value="manual">Choose a template</option>
                        @foreach(get_whatsapp_templates() as $tpl)
                        <option value="{{$tpl}}">{{$tpl}}</option>
                        @endforeach
                    </select>
                </div>


                <div class="tpl_loading" style="display:none;"><span style="color:red;">Loading... Please wait.</span></div>

                <div class="form-group row" id="subject" style="display:none;">
                    <div class="col-sm-12">
                        <label>Subject</label>
                        <input id="subject_val" class="form-control" name="subject">
                        </input>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <div class="col-sm-12">
                        <textarea id="message" style="display:none;" class="form-control" name="message" rows="10" cols="150"></textarea>
                        {{-- <textarea id="message_html" name="message_html" class="form-control textarea_editor" style="height:300px;"></textarea> --}}
                        <textarea id="message_html" name="message_html" rows="10" style="height:300px;" class="ckeditor_toolbar_all form-control"></textarea>
                    </div>
                </div>
                <div class="form-group" style="text-align: center">
                    {{ form_submit("Continue") }}
                </div>

                <div class="col-sm-12">
                    <strong>Note:</strong>
                </div><br>
                <div class="col-sm-12">
                    <strong>Following variables can be used in the message content:</strong>
                    <br>#first_name# - Replaces with User First name
                    <br>#full_name# - Replaces with User Full name
                    <br>#sitename# - Website Name
                    <br>#siteurl# - Website URL
                </div>
                {{ html()->form()->close() }}
            </div>
        </div>
        @if($show_email_queue)
        <div class="row col">
            <p class="text-primary">Current emails in Queue: <strong>{{$email_queue_size}}</strong></p>
        </div>
        @endif
    </div>
</div>
</div>
@endsection

@push('after-styles')
{{-- <link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " /> --}}
@endpush
@push('after-scripts')
{{-- <script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
<script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script> --}}

<script>
    $(document).ready(function() {

        //$('.myselect2').select2();
        // $('.textarea_editor').wysihtml5();

        $('#email_template').change(function() {
            
            if (this.value == 'manual') {
                $('#subject_val').val('');
                window.editor.setData('');
            } else {
                $('.tpl_loading').show();
                $.post("{{route('admin.mailtemplates.ajaxgetmailtpl')}}", {
                    'hook': this.value,
                    '_token': $('meta[name="csrf-token"]').attr('content')
                },
                function(data, status) {
                    var tpl = JSON.parse(data);
                    $('.tpl_loading').hide();
                    $('#subject_val').val(tpl.mail_tpl.subject);

                    if(tpl.emailSignature.email_signature){
                        window.editor.setData(tpl.mail_tpl.message + "<br><br><br>" +tpl.emailSignature.email_signature);
                    }else{
                        window.editor.setData(tpl.mail_tpl.message + "<br>");
                    }
                });
                
            }
        });

        $('#sms_template').change(function() {
            if (this.value == 'manual') {
                $('#message').val('');
            } else {
                $('.tpl_loading').show();
                $.post("{{route('admin.smstemplates.ajaxgetsmstpl')}}", {
                        'hook': this.value,
                        '_token': $('meta[name="csrf-token"]').attr('content')
                    },
                    function(data, status) {
                        var tpl = JSON.parse(data);
                        $('.tpl_loading').hide();
                        $('#message').val(tpl.message);
                    });
            }
        });

        $('#whtsp_template').change(function() {
            if (this.value == 'manual') {
                $('#message').val('');
            } else {
                $('.tpl_loading').show();
                $.post("{{route('admin.whatsapptemplates.ajaxgetwhtsptpl')}}", {
                        'hook': this.value,
                        '_token': $('meta[name="csrf-token"]').attr('content')
                    },
                    function(data, status) {
                        var tpl = JSON.parse(data);
                        $('.tpl_loading').hide();
                        $('#message').val(tpl.message);
                    });
            }
        });

        $("#target").click(function(e) {
            e.preventDefault();
            if (this.value == 'Students') {
                $("#student_overseas_status").show();
                $("#student_status").prop('required',true);
                $("#leadcountry").hide();
                $("#leadstatus").hide();
            } else if (this.value == 'Leads') {
                $("#student_overseas_status").hide();
                // $("#student_overseas_status").removeAttr('required', false);
                $("#student_status").prop('required',false);
                $("#leadcountry").show();
                $("#leadstatus").show();
            } else if (this.value == 'Staff' || this.value == 'Agents') {
                $("#student_overseas_status").hide();
                $("#student_status").prop('required',false);
                $("#leadcountry").hide();
                $("#leadstatus").hide();
            }
        });


        $("#radio_1").click(function() {
            $("#email_template_block").show();
            $("#sms_template_block,#whtsp_template_block").hide();
            $("#subject").show();
            $("#message").hide();
            // $("#message_html").show();
            $(".ck-editor").show();
            $('.ck-toolbar').show();
            // $(".wysihtml5-sandbox").show();
        });
        $("#radio_2").click(function() {
            $("#sms_template_block").show();
            $("#email_template_block,#whtsp_template_block").hide();
            $("#subject").hide();
            $("#message").show();
            $("#message").prop('readonly', false);
            // $("#message_html").hide();
            $(".ck-editor").hide();
            $('.ck-toolbar').hide();
            // $(".wysihtml5-sandbox").hide();
        });
        $("#radio_3").click(function() {
            $("#email_template_block").hide();
            $("#sms_template_block,#whtsp_template_block").hide();
            $("#subject").show();
            $("#message").show();
            $("#message").prop('readonly', false);
            // $("#message_html").hide();
            $(".ck-editor").hide();
            $('.ck-toolbar').hide();
            // $(".wysihtml5-sandbox").hide();
        });
        $("#radio_4").click(function() {
            $("#whtsp_template_block").show();
            $("#email_template_block,#sms_template_block").hide();
            $("#subject").hide();
            $("#message").show();
            $("#message").prop('readonly', true);
            // $("#message_html").hide();
            $(".ck-editor").hide();
            $('.ck-toolbar').hide();
            // $(".wysihtml5-sandbox").hide();
        });
    });
</script>
@endpush