@extends('backend.layouts.app')

@section('title', "Add New Category")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Add New Category
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <a href="{{ route('admin.category') }}" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
            </div>
        </div>
        <!--row-->

        <div class="row mt-4">
            <div class="col">
                {{ html()->form('POST', route('admin.category.save-category'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                @csrf
                <div class="row">
                    <div class="col-lg-12 col-sm-12 col-md-12">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="parentcat"><b>Parent Category</b></label>
                        </div>
                        <div class="col-md-6 col-lg-6 col-sm-6">
                            <select class="form-control form-select" id="parentcat" name="parentcat">
                                <option value="0">Select Parent Category</option>
                                @foreach($categories as $category)
                                <option value="{{$category->id}}">{{$category->title}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="title"><b>Category Title</b> <span style="color: red;">*</span></label>
                        </div>
                        <div class="col-md-6 col-lg-6 col-sm-6">
                            <input type="text" class="form-control" id="title" value="{{old('title')}}" name="title" required>
                        </div>
                    </div>


                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="details_en"><b>Category Description</b></label>
                        </div>
                        <div class="col-md-6 col-lg-6 col-sm-6">
                            <textarea class="form-control" id="details" name="details" rows="5">{{old('details')}}</textarea>
                        </div>
                    </div>

                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="is_marketplace"><b>Status </b> <span style="color: red;">*</span></label>
                        </div>
                        <div class="col-md-6 col-lg-6 col-sm-6">
                            <select class="form-control form-select" id="status" name="status">
                                <option value="1">Enabled</option>
                                <option value="0">Disabled</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="file"><b>Photo</b></label>
                        </div>
                        <div class="col-md-6 col-lg-6 col-sm-6">
                            <input type="file" name="file" id="file" class="form-control" value="{{old('file')}}">
                            Extensions: .png, .jpg, .jpeg, .gif, .svg
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="display_order"><b>Display Order</b> <span style="color: red;">*</span><label>
                        </div>
                        <div class="col-md-6 col-lg-6 col-sm-6">
                            <input type="number" value="9999" min="0" name="display_order" id="display_order" class="form-control" required>
                        </div>
                    </div>

                    <div class="col-lg-12 col-sm-12 col-md-12 ml-4 mt-4">
                        <button type="submit" class="ml-2 btn btn-primary">Save</button>
                        <a href="{{ URL::previous() }}" type="submit" class="btn btn-danger">Cancel</a>
                    </div>

                </div>
                </form>
            </div>



        </div>
        <!--col-->
    </div>
    <!--row-->
</div>
</div>
@endsection