@extends('backend.layouts.app')

@section('title', "Edit Category")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-8 col-8">
                <h4 class="card-title mb-0">
                    Edit Category
                </h4>
            </div>

            <div class="col-4 col-4">
                <div class="float-right">
                    <div class="btn-group" role="group" aria-label="Toolbar button groups">
                        <div class="btn-group" role="group">
                        </div>
                    </div>
                </div>
            </div>
            <!--/.col-->
        </div>
        <!--/.row-->
        <hr>
        <div class="row mt-4">
            <div class="col">
                <form action="{{route('admin.category.update-category')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="slug" value="{{$cat_det->slug}}">
                    <div class="row">
                        <div class="col-lg-12 col-sm-12 col-md-12">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="parentcat"><b>Parent Category</b></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <select class="form-control form-select" id="parentcat" name="parentcat">
                                    <option value="0">Select Parent Category</option>
                                    @foreach($categories as $category)
                                    <option value="{{$category->id}}" @if($category->id == $cat_det->parent) selected @endif>{{$category->title}}</option>
                                    @endforeach
                                </select>              
                            </div>
                        </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="title_en"><b>Category Title</b> <span style="color: red;">*</span></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="text" class="form-control" id="title" value="{{$cat_det->title}}" name="title" required>             
                            </div>
                        </div>


                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="details_en"><b>Category Description</b></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <textarea class="form-control" id="details" name="details" rows="5">{{$cat_det->details}}</textarea>
                            </div>
                        </div>

                         <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="status"><b>Status </b> <span style="color: red;">*</span></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <select class="form-control form-select" id="status" name="status">
                                    <option value="1" @if($cat_det->status == 1) selected @endif>Enabled</option>
                                    <option value="0" @if($cat_det->status == 0) selected @endif>Disabled</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="file"><b>Photo</b></label>
                            </div>
                            <div class="ml-4 mb-2">
                                @if($cat_det->photo)
                                 <img src="{{asset('storage/categories/'.$cat_det->photo)}}" style="height: 150px;"><a href="{{route('admin.category.removeimg',[$cat_det->slug])}}" class="btn btn-danger" style="margin-top: -114px;margin-left: -34px;">&times;</a>
                                @endif
                                </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="file" name="file" id="file" class="form-control" value="{{old('file')}}">
                                Extensions: .png, .jpg, .jpeg, .gif, .svg
                            </div>

                        </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="display_order"><b>Display Order</b> <span style="color: red;">*</span><label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="number" value="{{$cat_det->order}}" min="0" name="display_order" id="display_order" class="form-control" required>
                            </div>
                        </div>
                        <div>
                        <div class="col-lg-12 col-sm-12 col-md-12 ml-4 mt-4">
                            <button type="submit" class="ml-2 btn btn-primary">Update</button>
                            <a href="{{ route('admin.category') }}" type="submit" class="btn btn-danger">Cancel</a>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="card-footer">
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    
                </div>
            </div>
            <div class="col-5">
                <div class="float-right">
                    
                </div>
            </div>
        </div>
    </div>
</div>
@endsection        