@extends('backend.layouts.app')
@section('title', "Categories")
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    Product Categories
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="New Course Info Page" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.category.create-category') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New Category"><i class="bi bi-plus-circle"></i> Create</a>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table eductrl-datatable" id="suggestions_tbl">
                        <thead class="dker">
                            <tr>
                                <th>Category Title</th>
                                <th class="text-center" style="width:100px;">Order</th>
                                <th class="text-center" style="width:100px;">Status</th>
                                <th class="text-center" style="width:100px;">Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            for ($i = 0; $i < count($categories); $i++) { ?>
                                <tr>
                                    <td class="">
                                        <div style="display: flex;" class="">
                                            <div>
                                                <div class="px-2 py-1 mt-3" style="border: 2px solid #cbcaca;">{{$i+1}}</div>
                                            </div>

                                            @if($categories[$i]->photo)
                                            <div style="margin-left: 20px;"><img src="{{asset('storage/categories/'.$categories[$i]->photo)}}" style="width: 100px; height: 56px;"></div>
                                            @endif

                                            <div style="margin-left: 20px;" class="mt-3"><b>{{$categories[$i]->title}}</b></div>
                                        </div>
                                    </td>
                                    <td class="text-center">{{$categories[$i]->order}}</td>
                                    <td class="text-center"><i class="fa {{ ($categories[$i]->status==1) ? "fa-check text-success":"fa-times text-danger" }} inline"></i></td>
                                    <td class="text-center">
                                        <div style="display: flex; text-align: center;">
                                            <a title="Edit" href="{{route('admin.category.edit-category',[$categories[$i]->slug])}}" class="btn btn-info m-1"><i class="fa fa-edit"></i></a>
                                            <a title="Delete" href="{{route('admin.category.delete-category',[$categories[$i]->slug])}}" onclick="return confirm('Are you sure do you want to delete this?')" class="btn btn-danger m-1"><i class="fa fa-trash"></i></a>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                                $co = 0;
                                for ($k = 0; $k < count($subcategories); $k++) {
                                    $cat_de = array();
                                    if ($subcategories[$k]->parent == $categories[$i]->id) {
                                        $co++;
                                        $cat_de[] = $subcategories[$k];
                                    }
                                    $si = 1;
                                    if (isset($cat_de)) {
                                        for ($j = 0; $j < count($cat_de); $j++) {
                                            $cat_det = $cat_de[$j];
                                ?>
                                            <tr>
                                                <td class="">
                                                    <div style="display: flex; position: relative;margin-left: 44px;" class="mt-3">
                                                        @if($co == 1)
                                                        <img style="position: absolute; top: -30px; left: -29px;" src="{{asset('assets/images/background/treepart_ltr2.png')}}">
                                                        @else
                                                        <img style="position: absolute; top: -47px; left: -29px;" src="{{asset('assets/images/background/treepart_ltr.png')}}">
                                                        @endif

                                                        <div>
                                                            <div class="px-2 py-1 mt-3" style="border: 2px solid #cbcaca;">{{$co}}</div>
                                                        </div>

                                                        @if($cat_det->photo)
                                                        <div style="margin-left: 20px;"><img src="{{asset('storage/categories/'.$cat_det->photo)}}" style="width: 100px;height: 56px;"></div>
                                                        @endif

                                                        <div style="margin-left: 20px;" class="mt-3"><b>{{$cat_det->title}}</b></div>
                                                    </div>
                                                </td>
                                                <td class="text-center">{{$cat_det->order}}</td>
                                                <td class="text-center"><i class="fa {{ ($cat_det->status==1) ? "fa-check text-success":"fa-times text-danger" }} inline"></i></td>
                                                <td class="text-center">
                                                    <div style="display: flex;">
                                                        <a href="{{route('admin.category.edit-category',[$cat_det->slug])}}" class="btn btn-info m-1"><i class="fa fa-pen"></i></a>
                                                        <a href="{{route('admin.category.delete-category',[$cat_det->slug])}}" onclick="return confirm('Are you sure do you want to delete this?')" class="btn btn-danger m-1"><i class="fa fa-trash"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                <?php
                                        }
                                    }
                                } ?>
                            <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--col-->

        </div>
        <!--row-->
    </div>
</div>
@endsection