@extends('backend.layouts.app')
@section('title', app_name() . ' | Send EMail')
@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Send Email
                </h4>
            </div>
        </div>
        <!--row-->

        {{ html()->modelForm($logged_in_user, 'POST', route('admin.communicate.mail.send', $userid))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
        <input type="hidden" name="userid" value="{{ $userid }}">
        <div class="row mt-4">
            <div class="col-md-8 col-sm-12">
                <div class="form-group">
                    {{-- User: {{ $name }}<br /><br>
                    Email: {{ $email }}<br /><br> --}}
                    To: <b>{{ $name }} &nbsp;&lt;{{$email}}&gt;</b> <br><br>
                    From: {{$from}} <br><br>
                </div>
                <div class="form-group">
                    <select class="form-control form-select" id="msg_template">
                        <option value="manual">Select a template or type message</option>
                        @foreach(get_email_templates() as $tpl)
                        <option value="{{$tpl}}">{{$tpl}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="tpl_loading" style="display:none;"><span style="color:red;">Loading... Please wait.</span></div>
                <div class="form-group">
                    <label>Subject</label>
                    <input class="form-control" type="text" id="subject" name="subject" placeholder="Subject" value="" required />
                </div>
                <div class="form-group">
                    <label>Message</label>
                    <textarea name='message' rows="10" id="message" class="ckeditor_toolbar_all form-control">@if($userDetails->email_signature)<br><br><br><br>{!! $userDetails->email_signature !!}@endif</textarea>
                </div>
                <div class="form-group">
                    <label>Attachments</label>
                     <input type="file" id="attachment" multiple name="attachment[]" class="form-control" accept=".doc,.docx,.pdf,.jpg,.jpeg,.png,.gif,.zip" max="10">
                     <small>Note: File size limit is {{env('ATTACHMENT_MAX_SIZE')}}MB</small>
                </div>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-md-8 col-sm-12 text-center">
                <input type="submit" name="submit" class="btn btn-primary btn-sm" value="Send" />
            </div>
        </div>
        {{ html()->closeModelForm() }}
        <span >Note: #password# cannot be used to send student password</span>
    </div>
</div>

@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('#msg_template').change(function() {
            if (this.value == 'manual') {
                $('#subject').val('');
                window.editor.setData("");
            } else {
                $('.tpl_loading').show();
                $.post("{{route('admin.mailtemplates.ajaxgetmailtpl')}}", {
                    'hook': this.value,
                    '_token': $('meta[name="csrf-token"]').attr('content')
                },
                function(data, status) {
                    var tpl = JSON.parse(data);
                    $('.tpl_loading').hide();
                    $('#subject').val(tpl.mail_tpl.subject);
                    if(tpl.emailSignature.email_signature){
                        window.editor.setData(tpl.mail_tpl.message + "<br><br><br>" +tpl.emailSignature.email_signature);
                    } else{
                        window.editor.setData(tpl.mail_tpl.message);
                    }
                });
            }
        });
    });
</script>

@endpush
