@extends('backend.layouts.app')

@section('title', app_name() . ' | Send SMS')

@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                    Send SMS
                </h4>
            </div><!--col-->

            <!-- <div class="col-sm-2 " style="margin-top:20px;text-align: right;">

            </div> -->

        </div><!--row-->

        {{ html()->modelForm($logged_in_user, 'POST', route('admin.communicate.sms.send', $userinfo->id))->class('form-horizontal')->open() }}
        <input type="hidden" name="userid" value="{{ $userinfo->id }}">
        <div class="row mt-4">
            <div class="col-md-8 col-sm-12">
                User: {{ $userinfo->name }}<br /><br>
                Mobile: {{ ($userinfo->dialcode == '233') ? $userinfo->mobile : $userinfo->dialcode."".$userinfo->mobile }}<br /><br>
                <div class="form-group">
                    <select class="form-control form-select" id="msg_template">
                        <option value="manual">Select a template or type message</option>
                        @foreach(get_sms_templates() as $tpl)
                        <option value="{{$tpl}}">{{$tpl}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="tpl_loading" style="display:none;"><span style="color:red;">Loading... Please wait.</span></div>
                <textarea id="message" name="message" placeholder="Message" class="form-control" style="height:100px;" required ></textarea>
            </div>

        </div>
        <div class="row mt-4">
            <div class="col-md-8 col-sm-12 text-center">
                <input type="submit" name="submit" class="btn btn-primary btn-sm" value="Send" />
            </div>   
        </div>
        {{ html()->closeModelForm() }}  
    </div><!--card-body-->
</div><!--card-->
@endsection
@push('after-scripts')
<script>
    $(document).ready(function() {
        $('#msg_template').change(function() {
            if (this.value == 'manual') {
                $("#message").val('');
            } else {
                $('.tpl_loading').show();
                $.post("{{route('admin.smstemplates.ajaxgetsmstpl')}}", {
                        'hook': this.value,
                        '_token': $('meta[name="csrf-token"]').attr('content')
                    },
                    function(data, status) {
                        var tpl = JSON.parse(data);
                        $('.tpl_loading').hide();
                        $("#message").val(tpl.message);
                    });
            }
        });
    });
</script>
@endpush