@extends('backend.layouts.app')

@section('title', app_name() . ' | Whatsapp User')

@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection

@section('content')
<div class="card">
    @if(!get_site_config('whatsapp_enabled'))
    <span class="alert alert-danger">Whatsapp is Disabled</span>
    @endif
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                    Send Whatsapp
                </h4>
            </div><!--col-->

            <!-- <div class="col-sm-2 " style="margin-top:20px;text-align: right;">

            </div> -->

        </div><!--row-->
        {{ html()->modelForm($logged_in_user, 'POST', route('admin.communicate.whatsapp.send', $userinfo->id))->class('form-horizontal')->open() }}
        <input type="hidden" name="userid" value="{{ $userinfo->id }}">
        <div class="row mt-4">
            <div class="col-md-8 col-sm-12">
                User: {{ $userinfo->name }}<br /><br>
                Whatsapp no.: {{ ($userinfo->whatsapp)? $userinfo->dialcode."".$userinfo->whatsapp : 'N/A' }}<br/>
                @if(!$userinfo->whatsapp)
                <p><small class="text-danger">Please add whatsapp number first.</small> 
                @endif
                <div class="form-group mt-3">
                    <select class="form-control form-select" name="msg_template" id="msg_template" required>
                        <option value="manual">Select a template</option>
                        @foreach(get_whatsapp_templates() as $tpl)
                        <option value="{{$tpl}}">{{$tpl}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="tpl_loading" style="display:none;"><span style="color:red;">Loading... Please wait.</span></div>
                <textarea id="message" name="message" placeholder="Message" class="form-control" readonly style="height:100px;" required ></textarea>
                {{-- @if(get_site_config('whatsapp_provider')=='aisensy')
                <small>Replace <?php echo "{{message}}";?> with your message.</small>
                @endif --}}
            </div>
            
        </div>
        <div class="row mt-4">
            <div class="col-md-8 col-sm-12 text-center">
                <input type="submit" name="submit" @if($userinfo->whatsapp && get_site_config('whatsapp_enabled')) class="btn btn-primary btn-sm" @else class="btn btn-disabled btn-sm" disabled @endif value="Send" />
            </div>   
        </div>
        {{ html()->closeModelForm() }}  
    </div><!--card-body-->
</div><!--card-->
@endsection
@push('after-scripts')
<script>
    $(document).ready(function() {
        $('#msg_template').change(function() {
            if (this.value == 'manual') {
                $("#message").val('');
            } else {
                $('.tpl_loading').show();
                $.post("{{route('admin.whatsapptemplates.ajaxgetwhtsptpl')}}", {
                        'hook': this.value,
                        '_token': $('meta[name="csrf-token"]').attr('content')
                    },
                    function(data, status) {
                        var tpl = JSON.parse(data);
                        $('.tpl_loading').hide();
                        $("#message").val(tpl.message);
                    });
            }
        });
    });
</script>
@endpush