@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('content-blocks')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general active show" id="content_blocks">

                                <div class="row">
                                    <div class="col-sm-12 col-md-9">
                                        <h4>Add New Content Block</h4>
                                        <form action="{{route('admin.content-blocks.save')}}" method="post">
                                            @csrf
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group mb-3">
                                                        <label class="required-field">Section</label>
                                                        <input type="text" class="form-control" name="section" maxlength="100" required />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="form-group mb-3">
                                                        <label>Content</label><br />
                                                        <textarea id="content" name="content" class="ckeditor_toolbar2"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="text-center">
                                                <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                            </div>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-12">
                                        <hr>
                                        <h4>Existing Contents</h4>

                                        <div class="table-responsive">
                                            <table class="table eductrl-datatable">
                                                <thead>
                                                    <tr>
                                                        <th>Section</th>
                                                        <th>Content</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($content_blocks))
                                                    @foreach($content_blocks as $content_block)
                                                    <tr>
                                                        <td>{{$content_block->section}}</td>
                                                        <td>{!!$content_block->content!!}</td>
                                                        </td>
                                                        <td>
                                                            <a href="{{ route('admin.content-blocks.edit', $content_block->id)}}"><i class='fas fa-edit text-primary' style='font-size:17px'></i></a>&nbsp;
                                                            <a href="{{ route('admin.content-blocks.delete', $content_block->id)}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure?"><i class='fas fa-trash-alt text-danger' style='font-size:17px'></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                    @else
                                                    <tr>
                                                        <td colspan="3" class="text-center">No Record Found</td>
                                                    </tr>
                                                    @endif
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>
                                </div>

                            </div>

                        </div><!-- End Bordered Tabs -->

                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@push('after-scripts')
<script>
    addDeleteForms();
</script>
@endpush