@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')
<div class="row">
    <div class="col" style="margin-bottom:10px;">
        <h4 style="">Settings</h4>
    </div>
</div>

<div class="row">


    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <!-- Bordered Tabs -->
                <ul class="nav nav-tabs nav-tabs-bordered">
                {!!get_settings_tabs('content-blocks')!!}
                </ul>
                <div class="tab-content pt-4">

                    <div class="tab-pane fade general active show" id="content_blocks">

                        <div class="row">
                            <div class="col-sm-12 col-md-9">
                                <h4>Edit Content Block</h4>
                                <form action="{{route('admin.content-blocks.save')}}" method="post">
                                    @csrf
                                    <input type="hidden" name="id" value="{{$content_block->id}}" />
                                    <div class="row">
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group mb-3">
                                                <label>Section</label>
                                                <input type="text" class="form-control" name="section" value="{{$content_block->section}}" readonly />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group mb-3">
                                                <label>Content</label><br />
                                                <textarea id="content" class="ckeditor_toolbar2" name="content">{{$content_block->content}}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="document.location='{{route('admin.banners')}}'">Cancel</button>
                                    </div>

                            </div>
                        </div>

                    </div>

                </div><!-- End Bordered Tabs -->

            </div>
        </div>

    </div>
</div>



@endsection