@extends('backend.layouts.app')
@section('title', "Leads - Assign Staff")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                Leads - Assign Staff
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 " style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->
        {{ html()->form('POST', route('admin.leads.assignstaff.update'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

        
        
        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>Leads</b></span></label>
            </div>
        </div>
            
        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                @foreach ($leaddata_arr as $leaddata)
                    <input type="hidden" name="lead_id[]" value="{{$leaddata->id}}">
                    <label class="col-form-label"><b>{{ $leaddata->first_name }} {{$leaddata->last_name }}</b>  ({{ $leaddata->email }})</label> <br>
                @endforeach
            </div>
        </div>
            
        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>Assign To</b></label>
                <div class="">
                    <select class="form-select" id='staff' name="staff">
                        <option value=''>Select</option>
                             @foreach($staff as $stf)
                                <option value="{{$stf->id}}">{{$stf->first_name . ' ' . $stf->last_name}}</option>
                            @endforeach
                    </select>
                </div>
            </div>
        </div>
            

        <div class="row" style="margin-top:10px;">
            <div class="col-sm-12 col-md-8">
                <div class="form-group mb-0 clearfix">
                    {{ form_submit("Save") }}
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'">Cancel</button>
                </div>
            </div>
        </div>


    </div>
</div>
@endsection
