@extends('backend.layouts.app')
@section('title', "Lead - Assign Staff")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Convert Lead to Student
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.counsellingdetails') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->
        {{ html()->form('POST', route('admin.counselling.convert', $lead->id))->class('form-horizontal')->open() }}

        <div class="form-group row mb-2">
            <div class="col-md-12">
                <label class="col-form-label"><b>Lead</b></span></label>
                <div class="">
                    <p class="">{{ $lead->first_name }} {{$lead->last_name }}</p>
                    <p>Email: {{ $lead->email }}<br />
                    Ph: {{ $lead->mobile }}</p>
                </div>
            </div>
        </div>

        <div class="form-group row mb-2">
            <div class="col-md-12">
                @if($student)
                <label class="col-form-label"><b>Matching Student Found</b></label>
                <div class="">
                    <p>Student Name: {{$student->name}}</p>
                    <p>Email: {{$student->email}}<br />
                    Ph: {{$student->mobile}}</p>
                </div>
                @else
                <!-- <p class="text-danger">No matching student with email id {{$lead->email}} found!<br />
                    Do you still want to mark this lead as converted?</p> -->
                <p class="text-danger">Student account will be created & login credentials will be sent by email.</p>
                @endif
            </div>
        </div>

        <div class="row" style="margin-top:10px;">
            <div class="col-sm-12 col-md-8">
                <div class="form-group mb-0 clearfix">
                    {{ form_submit("Convert") }}
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.counsellingdetails') }}'">Cancel</button>
                </div>
            </div>
        </div>


    </div>
</div>
@endsection