@extends('backend.layouts.app')
@section('title', "Lead - Counselling")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Convert Lead to Counselling
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->
        {{ html()->form('POST', route('admin.counselling.assignCounseller'))->class('form-horizontal')->open() }}
        <input type="hidden" name="lead_id" value="{{$lead->id}}">
        <div class="form-group row mb-2">
            <div class="col-md-12">
                <label class="col-form-label"><b>Lead</b></span></label>
                <div class="">
                    <p class="">{{ $lead->first_name }} {{$lead->last_name }}</p>
                    <p>Email: {{ $lead->email }}<br />
                    Ph: {{ $lead->mobile }}</p>
                </div>
            </div>
        </div>

        <div class="form-group row mb-2">
            <div class="col-md-12">
                <!-- @if($student) -->
                <label class="col-form-label"><b>Matching Student Found</b></label>
                <div class="">
                    <p>Student Name: {{$student->name}}</p>
                    <p>Email: {{$student->email}}<br />
                    Ph: {{$student->mobile}}</p>
                </div>
              <!--   @else
                
                <p class="text-danger">Student account will be created & login credentials will be sent by email.</p>
                @endif -->
            </div>
        </div>
        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>Select Counsellor</b></label>
                <div class="">
                    <select class="form-select" id='counsellor' name="counsellor" required>
                        <option value=''>Select</option>
                             @foreach($staff as $stf)
                                <option value="{{$stf->id}}" {{($lead->counselling_date && $lead->assigned_to == $stf->id) ? 'selected' : ''}}>{{$stf->first_name . ' ' . $stf->last_name}}</option>
                            @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>Date Time</b></label>
                <div class="">
                    <input type="text" class="form-control" value="{{($lead->counselling_date)? date('d-m-Y g:i a',strtotime($lead->counselling_date)): ''}}" autocomplete="off" id="counselling_datetime" name="date_time" required>
                </div>
            </div>
        </div>

        <div class="row" style="margin-top:10px;">
            <div class="col-sm-12 col-md-8">
                <div class="form-group mb-0 clearfix">
                    <button class="btn btn-primary btn-sm" type="submit">Update</button>
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'">Cancel</button>
                </div>
            </div>
        </div>


    </div>
</div>
@endsection