@extends('backend.layouts.app')

@section('title', "Counselling")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    Counselling
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                    <button onclick="javascript:searchTable();" class="btn btn-success btn-sm" title="Refresh"><i class="bi bi-arrow-clockwise"></i></button>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->

        <div style="border:1px solid #ccc;border-radius:5px;padding:12px 12px 4px 12px;background-color: #f8f8f8;">
            <div class="row mt-4">
                <div class="col-sm-12 col-md-3">
                    <select class="form-select" id='status_search'>
                        <option value=''>All Open Leads</option>
                        @foreach(counselling_lead_status_list() as $status_data)
                        @if($status_data->disqualified_status!=1)
                        <option value="{{$status_data->status}}" {{($filters['status'] == $status_data->status)? 'selected' : ''}}>{{$status_data->status}}</option>
                        @endif
                        @endforeach
                    </select>
                </div>

                @if(config('app.product_code') == 'EDUCTRL_CRM')
                <div class="col-sm-12 col-md-2">
                    <select class="form-select" id="leadtype">
                        <option value="">- Lead Type -</option>
                        @foreach(get_lead_types() as $lead_type)
                        <option value="{{$lead_type}}">{{$lead_type}}</option>
                        @endforeach
                    </select>
                </div>
                @else
                <input type='hidden' id="leadtype" value=''>
                @endif

                <div class="col-sm-12 col-md-3">
                    <select class="form-select" name="assigned_to" id="assigned_to">
                        <option value="">- Assigned To -</option>
                        @foreach($staff as $stf)
                        <option {{($filters['assigned_to'] == $stf->id)? 'selected' : ''}} value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-3">
                    <select class="form-select" name="lead_country" id="lead_country">
                        <option value="">- Country -</option>
                        @foreach($lead_countries as $countries)
                        <option {{($filters['lead_countries'] == $countries->country)? 'selected' : ''}} value="{{$countries->country}}">{{get_country_name($countries->country)}}</option>
                        @endforeach                        
                    </select>
                </div>

                <div class="col-sm-12 col-md-2">
                    <select class="form-select" id="branch" name="branch">
                        <option value="all" @if($current_branch=='all' ) selected="selected" @endif>All Branch</option>
                        @foreach($branch as $id => $name)
                        <option value="{{ $id }}" @if($current_branch==$id) selected="selected" @endif>{{ $name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-12 col-md-4">
                <input type="text" id="counselling_daterange" value="@isset($filters['counselling_daterange']){{$filters['counselling_daterange']}}@endisset" name="counselling_daterange" class="daterange form-control" placeholder="Counselling date">
                </div>                

                <div class="col-sm-12 col-md-4">
                    <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                    <button onclick="javascript:clearTable();" class=" btn btn-outline-primary btn-sm">Clear</button>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-md-2">
                    <input type="checkbox" name="myleads" id="myleads" value="1" @if($filters['my_data']=='1' ) checked @endif> My Leads Only
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col lead-horizontal">
                <div class="">
                    <table class="table w-100" id="lead_list">
                        <thead>
                            <tr>
                                <th data-orderable="false">
                                    <div class="form-check form-check-sm form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" id="check_all" name="check_all" />
                                    </div>
                                </th>
                                <th>ID</th>
                                <th>Actions</th>
                                <th>Lead</th>
                                <!-- <th>Branch</th> -->
                                <th>Counselling Date</th>
                                <th>Status</th>
                                <th>Assigned to</th>
                                <th>Next Followup</th>
                                <th>Created</th>
                            </tr>
                        </thead>

                    </table>


                    <div class="col-md-3 col-sm-12 process-selected" style="display:none; margin:15px 2px;">
                        <label>With Selected</label>
                        <select class="form-select" name="bulk_assigned_to" id="bulk_assigned_to">
                            <option value="">- Select -</option>
                            <option value="bulk_lead_assignment">Assign Leads to Staff</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <!--row-->
    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection


@push ('after-scripts')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script type="text/javascript">
    $(document).ready(function() {
        loadData();
        $('.daterange').daterangepicker({
            autoUpdateInput: false,
        });
        $('.daterange').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY') + ' to ' + picker.endDate.format('DD-MM-YYYY'));
        });
        $('.daterange').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });
        $("#check_all").on("click", function() {
            if ($("input:checkbox[name='check_all']").prop("checked")) {
                $("input:checkbox[name='multiselect']").prop("checked", true);
            } else {
                $("input:checkbox[name='multiselect']").prop("checked", false);
            }
            checkboxCheckSelected();
        });
        $('#myleads').change(function() {
            $("#lead_list").dataTable().fnDestroy();
            loadData();
        });

        $('#bulk_assigned_to').on('change', function() {
            if (this.value == 'bulk_lead_assignment') {
                processBulkLead();
            }
            if (this.value == 'bulk_lead_delete') {
                Swal.fire({
                    title: `Are you sure you want to delete selected leads?`,
                    showCancelButton: true,
                    confirmButtonText: "Delete",
                    cancelButtonText: "Cancel",
                    type: 'warning'
                }).then((result) => {
                    result.value && processBulkDelete();
                });
            } else {}
        });

    });

    function processBulkDelete() {
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function() {
            dataArray.push($(this).val());
        });
        var sub_options = {
            url: "{{route('admin.leads.bulkdeletelead')}}",
            method: "POST",
            data: {
                'id_arr': dataArray,
                '_token': $('meta[name="csrf-token"]').attr('content')
            }
        };
        manual_form_submit(sub_options);
    }

    function processBulkLead() {
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function() {
            dataArray.push($(this).val());
        });
        var sub_options = {
            url: "{{route('admin.leads.bulkassignstaff')}}",
            method: "POST",
            data: {
                'id_arr': dataArray,
                '_token': $('meta[name="csrf-token"]').attr('content')
            }
        };
        manual_form_submit(sub_options);
    }


    function manual_form_submit(options) {
        var $form = $("<form />");
        $form.attr("action", options.url);
        $form.attr("method", options.method);
        for (var data in options.data)
            $form.append('<input type="hidden" name="' + data + '" value="' + options.data[data] + '" />');
        $("body").append($form);
        $form.submit();
    }


    function checkboxCheckSelected() {
        var total_check_boxes = $("input:checkbox[name='multiselect']").length;
        var total_checked_boxes = $("input:checkbox[name='multiselect']:checked").length;
        if (total_check_boxes === total_checked_boxes) {
            $("#check_all").prop("checked", true);
        } else {
            $("#check_all").prop("checked", false);
        }
        if (total_checked_boxes > 0) {
            $(".process-selected").show();
        } else {
            $(".process-selected").hide();
        }
    }

    function clearSelectedCheckboxs() {
        $("#check_all").prop("checked", false);
        $(".process-selected").hide();

    }

    function loadData(myleads) {
        $('#lead_list').DataTable({
            "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',
            processing: true,
            serverSide: true,
            language: {
                searchPlaceholder: "Search By ID, Name, Mobile, Email"
            },
            autoWidth: true,
            responsive: true,
            lengthMenu: [10, 25, 50, 100],
            "ajax": {
                "url": "{{route('admin.ajaxcounsellinglist')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'status': $('#status_search').val(),
                    'leadtype': $('#leadtype').val(),
                    'lead_country': $('#lead_country').val(),
                    'branch': $('#branch').val(),
                    'assigned_to': $('#assigned_to').val(),
                    'myleads': $('#myleads:checked').val(),
                    'counselling_daterange': $('#counselling_daterange').val(),
                },
            },
            "drawCallback": function( settings ) {
                addDeleteForms();
            },
            'order': [
                [8, 'desc']
            ],
            columns: [{
                    data: 'id'
                },
                {
                    data: 'id'
                },
                {
                    data: 'actions',
                    orderable: false,
                    //searchable: false
                },
                {
                    data: 'name'
                },
                // {
                //     data: 'branch',
                //     orderable: false,
                // },
                {
                    data: 'counselling_date'
                },
                {
                    data: 'status'
                },
                {
                    data: 'assigned_to_name',
                    orderable: false,
                    //searchable: false,
                },
                {
                    data: 'next_followup'
                },
                {
                    data: 'created_at'
                },
            ],
            columnDefs: [{
                    targets: 0,
                    orderable: false,
                    render: function(data) {

                        if (data != '') {
                            return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" onclick="javascript:checkboxCheckSelected();" name="multiselect" type="checkbox" value="${data}" />
                                </div>`;
                        } else {
                            return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" name="multiselectd" type="checkbox" value="" disabled />
                                </div>`;
                        }
                    }
                },

            ],
            @if(isset($search) && strlen($search))
            "search": {
                "search": "{{$search}}"
            },
            @endif "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 3, 4, 5, 6, 7, 8]
                    }
                },
            ]
        });
    }


    function searchTable() {
        $("#lead_list").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        $('#status_search').val('');
        $('#leadtype').val('');
        $('#assigned_to').val('');
        $('#lead_country').val('');
        $('#branch').val('all');
        $('#counselling_daterange').val('');
        $("#lead_list").dataTable().fnDestroy();
        loadData();
    }
</script>
@endpush



@push ('after-styles')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style>
    .edu-tooltip {
        position: relative;
        display: inline-block;
        /* border-bottom: 1px dotted black; */
    }

    .edu-tooltip .edu-tooltiptext {
        visibility: hidden;
        width: 300px;
        background-color: black;
        color: #fff;
        font-size: 0.9em;
        text-align: center;
        border-radius: 6px;
        padding: 5px 0;
        position: absolute;
        z-index: 1;
        top: 150%;
        left: 50%;
        margin-left: -60px;
    }

    .edu-tooltip .edu-tooltiptext::after {
        content: "";
        position: absolute;
        bottom: 100%;
        left: 50%;
        margin-left: -5px;
        border-width: 5px;
        border-style: solid;
        border-color: transparent transparent black transparent;
    }

    .edu-tooltip:hover .edu-tooltiptext {
        visibility: visible;
    }
    .lead-horizontal {
            overflow-x: scroll;
        }
</style>

@endpush