@extends('backend.layouts.app')
@section('title', "Add New Lead")
@section('content')


<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Add New Lead
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>

        </div>
        <!--row-->

        {{ html()->form('POST', route('admin.leadmanagement.store'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

        <div class="col-sm-12 col-md-9">
            <!-- <div class="form-group row ">
                <div class="col-sm-12">
                    <label class="col-form-label required-field">Title:</label>
                    <input type="radio" class="radio-col-blue" id="radio_1" name="title" value="Mr." {{ Request::old('title') == 'Mr.' ? 'checked' : (Request::old('title') == '' ? 'checked' : '') }} />
                    <label for="radio_1">Mr.&nbsp;</label>

                    <input type="radio" class="radio-col-blue" id="radio_2" name="title" value="Ms." {{ Request::old('title') == 'Ms.' ? 'checked' : '' }} />
                    <label for="radio_2">Ms.&nbsp;</label>

                    <input type="radio" class="radio-col-blue" id="radio_3" name="title" value="Mrs." {{ Request::old('title') == 'Mrs.' ? 'checked' : '' }} />
                    <label for="radio_3">Mrs.&nbsp;</label>

                    <input type="radio" class="radio-col-blue" id="radio_4" name="title" value="Dr." {{ Request::old('title') == 'Dr.' ? 'checked' : '' }} />
                    <label for="radio_4">Dr.&nbsp;</label>

                    <input type="radio" class="radio-col-blue" id="radio_5" name="title" value="Prof." {{ Request::old('title') == 'Prof.' ? 'checked' : '' }} />
                    <label for="radio_5">Prof.</label>
                </div>
            </div> -->

            <div class="form-group row">
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label required-field">First Name</span></label>
                    <div class="">
                        <input type="text" class="form-control" name="fname" value="{{ Request::old('fname') }}" required>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Last Name</label>
                    <div class="">
                        <input type="text" class="form-control" name="lname" value="{{ Request::old('lname') }}">
                    </div>
                </div>
            </div>

            <div class="form-group row mt-2 mb-2">
                <div class="col-sm-12">
                    <label class="col-form-label required-field">Gender:</label>
                    <input type="radio" class="radio-col-blue" id="radio_1" name="gender" value="Male" {{ Request::old('gender') == 'Male' ? 'checked' : (Request::old('gender') == '' ? 'checked' : '') }} required />
                    <label for="radio_1">Male</label>

                    <input type="radio" style="margin-left:8px;" class="radio-col-blue" id="radio_2" name="gender" value="Female" {{ Request::old('gender') == 'Female' ? 'checked' : '' }} required />
                    <label for="radio_2">Female</label>
                </div>
            </div>


            <div class="form-group row ">
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label required-field">Email</label>
                    <div class="">
                        <input type="text" class="form-control" name="email" value="{{ Request::old('email') }}" required>
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Mobile No.</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <select class="form-select" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                <option value=''>Dialcode</option>
                                @foreach($dialcodes as $dialcode)
                                <option {{($dialcode->code == Request::old('dialcode'))? 'selected' : ''}} value="{{$dialcode->code}}">{{$dialcode->code}}</option>
                                @endforeach
                            </select>
                        </div>
                        <input type="text" class="form-control" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" name="mobile" value="{{ Request::old('mobile') }}" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}">
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label for="alternate_contact" class="col-form-label">Alternate Contact</label>
                    <div class="">
                        <input type="text" id="alternate_contact" maxlength="50" class="form-control" name="alternate_contact" value="{{ Request::old('alternate_contact') }}">
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <div class="col-sm-12 col-md-8">
                    <label for="whatsapp_number" class="col-form-label">Whatsapp No.</label>
                    <div class="">
                        <input type="text" id="whatsapp_number" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" class="form-control" name="whatsapp_number" value="{{ Request::old('whatsapp_number') }}">
                    </div>
                </div>
            </div>

            <div class="form-group row ">
                <div class="col-sm-12 col-md-8">
                    <label for="address" class="col-form-label">City/Location</label>
                    <div class="">
                        <input type="text" id="address" class="form-control" name="address" value="{{ Request::old('address') }}">
                    </div>
                </div>
            </div>

            <div class="form-group row ">
                <div class="col-sm-12 col-md-3">
                    <label class="col-form-label">Lead Source</label>
                    <div class="">
                        <select class="form-select" id='lead_source' name="lead_source">
                            <option value=''>Select</option>
                            @foreach(get_lead_sources() as $source_data)
                            <option {{($source_data == Request::old('lead_source'))? 'selected' : ''}} value="{{$source_data}}">{{ucfirst($source_data)}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-md-5">
                    <div class="form-group">
                        <label for="address" class="col-form-label">Source Details</label>
                        <div class="">
                            <input type="text" class="form-control" name="lead_source_detail" value="{{ Request::old('lead_source_detail') }}">
                        </div>
                    </div>
                </div>
            </div>


            <div class="form-group row" id="branch">
                <label class="col-form-label">Branch</label>
                <div class="col-sm-12 col-md-8">
                    <select class="form-select" id="branch" name="branch">
                        <option value="">Select Branch</option>
                        @foreach($branch as $branches)
                        <option {{($branches->id == Request::old('branch'))? 'selected' : ''}} value="{{ $branches->id }}">{{ $branches->branch_name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>            

            @if(config('app.product_code') == 'OVERSEAS')
            <input type="hidden" name="leadtype" value="Study Abroad">
            @elseif(config('app.product_code') == 'TRAINING')
            <input type="hidden" name="leadtype" value="Coaching">
            @elseif(config('app.product_code') == 'VISA')
            <input type="hidden" name="leadtype" value="Visa">
            @else
            <div class="form-group row">
                <label class="col-form-label required-field">Lead Type</label>
                <div class="col-sm-12 col-md-8">
                    <select class="form-select" id="leadtype" name="leadtype" required>
                        <option value="">Select</option>
                        @foreach(get_lead_types() as $lead_type)
                        <option value="{{$lead_type}}">{{$lead_type}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            @endif


            @if(config('app.product_code') == 'TRAINING' || config('app.product_code') == 'EDUCTRL_CRM')            
            <div class="form-group row" id="course" @if(config('app.product_code') == 'EDUCTRL_CRM') style="display:none;" @endif>
                <label class="col-form-label">Course Interested in</label>
                <div class="col-sm-12 col-md-8">
                    <select class="form-select" id="courses" name="course">
                        <option value="">Select Course</option>
                        @foreach($courses as $course)
                        <option value="{{ $course->id }}" @if (old('course')==$course->title) selected="selected" @endif>{{ $course->title }}</option>
                        @endforeach
                    </select>
                </div>
            </div>



            <div class="form-group row" id="coc" @if(config('app.product_code') == 'EDUCTRL_CRM') style="display:none;" @endif>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label required-field">Country of Citizenship</label>
                    <select class="form-select" id="country" name="country">
                        <option value="">Select</option>
                        @foreach ($country_list as $key => $value)
                        <option value="{{ $value }}" @if(old('country') == $value) selected @endif>{{ $value }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Date of Birth</label>
                    <input type="text" class="form-control mydatepicker" autocomplete="off" id="dob" name="date_of_birth" value="{{ Request::old('date_of_birth') }}">
                </div>
            </div>
            @endif

            @unless(config('app.product_code') == 'TRAINING')
            <div class="form-group row" id="countries" >
                <label class="col-form-label">Country Interested to Study In</label>
                <div class="col-sm-12 col-md-8">
                <select name="country_pref[]" class="form-select select2" multiple>
                    @foreach($countries as $country)
                    <option  value="{{$country->country}}">{{$country->country}}</option>
                    @endforeach
                </select>
                </div>
            </div>
            @endunless

            @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
            <div class="form-group row " id="qualification" @unless(config('app.product_code')=='OVERSEAS' ) style="display:none;" @endunless>
                <label class="col-form-label">Your Qualification</label>
                <div class="col-sm-12 col-md-8">
                    <select class="form-select" id="qualification" name="qualification">
                        <option value="">Select Qualification</option>
                        <option value="bachelors" {{ Request::old('qualification') == 'bachelors' ? 'selected' : '' }}>Bachelors
                        </option>
                        <option value="masters" {{ Request::old('qualification') == 'masters' ? 'selected' : '' }}>Masters
                        </option>
                    </select>
                </div>
            </div>

            <div class="form-group row " id="csc" @unless(config('app.product_code')=='OVERSEAS' ) style="display:none;" @endunless>
                
                <div class="col-sm-12 col-md-8">
                    <label class="col-form-label">Currently Studying Course</label>
                    <input type="text" class="form-control" id="currently_studying_course" name="currently_studying_course" value="{{ Request::old('currently_studying_course') }}">
                </div>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Work Experience</label>
                    <input type="text" class="form-control" id="work_experience" name="work_experience" value="{{ Request::old('work_experience') }}">
                </div>
            </div>

            <div class="row mb-3" id="scores" @unless(config('app.product_code')=='OVERSEAS' ) style="display:none;" @endunless>
                <div class="col-sm-6 col-md-2">
                    <label class="col-form-label">CGPA</label>
                    <div class="">
                        <input type="text" class="form-control" id="cgpa" name="cgpa" value="{{ Request::old('cgpa') }}">
                    </div>
                </div>
                <div class="col-sm-6 col-md-2">
                    <label class="col-form-label">IELTS</label>
                    <div class="">
                        <input type="text" class="form-control" id="ielts" name="ielts" value="{{ Request::old('ielts') }}">
                    </div>
                </div>
                <div class="col-sm-6 col-md-2">
                    <label class="col-form-label">TOEFL</label>
                    <div class="">
                        <input type="text" class="form-control" id="toefl" name="toefl" value="{{ Request::old('toefl') }}">
                    </div>
                </div>
                <div class="col-sm-6 col-md-2">
                    <label class="col-form-label">PTE</label>
                    <div class="">
                        <input type="text" class="form-control" id="pte" name="pte" value="{{ Request::old('pte') }}">
                    </div>
                </div>
                <div class="col-sm-6 col-md-2">
                    <label class="col-form-label">GRE</label>
                    <div class="">
                        <input type="text" class="form-control" id="gre" name="gre" value="{{ Request::old('gre') }}">
                    </div>
                </div>
                <div class="col-sm-6 col-md-2">
                    <label class="col-form-label">DUOLINGO</label>
                    <div class="">
                        <input type="text" class="form-control" id="duolingo" name="duolingo" value="{{ Request::old('duolingo') }}">
                    </div>
                </div>
            </div>

            <div class="form-group row " id="interested" @unless(config('app.product_code')=='OVERSEAS' ) style="display:none;" @endunless>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label required-field">Interested Study Level</label>
                    <select class="form-select" id="study_level" name="study_level">
                        <option value="">Select Study Level</option>
                        @foreach(get_study_levels() as $key => $value)
                            <option value="{{$key}}" {{(Request::old('study_level') == $key)? 'selected' : ''}}>{{$value}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Course Interested to Study</label>
                    <input type="text" class="form-control" value="{{Request::old('course_interested')}}" id="course_interested" name="course_interested">
                </div>
                <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Intake</label>
                        <select name="intake" class="form-select form-control">
                            <option value="">Intake</option>
                            <?php $month = date('n'); // current month
                             for ($x = 0; $x < 24; $x++) { ?>
                              <option {{(Request::old('intake')==date('m Y', mktime(0,0,0,$month + $x,1)))? 'selected' : ''}} value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                              <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                             <?php } ?></option>
                        </select>
                </div>
            </div>

            <div class="form-group row mt-2 mb-2" id="req" @unless(config('app.product_code')=='OVERSEAS' ) style="display:none;" @endunless>
                <div class="col-sm-4">
                    <label class="col-form-label">Require Accommodation?</label>
                    <select class="form-select" name="accommodation">
                        <option value="">Select </option>
                        <option value="1" {{(Request::old('accommodation') == '1')? 'selected' : ''}}>Yes</option>
                        <option value="0" {{(Request::old('accommodation') == '0')? 'selected' : ''}}>No</option>
                    </select>
                </div>
                <div class="col-sm-4">
                    <label class="col-form-label">Require Study Permit?</label>
                    <select class="form-select" name="study_permit">
                        <option value="">Select </option>
                        <option value="1" {{(Request::old('study_permit') == '1')? 'selected' : ''}}>Yes</option>
                        <option value="0" {{(Request::old('study_permit') == '0')? 'selected' : ''}}>No</option>
                    </select>
                </div>
                <div class="col-sm-4">
                    <label class="col-form-label">Require Education Loan?</label>
                    <select class="form-select" name="education_loan">
                        <option value="">Select </option>
                        <option value="1" {{(Request::old('education_loan') == '1')? 'selected' : ''}}>Yes</option>
                        <option value="0" {{(Request::old('education_loan') == '0')? 'selected' : ''}}>No</option>
                    </select>
                </div>                
            </div>
            @endif

            <div class="form-group row">
                <label class="col-form-label">Notes</label>
                <div class="col-sm-12 col-md-8">
                    <textarea class="form-control" name="note">{{ Request::old('note') }}</textarea>
                </div>
            </div>


            <div class="form-group row" id="">
                <div class="col-sm-12">
                    <label class="col-form-label required-field">Assign To Staff</label>
                    <div class="col-md-8">
                        <select class="form-select" id="assign_to" name="assign_to" required="required">
                            <option value="">Select Staff</option>
                            @foreach($staff as $stf)
                            <option {{($stf->id == Request::old('assign_to'))? 'selected' : ''}} value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            <div class="row" style="margin-top:10px;">
                <div class="col-sm-12 col-md-8 text-center">
                    <div class="form-group mb-0 clearfix">
                        {{ form_submit("Create Lead") }}
                    </div>
                </div>
            </div>
        </div>
        </form>

    </div>
</div>
@endsection

@push ('after-styles')
<style>
    .select2-container .select2-selection--single {
        height: 33px !important;
    }
</style>
@endpush

@push('after-scripts')
<script>
    $(document).ready(function() {
        $("#countries").hide();
        $("#leadtype").change(function(e) {
            e.preventDefault();
            if (this.value == 'Coaching') {
                $("#course").show();
                $("#countries").hide();
                $("#qualification,#csc,#interested,#coc,#req,#countries").hide();
                $('#country,#study_level').removeAttr("required");
                $("#scores").hide();
            } else if (this.value == 'Study Abroad') {
                $("#course").hide();
                ////$("#courses").removeAttr('required');
                $("#countries").show();
                $("#qualification,#csc,#interested,#coc,#req,#countries").show();
                $('#country,#study_level').attr("required","required");
                $("#scores").show();
            } else if(this.value == 'Study Abroad & Coaching') {
                $("#course").show();
                $("#countries").show();
                $("#qualification,#csc,#interested,#coc,#req,#countries").show();
                $('#country,#study_level').attr("required","required");
                $("#scores").show();
                ////$("#courses").removeAttr('required');
            }
        });

        // $('#batches').hide(); //initially dropdown is hidden
        // $('#checkbox').change(function() { //change click to hidden

        //     if ($(this).is(':checked')) { //check if checkbox is checked
        //         $('#batches').show(); //show if checked
        //     } else {
        //         $('#batches').hide(); //hide if unchecked
        //     }

        // });

    });
</script>
@endpush