@extends('backend.layouts.app')
@section('title', "Edit Lead")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Edit Lead
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.counsellingdetails') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->
        {{ html()->form('POST', route('admin.counselling.update', $leaddata->id))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
        <!-- 
        <div class="form-group row mb-2">
            <div class="col-sm-12">
                <label class="col-form-label required-field">Title:</label>
                <input type="radio" class="radio-col-blue" id="radio_1" name="title" value="Mr." {{ $leaddata->title == 'Mr.' ? 'checked' : '' }} />
                <label for="radio_1">Mr.&nbsp;</label>

                <input type="radio" class="radio-col-blue" id="radio_2" name="title" value="Ms." {{ $leaddata->title == 'Ms.' ? 'checked' : '' }} />
                <label for="radio_2">Ms.&nbsp;</label>

                <input type="radio" class="radio-col-blue" id="radio_3" name="title" value="Mrs." {{ $leaddata->title == 'Mrs.' ? 'checked' : '' }} />
                <label for="radio_3">Mrs.&nbsp;</label>

                <input type="radio" class="radio-col-blue" id="radio_4" name="title" value="Dr." {{ $leaddata->title == 'Dr.' ? 'checked' : '' }} />
                <label for="radio_4">Dr.&nbsp;</label>

                <input type="radio" class="radio-col-blue" id="radio_5" name="title" value="Prof." {{ $leaddata->title == 'Prof.' ? 'checked' : '' }} />
                <label for="radio_5">Prof.</label>
            </div>
        </div> -->

        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label required-field">First Name</span></label>
                <div class="">
                    <input type="text" class="form-control" name="fname" value="{{ $leaddata->first_name }}" required>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Last Name</label>
                <div class="">
                    <input type="text" class="form-control" name="lname" value="{{ $leaddata->last_name }}">
                </div>
            </div>
        </div>

        <div class="form-group row mt-2 mb-2">
            <div class="col-sm-12">
                <label class="col-form-label required-field">Gender</label>
                <input type="radio" class="radio-col-blue" id="radio_1" name="gender" value="Male" {{ ($leaddata->gender == 'Male') ? 'checked' : ''}} required />
                <label for="radio_1">Male</label>

                <input type="radio" style="margin-left:8px;" class="radio-col-blue" id="radio_2" name="gender" value="Female" {{ ($leaddata->gender == 'Female') ? 'checked' : '' }} required />
                <label for="radio_2">Female</label>
            </div>
        </div>

        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label required-field">Email</label>
                <div class="">
                    <input type="text" class="form-control" name="email" value="{{ $leaddata->email }}" required>
                </div>
            </div>
            <div class="col-sm-12 col-md-3">
                <label class="col-form-label">Mobile No.</label>
                
                    <div class="input-group-prepend">
                        <select class="form-select" name="dialcode">
                            <option value=''>Dialcode</option>
                            @foreach($dialcodes as $dialcode)
                            <option {{($dialcode->code == $leaddata->dialcode)? 'selected' : ''}} value="{{$dialcode->code}}">{{$dialcode->code}}</option>
                            @endforeach
                        </select>
                    </div>
                    <input type="text" class="form-control" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" name="mobile" value="{{$leaddata->mobile}}" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}">
                </div>
            </div>
            <div class="col-sm-12 col-md-3">
                <label for="alternate_contact" class="col-form-label">Alternate Contact</label>
                <div class="">
                    <input type="text" id="alternate_contact" maxlength="50" class="form-control" name="alternate_contact" value="{{$leaddata->alternate_contact}}">
                </div>
            </div>
        </div>
        <div class="form-group row">
                <div class="col-sm-12 col-md-6">
                    <label for="whatsapp_number" class="col-form-label">Whatsapp No.</label>
                    <div class="">
                        <input type="text" id="whatsapp_number" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" class="form-control" name="whatsapp_number" value="{{$leaddata->whatsapp}}">
                    </div>
                </div>
            </div>

        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-3">
                <label for="address" class="col-form-label">City/Location</label>
                <div class="">
                    <input type="text" id="address" class="form-control" name="address" value="{{ $leaddata->address }}">
                </div>
            </div>
            <div class="col-sm-12 col-md-2">
                <label class="col-form-label">Lead Source</label>
                <div class="">
                    <select class="form-select" id='lead_source' name="lead_source">
                        <option value=''>Select</option>
                        @foreach(get_lead_sources() as $source_data)
                        <option {{$source_data == $leaddata->lead_source ? 'selected' : ''}} value="{{$source_data}}">{{ucfirst($source_data)}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-sm-12 col-md-5">
                <div class="form-group">
                    <label for="address" class="col-form-label">Source Details</label>
                    <div class="">
                        <input type="text" class="form-control" name="lead_source_detail" value="{{ $leaddata->lead_source_detail }}">
                    </div>
                </div>
            </div>
        </div>


        @if(config('app.product_code') == 'EDUCTRL_CRM')
        <div class="form-group row mb-3">
            <label class="col-form-label">Lead Type</label>
            <div class="col-sm-12 col-md-8">
                <select class="form-select" id="leadtype" name="leadtype" disabled>
                    <option value="">Select</option>
                    @foreach(get_lead_types() as $lead_type)
                    <option value="{{$lead_type}}" {{$lead_type == $leaddata->lead_type ? 'selected' : ''}}>{{$lead_type}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        @endif

        <div class="form-group row" id="branch">
            <label class="col-form-label">Branch</label>
            <div class="col-sm-12 col-md-8">
                <select class="form-select" id="branch" name="branch">
                    <option value="">Select Branch</option>
                    @foreach($branch as $branches)
                    <option {{$branches->id == $leaddata->branch ? 'selected' : ''}} value="{{ $branches->id }}">{{ $branches->branch_name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="form-group row mb-3" id="course" @unless(config('app.product_code')=='TRAINING' ) style="display:none;" @endunless>
            <label class="col-form-label">Course Interested in</label>
            <div class="col-sm-12 col-md-8">
                <select class="form-select" id="courses" name="course">
                    <option value="">Select Course</option>
                    @foreach($courses as $course)
                    <option value="{{ $course->id }}" @if ($leaddata->course == $course->id) selected="selected" @endif>{{ $course->title }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="form-group row" id="coc" @unless($leaddata->lead_type =='Study Abroad' || $leaddata->lead_type =='Study Abroad & Coaching' ) style="display:none;" @endunless>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Country of Citizenship</label>
                <select class="form-select" id="country" name="country">
                    <option value="">Select</option>
                    @foreach ($country_list as $key => $value)
                    <option value="{{ $value }}" @if($leaddata->country == $value) selected @endif>{{ $value }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Date of Birth</label>
                <input type="text" class="form-control mydatepicker" autocomplete="off" id="dob" name="date_of_birth" value="{{date('d-m-Y', strtotime($leaddata->date_of_birth))}}">
            </div>
        </div>

        <div class="form-group row " id="csc" @unless($leaddata->lead_type =='Study Abroad' || $leaddata->lead_type =='Study Abroad & Coaching' ) style="display:none;" @endunless>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Currently Studying Course</label>
                <input type="text" class="form-control" id="currently_studying_course" name="currently_studying_course" value="{{ $leaddata->current_course}}">
            </div>
            <div class="col-sm-12 col-md-4">
                    <label class="col-form-label">Work Experience</label>
                    <input type="text" class="form-control" id="work_experience" name="work_experience" value="{{ $leaddata->work_experience }}">
            </div>
        </div>

        <div class="form-group row " id="cits" @unless($leaddata->lead_type !='Study Abroad' || $leaddata->lead_type !='Study Abroad & Coaching') style="display:none;" @endunless>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Interested Study Level</label>
                <select class="form-select" id="study_level" name="study_level">
                    <option value="">Select Study Level</option>
                    @foreach(get_study_levels() as $key => $value)
                    <option value="{{$key}}" {{($leaddata->study_level == $key)? 'selected' : ''}}>{{$value}}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Course Interested to Study</label>
                <input type="text" class="form-control" value="{{$leaddata->course_interested}}" id="course_interested" name="course_interested">
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Intake</label>
                    <select name="intake" class="form-select form-control">
                        <option value="">Intake</option>
                        <?php $month = date('n'); // current month
                         for ($x = 0; $x < 24; $x++) { ?>
                          <option {{($leaddata->intake_month.' '.$leaddata->intake_year==date('m Y', mktime(0,0,0,$month + $x,1)))? 'selected' : ''}} value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                          <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                         <?php } ?></option>
                    </select>
            </div>
        </div>

        <div class="form-group row mt-2 mb-2" id="req" @unless($leaddata->lead_type =='Study Abroad' || $leaddata->lead_type =='Study Abroad & Coaching') style="display:none;" @endunless>
            <div class="col-sm-4">
                <label class="col-form-label">Require Accommodation?</label>
                <select class="form-select" name="accommodation">
                    <option value="">Select </option>
                    <option value="1" {{($leaddata->accommodation == '1')? 'selected' : ''}}>Yes</option>
                    <option value="0" {{($leaddata->accommodation == '0')? 'selected' : ''}}>No</option>
                </select>
            </div>
            <div class="col-sm-4">
                <label class="col-form-label">Require Study Permit?</label>
                <select class="form-select" name="study_permit">
                    <option value="">Select </option>
                    <option value="1" {{($leaddata->study_permit == '1')? 'selected' : ''}}>Yes</option>
                    <option value="0" {{($leaddata->study_permit == '0')? 'selected' : ''}}>No</option>
                </select>
            </div>
            <div class="col-sm-4">
                <label class="col-form-label">Require Education Loan?</label>
                <select class="form-select" name="education_loan">
                    <option value="">Select </option>
                    <option value="1" {{($leaddata->education_loan == '1')? 'selected' : ''}}>Yes</option>
                    <option value="0" {{($leaddata->education_loan == '0')? 'selected' : ''}}>No</option>
                </select>
            </div>
        </div>


        <div class="form-group row mb-3" id="countries" @unless(config('app.product_code')=='OVERSEAS' ) style="display:none;" @endunless>
            <label class="col-form-label">Country Interested to Study In</label>
            <div class="col-sm-12 col-md-8" style="height: 120px;overflow-y:scroll">
                @foreach($countries as $country)
                <input type="checkbox" id="country_pref" name="country_pref[]" value="{{$country->country}}" @if (strpos($leaddata->country_pref, $country->country) !== false) checked @endif> <label>{{$country->country}}</label><br>
                @endforeach
            </div>
        </div>

        <div class="form-group row mb-2" id="qualification" @unless(config('app.product_code')=='OVERSEAS' ) style="display:none;" @endunless>
            <label class="col-form-label">Your Qualification</label>
            <div class="col-sm-12 col-md-8">
                <select class="form-select" id="qualification" name="qualification">
                    <option value="">Select Qualification</option>
                    <option value="bachelors" {{ $leaddata->qualification == 'bachelors' ? 'selected' : '' }}>Bachelors
                    </option>
                    <option value="masters" {{ $leaddata->qualification == 'masters' ? 'selected' : '' }}>Masters
                    </option>
                </select>
            </div>
        </div>

        <div class="row mb-3" id="scores" @unless($leaddata->lead_type =='Study Abroad' || $leaddata->lead_type =='Study Abroad & Coaching' ) style="display:none;" @endunless>
            <div class="col-sm-6 col-md-2">
                <label class="col-form-label">CGPA</label>
                <div class="">
                    <input type="text" class="form-control" id="cgpa" name="cgpa" value="{{ $leaddata->cgpa }}">
                </div>
            </div>
            <div class="col-sm-6 col-md-2">
                <label class="col-form-label">IELTS</label>
                <div class="">
                    <input type="text" class="form-control" id="ielts" name="ielts" value="{{ $leaddata->ielts }}">
                </div>
            </div>
            <div class="col-sm-6 col-md-2">
                <label class="col-form-label">TOEFL</label>
                <div class="">
                    <input type="text" class="form-control" id="toefl" name="toefl" value="{{ $leaddata->toefl }}">
                </div>
            </div>
            <div class="col-sm-6 col-md-2">
                <label class="col-form-label">PTE</label>
                <div class="">
                    <input type="text" class="form-control" id="pte" name="pte" value="{{ $leaddata->pte }}">
                </div>
            </div>
             <div class="col-sm-6 col-md-2">
                    <label class="col-form-label">GRE</label>
                    <div class="">
                        <input type="text" class="form-control" id="gre" name="gre" value="{{ $leaddata->gre }}">
                    </div>
                </div>
                <div class="col-sm-6 col-md-2">
                    <label class="col-form-label">DUOLINGO</label>
                    <div class="">
                        <input type="text" class="form-control" id="duolingo" name="duolingo" value="{{ $leaddata->duolingo }}">
                    </div>
                </div>
        </div>


        <div class="form-group row mb-3">
            <label class="col-form-label">Notes</label>
            <div class="col-sm-12 col-md-8">
                <textarea class="form-control" name="note">{{$leaddata->description}}</textarea>
            </div>
        </div>

        <div class="row" style="margin-top:10px;">
            <div class="col-sm-12 col-md-8 text-center">
                <div class="form-group mb-0 clearfix">
                    {{ form_submit("Save") }}
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'">Cancel</button>
                </div>
            </div>
        </div>


    </div>
</div>
@endsection