@extends('backend.layouts.app')
@section('title', "View Lead")
@section('content')
<!--   not used -->

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    {{ $leaddatas->title }} {{ $leaddatas->first_name}} {{ $leaddatas->last_name}}
                </h4>
                <h5>{{$leaddatas->email}}</h5>
                <h5>{{$leaddatas->mobile }}</h5>
                <br />
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.leadmanagementdetails') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->

        @if(config('app.product_code') == 'EDUCTRL_CRM')
        <div class="form-group row mb-2">
            <label class="col-sm-3">Lead Type</label>
            <div class="col-sm-6">
                <label id="leadtype" name="leadtype">
                    <strong>{{ $leaddatas->lead_type }}</strong>
                </label>
            </div>
        </div>
        @endif

        <div class="form-group row mb-2">
            <label for="address" class="col-sm-3">City/Location</label>
            <div class="col-sm-6">
                <label name="address"><strong>{{ $leaddatas->address ? $leaddatas->address : '-' }}</strong>
                </label>
            </div>
        </div>


        @if($leaddatas->lead_type =='Coaching' || $leaddatas->lead_type =='Both')
        <div class="form-group row mb-2" id="course">
            <label class="col-sm-3">Course Interested in</label>
            <div class="col-sm-6">
                <label>
                    <strong>{{ $coursevalues ? $coursevalues->title : '-'}}</strong>
                </label>
            </div>
        </div>
        @endif

        @if($leaddatas->lead_type =='Study Abroad' || $leaddatas->lead_type =='Both')
        <div class="form-group row mb-2" id="country">
            <label class="col-sm-3">Country Interested in</label>
            <div class="col-sm-6">
                <label id="country" name="country">
                    <strong>{{ $leaddatas->country ? $leaddatas->country : '-' }}</strong>
                </label>
            </div>
        </div>

        <div class="form-group row mb-2" id="qualification">
            <label class="col-sm-3">Qualification</label>
            <div class="col-sm-6">
                <label id="qualification" name="qualification">
                    <strong>{{ $leaddatas->qualification }}</strong>
                </label>
            </div>
        </div>

        <div class="form-group row mb-2" id="cgpa">
            <label class="col-sm-3">CGPA</label>
            <div class="col-sm-6">
                <label id="cgpa" name="cgpa"><strong>{{ $leaddatas->cgpa }}</strong>
                </label>
            </div>
        </div>

        <div class="form-group row mb-2" id="ielts">
            <label class="col-sm-3">IELTS</label>
            <div class="col-sm-6">
                <label id="ielts" name="ielts"><strong>{{$leaddatas->ielts}}</strong>
                </label>
            </div>
        </div>

        <div class="form-group row mb-2" id="toefl">
            <label class="col-sm-3">TOEFL</label>
            <div class="col-sm-6">
                <label id="toefl" name="toefl"><strong>{{$leaddatas->toefl}}</strong>
                </label>
            </div>
        </div>

        <div class="form-group row mb-2" id="pte">
            <label class="col-sm-3">PTE</label>
            <div class="col-sm-6">
                <label id="pte" name="pte"><strong>{{$leaddatas->pte}}</strong>
                </label>
            </div>
        </div>
        @endif

        <div class="form-group row mb-2">
            <label class="col-sm-3">Lead Source</label>
            <div class="col-sm-6">
                <label><strong>{{$leaddatas->lead_source ? ucfirst($leaddatas->lead_source) : '-'}} @if($leaddatas->lead_source && $leaddatas->source) ({{$leaddatas->source}}) @endif</strong></label>
            </div>
        </div>
            
        <div class="form-group row mb-2">
            <label class="col-sm-3">Description</label>
            <div class="col-sm-6">
                <label><strong>{!!$leaddatas->description ? $leaddatas->description : '-'!!}</strong></label>
            </div>
        </div>

        <p class="text-muted mt-3">Created at {{$leaddatas->created_at}} by {{get_user_full_name_by_id($leaddatas->created_by)}}</p>

    </div>
</div>
@endsection