@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')
<div class="row">
    <div class="col" style="margin-bottom:10px;">
        <h4 style="">Settings</h4>
    </div>
</div>

<div class="row">


    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <!-- Bordered Tabs -->
                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('leads-settings')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general active show" id="banners">

                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Add New Status</h4>
                                                <form action="{{route('admin.lead-status.save')}}" method="post" enctype="multipart/form-data">
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-sm-12 col-md-12">
                                                            <div class="form-group mb-3">
                                                                <label class="required-field"><b>Status Name</b></label>
                                                                <input type="text" class="form-control" name="status_name" maxlength="200" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-sm-12 col-md-12">
                                                            <div class="form-group mb-3">
                                                                <label class="required-field"><b>Type</b></label>
                                                                <input class="form-check-input" type="radio" value='none' id="none" name="type" required checked>
                                                                <label class="form-check-label" for="none">
                                                                    None&nbsp;&nbsp;
                                                                </label>
                                                                <input class="form-check-input" type="radio" value='default' id="default" name="type" required>
                                                                <label class="form-check-label" for="default">
                                                                    Default&nbsp;&nbsp;
                                                                </label>
                                                                <input class="form-check-input" type="radio" value='counselling' id="counselling" name="type" required>
                                                                <label class="form-check-label" for="counselling">
                                                                    Counselling&nbsp;&nbsp;
                                                                </label>
                                                                <input class="form-check-input" type="radio" value='converted' id="converted" name="type" required>
                                                                <label class="form-check-label" for="converted">
                                                                    Converted&nbsp;&nbsp;
                                                                </label>
                                                                <input class="form-check-input" type="radio" value='disqualified' id="disqualified" name="type" required>
                                                                <label class="form-check-label" for="disqualified">
                                                                    Disqualified&nbsp;&nbsp;
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-sm-12 col-md-6">
                                                            <div class="form-group mb-3">
                                                                <label class="required-field"><b>Color</b></label>
                                                                <input type="text" autocomplete="off" class="form-control colorPicker" name="color" required />
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-12 col-md-6">
                                                            <div class="form-group mb-3">
                                                                <label class="required-field"><b>Display Order</b></label>
                                                                <input type="number" class="form-control" name="display_order" value="99" required />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="text-center">
                                                        <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-12">
                                        <hr>
                                        <h4>Lead Status List</h4>

                                        <div class="table-responsive">
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th>Status</th>
                                                        <th>Default</th>
                                                        <th>Counselling</th>
                                                        <th>Converted</th>
                                                        <th>Disqualified</th>
                                                        <th>Display Order</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($status as $stat)
                                                    <?php
                                                    if ($stat->default == 0) {
                                                        $def = "";
                                                    } else {
                                                        $def = "Yes";
                                                    }
                                                    if ($stat->counselling_status == 0) {
                                                        $coun = "";
                                                    } else {
                                                        $coun = "Yes";
                                                    }
                                                    if ($stat->converted_status == 0) {
                                                        $conv = "";
                                                    } else {
                                                        $conv = "Yes";
                                                    }
                                                    if ($stat->disqualified_status == 0) {
                                                        $dis = "";
                                                    } else {
                                                        $dis = "Yes";
                                                    }
                                                    ?>
                                                    <tr>
                                                        <td><span class="tag" style="background-color:{{$stat->colorcode}} !important">{{$stat->status}}</span></td>
                                                        <td>{{$def}}</td>
                                                        <td>{{$coun}}</td>
                                                        <td>{{$conv}}</td>
                                                        <td>{{$dis}}</td>
                                                        <td>{{$stat->display_order}}</td>
                                                        <td>
                                                            <a href="" id="editStatus" data-toggle="modal" data-target='#practice_modal' data-id="{{ $stat->id }}" data-order="{{$stat->display_order}}" data-color="{{$stat->colorcode}}"><i class='fas fa-edit text-primary' style='font-size:17px'></i></a>&nbsp;
                                                            <a href="{{ route('admin.removeLeadStatus', $stat->id)}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure?"><i class='fas fa-trash-alt text-danger' style='font-size:17px'></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <p class="">
                                            Notes:
                                            <br />* 'Default', 'Converted', 'Disqualified' statuses are required for proper functioning of Leads feature.
                                            <br />* When a Student registers with the email id existing in Leads database, that lead is auto updated as Converted.
                                        </p>

                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <hr>
                                        <h4>Lead Sources</h4>
                                        <form method="post" action="{{route('admin.leads-settings.update')}}">
                                            @csrf
                                            <div class="form-group">
                                                <label class="required-field">Lead Sources</label>
                                                <input type="text" class="form-control" name="lead_sources" value="{{get_site_config('lead_sources')}}" required>
                                                <p class="small">Enter comma seperated values</p>
                                            </div>
                                            <h4>Automated Email to Leads</h4>
                                            <div class="form-group">
                                                <input type="checkbox" class="" name="lead_welcome_email_web2lead" value="1" @if(get_site_config('lead_welcome_email_web2lead')) checked @endif> <label class="">Send Welcome email to leads received through Web to Lead forms</label>
                                            </div>
                                            <div class="form-group">
                                                <input type="checkbox" class="" name="lead_welcome_email_lead_create" value="1" @if(get_site_config('lead_welcome_email_lead_create')) checked @endif> <label class="">Send Welcome email to leads added from Admin panel</label>
                                            </div>
                                            <p class="small">&nbsp;&nbsp;&nbsp;&nbsp;<a target="_blank" href="{{route('admin.mailtemplates.edit','LEAD_WELCOME')}}"><i class="fa fa-edit"></i>Edit Welcome email template</a></p>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary btn-sm">Update</button>
                                    </div>
                                    </form>
                                </div>
                            </div>


                        </div>

                    </div><!-- End Bordered Tabs -->

                </div>
            </div>
        </div>
    </div>
</div>
</div>


<div class="modal fade" id="status_update_modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Status</h5>

                <button type="button" class="btn btn-sm btn-outline-dark" data-bs-dismiss="modal">&times;</button>
            </div>
            <form id="statusDataForm" method="POST" action="{{route('admin.lead-status.update')}}">
                @csrf
                <input type="hidden" id="status_id" name="status_id" value="">
                <div class="modal-body">
                    <span class="label"><b>Color</b></span>
                    <input type="text" autocomplete="off" name="color" id="color" value="" class="form-control colorPicker" required>
                    <span class="label"><b>Display Order</b></span>
                    <input type="number" autocomplete="off" name="display_order" id="display_order" value="" class="form-control" required>
                    <div class="row">
                        <div class="col text-center">
                            <button type="submit" class="btn btn-md btn-success" style="font-size: 0.9em;">Update</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </div>
</div>
@endsection

@push('after-scripts')
<script>
    addDeleteForms();
    $('body').on('click', '#editStatus', function(event) {

        event.preventDefault();
        var id = $(this).data('id');
        var order = $(this).data('order');
        var color = $(this).data('color');
        $('#status_update_modal').modal('show');
        $('#status_id').val(id);
        $('#color').val(color);
        $('#display_order').val(order);

    });
</script>
@endpush