@extends('backend.layouts.app')

@section('title', "Country Information Management")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <h4 class="card-title mb-0">
                    Country Information Management
                    <small class="text-muted">Create folders, upload documents</small>
                </h4>
            </div><!--col-->
        </div><!--row-->    

        <div class="row">
            <div class="col-md-12">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                  <li class="nav-item" role="presentation">
                    <button class="nav-link " id="folders-tab" data-bs-toggle="tab" data-bs-target="#folders" type="button" role="tab" aria-controls="folders" aria-selected="true"><i class="bi bi-folder-fill"></i> <b>Add Folder</b></button>
                  </li>
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="docs-tab" data-bs-toggle="tab" data-bs-target="#docs" type="button" role="tab" aria-controls="docs" aria-selected="false"><i class="bi bi-file-earmark-fill"></i> <b>Add Document</b></button>
                  </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                  <div class="tab-pane fade show " id="folders" role="tabpanel" aria-labelledby="folders-tab">
                      @include('backend.countryinfo.tabs.folders')
                  </div>
                  <div class="tab-pane fade" id="docs" role="tabpanel" aria-labelledby="docs-tab">
                       @include('backend.countryinfo.tabs.docs')
                  </div>
                </div>

              
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <br />
                <strong class="">You are Here: 
                    <?php
                    $level = count($folder_breadcrumb);
                    for ($i = $level - 1; $i >= 0; $i--) {
                        if ($i != $level - 1) {
                            echo " > ";
                        }
                        echo "<a class=\"links\" href=\"" . route('admin.countryinfo') . "/" . $folder_breadcrumb[$i]['id'] . "\">" . $folder_breadcrumb[$i]['name'] . "</a>";
                    }
                    ?>

                </strong>
                <br />
                <br />
                <h5>Folders</h5>
            </div>
        </div>          

        <div class="row">
            @foreach($folders as $folder)
            <div class="col-sm-12 col-md-4">
                <p style="padding:15px;border:1px solid #ccc;">
                    <span><img style="height: 70px; width:70px;" src="{!!$folder['image'] ? asset('storage/'.$folder['image']) : asset('assets/images/page/study.jpg')!!}"></span>
                    <span style="font-size: 1.2em;font-weight: bold;text-decoration: underline"><a href="<?php echo route('admin.countryinfo') . "/" . $folder['id']; ?>">{{ $folder['name'] }}</a></span>
                    @if($folder['sharing'] == 'private')
                    <span><i class="ri-lock-fill"></i></span>
                    @elseif($folder['sharing'] == 'member')
                    <span><i class="ri-user-3-fill"></i></span>
                    @else
                    <span><i class="ri-lock-unlock-fill"></i></span>
                    @endif
                    <br /><span style="color:#F40080"><i class="ri-close-fill"></i> <a href="<?php echo route('admin.countryinfo.removefolder', $folder['id']); ?>" onclick="if (confirm('Delete selected item?')) {
                                return true;
                            } else {
                                event.stopPropagation();
                                event.preventDefault();
                            }
                            ;">Remove</a></span>
                </p>
            </div>
            @endforeach
        </div>

        @if($current_folder > 0)
        <div class="row m-t-30">
            <div class="col-md-12">
                <h5>Documents</h5>
                @foreach($docs as $doc)
                <p style="padding:0px 20px 10px 10px;">
                    <span style="font-size: 1.2em;font-weight: bold;"><a href="{{ $doc['file'] }}">{{ $doc['title'] }}</a></span>
                    @if(strlen($doc['description']))
                    <br />{{ $doc['description'] }}
                    @endif
                    <br /><span style="color:#F40080"><i class="fa fa-times"></i> <a href="<?php echo route('admin.countryinfo.removedoc', $doc['id']); ?>" onclick="if (confirm('Delete selected item?')) {
                                return true;
                            } else {
                                event.stopPropagation();
                                event.preventDefault();
                            }
                            ;">Remove</a></span>
                </p>
                @endforeach            
            </div>
        </div>
        @endif

            <div class="alert alert-warning" role="alert">
                <strong>Notes:</strong></br />
                This information is visible to students in <b>Student Menu > Country Information</b> (If Country Information enabled in Settings > Modules > Student Area > Study Abroad)
                <hr>
                <strong>Access Permission:</strong></br />
                <i class="fa fa-lock"></i> Private -> Only explicitly allowed students can access<br />
                <i class="fa fa-user"></i> Members -> All students can access<br />
                <i class="fa fa-unlock"></i> Public -> All students can access<br />
            </div>
    </div>
</div>
@endsection