@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('country-settings')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade general show active" id="country-settings">
                                <div class="row">
                                    <div class="col-9">
                                        <h3>{{$state}}</h3>
                                    </div>
                                    <div class="col-3">
                                        <button class='btn btn-primary btn-sm ms-3' id="" data-bs-toggle='modal' data-bs-target='#add-city'><i class="fa fa-plus"></i> Add City</button>
                                        <a href="{{route('admin.view-country.state', get_country_by_state_id($state_id))}}" title="Back" class="btn btn-sm btn-outline-primary"><i class="fa fa-reply"></i></a>
                                    </div>
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table class="table" id="city_list">
                                                <thead>
                                                    <tr>
                                                        <th data-orderable="false">
                                                            <div class="form-check form-check-sm form-check-custom form-check-solid ms-2">
                                                                <input class="form-check-input" type="checkbox" id="check_all" name="check_all" />
                                                            </div>
                                                        </th>
                                                        <th>City</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                            <div class="col-md-3 col-sm-12 process-selected mx-3" id="bulk_operation">
                                                <select class="form-select" name="bulk_enabled_disable" id="bulk_enabled_disable">
                                                    <option value="">- Bulk Actions -</option>
                                                    <option value="bulk_enabled">Enable</option>
                                                    <option value="bulk_disabled">Disable</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade " tabindex="-1" id="add-city" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-body">
            <form method="post" action="{{route('admin.add.state.city')}}" id="">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Add City for {{$state}}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="add_state_id" value="{{$state_id}}" id="add_state_id">
                        <div class="form-group">
                            <label class="required-field"><b>New City</b></label>
                            <input type="text" name="city" placeholder="New State" class="form-control required-field" value="" maxlength="50" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary w-25 mx-auto">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade " tabindex="-1" id="edit_state_modal" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-body">
            <form method="post" action="{{route('admin.view-state.city.edit.update')}}" id="">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit City</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="city_id" value="" id="city_id">
                        <input type="hidden" name="state_id" value="" id="state_id">
                        <div class="form-group">
                            <label class="required-field"><b>City</b></label>
                            <input type="text" name="city" placeholder="New State" id="new-city" class="form-control required-field" value="" maxlength="50" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary w-25 mx-auto">Update</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }
        loadData();

        $(document).on('click', '.edit-city', function() {
            $('#new-city').val($(this).data('city'));
            $('#city_id').val($(this).data('city_id'));
            $('#state_id').val($(this).data('state_id'));
        });

        $("#check_all").on("click", function() {
            if ($("input:checkbox[name='check_all']").prop("checked")) {
                $("input:checkbox[name='multiselect']").prop("checked", true);
            } else {
                $("input:checkbox[name='multiselect']").prop("checked", false);
            }
            checkboxCheckSelected();
        });

        function checkboxCheckSelected() {
            var total_check_boxes = $("input:checkbox[name='multiselect']").length;
            var total_checked_boxes = $("input:checkbox[name='multiselect']:checked").length;
            if (total_check_boxes === total_checked_boxes) {
                $("#check_all").prop("checked", true);
            } else {
                $("#check_all").prop("checked", false);
            }
            // if (total_checked_boxes > 0) {
            //     $(".process-selected").show();
            // } else {
            //     $(".process-selected").hide();
            // }
        }

        function clearSelectedCheckboxs() {
            $("#check_all").prop("checked", false);
            // $(".process-selected").hide();
        }

        $('#bulk_enabled_disable').on('change', function() {
            // Checking with selected empty or not
            var dataArray = new Array();
            $("input:checkbox[name=multiselect]:checked").each(function() {
                dataArray.push($(this).val());
            });
            if(dataArray.length == 0){
                alert("Please select at-least one State!");
                $('#bulk_enabled_disable').val("");
                return;
            }

            if (this.value == 'bulk_enabled') {
                processBulkEnableState();
            }
            if (this.value == 'bulk_disabled') {
                processBulkDisableState();
            }
        });

        function processBulkEnableState() {
            var dataArray = new Array();
            $("input:checkbox[name=multiselect]:checked").each(function() {
                dataArray.push($(this).val());
            });
            var sub_options = {
                url: "{{route('admin.setting.cities.bulkEnableDisable')}}",
                method: "POST",
                data: {
                    'id_arr': dataArray,
                    'states_status': "1",
                    '_token': $('meta[name="csrf-token"]').attr('content')
                }
            };
            manual_form_submit(sub_options);
        }

        function processBulkDisableState() {
            var dataArray = new Array();
            $("input:checkbox[name=multiselect]:checked").each(function() {
                dataArray.push($(this).val());
            });
            var sub_options = {
                url: "{{route('admin.setting.cities.bulkEnableDisable')}}",
                method: "POST",
                data: {
                    'id_arr': dataArray,
                    'states_status': "0",
                    '_token': $('meta[name="csrf-token"]').attr('content')
                }
            };
            manual_form_submit(sub_options);
        }

        function manual_form_submit(options) {
            var $form = $("<form />");
            $form.attr("action", options.url);
            $form.attr("method", options.method);
            for (var data in options.data){
                $form.append('<input type="hidden" name="' + data + '" value="' + options.data[data] + '" />');
                $form.append('<input type="hidden" name="state_id" value="{{$state_id}}" id="state_id" />');
            }
            $("body").append($form);
            $form.submit();
        }
    });

    function loadData() {
        $('#city_list').DataTable({
            processing: true,
            serverSide: true,
            language: {
                searchPlaceholder: "Search By City Name..."
            },
            autoWidth: true,
            responsive: true,
            lengthMenu: [25, 50, 100],
            "ajax": {
                "url": "{{route('admin.ajaxcitylist')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'state_id': '{{$state_id}}'
                },
            },
            'order': [
                1, "asc"
            ],
            "drawCallback": function( settings ) {
                addDeleteForms();            
            },
            columns: [{
                    data: 'id'
                },
                {
                    data: 'city'
                },
                {
                    data: 'status',
                },
                {
                    data: 'actions',
                    orderable: false,
                    searchable: false
                }
            ],
            columnDefs: [{
                    targets: 0,
                    orderable: false,
                    render: function(data) {
                        if (data != '') {
                            return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" onclick="javascript:checkboxCheckSelected();" name="multiselect" type="checkbox" value="${data}" />
                                </div>`;
                        } else {
                            return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" name="multiselectd" type="checkbox" value="" disabled />
                                </div>`;
                        }
                    }
                },
            ],
        });
    }
</script>
@endpush