@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')


<div class="row">


    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('country-settings')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general show active" id="country-settings">

                                <div class="row">
                                    <div class="col">
                                        <h4>Study Overseas Country List</h4>
                                        Enable the countries to which you are processing Study Abroad applications.<br />
                                        In Course Preferences, only enabled countries will be shown.
                                        <br />
                                        <br />
                                        <div class="table-responsive">
                                            <table class="table" id="country_list">
                                                <thead>
                                                    <tr>
                                                        <th>Country</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>

                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- End Bordered Tabs -->
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }
        loadData();
    });

    function changeStatus(country) {
        $.ajax({
            url: "change-country-status/" + country,
            method: "GET",
            success: function(data) {
                alert(data);
                $("#country_list").dataTable().fnDestroy();
                loadData();
            }
        });
    }

    function loadData() {
        $('#country_list').DataTable({
            processing: true,
            serverSide: true,
            language: {
                searchPlaceholder: "Search By Country Name"
            },
            autoWidth: true,
            responsive: true,
            lengthMenu: [25, 50, 100],
            "ajax": {
                "url": "{{route('admin.ajaxcountrylist')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
            },
            'order': [
                0, "asc"
            ],
            columns: [{
                    data: 'country'
                },
                {
                    data: 'status'
                },
                {
                    data: 'actions',
                    orderable: false,
                    searchable: false
                }
            ],
        });
    }
</script>
@endpush