@extends('backend.layouts.app')

@section('title', "Country Information Permission Management")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                    Country Info Access Permissions
                    <small class="text-muted">Manage member access</small>
                </h4>
            </div><!--col-->
            <div class="col-sm-2 " style="margin-top:20px;text-align: right;">
               <button type="cancel" name="back" class="btn btn-sm btn-primary " value="Back" onclick="document.location ='{{ route('admin.auth.user.index') }}'" title="Back">  <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>

        </div><!--row-->    

        <div class="row">
            <div class="col">
                <br />
                <h3>{{ $user_name }}</h3>
                {{ html()->form('POST', route('admin.auth.user.countrypermissionupdate', $userid))->class('form-horizontal')->open() }}
                <table class="table table-hover">
                    <tr>
                        <th>Folder</th>
                        <th>Has Access</th>
                    </tr>
                    @if(count($data)) 
                    @foreach($data as $folder)
                    <tr>
                        <td>{{ $folder['name'] }}</td>
                        <td><input type="checkbox" name="folder[]" value="{{$folder['id']}}" {{$folder['checked']}} /></td>
                    </tr>
                    @endforeach
                    <tr>
                        <td></td>
                        <td><input type="submit" name="save" class="btn btn-primary btn-sm" value="Save Changes"></td>
                    </tr>
                    @else
                    No private folders found
                    @endif
                </table>

                {{ html()->form()->close() }}
            </div>
        </div>
        <br /><br />

        <div class="alert alert-warning" role="alert">
            <strong>Note:</strong><br />
            Only Private Folders are shown
        </div>
    </div>
</div>
@endsection




