@extends('backend.layouts.app')

@section('title', "course Category")

@section('content')
<div class="card">
    <div class="card-body">

        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0"> 
                    Course Categories 
                </h4>
            </div><!--col-->

            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.course-category.create') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New"><i class="bi bi-plus-circle"></i> Create</a>
                </div><!--btn-toolbar-->
            </div><!--col--> 
        </div><!--row-->  


        <p id = "GFG_UP" style =  
           "font-size: 15px; font-weight: bold;">  
        </p> 
        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="batch_data"> 
                        <thead>
                            <tr>
                                <th class="select_data">Course Category</th>
                                <th class="select_data" data-orderable="false">Action</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th class="select_data">Course Category</th>
                                <th class="select_data" data-orderable="false">Action</th>
                            </tr>
                        </tfoot>                        
                    </table>
                </div>
            </div> 
        </div>    
    </div><!--card-body-->
</div><!--card-->
@endsection


@push('after-scripts')
<script>       
        
    $(document).ready(function () {
            $('#batch_data').DataTable({
                "language": {
                    searchPlaceholder: "Search By Category"
                },
                "lengthMenu" : [10,20,50],
                "processing": true,
                "serverSide": true,
                "ajax":{
                         "url": "{{route('admin.course-category.ajaxcoursecategory')}}",
                         "dataType": "json",
                         "type": "post",
                          data: { '_token':  $('meta[name="csrf-token"]').attr('content')},
                       },
                "drawCallback": function( settings ) {
                    addDeleteForms();
                },
                "order": [ 2, "desc" ],
                "columnDefs": [
                    {
                        "targets": [ 2 ],
                        "visible": false
                    }
                ],               
                "columns": [
                    { "data": "category" },
                    { "data": "actions" },
                    { "data": "created_at" },
                ]
            });            
            
    });      
      
</script>
@endpush   
