@extends('backend.layouts.app')

@push('after-styles')
@endpush
@push('after-scripts')
    <script src="{{ asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <script>
    $(document).ready(function() {

        if ($("#mymce").length > 0) {
            tinymce.init({
                selector: "textarea#mymce",
                theme: "modern",
                height: 300,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }
    });
    </script>
@endpush

@section('title', "Edit Course Category")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Edit Course Category
                </h4>
            </div><!--col-->
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col-md-8">


                    {{ html()->form('POST', route('admin.course-category.update', $page->id))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                    @method('PATCH')
                    <div style="margin-top:10px;">

                        <div class="form-group">
                            <label>Course Category</label>
                            <input tyle="text" name="category" class="form-control" maxlength="100" value="{{ $page->category }}" required>
                        </div>
                        <div class="form-group" style="text-align: center">
                            {{ form_submit("Update") }}
                        </div>
                        {{ html()->form()->close() }}  
                    </div>
                
                
                
            </div><!--col-->
        </div><!--row-->
    </div>
</div>
@endsection        