@extends('backend.layouts.app')
@section('title', "Course Management- Categories")

@section('content')
<div class="card">
    <div class="card-body pt-3">
        <div class="row">
            <div class="col-sm-7 col-7" style="margin-bottom:10px;">
                <h4 style="">Course Management - Categories</h4>
            </div>

            <div class="col-sm-5 col-5">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="Add New Course"  style="float: right;"> 
                    <a href="{{ route('admin.coursemanagement.create.category') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New Category"><i class="bi bi-plus-circle"></i> Create</a>
                </div>
            </div>           
        </div>

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table table-bordered" id="suggestions_tbl">
                        <thead>
                            <tr>
                                {{-- <th class="select_filter eductrl-datatable-col-header">ID</th> --}}
                                <th class="select_filter eductrl-datatable-col-header">Category(Study Area > Discipline Area)</th>
                                <th class="select_filter eductrl-datatable-col-header">Status</th>
                                <th class="select_filter eductrl-datatable-col-header">Display Order</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php for ($i = 0; $i < count($categories); $i++) { ?>
                                <tr>
                                    {{-- <td class="">
                                            <div class="mt-1" style="margin-left:3px;"><b>{{$categories[$i]->id}}</b></div>
                                    </td> --}}
                                    <td class="">
                                        <div style="display: flex;" class="">
                                            <div>
                                                <div class="px-1" style="border: 2px solid #cbcaca;">
                                                <!-- {{$i+1}} -->
                                                {{"+"}}
                                            </div>
                                            </div>
                                            <div class="mt-1" style="margin-left:3px;"><b>{{$categories[$i]->title}} (ID: {{$categories[$i]->id}})</b></div>
                                        </div>
                                    </td>
                                    <td class=""><i class="fa {{ ($categories[$i]->status==1) ? "fa-check text-success":"fa-times text-danger" }} inline"></i></td>
                                    <td class="">{{$categories[$i]->display_order}}</td>
                                    <td class="text-center">
                                        <div style="display: flex; text-align: center;">
                                            <a href="{{route('admin.coursemanagement.edit-category',$categories[$i]->id)}}" class="btn btn-primary btn-sm" style="margin-right:3px;"><i class="fas fa-edit"></i> Edit</a>
                                            <a href="{{ route('admin.coursemanagement.destroy-category',$categories[$i]->id)}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure?" class="btn btn-danger btn-sm" ><i class="fas fa-trash"></i> Delete</a>
                                        </div>
                                    </td>
                                </tr>
                                <?php
                                $co = 0;
                                for ($k = 0; $k < count($subcategories); $k++) {
                                    $cat_de = array();
                                    if ($subcategories[$k]->parent_id == $categories[$i]->id) {
                                        $co++;
                                        $cat_de[] = $subcategories[$k];
                                        // break;
                                    }
                                    $si = 1;
                                    if (isset($cat_de)) {
                                        for ($j = 0; $j < count($cat_de); $j++) {
                                            $cat_det = $cat_de[$j];
                                ?>
                                <tr>
                                    {{-- <td class="">
                                            <div class="mt-1" style="margin-left:3px;"><b>{{$cat_det->id}}</b></div>
                                    </td> --}}
                                    <td class="">
                                        <div style="display: flex; position: relative;margin-left: 38px;">
                                            @if($co == 1)
                                            <img style="position: absolute; top: -28px; left: -29px;" src="{{asset('storage/background/treepart_ltr2.png')}}">
                                            @else
                                            <img style="position: absolute; top: -47px; left: -29px;" src="{{asset('storage/background/treepart_ltr.png')}}">
                                            @endif
                                            <div>
                                                <!-- <div class="px-1 mt-3" style="border: 2px solid #cbcaca;">{{$co}}</div> -->
                                            </div>
                                            <div class="mt-4" style="margin-left:3px;"><b>{{$cat_det->title}} <span class="text-muted">(ID: {{$cat_det->id}})</span></b></div>
                                        </div>
                                    </td>
                                        <td ><i class="fa {{ ($cat_det->status==1) ? "fa-check text-success":"fa-times text-danger" }} inline"></i></td>
                                        <td class="">{{$cat_det->display_order}}</td>
                                        <td class="text-center">
                                            <div style="display: flex;">
                                                <a href="{{route('admin.coursemanagement.edit-category',$cat_det->id)}}" class="btn btn-primary btn-sm" style="margin-right:3px;"><i class="fas fa-edit"></i> Edit</a>
                                                <a href="{{ route('admin.coursemanagement.destroy-category',$cat_det->id)}}"
                                                data-method="delete"
                                                data-trans-button-cancel="Cancel"
                                                data-trans-button-confirm="Delete"
                                                data-trans-title="Are you sure?"
                                                class="btn btn-danger btn-sm" ><i class="fas fa-trash"></i> Delete</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php
                                        }
                                    }
                                    // break;
                                } ?>
                            <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
            </div><!--row-->
        </div>
</div>
@endsection
@push('after-scripts')
<script>
   addDeleteForms();
</script>
@endpush   
