
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <link href="{{ asset('assets/backend/vendorfiles/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet">
        <link href="{{ asset('assets/backend/css/style.css')}}?v=6" rel="stylesheet">
        
        <style>
            @font-face {
            font-family: 'Roboto';
            font-weight: normal;
            font-style: normal;
            font-variant: normal;
            src: url("storage/fonts/Roboto/Roboto-Regular.ttf") format('truetype');
            }
            /* body, th, td{
                font-family: 'Roboto', sans-serif!important;
            } */
            /* @font-face {
                    font-family: 'Roboto';
                    font-style: normal;
                    font-weight: 400;
                    src: local('Roboto Light'), local('Roboto-Light'), url(https://themes.googleusercontent.com/static/fonts/roboto/v9/Pru33qjShpZSmG3z6VYwnT8E0i7KZn-EPnyo3HZu7kw.woff) format('woff');
            } */
            
            body {
                font-family: 'Roboto', sans-serif!important;
                color: #121212;
                font-style: normal;
                font-size: 14px;
                background-color: #fff!important;
            }
            .dataTable th {
                font-weight: 700;
                font-family: 'Roboto', sans-serif!important;
                font-size: 15px!important;
            }
            td{
                padding: 5px;
            }
            table.bordered td, th {
                font-style: normal;
                border: 1px solid #808080;
                margin:0;
            }
        </style>
    </head>
<body>
<div class="card" style="border: none;">
    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <h4 class="text-center p-4">Courses List</h4>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered dataTable">
                        <thead class="tableHeading">
                            <tr>
                                <th class="text-center">Course</th>
                                <th class="text-center">Institution Name</th>
                                <th class="text-center">Country</th>
                                <th class="text-center">Duration</th>
                                <th class="text-center">Intakes</th>
                                <th class="text-center">Application Fee</th>
                                <th class="text-center">Tuition Fee</th>
                                <th class="text-center">Study Level</th>
                                <th class="text-center">Study Area</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($courses as $course)
                            <tr>
                                <td>{{$course->course_name ? $course->course_name : "--"}}</td>
                                <td>{{$course->university_name ? $course->university_name : "--"}}</td>
                                <td>{{$course->country ? get_country_name($course->country) : "--"}}</td>
                                <td>{{$course->duration ? $course->duration : "--"}}</td>
                                <?php
                                    $intakes = array();
                                    if($course->intakes){
                                        $intakes = explode(",", $course->intakes);
                                    }
                                    $count = count($intakes);
                                    $allIntake = "";
                                    $i = 0;
                                    foreach($intakes as $intake){
                                        $i++;
                                        $allIntake .= substr($intake, 0, 3);
                                        if($i < $count){
                                            $allIntake .= ", ";
                                        }
                                    }
                                ?>
                                <td>{{$course->intakes ? $allIntake : "--"}}</td>
                                <td>{{$course->application_fee ? $course->currency." ".$course->application_fee : "--"}}</td>
                                <td>{{$course->yearly_tuition_fee ? $course->currency." ".$course->yearly_tuition_fee : "--"}}</td>
                                <td>{{$course->study_level ? $course->study_level : "--"}}</td>
                                <td>{{$course->category ? get_university_course_parent_category_name($course->category ) : "--"}}</td>
                            </tr>
                           @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div></body></html>